/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.mime.content.AbstractContentBody;

public class InputStreamBody
extends AbstractContentBody {
    private final String filename;
    private final InputStream in;

    public InputStreamBody(InputStream inputStream, String string2) {
        this(inputStream, "application/octet-stream", string2);
    }

    public InputStreamBody(InputStream inputStream, String string2, String string3) {
        super(string2);
        if (inputStream != null) {
            this.in = inputStream;
            this.filename = string3;
            return;
        }
        throw new IllegalArgumentException("Input stream may not be null");
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = this.in.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                outputStream.flush();
                return;
            }
            finally {
                this.in.close();
            }
        }
        throw new IllegalArgumentException("Output stream may not be null");
    }
}

