/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.http.entity.mime.content.AbstractContentBody;

public class StringBody
extends AbstractContentBody {
    private final Charset charset;
    private final byte[] content;

    public StringBody(String string2) throws UnsupportedEncodingException {
        this(string2, "text/plain", null);
    }

    public StringBody(String string2, String object, Charset charset) throws UnsupportedEncodingException {
        super((String)object);
        if (string2 != null) {
            object = charset;
            if (charset == null) {
                object = Charset.forName("US-ASCII");
            }
            this.content = string2.getBytes(((Charset)object).name());
            this.charset = object;
            return;
        }
        throw new IllegalArgumentException("Text may not be null");
    }

    public StringBody(String string2, Charset charset) throws UnsupportedEncodingException {
        this(string2, "text/plain", charset);
    }

    public static StringBody create(String string2) throws IllegalArgumentException {
        return StringBody.create(string2, null, null);
    }

    public static StringBody create(String object, String string2, Charset charset) throws IllegalArgumentException {
        try {
            object = new StringBody((String)object, string2, charset);
            return object;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Charset ");
            ((StringBuilder)object).append(charset);
            ((StringBuilder)object).append(" is not supported");
            throw new IllegalArgumentException(((StringBuilder)object).toString(), unsupportedEncodingException);
        }
    }

    public static StringBody create(String string2, Charset charset) throws IllegalArgumentException {
        return StringBody.create(string2, null, charset);
    }

    @Override
    public String getCharset() {
        return this.charset.name();
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public String getFilename() {
        return null;
    }

    public Reader getReader() {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), this.charset);
    }

    @Override
    public String getTransferEncoding() {
        return "8bit";
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.content);
            byte[] byArray = new byte[4096];
            while ((n = byteArrayInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            return;
        }
        throw new IllegalArgumentException("Output stream may not be null");
    }
}

