/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.xerces.dom.CharacterDataImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom3.TypeInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AttrImpl
extends NodeImpl
implements Attr,
TypeInfo {
    static final long serialVersionUID = 7277707688218972102L;
    protected static TextImpl textNode;
    protected String name;
    transient Object type;
    protected Object value = null;

    protected AttrImpl() {
    }

    protected AttrImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl);
        this.name = string2;
        this.isSpecified(true);
        this.hasStringValue(true);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.needsSyncChildren(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }

    void checkNormalizationAfterInsert(ChildNode childNode) {
        block3: {
            block4: {
                block2: {
                    if (childNode.getNodeType() != 3) break block2;
                    ChildNode childNode2 = childNode.previousSibling();
                    childNode = childNode.nextSibling;
                    if ((childNode2 == null || childNode2.getNodeType() != 3) && (childNode == null || childNode.getNodeType() != 3)) break block3;
                    break block4;
                }
                if (childNode.isNormalized()) break block3;
            }
            this.isNormalized(false);
        }
    }

    void checkNormalizationAfterRemove(ChildNode childNode) {
        if (childNode != null && childNode.getNodeType() == 3 && (childNode = childNode.nextSibling) != null && childNode.getNodeType() == 3) {
            this.isNormalized(false);
        }
    }

    @Override
    public Node cloneNode(boolean bl) {
        AttrImpl attrImpl;
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (!(attrImpl = (AttrImpl)super.cloneNode(bl)).hasStringValue()) {
            attrImpl.value = null;
            for (Node node = (Node)this.value; node != null; node = node.getNextSibling()) {
                attrImpl.appendChild(node.cloneNode(true));
            }
        }
        attrImpl.isSpecified(true);
        return attrImpl;
    }

    @Override
    public NodeList getChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Element getElement() {
        NodeImpl nodeImpl = this.isOwned() ? this.ownerNode : null;
        return (Element)((Object)nodeImpl);
    }

    @Override
    public Node getFirstChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        this.makeChildNode();
        return (Node)this.value;
    }

    @Override
    public Node getLastChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.lastChild();
    }

    @Override
    public int getLength() {
        if (this.hasStringValue()) {
            return 1;
        }
        ChildNode childNode = (ChildNode)this.value;
        int n = 0;
        while (childNode != null) {
            ++n;
            childNode = childNode.nextSibling;
        }
        return n;
    }

    @Override
    public String getName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public Element getOwnerElement() {
        NodeImpl nodeImpl = this.isOwned() ? this.ownerNode : null;
        return (Element)((Object)nodeImpl);
    }

    public TypeInfo getSchemaTypeInfo() {
        return this;
    }

    @Override
    public boolean getSpecified() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.isSpecified();
    }

    @Override
    public String getTypeName() {
        return (String)this.type;
    }

    @Override
    public String getTypeNamespace() {
        return null;
    }

    @Override
    public String getValue() {
        Object object;
        block10: {
            if (this.needsSyncData()) {
                this.synchronizeData();
            }
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            object = this.value;
            Object object2 = "";
            if (object == null) {
                return "";
            }
            if (this.hasStringValue()) {
                return (String)this.value;
            }
            Object object3 = (ChildNode)this.value;
            object = ((NodeImpl)object3).getNodeType() == 5 ? ((EntityReferenceImpl)object3).getEntityRefValue() : ((NodeImpl)object3).getNodeValue();
            object3 = ((ChildNode)object3).nextSibling;
            if (object3 != null && object != null) {
                StringBuffer stringBuffer = new StringBuffer((String)object);
                object = object3;
                while (true) {
                    if (object == null) {
                        return stringBuffer.toString();
                    }
                    if (((NodeImpl)object).getNodeType() == 5) {
                        object2 = object3 = ((EntityReferenceImpl)object).getEntityRefValue();
                        if (object3 == null) {
                            return "";
                        }
                    } else {
                        object2 = ((NodeImpl)object).getNodeValue();
                    }
                    stringBuffer.append((String)object2);
                    object = ((ChildNode)object).nextSibling;
                }
            }
            if (object != null) break block10;
            object = object2;
        }
        return object;
    }

    @Override
    public boolean hasChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        boolean bl = this.value != null;
        return bl;
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.internalInsertBefore(node, node2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Node internalInsertBefore(Node node, Node node2, boolean bl) throws DOMException {
        NodeImpl nodeImpl;
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        boolean bl2 = coreDocumentImpl.errorChecking;
        if (node.getNodeType() == 11) {
            if (bl2) {
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (!coreDocumentImpl.isKidOK(this, node3)) throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
                }
            }
            while (true) {
                if (!node.hasChildNodes()) {
                    return node;
                }
                this.insertBefore(node.getFirstChild(), node2);
            }
        }
        if (node == node2) {
            node2 = node2.getNextSibling();
            this.removeChild(node);
            this.insertBefore(node, node2);
            return node;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl2) {
            if (this.isReadOnly()) throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            if (node.getOwnerDocument() != coreDocumentImpl) throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            if (!coreDocumentImpl.isKidOK(this, node)) throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
            if (node2 != null && node2.getParentNode() != this) {
                throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
            }
            boolean bl3 = true;
            for (nodeImpl = this; bl3 && nodeImpl != null; nodeImpl = nodeImpl.parentNode()) {
                bl3 = node != nodeImpl;
            }
            if (!bl3) {
                throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
            }
        }
        this.makeChildNode();
        coreDocumentImpl.insertingNode(this, bl);
        nodeImpl = (ChildNode)node;
        NodeImpl nodeImpl2 = ((ChildNode)nodeImpl).parentNode();
        if (nodeImpl2 != null) {
            nodeImpl2.removeChild(nodeImpl);
        }
        nodeImpl2 = (ChildNode)node2;
        nodeImpl.ownerNode = this;
        nodeImpl.isOwned(true);
        ChildNode childNode = (ChildNode)this.value;
        if (childNode == null) {
            this.value = nodeImpl;
            nodeImpl.isFirstChild(true);
            ((ChildNode)nodeImpl).previousSibling = nodeImpl;
        } else if (nodeImpl2 == null) {
            node2 = childNode.previousSibling;
            ((ChildNode)node2).nextSibling = nodeImpl;
            ((ChildNode)nodeImpl).previousSibling = node2;
            childNode.previousSibling = nodeImpl;
        } else if (node2 == childNode) {
            childNode.isFirstChild(false);
            ((ChildNode)nodeImpl).nextSibling = childNode;
            ((ChildNode)nodeImpl).previousSibling = childNode.previousSibling;
            childNode.previousSibling = nodeImpl;
            this.value = nodeImpl;
            nodeImpl.isFirstChild(true);
        } else {
            node2 = ((ChildNode)nodeImpl2).previousSibling;
            ((ChildNode)nodeImpl).nextSibling = nodeImpl2;
            ((ChildNode)node2).nextSibling = nodeImpl;
            ((ChildNode)nodeImpl2).previousSibling = nodeImpl;
            ((ChildNode)nodeImpl).previousSibling = node2;
        }
        this.changed();
        coreDocumentImpl.insertedNode(this, nodeImpl, bl);
        this.checkNormalizationAfterInsert((ChildNode)nodeImpl);
        return node;
    }

    Node internalRemoveChild(Node node, boolean bl) throws DOMException {
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        if (coreDocumentImpl.errorChecking) {
            if (!this.isReadOnly()) {
                if (node != null && node.getParentNode() != this) {
                    throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
                }
            } else {
                throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            }
        }
        ChildNode childNode = (ChildNode)node;
        coreDocumentImpl.removingNode(this, childNode, bl);
        if (childNode == this.value) {
            childNode.isFirstChild(false);
            node = childNode.nextSibling;
            this.value = node;
            ChildNode childNode2 = (ChildNode)node;
            if (node != null) {
                ((NodeImpl)node).isFirstChild(true);
                ((ChildNode)node).previousSibling = childNode.previousSibling;
            }
        } else {
            ChildNode childNode3;
            ChildNode childNode4 = childNode.previousSibling;
            childNode4.nextSibling = childNode3 = childNode.nextSibling;
            node = childNode3;
            if (childNode3 == null) {
                node = (ChildNode)this.value;
            }
            ((ChildNode)node).previousSibling = childNode4;
        }
        node = childNode.previousSibling();
        childNode.ownerNode = coreDocumentImpl;
        childNode.isOwned(false);
        childNode.nextSibling = null;
        childNode.previousSibling = null;
        this.changed();
        coreDocumentImpl.removedNode(this, bl);
        this.checkNormalizationAfterRemove((ChildNode)node);
        return childNode;
    }

    @Override
    public boolean isEqualNode(Node node) {
        return super.isEqualNode(node);
    }

    @Override
    public boolean isId() {
        return this.isIdAttribute();
    }

    @Override
    public Node item(int n) {
        if (this.hasStringValue()) {
            if (n == 0 && this.value != null) {
                this.makeChildNode();
                return (Node)this.value;
            }
            return null;
        }
        ChildNode childNode = (ChildNode)this.value;
        for (int i = 0; i < n && childNode != null; ++i) {
            childNode = childNode.nextSibling;
        }
        return childNode;
    }

    final ChildNode lastChild() {
        this.makeChildNode();
        Object object = this.value;
        object = object != null ? ((ChildNode)object).previousSibling : null;
        return object;
    }

    final void lastChild(ChildNode childNode) {
        Object object = this.value;
        if (object != null) {
            ((ChildNode)object).previousSibling = childNode;
        }
    }

    protected void makeChildNode() {
        if (this.hasStringValue()) {
            if (this.value != null) {
                TextImpl textImpl = (TextImpl)this.ownerDocument().createTextNode((String)this.value);
                this.value = textImpl;
                textImpl.isFirstChild(true);
                textImpl.previousSibling = textImpl;
                textImpl.ownerNode = this;
                textImpl.isOwned(true);
            }
            this.hasStringValue(false);
        }
    }

    @Override
    public void normalize() {
        if (!this.isNormalized() && !this.hasStringValue()) {
            Node node = (ChildNode)this.value;
            while (true) {
                if (node == null) {
                    this.isNormalized(true);
                    return;
                }
                Node node2 = node.getNextSibling();
                if (node.getNodeType() == 3) {
                    if (node2 != null && node2.getNodeType() == 3) {
                        ((Text)node).appendData(node2.getNodeValue());
                        this.removeChild(node2);
                        continue;
                    }
                    if (node.getNodeValue().length() == 0) {
                        this.removeChild(node);
                    }
                }
                node = node2;
            }
        }
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        if (!this.hasStringValue()) {
            return this.internalRemoveChild(node, false);
        }
        throw new DOMException(8, "DOM008 Not found");
    }

    void rename(String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = string2;
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.makeChildNode();
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        coreDocumentImpl.replacingNode(this);
        this.internalInsertBefore(node, node2, true);
        if (node != node2) {
            this.internalRemoveChild(node2, true);
        }
        coreDocumentImpl.replacedNode(this);
        return node2;
    }

    public void setIdAttribute(boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isIdAttribute(bl);
    }

    @Override
    public void setNodeValue(String string2) throws DOMException {
        this.setValue(string2);
    }

    @Override
    void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        super.setOwnerDocument(coreDocumentImpl);
        if (!this.hasStringValue()) {
            ChildNode childNode = (ChildNode)this.value;
            while (childNode != null) {
                childNode.setOwnerDocument(coreDocumentImpl);
                childNode = childNode.nextSibling;
            }
        }
    }

    @Override
    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (bl2) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            if (this.hasStringValue()) {
                return;
            }
            ChildNode childNode = (ChildNode)this.value;
            while (childNode != null) {
                if (childNode.getNodeType() != 5) {
                    childNode.setReadOnly(bl, true);
                }
                childNode = childNode.nextSibling;
            }
        }
    }

    public void setSpecified(boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isSpecified(bl);
    }

    public void setType(Object object) {
        this.type = object;
    }

    @Override
    public void setValue(String string2) {
        if (!this.isReadOnly()) {
            Object object;
            CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
            Element element = this.getOwnerElement();
            if (this.needsSyncData()) {
                this.synchronizeData();
            }
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            if (this.value != null) {
                String string3;
                if (coreDocumentImpl.getMutationEvents()) {
                    if (this.hasStringValue()) {
                        Object object2 = this.value;
                        string3 = (String)object2;
                        object = textNode;
                        object2 = (String)object2;
                        if (object == null) {
                            textNode = (TextImpl)coreDocumentImpl.createTextNode((String)object2);
                        } else {
                            ((CharacterDataImpl)object).data = object2;
                        }
                        this.value = object = textNode;
                        ((NodeImpl)object).isFirstChild(true);
                        ((ChildNode)object).previousSibling = object = textNode;
                        AttrImpl.textNode.ownerNode = this;
                        textNode.isOwned(true);
                        this.hasStringValue(false);
                        this.internalRemoveChild(textNode, true);
                    } else {
                        string3 = this.getValue();
                        while ((object = this.value) != null) {
                            this.internalRemoveChild((Node)object, true);
                        }
                    }
                } else {
                    if (this.hasStringValue()) {
                        string3 = (String)this.value;
                    } else {
                        string3 = this.getValue();
                        object = (ChildNode)this.value;
                        ((ChildNode)object).previousSibling = null;
                        ((NodeImpl)object).isFirstChild(false);
                        ((NodeImpl)object).ownerNode = coreDocumentImpl;
                    }
                    this.value = null;
                    this.needsSyncChildren(false);
                }
                object = string3;
                if (this.isIdAttribute()) {
                    object = string3;
                    if (element != null) {
                        coreDocumentImpl.removeIdentifier(string3);
                        object = string3;
                    }
                }
            } else {
                object = "";
            }
            this.isSpecified(true);
            if (coreDocumentImpl.getMutationEvents()) {
                this.internalInsertBefore(coreDocumentImpl.createTextNode(string2), null, true);
                this.hasStringValue(false);
                coreDocumentImpl.modifiedAttrValue(this, (String)object);
            } else {
                this.value = string2;
                this.hasStringValue(true);
                this.changed();
            }
            if (this.isIdAttribute() && element != null) {
                coreDocumentImpl.putIdentifier(string2, element);
            }
            return;
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append("=");
        stringBuffer.append("\"");
        stringBuffer.append(this.getValue());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }
}

