/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class AttributeMap
extends NamedNodeMapImpl {
    protected AttributeMap(ElementImpl elementImpl, NamedNodeMapImpl namedNodeMapImpl) {
        super(elementImpl);
        if (namedNodeMapImpl != null) {
            this.cloneContent(namedNodeMapImpl);
            if (this.nodes != null) {
                this.hasDefaults(true);
            }
        }
    }

    private final Node remove(AttrImpl attrImpl, int n, boolean bl) {
        Node node;
        Serializable serializable;
        CoreDocumentImpl coreDocumentImpl = this.ownerNode.ownerDocument();
        String string2 = attrImpl.getNodeName();
        if (attrImpl.isIdAttribute()) {
            coreDocumentImpl.removeIdentifier(attrImpl.getValue());
        }
        if (this.hasDefaults() && bl && (serializable = ((ElementImpl)this.ownerNode).getDefaultAttributes()) != null && (node = ((NamedNodeMapImpl)serializable).getNamedItem(string2)) != null && this.findNamePoint(string2, n + 1) < 0) {
            serializable = (NodeImpl)node.cloneNode(true);
            if (node.getLocalName() != null) {
                ((AttrNSImpl)serializable).namespaceURI = attrImpl.getNamespaceURI();
            }
            ((NodeImpl)serializable).ownerNode = this.ownerNode;
            ((NodeImpl)serializable).isOwned(true);
            ((NodeImpl)serializable).isSpecified(false);
            this.nodes.setElementAt(serializable, n);
            if (attrImpl.isIdAttribute()) {
                coreDocumentImpl.putIdentifier(((NodeImpl)serializable).getNodeValue(), (ElementImpl)this.ownerNode);
            }
        } else {
            this.nodes.removeElementAt(n);
        }
        attrImpl.ownerNode = coreDocumentImpl;
        attrImpl.isOwned(false);
        attrImpl.isSpecified(true);
        attrImpl.isIdAttribute(false);
        coreDocumentImpl.removedAttrNode(attrImpl, this.ownerNode, string2);
        return attrImpl;
    }

    @Override
    protected void cloneContent(NamedNodeMapImpl serializable) {
        int n;
        Vector vector = ((NamedNodeMapImpl)serializable).nodes;
        if (vector != null && (n = vector.size()) != 0) {
            if (this.nodes == null) {
                this.nodes = new Vector(n);
            }
            this.nodes.setSize(n);
            for (int i = 0; i < n; ++i) {
                serializable = (NodeImpl)vector.elementAt(i);
                NodeImpl nodeImpl = (NodeImpl)((NodeImpl)serializable).cloneNode(true);
                nodeImpl.isSpecified(((NodeImpl)serializable).isSpecified());
                this.nodes.setElementAt(nodeImpl, i);
                nodeImpl.ownerNode = this.ownerNode;
                nodeImpl.isOwned(true);
            }
        }
    }

    @Override
    public NamedNodeMapImpl cloneMap(NodeImpl serializable) {
        serializable = new AttributeMap((ElementImpl)serializable, null);
        ((NamedNodeMapImpl)serializable).hasDefaults(this.hasDefaults());
        ((AttributeMap)serializable).cloneContent(this);
        return serializable;
    }

    protected final Node internalRemoveNamedItem(String string2, boolean bl) {
        if (!this.isReadOnly()) {
            int n = this.findNamePoint(string2, 0);
            if (n < 0) {
                if (!bl) {
                    return null;
                }
                throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
            }
            return this.remove((AttrImpl)this.nodes.elementAt(n), n, true);
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    protected final Node internalRemoveNamedItemNS(String string2, String string3, boolean bl) {
        if (!this.isReadOnly()) {
            int n;
            Object object;
            int n2 = this.findNamePoint(string2, string3);
            if (n2 < 0) {
                if (!bl) {
                    return null;
                }
                throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
            }
            AttrImpl attrImpl = (AttrImpl)this.nodes.elementAt(n2);
            CoreDocumentImpl coreDocumentImpl = this.ownerNode.ownerDocument();
            if (attrImpl.isIdAttribute()) {
                coreDocumentImpl.removeIdentifier(attrImpl.getValue());
            }
            Object object2 = attrImpl.getNodeName();
            if (this.hasDefaults() && (object = ((ElementImpl)this.ownerNode).getDefaultAttributes()) != null && (object = ((NamedNodeMapImpl)object).getNamedItem((String)object2)) != null && (n = this.findNamePoint((String)object2, 0)) >= 0 && this.findNamePoint((String)object2, n + 1) < 0) {
                object2 = (NodeImpl)object.cloneNode(true);
                ((NodeImpl)object2).ownerNode = this.ownerNode;
                if (object.getLocalName() != null) {
                    ((AttrNSImpl)object2).namespaceURI = string2;
                }
                ((NodeImpl)object2).isOwned(true);
                ((NodeImpl)object2).isSpecified(false);
                this.nodes.setElementAt(object2, n2);
                if (((NodeImpl)object2).isIdAttribute()) {
                    coreDocumentImpl.putIdentifier(((NodeImpl)object2).getNodeValue(), (ElementImpl)this.ownerNode);
                }
            } else {
                this.nodes.removeElementAt(n2);
            }
            attrImpl.ownerNode = coreDocumentImpl;
            attrImpl.isOwned(false);
            attrImpl.isSpecified(true);
            attrImpl.isIdAttribute(false);
            coreDocumentImpl.removedAttrNode(attrImpl, this.ownerNode, string3);
            return attrImpl;
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    void moveSpecifiedAttributes(AttributeMap attributeMap) {
        int n = attributeMap.nodes != null ? attributeMap.nodes.size() : 0;
        --n;
        while (n >= 0) {
            AttrImpl attrImpl = (AttrImpl)attributeMap.nodes.elementAt(n);
            if (attrImpl.isSpecified()) {
                attributeMap.remove(attrImpl, n, false);
                if (attrImpl.getLocalName() != null) {
                    this.setNamedItem(attrImpl);
                } else {
                    this.setNamedItemNS(attrImpl);
                }
            }
            --n;
        }
        return;
    }

    protected void reconcileDefaults(NamedNodeMapImpl namedNodeMapImpl) {
        int n = this.nodes != null ? this.nodes.size() : 0;
        --n;
        while (true) {
            NodeImpl nodeImpl;
            if (n < 0) {
                if (namedNodeMapImpl == null) {
                    return;
                }
                if (this.nodes != null && this.nodes.size() != 0) {
                    int n2 = namedNodeMapImpl.nodes.size();
                    for (n = 0; n < n2; ++n) {
                        nodeImpl = (AttrImpl)namedNodeMapImpl.nodes.elementAt(n);
                        int n3 = this.findNamePoint(((AttrImpl)nodeImpl).getNodeName(), 0);
                        if (n3 >= 0) continue;
                        nodeImpl = (NodeImpl)((AttrImpl)nodeImpl).cloneNode(true);
                        nodeImpl.ownerNode = this.ownerNode;
                        nodeImpl.isOwned(true);
                        nodeImpl.isSpecified(false);
                        this.nodes.setElementAt(nodeImpl, n3);
                    }
                } else {
                    this.cloneContent(namedNodeMapImpl);
                }
                return;
            }
            nodeImpl = (AttrImpl)this.nodes.elementAt(n);
            if (!nodeImpl.isSpecified()) {
                this.remove((AttrImpl)nodeImpl, n, false);
            }
            --n;
        }
    }

    protected Node removeItem(Node node, boolean bl) throws DOMException {
        int n;
        if (this.nodes != null) {
            for (n = 0; n < this.nodes.size(); ++n) {
                if (this.nodes.elementAt(n) != node) {
                    continue;
                }
                break;
            }
        } else {
            n = -1;
        }
        if (n >= 0) {
            return this.remove((AttrImpl)node, n, bl);
        }
        throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
    }

    @Override
    public Node removeNamedItem(String string2) throws DOMException {
        return this.internalRemoveNamedItem(string2, true);
    }

    @Override
    public Node removeNamedItemNS(String string2, String string3) throws DOMException {
        return this.internalRemoveNamedItemNS(string2, string3, true);
    }

    Node safeRemoveNamedItem(String string2) {
        return this.internalRemoveNamedItem(string2, false);
    }

    Node safeRemoveNamedItemNS(String string2, String string3) {
        return this.internalRemoveNamedItemNS(string2, string3, false);
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        boolean bl = this.isReadOnly();
        AttrImpl attrImpl = null;
        if (!bl) {
            if (node.getOwnerDocument() == this.ownerNode.ownerDocument()) {
                if (node.getNodeType() == 2) {
                    AttrImpl attrImpl2 = (AttrImpl)node;
                    if (attrImpl2.isOwned()) {
                        if (attrImpl2.getOwnerElement() == this.ownerNode) {
                            return node;
                        }
                        throw new DOMException(10, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INUSE_ATTRIBUTE_ERR", null));
                    }
                    attrImpl2.ownerNode = this.ownerNode;
                    attrImpl2.isOwned(true);
                    int n = this.findNamePoint(node.getNodeName(), 0);
                    if (n >= 0) {
                        attrImpl = (AttrImpl)this.nodes.elementAt(n);
                        this.nodes.setElementAt(node, n);
                        attrImpl.ownerNode = this.ownerNode.ownerDocument();
                        attrImpl.isOwned(false);
                        attrImpl.isSpecified(true);
                        node = attrImpl;
                    } else {
                        if (this.nodes == null) {
                            this.nodes = new Vector(5, 10);
                        }
                        this.nodes.insertElementAt(node, -1 - n);
                        node = attrImpl;
                    }
                    this.ownerNode.ownerDocument().setAttrNode(attrImpl2, (AttrImpl)node);
                    if (!attrImpl2.isNormalized()) {
                        this.ownerNode.isNormalized(false);
                    }
                    return node;
                }
                throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
            }
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        AttrImpl attrImpl;
        boolean bl = this.isReadOnly();
        Object var3_3 = null;
        if (bl) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        if (node.getNodeType() != 2) {
            throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
        }
        AttrImpl attrImpl2 = (AttrImpl)node;
        if (attrImpl2.isOwned()) {
            if (attrImpl2.getOwnerElement() == this.ownerNode) {
                return node;
            }
            throw new DOMException(10, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INUSE_ATTRIBUTE_ERR", null));
        }
        attrImpl2.ownerNode = this.ownerNode;
        attrImpl2.isOwned(true);
        int n = this.findNamePoint(attrImpl2.getNamespaceURI(), attrImpl2.getLocalName());
        if (n >= 0) {
            attrImpl = (AttrImpl)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
            attrImpl.ownerNode = this.ownerNode.ownerDocument();
            attrImpl.isOwned(false);
            attrImpl.isSpecified(true);
        } else {
            n = this.findNamePoint(node.getNodeName(), 0);
            if (n >= 0) {
                attrImpl = (AttrImpl)this.nodes.elementAt(n);
            } else {
                int n2;
                n = n2 = -1 - n;
                attrImpl = var3_3;
                if (this.nodes == null) {
                    this.nodes = new Vector(5, 10);
                    n = n2;
                    attrImpl = var3_3;
                }
            }
            this.nodes.insertElementAt(node, n);
        }
        this.ownerNode.ownerDocument().setAttrNode(attrImpl2, attrImpl);
        if (!attrImpl2.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return attrImpl;
    }
}

