/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CharacterDataImpl$1;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;

public abstract class CharacterDataImpl
extends ChildNode {
    static final long serialVersionUID = 7931170150428474230L;
    private static transient NodeList singletonNodeList = new CharacterDataImpl$1();
    protected String data;

    public CharacterDataImpl() {
    }

    protected CharacterDataImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl);
        this.data = string2;
    }

    public void appendData(String string2) {
        if (!this.isReadOnly()) {
            if (string2 == null) {
                return;
            }
            if (this.needsSyncData()) {
                this.synchronizeData();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.data);
            stringBuffer.append(string2);
            this.setNodeValue(stringBuffer.toString());
            return;
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    public void deleteData(int n, int n2) throws DOMException {
        if (!this.isReadOnly()) {
            if (n2 >= 0) {
                String string2;
                StringBuffer stringBuffer;
                block8: {
                    if (this.needsSyncData()) {
                        this.synchronizeData();
                    }
                    int n3 = Math.max(this.data.length() - n2 - n, 0);
                    try {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(this.data.substring(0, n));
                        if (n3 <= 0) break block8;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
                    }
                    string2 = this.data;
                    int n4 = n + n2;
                    string2 = string2.substring(n4, n3 + n4);
                }
                string2 = "";
                stringBuffer.append(string2);
                this.setNodeValueInternal(stringBuffer.toString());
                this.ownerDocument().deletedText(this, n, n2);
                return;
            }
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    @Override
    public NodeList getChildNodes() {
        return singletonNodeList;
    }

    public String getData() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    @Override
    public int getLength() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data.length();
    }

    @Override
    public String getNodeValue() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    public void insertData(int n, String string2) throws DOMException {
        if (!this.isReadOnly()) {
            if (this.needsSyncData()) {
                this.synchronizeData();
            }
            try {
                StringBuffer stringBuffer = new StringBuffer(this.data);
                this.setNodeValueInternal(stringBuffer.insert(n, string2).toString());
                this.ownerDocument().insertedText(this, n, string2.length());
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
            }
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    public void replaceData(int n, int n2, String string2) throws DOMException {
        this.deleteData(n, n2);
        this.insertData(n, string2);
    }

    public void setData(String string2) throws DOMException {
        this.setNodeValue(string2);
    }

    @Override
    public void setNodeValue(String string2) {
        this.setNodeValueInternal(string2);
        this.ownerDocument().replacedText(this);
    }

    protected void setNodeValueInternal(String string2) {
        if (!this.isReadOnly()) {
            if (this.needsSyncData()) {
                this.synchronizeData();
            }
            String string3 = this.data;
            CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
            coreDocumentImpl.modifyingCharacterData(this);
            this.data = string2;
            coreDocumentImpl.modifiedCharacterData(this, string3, string2);
            return;
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    public String substringData(int n, int n2) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        int n3 = this.data.length();
        if (n2 >= 0 && n >= 0 && n <= n3 - 1) {
            n2 = Math.min(n2 + n, n3);
            return this.data.substring(n, n2);
        }
        throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
    }
}

