/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.Node;

public abstract class ChildNode
extends NodeImpl {
    static final long serialVersionUID = -6112455738802414002L;
    protected ChildNode nextSibling;
    protected ChildNode previousSibling;

    public ChildNode() {
    }

    protected ChildNode(CoreDocumentImpl coreDocumentImpl) {
        super(coreDocumentImpl);
    }

    @Override
    public Node cloneNode(boolean bl) {
        ChildNode childNode = (ChildNode)super.cloneNode(bl);
        childNode.previousSibling = null;
        childNode.nextSibling = null;
        childNode.isFirstChild(false);
        return childNode;
    }

    @Override
    public Node getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public Node getParentNode() {
        NodeImpl nodeImpl = this.isOwned() ? this.ownerNode : null;
        return nodeImpl;
    }

    @Override
    public Node getPreviousSibling() {
        ChildNode childNode = this.isFirstChild() ? null : this.previousSibling;
        return childNode;
    }

    @Override
    final NodeImpl parentNode() {
        NodeImpl nodeImpl = this.isOwned() ? this.ownerNode : null;
        return nodeImpl;
    }

    @Override
    final ChildNode previousSibling() {
        ChildNode childNode = this.isFirstChild() ? null : this.previousSibling;
        return childNode;
    }
}

