/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMInputSourceImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.DOMWriterImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMBuilder;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.DOMInputSource;
import org.w3c.dom.ls.DOMWriter;

public class CoreDOMImplementationImpl
implements DOMImplementation,
DOMImplementationLS {
    private static final int SIZE = 2;
    static CoreDOMImplementationImpl singleton = new CoreDOMImplementationImpl();
    private int currentSize = 2;
    private int docAndDoctypeCounter = 0;
    private int freeValidatorIndex = -1;
    private RevalidationHandler[] validators = new RevalidationHandler[2];

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    protected int assignDocTypeNumber() {
        synchronized (this) {
            int n;
            this.docAndDoctypeCounter = n = this.docAndDoctypeCounter + 1;
            return n;
        }
    }

    protected int assignDocumentNumber() {
        synchronized (this) {
            int n;
            this.docAndDoctypeCounter = n = this.docAndDoctypeCounter + 1;
            return n;
        }
    }

    final void checkQName(String string2) {
        int n = string2.indexOf(58);
        int n2 = string2.lastIndexOf(58);
        int n3 = string2.length();
        if (n != 0 && n != n3 - 1 && n2 == n) {
            block8: {
                n2 = 0;
                if (n > 0) {
                    if (XMLChar.isNCNameStart(string2.charAt(0))) {
                        n2 = 1;
                        while (true) {
                            if (n2 >= n) {
                                n2 = n + 1;
                                break block8;
                            }
                            if (!XMLChar.isNCName(string2.charAt(n2))) break;
                            ++n2;
                        }
                        throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
                    }
                    throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
                }
            }
            if (XMLChar.isNCNameStart(string2.charAt(n2))) {
                ++n2;
                while (true) {
                    if (n2 >= n3) {
                        return;
                    }
                    if (!XMLChar.isNCName(string2.charAt(n2))) break;
                    ++n2;
                }
                throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
            }
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
    }

    @Override
    public DOMBuilder createDOMBuilder(short s, String string2) throws DOMException {
        if (s != 2) {
            if (string2 != null && string2.equals("http://www.w3.org/TR/REC-xml")) {
                return new DOMBuilderImpl("org.apache.xerces.parsers.DTDConfiguration", string2);
            }
            return new DOMBuilderImpl("org.apache.xerces.parsers.XML11Configuration", string2);
        }
        throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null));
    }

    @Override
    public DOMInputSource createDOMInputSource() {
        return new DOMInputSourceImpl();
    }

    @Override
    public DOMWriter createDOMWriter() {
        return new DOMWriterImpl();
    }

    @Override
    public Document createDocument(String string2, String string3, DocumentType node) throws DOMException {
        if (node != null && node.getOwnerDocument() != null) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        node = new CoreDocumentImpl((DocumentType)node);
        ((NodeImpl)node).appendChild(((CoreDocumentImpl)node).createElementNS(string2, string3));
        return node;
    }

    @Override
    public DocumentType createDocumentType(String string2, String string3, String string4) {
        this.checkQName(string2);
        return new DocumentTypeImpl(null, string2, string3, string4);
    }

    @Override
    public Node getFeature(String string2, String string3) {
        throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null));
    }

    RevalidationHandler getValidator(String object) {
        synchronized (this) {
            int n;
            block6: {
                n = this.freeValidatorIndex;
                if (n >= 0) break block6;
                object = (RevalidationHandler)ObjectFactory.newInstance("org.apache.xerces.impl.xs.XMLSchemaValidator", ObjectFactory.findClassLoader(), true);
                return object;
            }
            RevalidationHandler[] revalidationHandlerArray = this.validators;
            object = revalidationHandlerArray[n];
            this.freeValidatorIndex = n - 1;
            revalidationHandlerArray[n] = null;
            return object;
        }
    }

    @Override
    public boolean hasFeature(String string2, String string3) {
        boolean bl;
        block4: {
            block3: {
                boolean bl2 = false;
                boolean bl3 = string3 == null || string3.length() == 0;
                if (string2.equalsIgnoreCase("Core") && (bl3 || string3.equals("1.0") || string3.equals("2.0")) || string2.equalsIgnoreCase("XML") && (bl3 || string3.equals("1.0") || string3.equals("2.0"))) break block3;
                bl = bl2;
                if (!string2.equalsIgnoreCase("LS-Load")) break block4;
                if (bl3) break block3;
                bl = bl2;
                if (!string3.equals("3.0")) break block4;
            }
            bl = true;
        }
        return bl;
    }

    void releaseValidator(String revalidationHandlerArray, RevalidationHandler revalidationHandler) {
        synchronized (this) {
            int n;
            this.freeValidatorIndex = n = this.freeValidatorIndex + 1;
            revalidationHandlerArray = this.validators;
            if (revalidationHandlerArray.length == n) {
                this.currentSize = n = this.currentSize + 2;
                RevalidationHandler[] revalidationHandlerArray2 = new RevalidationHandler[n];
                System.arraycopy(revalidationHandlerArray, 0, revalidationHandlerArray2, 0, revalidationHandlerArray.length);
                this.validators = revalidationHandlerArray2;
            }
            this.validators[this.freeValidatorIndex] = revalidationHandler;
            return;
        }
    }
}

