/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CommentImpl;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.DOMConfigurationImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DOMNormalizer;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentFragmentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeListCache;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.UserDataHandler;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.DOMWriter;
import org.w3c.dom.ls.DocumentLS;

public class CoreDocumentImpl
extends ParentNode
implements Document,
DocumentLS {
    private static final int[] kidOK;
    static final long serialVersionUID = 0L;
    protected String actualEncoding;
    protected boolean allowGrammarAccess;
    protected int changes = 0;
    protected ElementImpl docElement;
    protected DocumentTypeImpl docType;
    private int documentNumber = 0;
    transient DOMNormalizer domNormalizer = null;
    protected String encoding;
    protected boolean errorChecking = true;
    transient DOMConfigurationImpl fConfiguration = null;
    protected String fDocumentURI;
    transient NodeListCache fFreeNLCache;
    protected Hashtable identifiers;
    private int nodeCounter = 0;
    private Hashtable nodeTable;
    protected boolean standalone;
    protected Hashtable userData;
    protected String version;

    static {
        int[] nArray = new int[13];
        kidOK = nArray;
        nArray[9] = 1410;
        nArray[1] = 442;
        nArray[5] = 442;
        nArray[6] = 442;
        nArray[11] = 442;
        nArray[2] = 40;
        nArray[12] = 0;
        nArray[4] = 0;
        nArray[3] = 0;
        nArray[8] = 0;
        nArray[7] = 0;
        nArray[10] = 0;
    }

    public CoreDocumentImpl() {
        this(false);
    }

    public CoreDocumentImpl(DocumentType documentType) {
        this(documentType, false);
    }

    public CoreDocumentImpl(DocumentType documentType, boolean bl) {
        this(bl);
        if (documentType != null) {
            try {
                DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)documentType;
            }
            catch (ClassCastException classCastException) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
            documentTypeImpl.ownerDocument = this;
            this.appendChild(documentType);
        }
    }

    public CoreDocumentImpl(boolean bl) {
        super(null);
        this.ownerDocument = this;
        this.allowGrammarAccess = bl;
    }

    /*
     * Unable to fully structure code
     */
    private Node importNode(Node var1_1, boolean var2_2, boolean var3_3, Hashtable var4_4) throws DOMException {
        var5_5 = var1_1.getNodeType();
        var6_6 = 0;
        var7_7 = 0;
        block0 : switch (var5_5) {
            default: {
                throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null));
            }
            case 12: {
                var8_8 = (Notation)var1_1;
                var9_9 = (NotationImpl)this.createNotation(var1_1.getNodeName());
                var9_9.setPublicId(var8_8.getPublicId());
                var9_9.setSystemId(var8_8.getSystemId());
                var10_10 = var2_2;
                break;
            }
            case 11: {
                var9_9 = this.createDocumentFragment();
                var10_10 = var2_2;
                break;
            }
            case 10: {
                if (var3_3) {
                    var9_9 = (DocumentType)var1_1;
                    var8_8 = (DocumentTypeImpl)this.createDocumentType(var9_9.getNodeName(), var9_9.getPublicId(), var9_9.getSystemId());
                    var11_11 = var9_9.getEntities();
                    var12_12 = var8_8.getEntities();
                    if (var11_11 != null) {
                        for (var6_6 = 0; var6_6 < var11_11.getLength(); ++var6_6) {
                            var12_12.setNamedItem(this.importNode(var11_11.item(var6_6), true, true, var4_4));
                        }
                    }
                    var12_12 = var9_9.getNotations();
                    var11_11 = var8_8.getNotations();
                    var9_9 = var8_8;
                    var10_10 = var2_2;
                    if (var12_12 == null) break;
                    var6_6 = var7_7;
                    while (true) {
                        if (var6_6 >= var12_12.getLength()) {
                            var9_9 = var8_8;
                            var10_10 = var2_2;
                            break block0;
                        }
                        var11_11.setNamedItem(this.importNode(var12_12.item(var6_6), true, true, var4_4));
                        ++var6_6;
                    }
                }
                throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null));
            }
            case 8: {
                var9_9 = this.createComment(var1_1.getNodeValue());
                var10_10 = var2_2;
                break;
            }
            case 7: {
                var9_9 = this.createProcessingInstruction(var1_1.getNodeName(), var1_1.getNodeValue());
                var10_10 = var2_2;
                break;
            }
            case 6: {
                var8_8 = (Entity)var1_1;
                var9_9 = (EntityImpl)this.createEntity(var1_1.getNodeName());
                var9_9.setPublicId(var8_8.getPublicId());
                var9_9.setSystemId(var8_8.getSystemId());
                var9_9.setNotationName(var8_8.getNotationName());
                var9_9.isReadOnly(false);
                var10_10 = var2_2;
                break;
            }
            case 5: {
                var9_9 = this.createEntityReference(var1_1.getNodeName());
lbl64:
                // 3 sources

                while (true) {
                    var10_10 = false;
                    break block0;
                    break;
                }
            }
            case 4: {
                var9_9 = this.createCDATASection(var1_1.getNodeValue());
                var10_10 = var2_2;
                break;
            }
            case 3: {
                var9_9 = this.createTextNode(var1_1.getNodeValue());
                var10_10 = var2_2;
                break;
            }
            case 2: {
                var9_9 = var1_1.getOwnerDocument().getImplementation().hasFeature("XML", "2.0") && var1_1.getLocalName() != null ? this.createAttributeNS(var1_1.getNamespaceURI(), var1_1.getNodeName()) : this.createAttribute(var1_1.getNodeName());
                if (!(var1_1 instanceof AttrImpl)) ** GOTO lbl82
                var8_8 = (AttrImpl)var1_1;
                if (!var8_8.hasStringValue()) ** GOTO lbl85
                ((AttrImpl)var9_9).setValue(var8_8.getValue());
                ** GOTO lbl64
lbl82:
                // 1 sources

                if (var1_1.getFirstChild() == null) {
                    var9_9.setNodeValue(var1_1.getNodeValue());
                    ** continue;
                }
lbl85:
                // 3 sources

                var10_10 = true;
                break;
            }
            case 1: {
                var10_10 = var1_1.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                var8_8 = var10_10 && var1_1.getLocalName() != null ? this.createElementNS(var1_1.getNamespaceURI(), var1_1.getNodeName()) : this.createElement(var1_1.getNodeName());
                var12_12 = var1_1.getAttributes();
                if (var12_12 != null) {
                    var7_7 = var12_12.getLength();
                    while (var6_6 < var7_7) {
                        var11_11 = (Attr)var12_12.item(var6_6);
                        if (var11_11.getSpecified() || var3_3) {
                            var9_9 = (Attr)this.importNode((Node)var11_11, true, var3_3, var4_4);
                            if (var10_10 && var11_11.getLocalName() != null) {
                                var8_8.setAttributeNodeNS((Attr)var9_9);
                            } else {
                                var8_8.setAttributeNode((Attr)var9_9);
                            }
                        }
                        ++var6_6;
                    }
                }
                var9_9 = var8_8;
                var10_10 = var2_2;
                if (var4_4 == null) break;
                var11_11 = var4_4.get(var1_1);
                var9_9 = var8_8;
                var10_10 = var2_2;
                if (var11_11 == null) break;
                if (this.identifiers == null) {
                    this.identifiers = new Hashtable<K, V>();
                }
                this.identifiers.put(var11_11, var8_8);
                var10_10 = var2_2;
                var9_9 = var8_8;
            }
        }
        this.callUserDataHandlers(var1_1, var9_9, (short)2);
        if (var10_10) {
            for (var1_1 = var1_1.getFirstChild(); var1_1 != null; var1_1 = var1_1.getNextSibling()) {
                var9_9.appendChild(this.importNode(var1_1, true, var3_3, var4_4));
            }
        }
        if (var9_9.getNodeType() == 6) {
            ((NodeImpl)var9_9).setReadOnly(true, true);
        }
        return var9_9;
    }

    public static boolean isXMLName(String string2) {
        if (string2 == null) {
            return false;
        }
        return XMLChar.isValidName(string2);
    }

    @Override
    public void abort() {
    }

    protected void addEventListener(NodeImpl nodeImpl, String string2, EventListener eventListener, boolean bl) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Node adoptNode(Node node) {
        NodeImpl nodeImpl;
        try {
            nodeImpl = (NodeImpl)node;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        short s = nodeImpl.getNodeType();
        if (s != 1) {
            if (s != 2) {
                if (s != 5) {
                    if (s == 9 || s == 10) throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null));
                    Node node2 = nodeImpl.getParentNode();
                    if (node2 != null) {
                        node2.removeChild(node);
                    }
                    nodeImpl.setOwnerDocument(this);
                    return nodeImpl;
                }
                Node node3 = nodeImpl.getParentNode();
                if (node3 != null) {
                    node3.removeChild(node);
                }
                while (true) {
                    if ((node = nodeImpl.getFirstChild()) == null) {
                        nodeImpl.setOwnerDocument(this);
                        node = this.docType;
                        if (node == null || (node3 = ((DocumentTypeImpl)node).getEntities().getNamedItem(nodeImpl.getNodeName())) == null) return nodeImpl;
                        node = (EntityImpl)node3;
                        for (node = node3.getFirstChild(); node != null; node = node.getNextSibling()) {
                            nodeImpl.appendChild(node.cloneNode(true));
                        }
                        return nodeImpl;
                    }
                    nodeImpl.removeChild(node);
                }
            }
            node = (AttrImpl)nodeImpl;
            ((AttrImpl)node).getOwnerElement().removeAttributeNode((Attr)node);
            ((NodeImpl)node).isSpecified(true);
            ((AttrImpl)node).setOwnerDocument(this);
            return nodeImpl;
        }
        Node node4 = nodeImpl.getParentNode();
        if (node4 != null) {
            node4.removeChild(node);
        }
        nodeImpl.setOwnerDocument(this);
        ((ElementImpl)nodeImpl).reconcileDefaultAttributes();
        return nodeImpl;
    }

    void callUserDataHandlers(Node node, Node node2, short s) {
        Object object = this.userData;
        if (object == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)((Hashtable)object).get(node);
        if (hashtable != null && !hashtable.isEmpty()) {
            Enumeration enumeration = hashtable.keys();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                object = (String)enumeration.nextElement();
                UserDataRecord userDataRecord = (UserDataRecord)hashtable.get(object);
                if (userDataRecord.fHandler == null) continue;
                userDataRecord.fHandler.handle(s, (String)object, userDataRecord.fData, node, node2);
            }
        }
    }

    @Override
    protected void changed() {
        ++this.changes;
    }

    @Override
    protected int changes() {
        return this.changes;
    }

    protected final void checkDOMNSErr(String string2, String string3) {
        if (this.errorChecking) {
            if (string3 != null) {
                if (string2.equals("xml") && !string3.equals(NamespaceContext.XML_URI)) {
                    throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
                }
                if (string2.equals("xmlns") && !string3.equals(NamespaceContext.XMLNS_URI) || !string2.equals("xmlns") && string3.equals(NamespaceContext.XMLNS_URI)) {
                    throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
                }
            } else {
                throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
            }
        }
    }

    protected final void checkNamespaceWF(String string2, int n, int n2) {
        if (!this.errorChecking) {
            return;
        }
        if (n != 0 && n != string2.length() - 1 && n2 == n) {
            return;
        }
        throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
    }

    protected final void checkQName(String string2, String string3) {
        int n;
        int n2;
        if (!this.errorChecking) {
            return;
        }
        int n3 = 1;
        if (string2 != null) {
            n2 = string2.length();
            if (XMLChar.isNCNameStart(string2.charAt(0))) {
                for (n = 1; n < n2; ++n) {
                    if (XMLChar.isNCName(string2.charAt(n))) {
                        continue;
                    }
                    throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
                }
            } else {
                throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
            }
        }
        n2 = string3.length();
        if (XMLChar.isNCNameStart(string3.charAt(0))) {
            n = n3;
            while (true) {
                if (n >= n2) {
                    return;
                }
                if (!XMLChar.isNCName(string3.charAt(n))) break;
                ++n;
            }
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
    }

    protected final void clearIdentifiers() {
        Hashtable hashtable = this.identifiers;
        if (hashtable != null) {
            hashtable.clear();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)super.clone();
        coreDocumentImpl.docType = null;
        coreDocumentImpl.docElement = null;
        return coreDocumentImpl;
    }

    @Override
    public Node cloneNode(boolean bl) {
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl();
        this.callUserDataHandlers(this, coreDocumentImpl, (short)1);
        this.cloneNode(coreDocumentImpl, bl);
        return coreDocumentImpl;
    }

    protected void cloneNode(CoreDocumentImpl coreDocumentImpl, boolean bl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            ChildNode childNode;
            Hashtable hashtable = null;
            if (this.identifiers != null) {
                hashtable = new Hashtable();
                Enumeration enumeration = this.identifiers.keys();
                while (enumeration.hasMoreElements()) {
                    childNode = enumeration.nextElement();
                    hashtable.put(this.identifiers.get(childNode), childNode);
                }
            }
            childNode = this.firstChild;
            while (childNode != null) {
                coreDocumentImpl.appendChild(coreDocumentImpl.importNode(childNode, true, true, hashtable));
                childNode = childNode.nextSibling;
            }
        }
        coreDocumentImpl.allowGrammarAccess = this.allowGrammarAccess;
        coreDocumentImpl.errorChecking = this.errorChecking;
    }

    protected void copyEventListeners(NodeImpl nodeImpl, NodeImpl nodeImpl2) {
    }

    @Override
    public Attr createAttribute(String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrImpl(this, string2);
    }

    @Override
    public Attr createAttributeNS(String string2, String string3) throws DOMException {
        return new AttrNSImpl(this, string2, string3);
    }

    public Attr createAttributeNS(String string2, String string3, String string4) throws DOMException {
        return new AttrNSImpl(this, string2, string3, string4);
    }

    @Override
    public CDATASection createCDATASection(String string2) throws DOMException {
        return new CDATASectionImpl(this, string2);
    }

    @Override
    public Comment createComment(String string2) {
        return new CommentImpl(this, string2);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public DocumentType createDocumentType(String string2, String string3, String string4) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        return new DocumentTypeImpl(this, string2, string3, string4);
    }

    @Override
    public Element createElement(String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        return new ElementImpl(this, string2);
    }

    public ElementDefinitionImpl createElementDefinition(String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        return new ElementDefinitionImpl(this, string2);
    }

    @Override
    public Element createElementNS(String string2, String string3) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string3)) {
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        return new ElementNSImpl(this, string2, string3);
    }

    public Element createElementNS(String string2, String string3, String string4) throws DOMException {
        return new ElementNSImpl(this, string2, string3, string4);
    }

    public Entity createEntity(String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        return new EntityImpl(this, string2);
    }

    @Override
    public EntityReference createEntityReference(String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        return new EntityReferenceImpl(this, string2);
    }

    public Notation createNotation(String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        return new NotationImpl(this, string2);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string2, String string3) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
        }
        return new ProcessingInstructionImpl(this, string2, string3);
    }

    @Override
    public Text createTextNode(String string2) {
        return new TextImpl(this, string2);
    }

    void deletedText(NodeImpl nodeImpl, int n, int n2) {
    }

    protected boolean dispatchEvent(NodeImpl nodeImpl, Event event) {
        return false;
    }

    void freeNodeListCache(NodeListCache nodeListCache) {
        nodeListCache.next = this.fFreeNLCache;
        this.fFreeNLCache = nodeListCache;
    }

    public String getActualEncoding() {
        return this.actualEncoding;
    }

    @Override
    public boolean getAsync() {
        return false;
    }

    @Override
    public String getBaseURI() {
        return this.fDocumentURI;
    }

    public DOMConfiguration getConfig() {
        if (this.fConfiguration == null) {
            this.fConfiguration = new DOMConfigurationImpl();
        }
        return this.fConfiguration;
    }

    @Override
    public DocumentType getDoctype() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    @Override
    public Element getDocumentElement() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    @Override
    public String getDocumentURI() {
        return this.fDocumentURI;
    }

    @Override
    public Element getElementById(String string2) {
        return this.getIdentifier(string2);
    }

    @Override
    public NodeList getElementsByTagName(String string2) {
        return new DeepNodeListImpl(this, string2);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string2, String string3) {
        return new DeepNodeListImpl(this, string2, string3);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    public Element getIdentifier(String object) {
        Object object2;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((object2 = this.identifiers) == null) {
            return null;
        }
        if ((object2 = (Element)((Hashtable)object2).get(object)) != null) {
            for (object = object2.getParentNode(); object != null; object = object.getParentNode()) {
                if (object != this) continue;
                return object2;
            }
        }
        return null;
    }

    public Enumeration getIdentifiers() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    @Override
    public DOMImplementation getImplementation() {
        return CoreDOMImplementationImpl.getDOMImplementation();
    }

    boolean getMutationEvents() {
        return false;
    }

    NodeListCache getNodeListCache(ParentNode parentNode) {
        NodeListCache nodeListCache = this.fFreeNLCache;
        if (nodeListCache == null) {
            return new NodeListCache(parentNode);
        }
        this.fFreeNLCache = nodeListCache.next;
        nodeListCache.fChild = null;
        nodeListCache.fChildIndex = -1;
        nodeListCache.fLength = -1;
        if (nodeListCache.fOwner != null) {
            nodeListCache.fOwner.fNodeListCache = null;
        }
        nodeListCache.fOwner = parentNode;
        return nodeListCache;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    protected int getNodeNumber() {
        if (this.documentNumber == 0) {
            this.documentNumber = ((CoreDOMImplementationImpl)CoreDOMImplementationImpl.getDOMImplementation()).assignDocumentNumber();
        }
        return this.documentNumber;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int getNodeNumber(Node node) {
        Integer n;
        int n2;
        Serializable serializable = this.nodeTable;
        if (serializable == null) {
            this.nodeTable = serializable = new Hashtable();
            this.nodeCounter = n2 = this.nodeCounter - 1;
            n = new Integer(n2);
        } else {
            if ((serializable = (Integer)((Hashtable)serializable).get(node)) != null) {
                return (Integer)serializable;
            }
            this.nodeCounter = n2 = this.nodeCounter - 1;
            serializable = this.nodeTable;
            n = new Integer(n2);
        }
        ((Hashtable)serializable).put(node, n);
        return n2;
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public final Document getOwnerDocument() {
        return null;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.errorChecking;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    protected Object getUserData(NodeImpl nodeImpl) {
        return this.getUserData(nodeImpl, "XERCES1DOMUSERDATA");
    }

    public Object getUserData(Node object, String string2) {
        Hashtable hashtable = this.userData;
        if (hashtable == null) {
            return null;
        }
        if ((object = (Hashtable)hashtable.get(object)) == null) {
            return null;
        }
        if ((object = ((Hashtable)object).get(string2)) != null) {
            return ((UserDataRecord)object).fData;
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public Node importNode(Node node, boolean bl) throws DOMException {
        return this.importNode(node, bl, false, null);
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (this.errorChecking && (s == 1 && this.docElement != null || s == 10 && this.docType != null)) {
            throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
        }
        if (node.getOwnerDocument() == null && node instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)node).ownerDocument = this;
        }
        super.insertBefore(node, node2);
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    void insertedNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
    }

    void insertedText(NodeImpl nodeImpl, int n, int n2) {
    }

    void insertingNode(NodeImpl nodeImpl, boolean bl) {
    }

    protected boolean isKidOK(Node node, Node node2) {
        boolean bl = this.allowGrammarAccess;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl && node.getNodeType() == 10) {
            if (node2.getNodeType() == 1) {
                bl3 = true;
            }
            return bl3;
        }
        bl3 = bl2;
        if ((kidOK[node.getNodeType()] & 1 << node2.getNodeType()) != 0) {
            bl3 = true;
        }
        return bl3;
    }

    boolean isNormalizeDocRequired() {
        return true;
    }

    @Override
    public boolean load(String string2) {
        return false;
    }

    @Override
    public boolean loadXML(String string2) {
        return false;
    }

    void modifiedAttrValue(AttrImpl attrImpl, String string2) {
    }

    void modifiedCharacterData(NodeImpl nodeImpl, String string2, String string3) {
    }

    void modifyingCharacterData(NodeImpl nodeImpl) {
    }

    @Override
    public void normalizeDocument() {
        DOMConfigurationImpl dOMConfigurationImpl;
        if (this.isNormalized() && !this.isNormalizeDocRequired()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.domNormalizer == null) {
            this.domNormalizer = new DOMNormalizer();
        }
        if ((dOMConfigurationImpl = this.fConfiguration) == null) {
            this.fConfiguration = new DOMConfigurationImpl();
        } else {
            dOMConfigurationImpl.reset();
        }
        this.domNormalizer.normalizeDocument(this, this.fConfiguration);
        this.isNormalized(true);
    }

    public void putIdentifier(String string2, Element element) {
        if (element == null) {
            this.removeIdentifier(string2);
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string2, element);
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s = node.getNodeType();
        if (s == 1) {
            this.docElement = null;
        } else if (s == 10) {
            this.docType = null;
        }
        return node;
    }

    protected void removeEventListener(NodeImpl nodeImpl, String string2, EventListener eventListener, boolean bl) {
    }

    public void removeIdentifier(String string2) {
        Hashtable hashtable;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((hashtable = this.identifiers) == null) {
            return;
        }
        hashtable.remove(string2);
    }

    Hashtable removeUserDataTable(Node node) {
        Hashtable hashtable = this.userData;
        if (hashtable == null) {
            return null;
        }
        return (Hashtable)hashtable.get(node);
    }

    void removedAttrNode(AttrImpl attrImpl, NodeImpl nodeImpl, String string2) {
    }

    void removedNode(NodeImpl nodeImpl, boolean bl) {
    }

    void removingNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Node renameNode(Node node, String object, String object2) throws DOMException {
        block15: {
            Node node2;
            Node node3;
            ElementImpl elementImpl;
            block17: {
                block12: {
                    Element element;
                    AttrImpl attrImpl;
                    block13: {
                        block16: {
                            block14: {
                                block10: {
                                    block11: {
                                        if (node.getOwnerDocument() != this) {
                                            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
                                        }
                                        short s = node.getNodeType();
                                        if (s == 1) break block10;
                                        if (s != 2) {
                                            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null));
                                        }
                                        attrImpl = (AttrImpl)node;
                                        element = attrImpl.getOwnerElement();
                                        if (element != null) {
                                            element.removeAttributeNode(attrImpl);
                                        }
                                        if (!(node instanceof AttrNSImpl)) break block11;
                                        ((AttrNSImpl)attrImpl).rename((String)object, (String)object2);
                                        object = attrImpl;
                                        if (element != null) {
                                            element.setAttributeNodeNS(attrImpl);
                                            object = attrImpl;
                                        }
                                        break block12;
                                    }
                                    if (object != null) break block13;
                                    attrImpl.rename((String)object2);
                                    object = attrImpl;
                                    if (element != null) {
                                        element.setAttributeNode(attrImpl);
                                        object = attrImpl;
                                    }
                                    break block12;
                                }
                                elementImpl = (ElementImpl)node;
                                if (!(elementImpl instanceof ElementNSImpl)) break block14;
                                ((ElementNSImpl)elementImpl).rename((String)object, (String)object2);
                                object = elementImpl;
                                break block15;
                            }
                            if (object != null) break block16;
                            elementImpl.rename((String)object2);
                            object = elementImpl;
                            break block15;
                        }
                        object = new ElementNSImpl(this, (String)object, (String)object2);
                        this.copyEventListeners(elementImpl, (NodeImpl)object);
                        object2 = this.removeUserDataTable(elementImpl);
                        node3 = elementImpl.getParentNode();
                        node2 = elementImpl.getNextSibling();
                        if (node3 != null) {
                            node3.removeChild(elementImpl);
                        }
                        break block17;
                    }
                    object = new AttrNSImpl(this, (String)object, (String)object2);
                    this.copyEventListeners(attrImpl, (NodeImpl)object);
                    Hashtable hashtable = this.removeUserDataTable(attrImpl);
                    while (true) {
                        if ((object2 = attrImpl.getFirstChild()) == null) {
                            this.setUserDataTable((Node)object, hashtable);
                            this.callUserDataHandlers(attrImpl, (Node)object, (short)4);
                            if (element == null) break;
                            element.setAttributeNode((Attr)object);
                            break;
                        }
                        attrImpl.removeChild((Node)object2);
                        ((NodeImpl)object).appendChild((Node)object2);
                    }
                }
                this.renamedAttrNode((Attr)node, (Attr)object);
                return object;
            }
            while (true) {
                Node node4;
                if ((node4 = elementImpl.getFirstChild()) == null) {
                    ((ElementImpl)object).moveSpecifiedAttributes(elementImpl);
                    this.setUserDataTable((Node)object, (Hashtable)object2);
                    this.callUserDataHandlers(elementImpl, (Node)object, (short)4);
                    if (node3 == null) break;
                    node3.insertBefore((Node)object, node2);
                    break;
                }
                elementImpl.removeChild(node4);
                ((NodeImpl)object).appendChild(node4);
            }
        }
        this.renamedElement((Element)node, (Element)object);
        return object;
    }

    void renamedAttrNode(Attr attr2, Attr attr3) {
    }

    void renamedElement(Element element, Element element2) {
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node.getOwnerDocument() == null && node instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)node).ownerDocument = this;
        }
        super.replaceChild(node, node2);
        short s = node2.getNodeType();
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node2;
    }

    void replacedNode(NodeImpl nodeImpl) {
    }

    void replacedText(NodeImpl nodeImpl) {
    }

    void replacingNode(NodeImpl nodeImpl) {
    }

    @Override
    public String saveXML(Node node) throws DOMException {
        if (node != null && this.getOwnerDocument() != node.getOwnerDocument()) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        DOMWriter dOMWriter = ((DOMImplementationLS)((Object)DOMImplementationImpl.getDOMImplementation())).createDOMWriter();
        Node node2 = node;
        if (node == null) {
            node2 = this;
        }
        return dOMWriter.writeToString(node2);
    }

    public void setActualEncoding(String string2) {
        this.actualEncoding = string2;
    }

    @Override
    public void setAsync(boolean bl) {
        if (!bl) {
            return;
        }
        throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null));
    }

    void setAttrNode(AttrImpl attrImpl, AttrImpl attrImpl2) {
    }

    @Override
    public void setDocumentURI(String string2) {
        this.fDocumentURI = string2;
    }

    public void setEncoding(String string2) {
        this.encoding = string2;
    }

    public void setErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    void setMutationEvents(boolean bl) {
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    @Override
    public void setTextContent(String string2) throws DOMException {
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object setUserData(Node object, String string2, Object object2, UserDataHandler userDataHandler) {
        Hashtable<String, UserDataRecord> hashtable;
        block6: {
            block5: {
                block4: {
                    if (object2 == null) {
                        object2 = this.userData;
                        if (object2 == null) return null;
                        if ((object = (Hashtable)((Hashtable)object2).get(object)) == null) return null;
                        if ((object = ((Hashtable)object).remove(string2)) == null) return null;
                        return ((UserDataRecord)object).fData;
                    }
                    hashtable = this.userData;
                    if (hashtable != null) break block4;
                    this.userData = new Hashtable();
                    hashtable = new Hashtable<String, UserDataRecord>();
                    break block5;
                }
                Hashtable hashtable2 = (Hashtable)hashtable.get(object);
                hashtable = hashtable2;
                if (hashtable2 != null) break block6;
                hashtable = new Hashtable();
            }
            this.userData.put(object, hashtable);
        }
        object = hashtable.put(string2, new UserDataRecord(object2, userDataHandler));
        if (object == null) return null;
        return ((UserDataRecord)object).fData;
    }

    protected void setUserData(NodeImpl nodeImpl, Object object) {
        this.setUserData(nodeImpl, "XERCES1DOMUSERDATA", object, null);
    }

    void setUserDataTable(Node node, Hashtable hashtable) {
        if (hashtable != null) {
            this.userData.put(node, hashtable);
        }
    }

    public void setVersion(String string2) {
        this.version = string2;
    }

    class UserDataRecord
    implements Serializable {
        Object fData;
        UserDataHandler fHandler;

        UserDataRecord(Object object, UserDataHandler userDataHandler) {
            this.fData = object;
            this.fHandler = userDataHandler;
        }
    }
}

