/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.DOMEntityResolverWrapper;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.ls.DOMEntityResolver;

public class DOMConfigurationImpl
extends ParserConfigurationSettings
implements XMLParserConfiguration,
DOMConfiguration {
    protected static final short CDATA = 8;
    protected static final short COMMENTS = 32;
    protected static final short DTNORMALIZATION = 2;
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final short ENTITIES = 4;
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final short NAMESPACES = 1;
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final short PSVI = 128;
    protected static final String SCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String SEND_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final short SPLITCDATA = 16;
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final short VALIDATE = 64;
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String XERCES_NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String XERCES_VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String XML_STRING = "http://xml.org/sax/properties/xml-string";
    protected Vector fComponents;
    XMLDocumentHandler fDocumentHandler;
    protected final DOMErrorHandlerWrapper fErrorHandlerWrapper;
    protected XMLErrorReporter fErrorReporter;
    protected Locale fLocale;
    protected SymbolTable fSymbolTable;
    protected ValidationManager fValidationManager;
    protected short features = (short)0;

    protected DOMConfigurationImpl() {
        this(null, null);
    }

    protected DOMConfigurationImpl(SymbolTable symbolTable) {
        this(symbolTable, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DOMConfigurationImpl(SymbolTable object, XMLComponentManager object2) {
        super((XMLComponentManager)object2);
        this.fErrorHandlerWrapper = new DOMErrorHandlerWrapper();
        this.fRecognizedFeatures = new Vector();
        this.fRecognizedProperties = new Vector();
        this.fFeatures = new Hashtable();
        this.fProperties = new Hashtable();
        this.addRecognizedFeatures(new String[]{XERCES_VALIDATION, XERCES_NAMESPACES, SCHEMA, DYNAMIC_VALIDATION, NORMALIZE_DATA, SEND_PSVI});
        this.setFeature(XERCES_VALIDATION, false);
        this.setFeature(SCHEMA, false);
        this.setFeature(DYNAMIC_VALIDATION, false);
        this.setFeature(NORMALIZE_DATA, false);
        this.setFeature(XERCES_NAMESPACES, true);
        this.setFeature(SEND_PSVI, true);
        this.addRecognizedProperties(new String[]{XML_STRING, SYMBOL_TABLE, ERROR_HANDLER, ENTITY_RESOLVER, ERROR_REPORTER, ENTITY_MANAGER, VALIDATION_MANAGER, GRAMMAR_POOL, JAXP_SCHEMA_SOURCE, JAXP_SCHEMA_LANGUAGE});
        short s = (short)(this.features | 1);
        this.features = s;
        s = (short)(s | 4);
        this.features = s;
        s = (short)(s | 0x20);
        this.features = s;
        s = (short)(s | 8);
        this.features = s;
        this.features = (short)(s | 0x10);
        object2 = object;
        if (object == null) {
            object2 = new SymbolTable();
        }
        this.fSymbolTable = object2;
        this.fComponents = new Vector();
        this.setProperty(SYMBOL_TABLE, this.fSymbolTable);
        this.fErrorReporter = object = new XMLErrorReporter();
        this.setProperty(ERROR_REPORTER, object);
        this.addComponent(this.fErrorReporter);
        object = new XMLEntityManager();
        this.setProperty(ENTITY_MANAGER, object);
        this.addComponent((XMLComponent)object);
        this.fValidationManager = object = this.createValidationManager();
        this.setProperty(VALIDATION_MANAGER, object);
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210") == null) {
            object = new XMLMessageFormatter();
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", (MessageFormatter)object);
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", (MessageFormatter)object);
        }
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            object = null;
            try {
                object = object2 = (MessageFormatter)ObjectFactory.newInstance("org.apache.xerces.impl.xs.XSMessageFormatter", ObjectFactory.findClassLoader(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null) {
                this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", (MessageFormatter)object);
            }
        }
        try {
            this.setLocale(Locale.getDefault());
            return;
        }
        catch (XNIException xNIException) {
            return;
        }
    }

    protected void addComponent(XMLComponent xMLComponent) {
        if (this.fComponents.contains(xMLComponent)) {
            return;
        }
        this.fComponents.addElement(xMLComponent);
        this.addRecognizedFeatures(xMLComponent.getRecognizedFeatures());
        this.addRecognizedProperties(xMLComponent.getRecognizedProperties());
    }

    @Override
    public boolean canSetParameter(String string2, Object object) {
        if (!(string2.equals("comments") || string2.equals("datatype-normalization") || string2.equals("cdata-sections") || string2.equals("entities") || string2.equals("split-cdata-sections") || string2.equals("namespaces") || string2.equals("validate"))) {
            boolean bl = string2.equals("infoset");
            boolean bl2 = true;
            boolean bl3 = true;
            if (!(bl || string2.equals("normalize-characters") || string2.equals("canonical-form") || string2.equals("validate-if-schema"))) {
                if (!(string2.equals("namespace-declarations") || string2.equals("whitespace-in-element-content") || string2.equals(SEND_PSVI))) {
                    throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string2}));
                }
                if (object != Boolean.TRUE) {
                    bl3 = false;
                }
                return bl3;
            }
            if (object instanceof Boolean) {
                bl3 = bl2;
                if (object == Boolean.TRUE) {
                    bl3 = false;
                }
                return bl3;
            }
            return false;
        }
        return object instanceof Boolean;
    }

    @Override
    protected void checkProperty(String string2) throws XMLConfigurationException {
        if (string2.startsWith("http://xml.org/sax/properties/") && string2.substring(30).equals("xml-string")) {
            throw new XMLConfigurationException(1, string2);
        }
        super.checkProperty(string2);
    }

    protected ValidationManager createValidationManager() {
        return new ValidationManager();
    }

    @Override
    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return null;
    }

    @Override
    public XMLDTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    @Override
    public XMLEntityResolver getEntityResolver() {
        return (XMLEntityResolver)this.fProperties.get(ENTITY_RESOLVER);
    }

    @Override
    public XMLErrorHandler getErrorHandler() {
        return (XMLErrorHandler)this.fProperties.get(ERROR_HANDLER);
    }

    @Override
    public Locale getLocale() {
        return this.fLocale;
    }

    @Override
    public Object getParameter(String object) throws DOMException {
        if (((String)object).equals("comments")) {
            object = (this.features & 0x20) != 0 ? Boolean.TRUE : Boolean.FALSE;
            return object;
        }
        if (((String)object).equals("namespaces")) {
            object = (this.features & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
            return object;
        }
        if (((String)object).equals("datatype-normalization")) {
            object = (this.features & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
            return object;
        }
        if (((String)object).equals("cdata-sections")) {
            object = (this.features & 8) != 0 ? Boolean.TRUE : Boolean.FALSE;
            return object;
        }
        if (((String)object).equals("entities")) {
            object = (this.features & 4) != 0 ? Boolean.TRUE : Boolean.FALSE;
            return object;
        }
        if (((String)object).equals("split-cdata-sections")) {
            object = (this.features & 0x10) != 0 ? Boolean.TRUE : Boolean.FALSE;
            return object;
        }
        if (((String)object).equals("validate")) {
            object = (this.features & 0x40) != 0 ? Boolean.TRUE : Boolean.FALSE;
            return object;
        }
        if (!(((String)object).equals("infoset") || ((String)object).equals("normalize-characters") || ((String)object).equals("canonical-form") || ((String)object).equals("validate-if-schema"))) {
            if (((String)object).equals(SEND_PSVI)) {
                return Boolean.TRUE;
            }
            if (((String)object).equals("psvi")) {
                object = (this.features & 0x80) != 0 ? Boolean.TRUE : Boolean.FALSE;
                return object;
            }
            if (!((String)object).equals("namespace-declarations") && !((String)object).equals("whitespace-in-element-content")) {
                if (((String)object).equals("error-handler")) {
                    return this.fErrorHandlerWrapper.getErrorHandler();
                }
                if (((String)object).equals("entity-resolver")) {
                    object = this.getEntityResolver();
                    if (object != null && object instanceof DOMEntityResolverWrapper) {
                        return ((DOMEntityResolverWrapper)object).getEntityResolver();
                    }
                    return null;
                }
                if (((String)object).equals("schema-type")) {
                    return this.getProperty(JAXP_SCHEMA_LANGUAGE);
                }
                if (((String)object).equals("schema-location")) {
                    return this.getProperty(JAXP_SCHEMA_SOURCE);
                }
                if (((String)object).equals(SYMBOL_TABLE)) {
                    return this.getProperty(SYMBOL_TABLE);
                }
                if (((String)object).equals(GRAMMAR_POOL)) {
                    return this.getProperty(GRAMMAR_POOL);
                }
                throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{object}));
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void parse(XMLInputSource xMLInputSource) throws XNIException, IOException {
    }

    protected void reset() throws XNIException {
        ValidationManager validationManager = this.fValidationManager;
        if (validationManager != null) {
            validationManager.reset();
        }
        int n = this.fComponents.size();
        int n2 = 0;
        while (n2 < n) {
            ((XMLComponent)this.fComponents.elementAt(n2)).reset(this);
            ++n2;
        }
        return;
    }

    @Override
    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
    }

    @Override
    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    @Override
    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        if (xMLEntityResolver != null) {
            this.fProperties.put(ENTITY_RESOLVER, xMLEntityResolver);
        }
    }

    @Override
    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        if (xMLErrorHandler != null) {
            this.fProperties.put(ERROR_HANDLER, xMLErrorHandler);
        }
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
        super.setFeature(string2, bl);
    }

    @Override
    public void setLocale(Locale locale) throws XNIException {
        this.fLocale = locale;
        this.fErrorReporter.setLocale(locale);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setParameter(String object, Object object2) throws DOMException {
        boolean bl;
        block35: {
            block36: {
                int n;
                block28: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    block30: {
                                        block29: {
                                            block27: {
                                                if (object2 != Boolean.TRUE && object2 != Boolean.FALSE) {
                                                    if (((String)object).equals("error-handler")) {
                                                        if (object2 instanceof DOMErrorHandler) {
                                                            this.fErrorHandlerWrapper.setErrorHandler((DOMErrorHandler)object2);
                                                            this.setErrorHandler(this.fErrorHandlerWrapper);
                                                            return;
                                                        }
                                                        throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                                                    }
                                                    if (((String)object).equals("entity-resolver")) {
                                                        if (!(object2 instanceof DOMEntityResolver)) {
                                                            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                                                        }
                                                        object = new DOMEntityResolverWrapper((DOMEntityResolver)object2);
                                                        this.setEntityResolver((XMLEntityResolver)object);
                                                        return;
                                                    }
                                                    if (((String)object).equals("schema-location")) {
                                                        if (!(object2 instanceof String)) {
                                                            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                                                        }
                                                        if ((String)this.getProperty(JAXP_SCHEMA_LANGUAGE) == Constants.NS_XMLSCHEMA) {
                                                            this.setProperty(JAXP_SCHEMA_SOURCE, object2);
                                                            return;
                                                        }
                                                        object = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object});
                                                        object2 = new DOMException(9, (String)object);
                                                        throw object2;
                                                    }
                                                    if (((String)object).equals("schema-type")) {
                                                        if (!(object2 instanceof String)) {
                                                            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                                                        }
                                                        if (object2.equals(Constants.NS_XMLSCHEMA)) {
                                                            this.setProperty(JAXP_SCHEMA_LANGUAGE, Constants.NS_XMLSCHEMA);
                                                            return;
                                                        }
                                                        if (!object2.equals(Constants.NS_DTD)) {
                                                            return;
                                                        }
                                                        object = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object});
                                                        object2 = new DOMException(9, (String)object);
                                                        throw object2;
                                                    }
                                                    String string2 = SYMBOL_TABLE;
                                                    if (((String)object).equals(SYMBOL_TABLE)) {
                                                        if (!(object2 instanceof SymbolTable)) {
                                                            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                                                        }
                                                        object = string2;
                                                    } else {
                                                        string2 = GRAMMAR_POOL;
                                                        if (!((String)object).equals(GRAMMAR_POOL)) {
                                                            throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{object}));
                                                        }
                                                        if (!(object2 instanceof XMLGrammarPool)) {
                                                            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                                                        }
                                                        object = string2;
                                                    }
                                                    this.setProperty((String)object, object2);
                                                    return;
                                                }
                                                bl = object2 == Boolean.TRUE;
                                                if (!((String)object).equals("comments")) break block27;
                                                n = this.features;
                                                n = bl ? (n |= 0x20) : (n &= 0xFFFFFFDF);
                                                break block28;
                                            }
                                            if (!((String)object).equals("datatype-normalization")) break block29;
                                            this.setFeature(NORMALIZE_DATA, bl);
                                            n = this.features;
                                            n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
                                            break block28;
                                        }
                                        if (!((String)object).equals("namespaces")) break block30;
                                        n = this.features;
                                        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
                                        break block28;
                                    }
                                    if (!((String)object).equals("cdata-sections")) break block31;
                                    n = this.features;
                                    n = bl ? (n |= 8) : (n &= 0xFFFFFFF7);
                                    break block28;
                                }
                                if (!((String)object).equals("entities")) break block32;
                                n = this.features;
                                n = bl ? (n |= 4) : (n &= 0xFFFFFFFB);
                                break block28;
                            }
                            if (!((String)object).equals("split-cdata-sections")) break block33;
                            n = this.features;
                            n = bl ? (n |= 0x10) : (n &= 0xFFFFFFEF);
                            break block28;
                        }
                        if (!((String)object).equals("validate")) break block34;
                        n = this.features;
                        n = bl ? (n |= 0x40) : (n &= 0xFFFFFFBF);
                        break block28;
                    }
                    if (((String)object).equals("infoset") || ((String)object).equals("normalize-characters") || ((String)object).equals("canonical-form") || ((String)object).equals("validate-if-schema")) break block35;
                    if (!((String)object).equals("namespace-declarations") && !((String)object).equals("whitespace-in-element-content")) {
                        if (((String)object).equals(SEND_PSVI)) {
                            if (bl) {
                                return;
                            }
                            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
                        }
                        if (!((String)object).equals("psvi")) {
                            throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{object}));
                        }
                        n = this.features;
                        n = bl ? (n |= 0x80) : (n &= 0xFFFFFF7F);
                    }
                    break block36;
                }
                this.features = (short)n;
                return;
            }
            if (bl) {
                return;
            }
            throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
        }
        if (!bl) {
            return;
        }
        throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{object}));
        catch (XMLConfigurationException xMLConfigurationException) {
            return;
        }
    }

    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        super.setProperty(string2, object);
    }
}

