/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMConfigurationImpl;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.psvi.AttributePSVI;
import org.apache.xerces.xni.psvi.ElementPSVI;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMNormalizer
implements XMLDocumentHandler {
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG_EVENTS = false;
    protected static final boolean DEBUG_ND = false;
    protected static final String PREFIX = "NS";
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    private QName fAttrQName;
    protected final Vector fAttributeList;
    protected DOMConfigurationImpl fConfiguration = null;
    protected Node fCurrentNode = null;
    protected final DOMErrorImpl fDOMError;
    protected CoreDocumentImpl fDocument = null;
    protected DOMErrorHandler fErrorHandler;
    protected final NamespaceContext fLocalNSBinder;
    protected final DOMLocatorImpl fLocator;
    protected final NamespaceContext fNamespaceContext;
    protected boolean fNamespaceValidation = false;
    final XMLString fNormalizedValue;
    protected boolean fPSVI = false;
    protected final QName fQName = new QName();
    protected SymbolTable fSymbolTable;
    protected RevalidationHandler fValidationHandler;

    public DOMNormalizer() {
        this.fNamespaceContext = new NamespaceSupport();
        this.fLocalNSBinder = new NamespaceSupport();
        this.fAttributeList = new Vector(5, 10);
        this.fDOMError = new DOMErrorImpl();
        this.fLocator = new DOMLocatorImpl();
        this.fAttrQName = new QName();
        this.fNormalizedValue = new XMLString(new char[16], 0, 0);
    }

    protected final void addNamespaceDecl(String string2, String string3, ElementImpl elementImpl) {
        if (string2 == XMLSymbols.EMPTY_STRING) {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS, string3);
        } else {
            String string4 = NamespaceContext.XMLNS_URI;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("xmlns:");
            stringBuffer.append(string2);
            elementImpl.setAttributeNS(string4, stringBuffer.toString(), string3);
        }
    }

    @Override
    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    @Override
    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    @Override
    public void doctypeDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
    }

    @Override
    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    @Override
    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    @Override
    public void endDocument(Augmentations augmentations) throws XNIException {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void endElement(QName cloneable, Augmentations object) throws XNIException {
        ElementPSVI elementPSVI = (ElementPSVI)object.getItem("ELEMENT_PSVI");
        if (elementPSVI == null) return;
        object = this.fCurrentNode;
        cloneable = (ElementImpl)object;
        if (this.fPSVI) {
            ((PSVIElementNSImpl)object).setPSVI(elementPSVI);
        }
        object = elementPSVI.getSchemaNormalizedValue();
        if ((this.fConfiguration.features & 2) != 0) {
            if (object == null) return;
        } else {
            if (((ParentNode)cloneable).getTextContent().length() != 0) return;
            if (object == null) return;
        }
        ((ParentNode)cloneable).setTextContent((String)object);
    }

    @Override
    public void endGeneralEntity(String string2, Augmentations augmentations) throws XNIException {
    }

    protected final void expandEntityRef(Node node, Node node2, Node node3) {
        Node node4 = node.getFirstChild();
        while (node4 != null) {
            Node node5 = node4.getNextSibling();
            if (node.getNodeType() == 3) {
                this.expandEntityRef(node4, node2, node3);
            } else {
                node2.insertBefore(node4, node3);
            }
            node4 = node5;
        }
        return;
    }

    @Override
    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    @Override
    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    protected final DOMError modifyDOMError(String string2, short s, Node node) {
        this.fDOMError.reset();
        this.fDOMError.fMessage = string2;
        this.fDOMError.fSeverity = s;
        this.fDOMError.fLocator = this.fLocator;
        this.fLocator.fRelatedNode = node;
        return this.fDOMError;
    }

    /*
     * Unable to fully structure code
     */
    protected final void namespaceFixUp(ElementImpl var1_1, AttributeMap var2_2) {
        block22: {
            block20: {
                block21: {
                    block19: {
                        if (var2_2 != null) {
                            for (var3_3 = 0; var3_3 < var2_2.getLength(); ++var3_3) {
                                var4_4 = (Attr)var2_2.getItem(var3_3);
                                var5_5 = var4_4.getNamespaceURI();
                                if (var5_5 == null || !var5_5.equals(NamespaceContext.XMLNS_URI)) continue;
                                var6_6 = var4_4.getNodeValue();
                                var5_5 = var6_6;
                                if (var6_6 == null) {
                                    var5_5 = XMLSymbols.EMPTY_STRING;
                                }
                                if (var5_5.equals(NamespaceContext.XMLNS_URI)) {
                                    if (this.fErrorHandler == null) continue;
                                    this.modifyDOMError("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name", (short)1, (Node)var4_4);
                                    if (this.fErrorHandler.handleError(this.fDOMError)) continue;
                                    throw new RuntimeException("Stopped at user request");
                                }
                                var6_6 = var4_4.getPrefix();
                                var6_6 = var6_6 != null && var6_6.length() != 0 ? this.fSymbolTable.addSymbol((String)var6_6) : XMLSymbols.EMPTY_STRING;
                                var4_4 = this.fSymbolTable.addSymbol(var4_4.getLocalName());
                                if (var6_6 == XMLSymbols.PREFIX_XMLNS) {
                                    if ((var5_5 = this.fSymbolTable.addSymbol((String)var5_5)).length() == 0) continue;
                                    this.fNamespaceContext.declarePrefix((String)var4_4, (String)var5_5);
                                    continue;
                                }
                                var5_5 = this.fSymbolTable.addSymbol((String)var5_5);
                                this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, (String)var5_5);
                            }
                        }
                        var6_6 = var1_1.getNamespaceURI();
                        var5_5 = var1_1.getPrefix();
                        if (var6_6 == null) break block19;
                        var6_6 = this.fSymbolTable.addSymbol((String)var6_6);
                        var5_5 = var5_5 != null && var5_5.length() != 0 ? this.fSymbolTable.addSymbol((String)var5_5) : XMLSymbols.EMPTY_STRING;
                        if (this.fNamespaceContext.getURI((String)var5_5) != var6_6) {
                            this.addNamespaceDecl((String)var5_5, (String)var6_6, var1_1);
                            this.fLocalNSBinder.declarePrefix((String)var5_5, (String)var6_6);
                            this.fNamespaceContext.declarePrefix((String)var5_5, (String)var6_6);
                        }
                        break block20;
                    }
                    if (var1_1.getLocalName() != null) break block21;
                    if (this.fErrorHandler == null) ** GOTO lbl62
                    if (!this.fNamespaceValidation) {
                        var5_5 = new StringBuffer();
                        var5_5.append("DOM Level 1 node: ");
                        var5_5.append(var1_1.getNodeName());
                        this.modifyDOMError(var5_5.toString(), (short)1, var1_1);
                        var7_7 = this.fErrorHandler.handleError(this.fDOMError);
                    } else {
                        var5_5 = new StringBuffer();
                        var5_5.append("DOM Level 1 node: ");
                        var5_5.append(var1_1.getNodeName());
                        this.modifyDOMError(var5_5.toString(), (short)2, var1_1);
                        this.fErrorHandler.handleError(this.fDOMError);
lbl62:
                        // 2 sources

                        var7_7 = true;
                    }
                    if (this.fNamespaceValidation || !var7_7) {
                        var2_2 = new StringBuffer();
                        var2_2.append("DOM Level 1 node: ");
                        var2_2.append(var1_1.getNodeName());
                        throw new RuntimeException(var2_2.toString());
                    }
                    break block20;
                }
                var5_5 = this.fNamespaceContext.getURI(XMLSymbols.EMPTY_STRING);
                if (var5_5 != null && var5_5.length() > 0) {
                    this.addNamespaceDecl(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, var1_1);
                    this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                }
            }
            if (var2_2 == null) break block22;
            var2_2.cloneMap(this.fAttributeList);
            block1: for (var3_3 = 0; var3_3 < this.fAttributeList.size(); ++var3_3) {
                block23: {
                    block24: {
                        var4_4 = (Attr)this.fAttributeList.elementAt(var3_3);
                        var4_4.normalize();
                        var2_2 = var4_4.getValue();
                        var8_8 = var4_4.getNodeName();
                        var6_6 = var4_4.getNamespaceURI();
                        var5_5 = var2_2;
                        if (var2_2 == null) {
                            var5_5 = XMLSymbols.EMPTY_STRING;
                        }
                        if (var6_6 == null) break block23;
                        var2_2 = var4_4.getPrefix();
                        var2_2 = var2_2 != null && var2_2.length() != 0 ? this.fSymbolTable.addSymbol((String)var2_2) : XMLSymbols.EMPTY_STRING;
                        this.fSymbolTable.addSymbol(var4_4.getLocalName());
                        if (var6_6 != null && var6_6.equals(NamespaceContext.XMLNS_URI)) continue;
                        ((AttrImpl)var4_4).setIdAttribute(false);
                        var8_8 = this.fSymbolTable.addSymbol((String)var6_6);
                        var6_6 = this.fNamespaceContext.getURI((String)var2_2);
                        if (var2_2 != XMLSymbols.EMPTY_STRING && var6_6 == var8_8) continue;
                        var4_4.getNodeName();
                        var6_6 = this.fNamespaceContext.getPrefix(var8_8);
                        if (var6_6 == null || var6_6 == XMLSymbols.EMPTY_STRING) break block24;
                        var2_2 = var6_6;
                        ** GOTO lbl126
                    }
                    if (var2_2 != XMLSymbols.EMPTY_STRING && this.fLocalNSBinder.getURI((String)var2_2) == null) ** GOTO lbl120
                    var2_2 = this.fSymbolTable;
                    var6_6 = new StringBuffer();
                    var6_6.append("NS");
                    var6_6.append(1);
                    var2_2 = var2_2.addSymbol(var6_6.toString());
                    var9_9 = 2;
                    while (true) {
                        block25: {
                            if (this.fLocalNSBinder.getURI((String)var2_2) != null) break block25;
lbl120:
                            // 2 sources

                            this.addNamespaceDecl((String)var2_2, var8_8, var1_1);
                            var5_5 = this.fSymbolTable.addSymbol((String)var5_5);
                            this.fLocalNSBinder.declarePrefix((String)var2_2, (String)var5_5);
                            this.fNamespaceContext.declarePrefix((String)var2_2, var8_8);
lbl126:
                            // 2 sources

                            var4_4.setPrefix((String)var2_2);
                            continue block1;
                        }
                        var2_2 = this.fSymbolTable;
                        var6_6 = new StringBuffer();
                        var6_6.append("NS");
                        var6_6.append(var9_9);
                        var2_2 = var2_2.addSymbol(var6_6.toString());
                        ++var9_9;
                    }
                }
                ((AttrImpl)var4_4).setIdAttribute(false);
                if (var4_4.getLocalName() != null) continue;
                if (this.fErrorHandler == null) ** GOTO lbl161
                if (!this.fNamespaceValidation) {
                    var2_2 = new StringBuffer();
                    var2_2.append("DOM Level 1 node: ");
                    var2_2.append(var8_8);
                    this.modifyDOMError(var2_2.toString(), (short)1, (Node)var4_4);
                    var7_7 = this.fErrorHandler.handleError(this.fDOMError);
                } else {
                    var2_2 = new StringBuffer();
                    var2_2.append("DOM Level 1 node: ");
                    var2_2.append(var8_8);
                    this.modifyDOMError(var2_2.toString(), (short)2, (Node)var4_4);
                    this.fErrorHandler.handleError(this.fDOMError);
lbl161:
                    // 2 sources

                    var7_7 = true;
                }
                if (!this.fNamespaceValidation && var7_7) continue;
                throw new RuntimeException("DOM Level 1 node");
            }
        }
    }

    final String normalizeAttributeValue(String string2, Attr attr2) {
        if (!attr2.getSpecified()) {
            return string2;
        }
        int n = string2.length();
        if (this.fNormalizedValue.ch.length < n) {
            this.fNormalizedValue.ch = new char[n];
        }
        Object object = this.fNormalizedValue;
        int n2 = 0;
        ((XMLString)object).length = 0;
        int n3 = 0;
        while (true) {
            block10: {
                int n4;
                block9: {
                    XMLString xMLString;
                    block7: {
                        block8: {
                            if (n2 >= n) {
                                if (n3 != 0) {
                                    string2 = this.fNormalizedValue.toString();
                                    attr2.setValue(string2);
                                }
                                return string2;
                            }
                            n4 = string2.charAt(n2);
                            if (n4 == 9 || n4 == 10) break block7;
                            if (n4 != 13) break block8;
                            object = this.fNormalizedValue.ch;
                            xMLString = this.fNormalizedValue;
                            n3 = xMLString.length;
                            xMLString.length = n3 + 1;
                            object[n3] = (char)32;
                            n4 = n2 + 1;
                            n3 = n2;
                            if (n4 < n) {
                                n3 = n2;
                                if (string2.charAt(n4) == '\n') {
                                    n3 = n4;
                                }
                            }
                            break block9;
                        }
                        object = this.fNormalizedValue.ch;
                        xMLString = this.fNormalizedValue;
                        int n5 = xMLString.length;
                        xMLString.length = n5 + 1;
                        object[n5] = (char)n4;
                        break block10;
                    }
                    object = this.fNormalizedValue.ch;
                    xMLString = this.fNormalizedValue;
                    n3 = xMLString.length;
                    xMLString.length = n3 + 1;
                    object[n3] = (char)32;
                    n3 = n2;
                }
                n4 = 1;
                n2 = n3;
                n3 = n4;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void normalizeDocument(CoreDocumentImpl object, DOMConfigurationImpl object2) {
        this.fDocument = object;
        this.fConfiguration = object2;
        this.fSymbolTable = (SymbolTable)((ParserConfigurationSettings)object2).getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fNamespaceContext.reset();
        this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        if ((this.fConfiguration.features & 0x40) != 0) {
            this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator("http://www.w3.org/2001/XMLSchema");
            object = this.fConfiguration;
            boolean bl = true;
            ((DOMConfigurationImpl)object).setFeature("http://xml.org/sax/features/validation", true);
            this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.fNamespaceValidation = true;
            if ((this.fConfiguration.features & 0x80) == 0) {
                bl = false;
            }
            this.fPSVI = bl;
            this.fDocument.clearIdentifiers();
            ((XMLComponent)((Object)this.fValidationHandler)).reset(this.fConfiguration);
        }
        this.fErrorHandler = (DOMErrorHandler)this.fConfiguration.getParameter("error-handler");
        object = this.fValidationHandler;
        if (object != null) {
            object.setBaseURI(this.fDocument.fDocumentURI);
            this.fValidationHandler.setDocumentHandler(this);
            this.fValidationHandler.startDocument(null, this.fDocument.encoding, this.fNamespaceContext, null);
        }
        try {
            object = this.fDocument.getFirstChild();
            while (true) {
                if (object == null) {
                    object = this.fValidationHandler;
                    if (object == null) return;
                    object.endDocument(null);
                    CoreDOMImplementationImpl.singleton.releaseValidator("http://www.w3.org/2001/XMLSchema", this.fValidationHandler);
                    this.fValidationHandler = null;
                    return;
                }
                object2 = object.getNextSibling();
                if ((object = this.normalizeNode((Node)object)) != null) continue;
                object = object2;
            }
        }
        catch (RuntimeException runtimeException) {
            object = new StringBuffer();
            ((StringBuffer)object).append("Runtime exception: ");
            ((StringBuffer)object).append(runtimeException.getMessage());
            this.modifyDOMError(((StringBuffer)object).toString(), (short)2, null);
            this.fErrorHandler.handleError(this.fDOMError);
            runtimeException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Node normalizeNode(Node object) {
        Object object2;
        ElementImpl elementImpl;
        block26: {
            int n;
            block27: {
                block24: {
                    block25: {
                        block22: {
                            Object object3;
                            Node node;
                            block21: {
                                block23: {
                                    short s = object.getNodeType();
                                    n = 0;
                                    if (s == 1) break block22;
                                    if (s == 8) break block23;
                                    if (s == 10) {
                                        if ((this.fConfiguration.features & 4) != 0) return null;
                                        ((DocumentTypeImpl)object).entities.removeAll();
                                        return null;
                                    }
                                    if (s != 3) {
                                        if (s != 4) {
                                            if (s != 5) {
                                                return null;
                                            }
                                            if ((this.fConfiguration.features & 4) != 0) return null;
                                            Node node2 = object.getPreviousSibling();
                                            Node node3 = object.getParentNode();
                                            ((EntityReferenceImpl)object).setReadOnly(false, true);
                                            this.expandEntityRef((Node)object, node3, (Node)object);
                                            node3.removeChild((Node)object);
                                            object = node2 != null ? node2.getNextSibling() : node3.getFirstChild();
                                            if (node2 == null) return object;
                                            if (node2.getNodeType() != 3) return object;
                                            if (object.getNodeType() != 3) return object;
                                            return node2;
                                        }
                                        if ((this.fConfiguration.features & 8) == 0) {
                                            Text text = this.fDocument.createTextNode(object.getNodeValue());
                                            Node node4 = object.getParentNode();
                                            Node node5 = object.getPreviousSibling();
                                            node4.replaceChild(text, (Node)object);
                                            if (node5 == null) return text;
                                            if (node5.getNodeType() != 3) return text;
                                            text.insertData(0, node5.getNodeValue());
                                            node4.removeChild(node5);
                                            return text;
                                        }
                                        if (this.fValidationHandler != null) {
                                            this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = object;
                                            this.fCurrentNode = object;
                                            this.fValidationHandler.startCDATA(null);
                                            this.fValidationHandler.characterData(object.getNodeValue(), null);
                                            this.fValidationHandler.endCDATA(null);
                                        }
                                        break block24;
                                    } else {
                                        Node node6 = object.getNextSibling();
                                        if (node6 != null && node6.getNodeType() == 3) {
                                            ((Text)object).appendData(node6.getNodeValue());
                                            node = object.getParentNode();
                                            object3 = object;
                                            object = node6;
                                            break block21;
                                        } else {
                                            if (object.getNodeValue().length() == 0) {
                                                object.getParentNode().removeChild((Node)object);
                                                return null;
                                            }
                                            if (this.fValidationHandler == null) return null;
                                            n = node6 != null ? (int)node6.getNodeType() : -1;
                                            if ((this.fConfiguration.features & 4) == 0) {
                                                if (n == 6) return null;
                                            }
                                            if ((this.fConfiguration.features & 0x20) == 0) {
                                                if (n == 8) return null;
                                            }
                                            if ((this.fConfiguration.features & 8) == 0) {
                                                if (n == 4) return null;
                                            }
                                            this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = object;
                                            this.fCurrentNode = object;
                                            this.fValidationHandler.characterData(object.getNodeValue(), null);
                                            return null;
                                        }
                                    }
                                }
                                if ((this.fConfiguration.features & 0x20) != 0) return null;
                                Node node7 = object.getPreviousSibling();
                                node = object.getParentNode();
                                node.removeChild((Node)object);
                                if (node7 == null) return null;
                                if (node7.getNodeType() != 3) return null;
                                object3 = node7.getNextSibling();
                                if (object3 == null) return null;
                                if (object3.getNodeType() != 3) return null;
                                ((TextImpl)object3).insertData(0, node7.getNodeValue());
                                object = node7;
                            }
                            node.removeChild((Node)object);
                            return object3;
                        }
                        this.fNamespaceContext.pushContext();
                        this.fLocalNSBinder.reset();
                        elementImpl = (ElementImpl)object;
                        if (elementImpl.needsSyncChildren()) {
                            elementImpl.synchronizeChildren();
                        }
                        object2 = elementImpl.hasAttributes() ? (AttributeMap)elementImpl.getAttributes() : null;
                        if ((1 & this.fConfiguration.features) == 0) break block25;
                        this.namespaceFixUp(elementImpl, (AttributeMap)object2);
                        break block26;
                    }
                    if (object2 == null) break block26;
                    break block27;
                }
                if ((this.fConfiguration.features & 0x10) == 0) return null;
                String string2 = object.getNodeValue();
                n = string2.indexOf("]]>");
                Node node = object.getParentNode();
                Object object4 = object;
                object = string2;
                while (true) {
                    if (n < 0) {
                        return null;
                    }
                    object4.setNodeValue(((String)object).substring(0, n += 2));
                    object = ((String)object).substring(n);
                    object4 = this.fDocument.createCDATASection((String)object);
                    node.insertBefore((Node)object4, object4.getNextSibling());
                    n = ((String)object).indexOf("]]>");
                }
            }
            while (n < ((NamedNodeMapImpl)object2).getLength()) {
                ((Attr)((NamedNodeMapImpl)object2).item(n)).normalize();
                ++n;
            }
        }
        if (this.fValidationHandler != null) {
            this.fAttrProxy.setAttributes((AttributeMap)object2, this.fDocument, elementImpl);
            this.updateQName(elementImpl, this.fQName);
            this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = object;
            this.fCurrentNode = object;
            this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
        }
        object2 = elementImpl.getFirstChild();
        while (true) {
            if (object2 == null) {
                if (this.fValidationHandler != null) {
                    this.updateQName(elementImpl, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = object;
                    this.fCurrentNode = object;
                    this.fValidationHandler.endElement(this.fQName, null);
                }
                this.fNamespaceContext.popContext();
                return null;
            }
            Node node = object2.getNextSibling();
            if ((object2 = this.normalizeNode((Node)object2)) != null) continue;
            object2 = node;
        }
    }

    @Override
    public void processingInstruction(String string2, XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    @Override
    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
    }

    @Override
    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    @Override
    public void startDocument(XMLLocator xMLLocator, String string2, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(QName object, XMLAttributes xMLAttributes, Augmentations object2) throws XNIException {
        Element element = (Element)this.fCurrentNode;
        int n = xMLAttributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            xMLAttributes.getName(n2, this.fAttrQName);
            Attr attr2 = element.getAttributeNodeNS(this.fAttrQName.uri, this.fAttrQName.localpart);
            object2 = (AttributePSVI)xMLAttributes.getAugmentations(n2).getItem("ATTRIBUTE_PSVI");
            if (object2 != null) {
                object = object2.getMemberTypeDefinition();
                boolean bl = object != null || (object = object2.getTypeDefinition()) != null ? ((XSSimpleType)object).isIDType() : false;
                if (bl) {
                    ((ElementImpl)element).setIdAttributeNode(attr2, true);
                }
                if (this.fPSVI) {
                    ((PSVIAttrNSImpl)attr2).setPSVI((AttributePSVI)object2);
                }
                if ((this.fConfiguration.features & 2) != 0) {
                    bl = attr2.getSpecified();
                    attr2.setValue(object2.getSchemaNormalizedValue());
                    if (!bl) {
                        ((AttrImpl)attr2).setSpecified(bl);
                    }
                }
            }
            ++n2;
        }
        return;
    }

    @Override
    public void startGeneralEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
    }

    @Override
    public void textDecl(String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    protected final void updateQName(Node object, QName qName) {
        String string2 = object.getPrefix();
        String string3 = object.getNamespaceURI();
        String string4 = object.getLocalName();
        Object var6_6 = null;
        string2 = string2 != null && string2.length() != 0 ? this.fSymbolTable.addSymbol(string2) : null;
        qName.prefix = string2;
        string2 = string4 != null ? this.fSymbolTable.addSymbol(string4) : null;
        qName.localpart = string2;
        qName.rawname = this.fSymbolTable.addSymbol(object.getNodeName());
        object = var6_6;
        if (string3 != null) {
            object = this.fSymbolTable.addSymbol(string3);
        }
        qName.uri = object;
    }

    @Override
    public void xmlDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected final Vector fAugmentations = new Vector(5);
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;

        protected XMLAttributesProxy() {
        }

        @Override
        public int addAttribute(QName cloneable, String string2, String string3) {
            int n;
            int n2 = n = this.fElement.getXercesAttribute(((QName)cloneable).uri, ((QName)cloneable).localpart);
            if (n < 0) {
                cloneable = (AttrImpl)((CoreDocumentImpl)this.fElement.getOwnerDocument()).createAttributeNS(((QName)cloneable).uri, ((QName)cloneable).rawname, ((QName)cloneable).localpart);
                n2 = this.fElement.setXercesAttributeNode((Attr)((Object)cloneable));
                ((AttrImpl)cloneable).setNodeValue(string3);
                this.fAugmentations.insertElementAt(new AugmentationsImpl(), n2);
                ((AttrImpl)cloneable).setSpecified(false);
            }
            return n2;
        }

        @Override
        public Augmentations getAugmentations(int n) {
            return (Augmentations)this.fAugmentations.elementAt(n);
        }

        @Override
        public Augmentations getAugmentations(String string2) {
            return null;
        }

        @Override
        public Augmentations getAugmentations(String string2, String string3) {
            return null;
        }

        @Override
        public int getIndex(String string2) {
            return -1;
        }

        @Override
        public int getIndex(String string2, String string3) {
            return -1;
        }

        @Override
        public int getLength() {
            AttributeMap attributeMap = this.fAttributes;
            int n = attributeMap != null ? attributeMap.getLength() : 0;
            return n;
        }

        @Override
        public String getLocalName(int n) {
            return null;
        }

        @Override
        public void getName(int n, QName qName) {
            AttributeMap attributeMap = this.fAttributes;
            if (attributeMap != null) {
                DOMNormalizer.this.updateQName((Node)attributeMap.getItem(n), qName);
            }
        }

        @Override
        public String getNonNormalizedValue(int n) {
            return null;
        }

        @Override
        public String getPrefix(int n) {
            return null;
        }

        @Override
        public String getQName(int n) {
            return null;
        }

        @Override
        public String getType(int n) {
            return "CDATA";
        }

        @Override
        public String getType(String string2) {
            return "CDATA";
        }

        @Override
        public String getType(String string2, String string3) {
            return "CDATA";
        }

        @Override
        public String getURI(int n) {
            return null;
        }

        @Override
        public String getValue(int n) {
            Object object = this.fAttributes;
            object = object != null ? ((NamedNodeMapImpl)object).item(n).getNodeValue() : "";
            return object;
        }

        @Override
        public String getValue(String string2) {
            return null;
        }

        @Override
        public String getValue(String object, String string2) {
            String string3;
            AttributeMap attributeMap = this.fAttributes;
            String string4 = string3 = null;
            if (attributeMap != null) {
                object = attributeMap.getNamedItemNS((String)object, string2);
                string4 = string3;
                if (object != null) {
                    string4 = object.getNodeValue();
                }
            }
            return string4;
        }

        @Override
        public boolean isSpecified(int n) {
            return ((Attr)this.fAttributes.getItem(n)).getSpecified();
        }

        @Override
        public void removeAllAttributes() {
        }

        @Override
        public void removeAttributeAt(int n) {
        }

        public void setAttributes(AttributeMap attributeMap, CoreDocumentImpl coreDocumentImpl, ElementImpl elementImpl) {
            this.fDocument = coreDocumentImpl;
            this.fAttributes = attributeMap;
            this.fElement = elementImpl;
            if (attributeMap != null) {
                int n = attributeMap.getLength();
                this.fAugmentations.setSize(n);
                for (int i = 0; i < n; ++i) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), i);
                }
            } else {
                this.fAugmentations.setSize(0);
            }
        }

        @Override
        public void setAugmentations(int n, Augmentations augmentations) {
            this.fAugmentations.setElementAt(augmentations, n);
        }

        @Override
        public void setName(int n, QName qName) {
        }

        @Override
        public void setNonNormalizedValue(int n, String string2) {
        }

        @Override
        public void setSpecified(int n, boolean bl) {
            ((AttrImpl)this.fAttributes.getItem(n)).setSpecified(bl);
        }

        @Override
        public void setType(int n, String string2) {
        }

        @Override
        public void setValue(int n, String string2) {
            Serializable serializable = this.fAttributes;
            if (serializable != null) {
                serializable = (AttrImpl)((NamedNodeMapImpl)serializable).getItem(n);
                boolean bl = ((AttrImpl)serializable).getSpecified();
                ((AttrImpl)serializable).setValue(string2);
                ((AttrImpl)serializable).setSpecified(bl);
            }
        }
    }
}

