/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DeferredAttrImpl;
import org.apache.xerces.dom.DeferredAttrNSImpl;
import org.apache.xerces.dom.DeferredCDATASectionImpl;
import org.apache.xerces.dom.DeferredCommentImpl;
import org.apache.xerces.dom.DeferredDocumentTypeImpl;
import org.apache.xerces.dom.DeferredElementDefinitionImpl;
import org.apache.xerces.dom.DeferredElementImpl;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.apache.xerces.dom.DeferredEntityImpl;
import org.apache.xerces.dom.DeferredEntityReferenceImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.DeferredNotationImpl;
import org.apache.xerces.dom.DeferredProcessingInstructionImpl;
import org.apache.xerces.dom.DeferredTextImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.ParentNode;
import org.w3c.dom.Element;

public class DeferredDocumentImpl
extends DocumentImpl
implements DeferredNode {
    protected static final int CHUNK_MASK = 2047;
    protected static final int CHUNK_SHIFT = 11;
    protected static final int CHUNK_SIZE = 2048;
    private static final boolean DEBUG_IDS = false;
    private static final boolean DEBUG_PRINT_REF_COUNTS = false;
    private static final boolean DEBUG_PRINT_TABLES = false;
    protected static final int INITIAL_CHUNK_COUNT = 32;
    static final long serialVersionUID = 5186323580749626857L;
    private final transient StringBuffer fBufferStr = new StringBuffer();
    protected transient int fIdCount;
    protected transient int[] fIdElement;
    protected transient String[] fIdName;
    protected boolean fNamespacesEnabled = false;
    protected transient int fNodeCount = 0;
    protected transient int[][] fNodeExtra;
    protected transient int[][] fNodeLastChild;
    protected transient Object[][] fNodeName;
    protected transient int[][] fNodeParent;
    protected transient int[][] fNodePrevSib;
    protected transient int[][] fNodeType;
    protected transient Object[][] fNodeURI;
    protected transient Object[][] fNodeValue;
    private final transient Vector fStrChunks = new Vector();

    public DeferredDocumentImpl() {
        this(false);
    }

    public DeferredDocumentImpl(boolean bl) {
        this(bl, false);
    }

    public DeferredDocumentImpl(boolean bl, boolean bl2) {
        super(bl2);
        this.needsSyncData(true);
        this.needsSyncChildren(true);
        this.fNamespacesEnabled = bl;
    }

    protected static int binarySearch(int[] nArray, int n, int n2, int n3) {
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            int n5 = nArray[n4];
            if (n5 == n3) {
                for (n = n4; n > 0 && nArray[n - 1] == n3; --n) {
                }
                return n;
            }
            if (n5 > n3) {
                n2 = n4 - 1;
                continue;
            }
            n = n4 + 1;
        }
        return -1;
    }

    private final int clearChunkIndex(int[][] nArray, int n, int n2) {
        int n3 = nArray[n] != null ? nArray[n][n2] : -1;
        if (n3 != -1) {
            int[] nArray2 = nArray[n];
            nArray2[2048] = nArray2[2048] - 1;
            nArray[n][n2] = -1;
            if (nArray[n][2048] == 0) {
                nArray[n] = null;
            }
        }
        return n3;
    }

    private final String clearChunkValue(Object[][] objectArray, int n, int n2) {
        String string2 = objectArray[n] != null ? (String)objectArray[n][n2] : null;
        if (string2 != null) {
            objectArray[n][n2] = null;
            RefCount refCount = (RefCount)objectArray[n][2048];
            --refCount.fCount;
            if (refCount.fCount == 0) {
                objectArray[n] = null;
            }
        }
        return string2;
    }

    private final void createChunk(int[][] nArray, int n) {
        nArray[n] = new int[2049];
        int n2 = 0;
        while (n2 < 2048) {
            nArray[n][n2] = -1;
            ++n2;
        }
        return;
    }

    private final void createChunk(Object[][] objectArray, int n) {
        objectArray[n] = new Object[2049];
        objectArray[n][2048] = new RefCount();
    }

    private final int getChunkIndex(int[][] nArray, int n, int n2) {
        n = nArray[n] != null ? nArray[n][n2] : -1;
        return n;
    }

    private final String getChunkValue(Object[][] object, int n, int n2) {
        object = object[n] != null ? (String)object[n][n2] : null;
        return object;
    }

    private final String getNodeValue(int n, int n2) {
        Object object = this.fNodeValue[n][n2];
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    private static void print(int[] nArray, int n, int n2, int n3, int n4) {
    }

    private final void putIdentifier0(String string2, Element element) {
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string2, element);
    }

    private final int setChunkIndex(int[][] nArray, int n, int n2, int n3) {
        if (n == -1) {
            return this.clearChunkIndex(nArray, n2, n3);
        }
        int n4 = nArray[n2][n3];
        if (n4 == -1) {
            int[] nArray2 = nArray[n2];
            nArray2[2048] = nArray2[2048] + 1;
        }
        nArray[n2][n3] = n;
        return n4;
    }

    private final String setChunkValue(Object[][] objectArray, Object object, int n, int n2) {
        if (object == null) {
            return this.clearChunkValue(objectArray, n, n2);
        }
        String string2 = (String)objectArray[n][n2];
        if (string2 == null) {
            RefCount refCount = (RefCount)objectArray[n][2048];
            ++refCount.fCount;
        }
        objectArray[n][n2] = object;
        return string2;
    }

    public void appendChild(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 >> 11;
        int n6 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeParent, n, n5, n6);
        n = this.getChunkIndex(this.fNodeLastChild, n3, n4);
        this.setChunkIndex(this.fNodePrevSib, n, n5, n6);
        this.setChunkIndex(this.fNodeLastChild, n2, n3, n4);
    }

    public int cloneNode(int n, boolean bl) {
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.fNodeType[n2][n3];
        int n5 = this.createNode((short)n4);
        int n6 = n5 >> 11;
        int n7 = n5 & 0x7FF;
        Object[][] objectArray = this.fNodeName;
        this.setChunkValue(objectArray, objectArray[n2][n3], n6, n7);
        objectArray = this.fNodeValue;
        this.setChunkValue(objectArray, objectArray[n2][n3], n6, n7);
        objectArray = this.fNodeURI;
        this.setChunkValue(objectArray, objectArray[n2][n3], n6, n7);
        n2 = this.fNodeExtra[n2][n3];
        if (n2 != -1) {
            n3 = n2;
            if (n4 != 2) {
                n3 = n2;
                if (n4 != 3) {
                    n3 = this.cloneNode(n2, false);
                }
            }
            this.setChunkIndex(this.fNodeExtra, n3, n6, n7);
        }
        if (bl) {
            n = this.getLastChild(n, false);
            n3 = -1;
            while (n != -1) {
                n2 = this.cloneNode(n, bl);
                this.insertBefore(n5, n2, n3);
                n = this.getRealPrevSibling(n, false);
                n3 = n2;
            }
        }
        return n5;
    }

    public int createDeferredAttribute(String string2, String string3, String string4, boolean bl) {
        int n = this.createNode((short)2);
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        this.setChunkValue(this.fNodeName, string2, n2, n3);
        this.setChunkValue(this.fNodeURI, string3, n2, n3);
        this.setChunkValue(this.fNodeValue, string4, n2, n3);
        int n4 = bl ? 32 : 0;
        this.setChunkIndex(this.fNodeExtra, n4, n2, n3);
        return n;
    }

    public int createDeferredAttribute(String string2, String string3, boolean bl) {
        return this.createDeferredAttribute(string2, null, string3, bl);
    }

    public int createDeferredCDATASection(String string2) {
        int n = this.createNode((short)4);
        this.setChunkValue(this.fNodeValue, string2, n >> 11, n & 0x7FF);
        return n;
    }

    public int createDeferredComment(String string2) {
        int n = this.createNode((short)8);
        this.setChunkValue(this.fNodeValue, string2, n >> 11, n & 0x7FF);
        return n;
    }

    public int createDeferredDocument() {
        return this.createNode((short)9);
    }

    public int createDeferredDocumentType(String string2, String string3, String string4) {
        int n = this.createNode((short)10);
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        this.setChunkValue(this.fNodeName, string2, n2, n3);
        this.setChunkValue(this.fNodeValue, string3, n2, n3);
        this.setChunkValue(this.fNodeURI, string4, n2, n3);
        return n;
    }

    public int createDeferredElement(String string2) {
        return this.createDeferredElement(null, string2);
    }

    public int createDeferredElement(String string2, String string3) {
        int n = this.createNode((short)1);
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        this.setChunkValue(this.fNodeName, string3, n2, n3);
        this.setChunkValue(this.fNodeURI, string2, n2, n3);
        return n;
    }

    public int createDeferredElement(String string2, String string3, Object object) {
        int n = this.createNode((short)1);
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        this.setChunkValue(this.fNodeName, string3, n2, n3);
        this.setChunkValue(this.fNodeURI, string2, n2, n3);
        this.setChunkValue(this.fNodeValue, object, n2, n3);
        return n;
    }

    public int createDeferredElementDefinition(String string2) {
        int n = this.createNode((short)21);
        this.setChunkValue(this.fNodeName, string2, n >> 11, n & 0x7FF);
        return n;
    }

    public int createDeferredEntity(String string2, String string3, String string4, String string5, String string6) {
        int n = this.createNode((short)6);
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.createNode((short)6);
        int n5 = n4 >> 11;
        int n6 = n4 & 0x7FF;
        this.setChunkValue(this.fNodeName, string2, n2, n3);
        this.setChunkValue(this.fNodeValue, string3, n2, n3);
        this.setChunkValue(this.fNodeURI, string4, n2, n3);
        this.setChunkIndex(this.fNodeExtra, n4, n2, n3);
        this.setChunkValue(this.fNodeName, string5, n5, n6);
        this.setChunkValue(this.fNodeValue, null, n5, n6);
        this.setChunkValue(this.fNodeURI, null, n5, n6);
        n3 = this.createNode((short)6);
        this.setChunkIndex(this.fNodeExtra, n3, n5, n6);
        this.setChunkValue(this.fNodeName, string6, n3 >> 11, n3 & 0x7FF);
        return n;
    }

    public int createDeferredEntityReference(String string2, String string3) {
        int n = this.createNode((short)5);
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        this.setChunkValue(this.fNodeName, string2, n2, n3);
        this.setChunkValue(this.fNodeValue, string3, n2, n3);
        return n;
    }

    public int createDeferredNotation(String string2, String string3, String string4, String string5) {
        int n = this.createNode((short)12);
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.createNode((short)12);
        this.setChunkValue(this.fNodeName, string2, n2, n3);
        this.setChunkValue(this.fNodeValue, string3, n2, n3);
        this.setChunkValue(this.fNodeURI, string4, n2, n3);
        this.setChunkIndex(this.fNodeExtra, n4, n2, n3);
        this.setChunkValue(this.fNodeName, string5, n4 >> 11, n4 & 0x7FF);
        return n;
    }

    public int createDeferredProcessingInstruction(String string2, String string3) {
        int n = this.createNode((short)7);
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        this.setChunkValue(this.fNodeName, string2, n2, n3);
        this.setChunkValue(this.fNodeValue, string3, n2, n3);
        return n;
    }

    public int createDeferredTextNode(String string2, boolean bl) {
        int n = this.createNode((short)3);
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        this.setChunkValue(this.fNodeValue, string2, n2, n3);
        this.setChunkIndex(this.fNodeExtra, bl ? 1 : 0, n2, n3);
        return n;
    }

    protected int createNode(short s) {
        int n = this.fNodeCount;
        int n2 = n >> 11;
        this.ensureCapacity(n2);
        this.setChunkIndex(this.fNodeType, s, n2, n & 0x7FF);
        s = (short)this.fNodeCount;
        this.fNodeCount = s + 1;
        return s;
    }

    protected void ensureCapacity(int n) {
        int[][] nArray = this.fNodeType;
        if (nArray == null) {
            this.fNodeType = new int[32][];
            this.fNodeName = new Object[32][];
            this.fNodeValue = new Object[32][];
            this.fNodeParent = new int[32][];
            this.fNodeLastChild = new int[32][];
            this.fNodePrevSib = new int[32][];
            this.fNodeURI = new Object[32][];
            this.fNodeExtra = new int[32][];
        } else if (nArray.length <= n) {
            int n2 = n * 2;
            Object object = new int[n2][];
            System.arraycopy(nArray, 0, object, 0, n);
            this.fNodeType = object;
            object = new Object[n2][];
            System.arraycopy(this.fNodeName, 0, object, 0, n);
            this.fNodeName = object;
            object = new Object[n2][];
            System.arraycopy(this.fNodeValue, 0, object, 0, n);
            this.fNodeValue = object;
            object = new int[n2][];
            System.arraycopy(this.fNodeParent, 0, object, 0, n);
            this.fNodeParent = object;
            object = new int[n2][];
            System.arraycopy(this.fNodeLastChild, 0, object, 0, n);
            this.fNodeLastChild = object;
            object = new int[n2][];
            System.arraycopy(this.fNodePrevSib, 0, object, 0, n);
            this.fNodePrevSib = object;
            object = new Object[n2][];
            System.arraycopy(this.fNodeURI, 0, object, 0, n);
            this.fNodeURI = object;
            object = new int[n2][];
            System.arraycopy(this.fNodeExtra, 0, object, 0, n);
            this.fNodeExtra = object;
        } else if (nArray[n] != null) {
            return;
        }
        this.createChunk(this.fNodeType, n);
        this.createChunk(this.fNodeName, n);
        this.createChunk(this.fNodeValue, n);
        this.createChunk(this.fNodeParent, n);
        this.createChunk(this.fNodeLastChild, n);
        this.createChunk(this.fNodePrevSib, n);
        this.createChunk(this.fNodeURI, n);
        this.createChunk(this.fNodeExtra, n);
    }

    public String getAttribute(int n, String string2) {
        if (n != -1 && string2 != null) {
            n = this.getChunkIndex(this.fNodeExtra, n >> 11, n & 0x7FF);
            while (true) {
                if (n == -1) {
                    return null;
                }
                int n2 = n >> 11;
                if (this.getChunkValue(this.fNodeName, n2, n &= 0x7FF) == string2) {
                    return this.getChunkValue(this.fNodeValue, n2, n);
                }
                n = this.getChunkIndex(this.fNodePrevSib, n2, n);
            }
        }
        return null;
    }

    public String getDeferredEntityBaseURI(int n) {
        if (n != -1) {
            return this.getNodeName(this.getNodeExtra(this.getNodeExtra(n, false), false), false);
        }
        return null;
    }

    public int getLastChild(int n) {
        return this.getLastChild(n, true);
    }

    public int getLastChild(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        n &= 0x7FF;
        n = bl ? this.clearChunkIndex(this.fNodeLastChild, n2, n) : this.getChunkIndex(this.fNodeLastChild, n2, n);
        return n;
    }

    boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public int getNodeExtra(int n) {
        return this.getNodeExtra(n, true);
    }

    public int getNodeExtra(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        n &= 0x7FF;
        n = bl ? this.clearChunkIndex(this.fNodeExtra, n2, n) : this.getChunkIndex(this.fNodeExtra, n2, n);
        return n;
    }

    @Override
    public int getNodeIndex() {
        return 0;
    }

    public String getNodeName(int n) {
        return this.getNodeName(n, true);
    }

    public String getNodeName(int n, boolean bl) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        String string2 = bl ? this.clearChunkValue(this.fNodeName, n2, n) : this.getChunkValue(this.fNodeName, n2, n &= 0x7FF);
        return string2;
    }

    public DeferredNode getNodeObject(int n) {
        NodeImpl nodeImpl;
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.getChunkIndex(this.fNodeType, n2, n3);
        if (n4 != 3 && n4 != 4) {
            this.clearChunkIndex(this.fNodeType, n2, n3);
        }
        if (n4 != 12) {
            if (n4 != 21) {
                switch (n4) {
                    default: {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("type: ");
                        stringBuffer.append(n4);
                        throw new IllegalArgumentException(stringBuffer.toString());
                    }
                    case 10: {
                        nodeImpl = new DeferredDocumentTypeImpl(this, n);
                        this.docType = (DocumentTypeImpl)nodeImpl;
                        break;
                    }
                    case 9: {
                        nodeImpl = this;
                        break;
                    }
                    case 8: {
                        nodeImpl = new DeferredCommentImpl(this, n);
                        break;
                    }
                    case 7: {
                        nodeImpl = new DeferredProcessingInstructionImpl(this, n);
                        break;
                    }
                    case 6: {
                        nodeImpl = new DeferredEntityImpl(this, n);
                        break;
                    }
                    case 5: {
                        nodeImpl = new DeferredEntityReferenceImpl(this, n);
                        break;
                    }
                    case 4: {
                        nodeImpl = new DeferredCDATASectionImpl(this, n);
                        break;
                    }
                    case 3: {
                        nodeImpl = new DeferredTextImpl(this, n);
                        break;
                    }
                    case 2: {
                        if (this.fNamespacesEnabled) {
                            nodeImpl = new DeferredAttrNSImpl(this, n);
                            break;
                        }
                        nodeImpl = new DeferredAttrImpl(this, n);
                        break;
                    }
                    case 1: {
                        Object object;
                        nodeImpl = this.fNamespacesEnabled ? new DeferredElementNSImpl(this, n) : new DeferredElementImpl(this, n);
                        if (this.docElement == null) {
                            this.docElement = (ElementImpl)nodeImpl;
                        }
                        if ((object = this.fIdElement) != null) {
                            n2 = DeferredDocumentImpl.binarySearch(object, 0, this.fIdCount - 1, n);
                            while (n2 != -1) {
                                object = this.fIdName[n2];
                                if (object != null) {
                                    this.putIdentifier0((String)object, (Element)((Object)nodeImpl));
                                    this.fIdName[n2] = null;
                                }
                                if (++n2 < this.fIdCount && this.fIdElement[n2] == n) continue;
                                n2 = -1;
                            }
                            break block0;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                nodeImpl = new DeferredElementDefinitionImpl(this, n);
            }
        } else {
            nodeImpl = new DeferredNotationImpl(this, n);
        }
        return nodeImpl;
    }

    public short getNodeType(int n) {
        return this.getNodeType(n, true);
    }

    public short getNodeType(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        n &= 0x7FF;
        n = bl ? this.clearChunkIndex(this.fNodeType, n2, n) : this.getChunkIndex(this.fNodeType, n2, n);
        return (short)n;
    }

    public String getNodeURI(int n) {
        return this.getNodeURI(n, true);
    }

    public String getNodeURI(int n, boolean bl) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        String string2 = bl ? this.clearChunkValue(this.fNodeURI, n2, n) : this.getChunkValue(this.fNodeURI, n2, n &= 0x7FF);
        return string2;
    }

    public String getNodeValue(int n) {
        return this.getNodeValue(n, true);
    }

    public String getNodeValue(int n, boolean bl) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        String string2 = bl ? this.clearChunkValue(this.fNodeValue, n2, n) : this.getChunkValue(this.fNodeValue, n2, n &= 0x7FF);
        return string2;
    }

    public String getNodeValueString(int n) {
        return this.getNodeValueString(n, true);
    }

    /*
     * Unable to fully structure code
     */
    public String getNodeValueString(int var1_1, boolean var2_2) {
        if (var1_1 == -1) {
            return null;
        }
        var3_3 = var1_1 >> 11;
        var4_4 = var1_1 & 2047;
        var5_5 = var2_2 != false ? this.clearChunkValue(this.fNodeValue, var3_3, var4_4) : this.getChunkValue(this.fNodeValue, var3_3, var4_4);
        if (var5_5 == null) {
            return null;
        }
        if ((var4_4 = this.getChunkIndex(this.fNodeType, var3_3, var4_4)) == 3) {
            if ((var1_1 = this.getRealPrevSibling(var1_1)) != -1 && this.getNodeType(var1_1, false) == 3) {
                this.fStrChunks.addElement(var5_5);
                do {
                    var4_4 = var1_1 >> 11;
                    var5_5 = this.getChunkValue(this.fNodeValue, var4_4, var1_1 &= 2047);
                    this.fStrChunks.addElement(var5_5);
                    var4_4 = this.getChunkIndex(this.fNodePrevSib, var4_4, var1_1);
                    if (var4_4 == -1) break;
                    var1_1 = var4_4;
                } while (this.getNodeType(var4_4, false) == 3);
                var1_1 = this.fStrChunks.size() - 1;
                while (true) {
                    if (var1_1 < 0) {
                        var5_5 = this.fBufferStr.toString();
                        this.fStrChunks.removeAllElements();
lbl24:
                        // 2 sources

                        while (true) {
                            this.fBufferStr.setLength(0);
                            return var5_5;
                        }
                    }
                    this.fBufferStr.append((String)this.fStrChunks.elementAt(var1_1));
                    --var1_1;
                }
            }
        } else if (var4_4 == 4 && (var1_1 = this.getLastChild(var1_1, false)) != -1) {
            this.fBufferStr.append(var5_5);
            while (true) {
                if (var1_1 == -1) {
                    var1_1 = this.fStrChunks.size() - 1;
                    while (true) {
                        if (var1_1 < 0) {
                            var5_5 = this.fBufferStr.toString();
                            this.fStrChunks.setSize(0);
                            ** continue;
                        }
                        this.fBufferStr.append((String)this.fStrChunks.elementAt(var1_1));
                        --var1_1;
                    }
                }
                var4_4 = var1_1 >> 11;
                var5_5 = this.getChunkValue(this.fNodeValue, var4_4, var1_1 &= 2047);
                this.fStrChunks.addElement(var5_5);
                var1_1 = this.getChunkIndex(this.fNodePrevSib, var4_4, var1_1);
            }
        }
        return var5_5;
    }

    public int getParentNode(int n) {
        return this.getParentNode(n, false);
    }

    public int getParentNode(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        n &= 0x7FF;
        n = bl ? this.clearChunkIndex(this.fNodeParent, n2, n) : this.getChunkIndex(this.fNodeParent, n2, n);
        return n;
    }

    public int getPrevSibling(int n) {
        return this.getPrevSibling(n, true);
    }

    public int getPrevSibling(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        if (this.getChunkIndex(this.fNodeType, n2, n &= 0x7FF) == 3) {
            int n3;
            while ((n = this.getChunkIndex(this.fNodePrevSib, n2, n)) != -1 && this.getChunkIndex(this.fNodeType, n2 = n >> 11, n3 = n & 0x7FF) == 3) {
                n = n3;
            }
        } else {
            n = this.getChunkIndex(this.fNodePrevSib, n2, n);
        }
        return n;
    }

    public int getRealPrevSibling(int n) {
        return this.getRealPrevSibling(n, true);
    }

    public int getRealPrevSibling(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        n &= 0x7FF;
        n = bl ? this.clearChunkIndex(this.fNodePrevSib, n2, n) : this.getChunkIndex(this.fNodePrevSib, n2, n);
        return n;
    }

    public Object getTypeInfo(int n) {
        if (n == -1) {
            return null;
        }
        Object object = this.fNodeValue;
        int n2 = n >> 11;
        Object object2 = object[n2] != null ? object[n2][n &= 0x7FF] : null;
        if (object2 != null) {
            object[n2][n] = null;
            object = (RefCount)object[n2][2048];
            --object.fCount;
            if (object.fCount == 0) {
                this.fNodeValue[n2] = null;
            }
        }
        return object2;
    }

    public int insertBefore(int n, int n2, int n3) {
        if (n3 == -1) {
            this.appendChild(n, n2);
            return n2;
        }
        n = n3 >> 11;
        int n4 = this.getChunkIndex(this.fNodePrevSib, n, n3 &= 0x7FF);
        this.setChunkIndex(this.fNodePrevSib, n2, n, n3);
        this.setChunkIndex(this.fNodePrevSib, n4, n2 >> 11, n2 & 0x7FF);
        return n2;
    }

    public int lookupElementDefinition(String string2) {
        block5: {
            if (this.fNodeCount <= 1) break block5;
            int n = this.getChunkIndex(this.fNodeLastChild, 0, 0);
            while (true) {
                int n2;
                int n3;
                block8: {
                    block7: {
                        block6: {
                            if (n != -1) break block6;
                            n = -1;
                            break block7;
                        }
                        n3 = n >> 11;
                        n2 = n & 0x7FF;
                        if (this.getChunkIndex(this.fNodeType, n3, n2) != 10) break block8;
                    }
                    if (n == -1) {
                        return -1;
                    }
                    n = this.getChunkIndex(this.fNodeLastChild, n >> 11, n & 0x7FF);
                    while (n != -1) {
                        n2 = n >> 11;
                        n3 = n & 0x7FF;
                        if (this.getChunkIndex(this.fNodeType, n2, n3) == 21 && this.getChunkValue(this.fNodeName, n2, n3) == string2) {
                            return n;
                        }
                        n = this.getChunkIndex(this.fNodePrevSib, n2, n3);
                    }
                    break;
                }
                n = this.getChunkIndex(this.fNodePrevSib, n3, n2);
            }
        }
        return -1;
    }

    public void print() {
    }

    public void putIdentifier(String string2, int n) {
        Object[] objectArray;
        int n2;
        String[] stringArray;
        int n3;
        if (this.fIdName == null) {
            this.fIdName = new String[64];
            this.fIdElement = new int[64];
        }
        if ((n3 = this.fIdCount) == (stringArray = this.fIdName).length) {
            n2 = n3 * 2;
            objectArray = new String[n2];
            System.arraycopy(stringArray, 0, objectArray, 0, n3);
            this.fIdName = objectArray;
            objectArray = new int[n2];
            System.arraycopy(this.fIdElement, 0, objectArray, 0, this.fIdCount);
            this.fIdElement = (int[])objectArray;
        }
        objectArray = this.fIdName;
        n2 = this.fIdCount;
        objectArray[n2] = string2;
        this.fIdElement[n2] = n;
        this.fIdCount = n2 + 1;
    }

    public void setActualEncoding(int n, String string2) {
        n = this.getNodeExtra(this.getNodeExtra(n, false), false);
        this.setChunkValue(this.fNodeValue, string2, n >> 11, n & 0x7FF);
    }

    public void setAsLastChild(int n, int n2) {
        this.setChunkIndex(this.fNodeLastChild, n2, n >> 11, n & 0x7FF);
    }

    public int setAttributeNode(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 >> 11;
        int n6 = n2 & 0x7FF;
        String string2 = this.getChunkValue(this.fNodeName, n5, n6);
        n = this.getChunkIndex(this.fNodeExtra, n3, n4);
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        while (true) {
            int n10;
            if (n == -1 || this.getChunkValue(this.fNodeName, n8 = n >> 11, n9 = n & 0x7FF).equals(string2)) {
                if (n != -1) {
                    n10 = this.getChunkIndex(this.fNodePrevSib, n8, n9);
                    if (n7 == -1) {
                        this.setChunkIndex(this.fNodeExtra, n10, n3, n4);
                    } else {
                        this.setChunkIndex(this.fNodePrevSib, n10, n7 >> 11, n7 & 0x7FF);
                    }
                    this.clearChunkIndex(this.fNodeType, n8, n9);
                    this.clearChunkValue(this.fNodeName, n8, n9);
                    this.clearChunkValue(this.fNodeValue, n8, n9);
                    this.clearChunkIndex(this.fNodeParent, n8, n9);
                    this.clearChunkIndex(this.fNodePrevSib, n8, n9);
                    n8 = this.clearChunkIndex(this.fNodeLastChild, n8, n9);
                    n9 = n8 >> 11;
                    this.clearChunkIndex(this.fNodeType, n9, n8 &= 0x7FF);
                    this.clearChunkValue(this.fNodeValue, n9, n8);
                    this.clearChunkIndex(this.fNodeParent, n9, n8);
                    this.clearChunkIndex(this.fNodeLastChild, n9, n8);
                }
                n9 = this.getChunkIndex(this.fNodeExtra, n3, n4);
                this.setChunkIndex(this.fNodeExtra, n2, n3, n4);
                this.setChunkIndex(this.fNodePrevSib, n9, n5, n6);
                return n;
            }
            n10 = this.getChunkIndex(this.fNodePrevSib, n8, n9);
            n7 = n;
            n = n10;
        }
    }

    public int setDeferredAttribute(int n, String string2, String string3, String string4, boolean bl) {
        int n2 = this.createDeferredAttribute(string2, string3, string4, bl);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeParent, n, n3, n4);
        int n5 = n >> 11;
        int n6 = this.getChunkIndex(this.fNodeExtra, n5, n &= 0x7FF);
        if (n6 != 0) {
            this.setChunkIndex(this.fNodePrevSib, n6, n3, n4);
        }
        this.setChunkIndex(this.fNodeExtra, n2, n5, n);
        return n2;
    }

    public int setDeferredAttribute(int n, String string2, String string3, String string4, boolean bl, boolean bl2, Object object) {
        int n2 = this.createDeferredAttribute(string2, string3, string4, bl);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeParent, n, n3, n4);
        int n5 = n >> 11;
        int n6 = n & 0x7FF;
        int n7 = this.getChunkIndex(this.fNodeExtra, n5, n6);
        if (n7 != 0) {
            this.setChunkIndex(this.fNodePrevSib, n7, n3, n4);
        }
        this.setChunkIndex(this.fNodeExtra, n2, n5, n6);
        n7 = this.getChunkIndex(this.fNodeExtra, n3, n4);
        if (bl2) {
            this.setChunkIndex(this.fNodeExtra, n7 | 0x200, n3, n4);
            this.putIdentifier(this.getChunkValue(this.fNodeValue, n3, n4), n);
        }
        if (object != null) {
            n = this.createNode((short)20);
            this.setChunkIndex(this.fNodeLastChild, n, n3, n4);
            this.setChunkValue(this.fNodeValue, object, n >> 11, n & 0x7FF);
        }
        return n2;
    }

    public void setEntityInfo(int n, String string2, String string3) {
        int n2 = this.getNodeExtra(n, false);
        if (n2 != -1) {
            n = n2 >> 11;
            this.setChunkValue(this.fNodeValue, string2, n, n2 &= 0x7FF);
            this.setChunkValue(this.fNodeURI, string3, n, n2);
        }
    }

    public void setIdAttribute(int n) {
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        n = this.getChunkIndex(this.fNodeExtra, n2, n3);
        this.setChunkIndex(this.fNodeExtra, n | 0x200, n2, n3);
    }

    public void setIdAttributeNode(int n, int n2) {
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        n2 = this.getChunkIndex(this.fNodeExtra, n3, n4);
        this.setChunkIndex(this.fNodeExtra, n2 | 0x200, n3, n4);
        this.putIdentifier(this.getChunkValue(this.fNodeValue, n3, n4), n);
    }

    public void setInternalSubset(int n, String string2) {
        int n2 = this.createNode((short)10);
        this.setChunkIndex(this.fNodeExtra, n2, n >> 11, n & 0x7FF);
        this.setChunkValue(this.fNodeValue, string2, n2 >> 11, n2 & 0x7FF);
    }

    void setNamespacesEnabled(boolean bl) {
        this.fNamespacesEnabled = bl;
    }

    @Override
    protected void synchronizeChildren() {
        if (this.needsSyncData()) {
            this.synchronizeData();
            if (!this.needsSyncChildren()) {
                return;
            }
        }
        boolean bl = this.mutationEvents;
        this.mutationEvents = false;
        this.needsSyncChildren(false);
        this.getNodeType(0);
        int n = this.getLastChild(0);
        ChildNode childNode = null;
        NodeImpl nodeImpl = null;
        while (true) {
            if (n == -1) {
                if (nodeImpl != null) {
                    this.firstChild = nodeImpl;
                    nodeImpl.isFirstChild(true);
                    this.lastChild(childNode);
                }
                this.mutationEvents = bl;
                return;
            }
            ChildNode childNode2 = (ChildNode)((Object)this.getNodeObject(n));
            if (childNode == null) {
                childNode = childNode2;
            } else {
                ((ChildNode)nodeImpl).previousSibling = childNode2;
            }
            childNode2.ownerNode = this;
            childNode2.isOwned(true);
            childNode2.nextSibling = nodeImpl;
            short s = childNode2.getNodeType();
            if (s == 1) {
                this.docElement = (ElementImpl)childNode2;
            } else if (s == 10) {
                this.docType = (DocumentTypeImpl)childNode2;
            }
            n = this.getPrevSibling(n);
            nodeImpl = childNode2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void synchronizeChildren(AttrImpl attrImpl, int n) {
        boolean bl = this.getMutationEvents();
        this.setMutationEvents(false);
        attrImpl.needsSyncChildren(false);
        int n2 = this.getLastChild(n);
        if (this.getPrevSibling(n2) == -1) {
            attrImpl.value = this.getNodeValueString(n);
            attrImpl.hasStringValue(true);
        } else {
            ChildNode childNode = null;
            n = n2;
            NodeImpl nodeImpl = null;
            while (true) {
                if (n == -1) {
                    if (childNode != null) {
                        attrImpl.value = nodeImpl;
                        nodeImpl.isFirstChild(true);
                        attrImpl.lastChild(childNode);
                    }
                    attrImpl.hasStringValue(false);
                    break;
                }
                ChildNode childNode2 = (ChildNode)((Object)this.getNodeObject(n));
                if (childNode == null) {
                    childNode = childNode2;
                } else {
                    ((ChildNode)nodeImpl).previousSibling = childNode2;
                }
                childNode2.ownerNode = attrImpl;
                childNode2.isOwned(true);
                childNode2.nextSibling = nodeImpl;
                n = this.getPrevSibling(n);
                nodeImpl = childNode2;
            }
        }
        this.setMutationEvents(bl);
    }

    protected final void synchronizeChildren(ParentNode parentNode, int n) {
        boolean bl = this.getMutationEvents();
        this.setMutationEvents(false);
        parentNode.needsSyncChildren(false);
        n = this.getLastChild(n);
        ChildNode childNode = null;
        NodeImpl nodeImpl = null;
        while (true) {
            if (n == -1) {
                if (childNode != null) {
                    parentNode.firstChild = nodeImpl;
                    nodeImpl.isFirstChild(true);
                    parentNode.lastChild(childNode);
                }
                this.setMutationEvents(bl);
                return;
            }
            ChildNode childNode2 = (ChildNode)((Object)this.getNodeObject(n));
            if (childNode == null) {
                childNode = childNode2;
            } else {
                ((ChildNode)nodeImpl).previousSibling = childNode2;
            }
            childNode2.ownerNode = parentNode;
            childNode2.isOwned(true);
            childNode2.nextSibling = nodeImpl;
            n = this.getPrevSibling(n);
            nodeImpl = childNode2;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void synchronizeData() {
        block12: {
            var1_1 = 0;
            this.needsSyncData(false);
            if (this.fIdElement == null) break block12;
            var2_2 = new IntVector();
            block0: while (var1_1 < this.fIdCount) {
                block13: {
                    var3_3 = this.fIdElement[var1_1];
                    var4_4 = this.fIdName[var1_1];
                    if (var4_4 != null) break block13;
                    var5_5 = var1_1;
                    ** GOTO lbl39
                }
                var2_2.removeAllElements();
                var5_5 = var3_3;
                do {
                    var2_2.addElement(var5_5);
                    var5_5 = var6_6 = this.getChunkIndex(this.fNodeParent, var5_5 >> 11, var5_5 & 2047);
                } while (var6_6 != -1);
                var5_5 = var2_2.size();
                var7_7 = this;
                var5_5 -= 2;
                block2: while (true) {
                    block14: {
                        if (var5_5 < 0) {
                            var8_8 = (Element)var7_7;
                            this.putIdentifier0(var4_4, (Element)var8_8);
                            this.fIdName[var1_1] = null;
                            while (true) {
                                var6_6 = var1_1 + 1;
                                var5_5 = var1_1;
                                if (var6_6 >= this.fIdCount) ** break;
                                if (this.fIdElement[var6_6] != var3_3) {
                                    var5_5 = var1_1;
                                    ** break;
                                }
                                var7_7 = this.fIdName[var6_6];
                                if (var7_7 != null) {
                                    this.putIdentifier0((String)var7_7, (Element)var8_8);
                                }
                                var1_1 = var6_6;
                            }
                        }
                        break block14;
lbl39:
                        // 3 sources

                        var1_1 = var5_5 + 1;
                        continue block0;
                    }
                    var6_6 = var2_2.elementAt(var5_5);
                    var8_8 = var7_7.getLastChild();
                    while (true) {
                        block16: {
                            block15: {
                                if (var8_8 == null) break block15;
                                if (!(var8_8 instanceof DeferredNode) || ((DeferredNode)var8_8).getNodeIndex() != var6_6) break block16;
                                var7_7 = var8_8;
                            }
                            --var5_5;
                            continue block2;
                        }
                        var8_8 = var8_8.getPreviousSibling();
                    }
                    break;
                }
            }
        }
    }

    static class IntVector {
        private int[] data;
        private int size;

        IntVector() {
        }

        private void ensureCapacity(int n) {
            int[] nArray = this.data;
            if (nArray == null) {
                this.data = new int[n + 15];
            } else if (n > nArray.length) {
                int[] nArray2 = new int[n + 15];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                this.data = nArray2;
            }
        }

        public void addElement(int n) {
            this.ensureCapacity(this.size + 1);
            int[] nArray = this.data;
            int n2 = this.size;
            this.size = n2 + 1;
            nArray[n2] = n;
        }

        public int elementAt(int n) {
            return this.data[n];
        }

        public void removeAllElements() {
            this.size = 0;
        }

        public int size() {
            return this.size;
        }
    }

    class RefCount {
        int fCount;

        RefCount() {
        }
    }
}

