/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeIteratorImpl;
import org.apache.xerces.dom.RangeImpl;
import org.apache.xerces.dom.TreeWalkerImpl;
import org.apache.xerces.dom.events.EventImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DocumentImpl
extends CoreDocumentImpl
implements DocumentTraversal,
DocumentEvent,
DocumentRange {
    static final long serialVersionUID = 515687835542616694L;
    protected Hashtable eventListeners;
    protected Vector iterators;
    protected boolean mutationEvents = false;
    protected Vector ranges;
    EnclosingAttr savedEnclosingAttr;

    public DocumentImpl() {
    }

    public DocumentImpl(DocumentType documentType) {
        super(documentType);
    }

    public DocumentImpl(DocumentType documentType, boolean bl) {
        super(documentType, bl);
    }

    public DocumentImpl(boolean bl) {
        super(bl);
    }

    @Override
    protected void addEventListener(NodeImpl object, String string2, EventListener eventListener, boolean bl) {
        if (string2 != null && !string2.equals("") && eventListener != null) {
            Vector<LEntry> vector;
            this.removeEventListener((NodeImpl)object, string2, eventListener, bl);
            Vector<LEntry> vector2 = vector = this.getEventListeners((NodeImpl)object);
            if (vector == null) {
                vector2 = new Vector<LEntry>();
                this.setEventListeners((NodeImpl)object, vector2);
            }
            vector2.addElement(new LEntry(string2, eventListener, bl));
            object = LCount.lookup(string2);
            if (bl) {
                ++((LCount)object).captures;
            } else {
                ++((LCount)object).bubbles;
            }
        }
    }

    @Override
    public Node cloneNode(boolean bl) {
        DocumentImpl documentImpl = new DocumentImpl();
        this.callUserDataHandlers(this, documentImpl, (short)1);
        this.cloneNode(documentImpl, bl);
        documentImpl.mutationEvents = this.mutationEvents;
        return documentImpl;
    }

    @Override
    protected void copyEventListeners(NodeImpl cloneable, NodeImpl nodeImpl) {
        if ((cloneable = this.getEventListeners((NodeImpl)cloneable)) == null) {
            return;
        }
        this.setEventListeners(nodeImpl, (Vector)((Vector)cloneable).clone());
    }

    @Override
    public Event createEvent(String string2) throws DOMException {
        if (!string2.equalsIgnoreCase("Events") && !"Event".equals(string2)) {
            if (!string2.equalsIgnoreCase("MutationEvents") && !"MutationEvent".equals(string2)) {
                throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null));
            }
            return new MutationEventImpl();
        }
        return new EventImpl();
    }

    @Override
    public NodeIterator createNodeIterator(Node object, int n, NodeFilter nodeFilter, boolean bl) {
        object = new NodeIteratorImpl(this, (Node)object, n, nodeFilter, bl);
        if (this.iterators == null) {
            this.iterators = new Vector();
        }
        this.iterators.addElement(object);
        return object;
    }

    public NodeIterator createNodeIterator(Node node, short s, NodeFilter nodeFilter) {
        return this.createNodeIterator(node, s, nodeFilter, true);
    }

    @Override
    public Range createRange() {
        if (this.ranges == null) {
            this.ranges = new Vector();
        }
        RangeImpl rangeImpl = new RangeImpl(this);
        this.ranges.addElement(rangeImpl);
        return rangeImpl;
    }

    @Override
    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        if (node != null) {
            return new TreeWalkerImpl(node, n, nodeFilter, bl);
        }
        throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null));
    }

    public TreeWalker createTreeWalker(Node node, short s, NodeFilter nodeFilter) {
        return this.createTreeWalker(node, s, nodeFilter, true);
    }

    @Override
    void deletedText(NodeImpl nodeImpl, int n, int n2) {
        Vector vector = this.ranges;
        if (vector != null) {
            int n3 = vector.size();
            for (int i = 0; i != n3; ++i) {
                ((RangeImpl)this.ranges.elementAt(i)).receiveDeletedText(nodeImpl, n, n2);
            }
        }
    }

    protected void dispatchAggregateEvents(NodeImpl nodeImpl, AttrImpl attrImpl, String object, short s) {
        Object object2;
        if (attrImpl != null) {
            LCount lCount = LCount.lookup("DOMAttrModified");
            NodeImpl nodeImpl2 = (NodeImpl)((Object)attrImpl.getOwnerElement());
            object2 = nodeImpl2;
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                object2 = nodeImpl2;
                if (nodeImpl2 != null) {
                    object2 = new MutationEventImpl();
                    ((MutationEventImpl)object2).initMutationEvent("DOMAttrModified", true, false, attrImpl, (String)object, attrImpl.getNodeValue(), attrImpl.getNodeName(), s);
                    nodeImpl2.dispatchEvent((Event)object2);
                    object2 = nodeImpl2;
                }
            }
        } else {
            object2 = null;
        }
        object = LCount.lookup("DOMSubtreeModified");
        if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
            object = new MutationEventImpl();
            object.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null, (short)0);
            if (attrImpl != null) {
                this.dispatchEvent(attrImpl, (Event)object);
                if (object2 != null) {
                    this.dispatchEvent((NodeImpl)object2, (Event)object);
                }
            } else {
                this.dispatchEvent(nodeImpl, (Event)object);
            }
        }
    }

    protected void dispatchAggregateEvents(NodeImpl nodeImpl, EnclosingAttr enclosingAttr) {
        if (enclosingAttr != null) {
            this.dispatchAggregateEvents(nodeImpl, enclosingAttr.node, enclosingAttr.oldvalue, (short)1);
        } else {
            this.dispatchAggregateEvents(nodeImpl, null, null, (short)0);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean dispatchEvent(NodeImpl var1_1, Event var2_2) {
        if (var2_2 == null) {
            return false;
        }
        var3_3 = (EventImpl)var2_2;
        if (var3_3.initialized && var3_3.type != null && !var3_3.type.equals("")) {
            var4_4 = LCount.lookup(var3_3.getType());
            if (var4_4.captures + var4_4.bubbles + var4_4.defaults == 0) {
                return var3_3.preventDefault;
            }
            var3_3.target = var1_1;
            var3_3.stopPropagation = false;
            var3_3.preventDefault = false;
            var5_5 = new Vector<Object>(10, 10);
            var2_2 = var1_1.getParentNode();
            while (true) {
                if (var2_2 == null) {
                    if (var4_4.captures > 0) {
                        var3_3.eventPhase = (short)true;
                        for (var6_6 = var5_5.size() - 1; var6_6 >= 0 && !var3_3.stopPropagation; --var6_6) {
                            var3_3.currentTarget = var2_2 = (NodeImpl)var5_5.elementAt(var6_6);
                            if ((var2_2 = this.getEventListeners((NodeImpl)var2_2)) == null) continue;
                            var7_7 = (Vector)var2_2.clone();
                            var8_10 = var7_7.size();
                            block8: for (var9_11 = 0; var9_11 < var8_10; ++var9_11) {
                                var10_12 = (LEntry)var7_7.elementAt(var9_11);
                                if (var10_12.useCapture && var10_12.type.equals(var3_3.type) && var2_2.contains(var10_12)) {
                                    var10_12.listener.handleEvent(var3_3);
                                }
lbl27:
                                // 4 sources

                            }
                        }
                    }
                    if (var4_4.bubbles > 0) {
                        var3_3.eventPhase = (short)2;
                        var3_3.currentTarget = var1_1;
                        var1_1 = this.getEventListeners((NodeImpl)var1_1);
                        if (!var3_3.stopPropagation && var1_1 != null) {
                            var2_2 = (Vector)var1_1.clone();
                            var9_11 = var2_2.size();
                            block10: for (var6_6 = 0; var6_6 < var9_11; ++var6_6) {
                                var7_7 = (LEntry)var2_2.elementAt(var6_6);
                                if (!var7_7.useCapture && var7_7.type.equals(var3_3.type) && var1_1.contains(var7_7)) {
                                    var7_7.listener.handleEvent(var3_3);
                                }
lbl42:
                                // 4 sources

                            }
                        }
                        if (var3_3.bubbles) {
                            var3_3.eventPhase = (short)3;
                            var8_10 = var5_5.size();
                            for (var6_6 = 0; var6_6 < var8_10 && !var3_3.stopPropagation; ++var6_6) {
                                var1_1 = (NodeImpl)var5_5.elementAt(var6_6);
                                var3_3.currentTarget = var1_1;
                                var2_2 = this.getEventListeners((NodeImpl)var1_1);
                                if (var2_2 == null) continue;
                                var1_1 = (Vector)var2_2.clone();
                                var11_14 = var1_1.size();
                                block13: for (var9_11 = 0; var9_11 < var11_14; ++var9_11) {
                                    var7_7 = (LEntry)var1_1.elementAt(var9_11);
                                    if (!var7_7.useCapture && var7_7.type.equals(var3_3.type) && var2_2.contains(var7_7)) {
                                        var7_7.listener.handleEvent(var3_3);
                                    }
lbl59:
                                    // 4 sources

                                }
                            }
                        }
                    }
                    if (var4_4.defaults > 0 && var3_3.cancelable) {
                        var12_15 = var3_3.preventDefault;
                    }
                    return var3_3.preventDefault;
                }
                var5_5.addElement(var2_2);
                var2_2 = var2_2.getParentNode();
            }
        }
        throw new EventException(0, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "UNSPECIFIED_EVENT_TYPE_ERR", null));
        catch (Exception var10_13) {
            ** continue;
        }
        catch (Exception var7_8) {
            ** continue;
        }
        catch (Exception var7_9) {
            ** continue;
        }
    }

    protected void dispatchEventToSubtree(NodeImpl nodeImpl, Node node, Event event) {
        if (this.getEventListeners(nodeImpl) != null && node != null) {
            ((NodeImpl)node).dispatchEvent(event);
            if (node.getNodeType() == 1) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                    this.dispatchEventToSubtree(nodeImpl, namedNodeMap.item(i), event);
                }
            }
            this.dispatchEventToSubtree(nodeImpl, node.getFirstChild(), event);
            this.dispatchEventToSubtree(nodeImpl, node.getNextSibling(), event);
        }
    }

    protected Vector getEventListeners(NodeImpl nodeImpl) {
        Hashtable hashtable = this.eventListeners;
        if (hashtable == null) {
            return null;
        }
        return (Vector)hashtable.get(nodeImpl);
    }

    @Override
    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    @Override
    boolean getMutationEvents() {
        return this.mutationEvents;
    }

    @Override
    void insertedNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
        if (this.mutationEvents) {
            Object object = LCount.lookup("DOMNodeInserted");
            if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                object = new MutationEventImpl();
                ((MutationEventImpl)object).initMutationEvent("DOMNodeInserted", true, false, nodeImpl, null, null, null, (short)0);
                this.dispatchEvent(nodeImpl2, (Event)object);
            }
            object = LCount.lookup("DOMNodeInsertedIntoDocument");
            if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0 && (object = (object = this.savedEnclosingAttr) != null ? (NodeImpl)((Object)((EnclosingAttr)object).node.getOwnerElement()) : nodeImpl) != null) {
                Object object2 = object;
                while (true) {
                    if (object == null) {
                        if (((NodeImpl)object2).getNodeType() != 9) break;
                        object = new MutationEventImpl();
                        ((MutationEventImpl)object).initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null, (short)0);
                        this.dispatchEventToSubtree(nodeImpl, nodeImpl2, (Event)object);
                        break;
                    }
                    NodeImpl nodeImpl3 = ((NodeImpl)object).getNodeType() == 2 ? (NodeImpl)((Object)((AttrImpl)object).getOwnerElement()) : ((NodeImpl)object).parentNode();
                    object2 = object;
                    object = nodeImpl3;
                }
            }
            if (!bl) {
                this.dispatchAggregateEvents(nodeImpl, this.savedEnclosingAttr);
            }
        }
    }

    @Override
    void insertedText(NodeImpl nodeImpl, int n, int n2) {
        Vector vector = this.ranges;
        if (vector != null) {
            int n3 = vector.size();
            for (int i = 0; i != n3; ++i) {
                ((RangeImpl)this.ranges.elementAt(i)).receiveInsertedText(nodeImpl, n, n2);
            }
        }
    }

    @Override
    void insertingNode(NodeImpl nodeImpl, boolean bl) {
        if (this.mutationEvents && !bl) {
            this.saveEnclosingAttr(nodeImpl);
        }
    }

    @Override
    void modifiedAttrValue(AttrImpl attrImpl, String string2) {
        if (this.mutationEvents) {
            this.dispatchAggregateEvents(attrImpl, attrImpl, string2, (short)1);
        }
    }

    @Override
    void modifiedCharacterData(NodeImpl nodeImpl, String string2, String string3) {
        if (this.mutationEvents) {
            Object object = LCount.lookup("DOMCharacterDataModified");
            if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                object = new MutationEventImpl();
                object.initMutationEvent("DOMCharacterDataModified", true, false, null, string2, string3, null, (short)0);
                this.dispatchEvent(nodeImpl, (Event)object);
            }
            this.dispatchAggregateEvents(nodeImpl, this.savedEnclosingAttr);
        }
    }

    @Override
    void modifyingCharacterData(NodeImpl nodeImpl) {
        if (this.mutationEvents) {
            this.saveEnclosingAttr(nodeImpl);
        }
    }

    @Override
    protected void removeEventListener(NodeImpl object, String string2, EventListener eventListener, boolean bl) {
        block8: {
            if (string2 == null || string2.equals("") || eventListener == null) break block8;
            Vector vector = this.getEventListeners((NodeImpl)object);
            if (vector == null) {
                return;
            }
            int n = vector.size() - 1;
            while (true) {
                block10: {
                    block9: {
                        if (n < 0) break block9;
                        LEntry lEntry = (LEntry)vector.elementAt(n);
                        if (lEntry.useCapture != bl || lEntry.listener != eventListener || !lEntry.type.equals(string2)) break block10;
                        vector.removeElementAt(n);
                        if (vector.size() == 0) {
                            this.setEventListeners((NodeImpl)object, null);
                        }
                        object = LCount.lookup(string2);
                        if (bl) {
                            --((LCount)object).captures;
                        } else {
                            --((LCount)object).bubbles;
                        }
                    }
                    return;
                }
                --n;
            }
        }
    }

    void removeNodeIterator(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            return;
        }
        Vector vector = this.iterators;
        if (vector == null) {
            return;
        }
        vector.removeElement(nodeIterator);
    }

    void removeRange(Range range) {
        if (range == null) {
            return;
        }
        Vector vector = this.ranges;
        if (vector == null) {
            return;
        }
        vector.removeElement(range);
    }

    @Override
    void removedAttrNode(AttrImpl attrImpl, NodeImpl nodeImpl, String string2) {
        if (this.mutationEvents) {
            Object object = LCount.lookup("DOMAttrModified");
            if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                object = new MutationEventImpl();
                ((MutationEventImpl)object).initMutationEvent("DOMAttrModified", true, false, attrImpl, attrImpl.getNodeValue(), null, string2, (short)3);
                this.dispatchEvent(nodeImpl, (Event)object);
            }
            this.dispatchAggregateEvents(nodeImpl, null, null, (short)0);
        }
    }

    @Override
    void removedNode(NodeImpl nodeImpl, boolean bl) {
        if (this.mutationEvents && !bl) {
            this.dispatchAggregateEvents(nodeImpl, this.savedEnclosingAttr);
        }
    }

    @Override
    void removingNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
        int n;
        int n2;
        Object object = this.iterators;
        int n3 = 0;
        if (object != null) {
            n2 = ((Vector)object).size();
            for (n = 0; n != n2; ++n) {
                ((NodeIteratorImpl)this.iterators.elementAt(n)).removeNode(nodeImpl2);
            }
        }
        if ((object = this.ranges) != null) {
            n2 = ((Vector)object).size();
            for (n = n3; n != n2; ++n) {
                ((RangeImpl)this.ranges.elementAt(n)).removeNode(nodeImpl2);
            }
        }
        if (this.mutationEvents) {
            if (!bl) {
                this.saveEnclosingAttr(nodeImpl);
            }
            object = LCount.lookup("DOMNodeRemoved");
            if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                object = new MutationEventImpl();
                ((MutationEventImpl)object).initMutationEvent("DOMNodeRemoved", true, false, nodeImpl, null, null, null, (short)0);
                this.dispatchEvent(nodeImpl2, (Event)object);
            }
            object = LCount.lookup("DOMNodeRemovedFromDocument");
            if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0 && (object = (object = this.savedEnclosingAttr) != null ? (NodeImpl)((Object)((EnclosingAttr)object).node.getOwnerElement()) : this) != null) {
                Object object2;
                NodeImpl nodeImpl3;
                do {
                    object2 = object;
                    nodeImpl3 = ((NodeImpl)object2).parentNode();
                    object = nodeImpl3;
                } while (nodeImpl3 != null);
                if (((NodeImpl)object2).getNodeType() == 9) {
                    object = new MutationEventImpl();
                    ((MutationEventImpl)object).initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null, (short)0);
                    this.dispatchEventToSubtree(nodeImpl, nodeImpl2, (Event)object);
                }
            }
        }
    }

    @Override
    void renamedAttrNode(Attr attr2, Attr attr3) {
    }

    @Override
    void renamedElement(Element element, Element element2) {
    }

    @Override
    void replacedNode(NodeImpl nodeImpl) {
        if (this.mutationEvents) {
            this.dispatchAggregateEvents(nodeImpl, this.savedEnclosingAttr);
        }
    }

    @Override
    void replacedText(NodeImpl nodeImpl) {
        Vector vector = this.ranges;
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i != n; ++i) {
                ((RangeImpl)this.ranges.elementAt(i)).receiveReplacedText(nodeImpl);
            }
        }
    }

    @Override
    void replacingNode(NodeImpl nodeImpl) {
        if (this.mutationEvents) {
            this.saveEnclosingAttr(nodeImpl);
        }
    }

    protected void saveEnclosingAttr(NodeImpl nodeImpl) {
        this.savedEnclosingAttr = null;
        Object object = LCount.lookup("DOMAttrModified");
        if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
            while (true) {
                if (nodeImpl == null) {
                    return;
                }
                short s = nodeImpl.getNodeType();
                if (s == 2) {
                    object = new EnclosingAttr();
                    ((EnclosingAttr)object).node = (AttrImpl)nodeImpl;
                    ((EnclosingAttr)object).oldvalue = ((EnclosingAttr)object).node.getNodeValue();
                    this.savedEnclosingAttr = object;
                    return;
                }
                if (s != 5) break;
                nodeImpl = nodeImpl.parentNode();
            }
        }
    }

    @Override
    void setAttrNode(AttrImpl attrImpl, AttrImpl attrImpl2) {
        if (this.mutationEvents) {
            if (attrImpl2 == null) {
                this.dispatchAggregateEvents(attrImpl.ownerNode, attrImpl, null, (short)2);
            } else {
                this.dispatchAggregateEvents(attrImpl.ownerNode, attrImpl, attrImpl2.getNodeValue(), (short)1);
            }
        }
    }

    protected void setEventListeners(NodeImpl nodeImpl, Vector vector) {
        block2: {
            boolean bl;
            block3: {
                block1: {
                    if (this.eventListeners == null) {
                        this.eventListeners = new Hashtable();
                    }
                    if (vector != null) break block1;
                    this.eventListeners.remove(nodeImpl);
                    if (!this.eventListeners.isEmpty()) break block2;
                    bl = false;
                    break block3;
                }
                this.eventListeners.put(nodeImpl, vector);
                bl = true;
            }
            this.mutationEvents = bl;
        }
    }

    @Override
    void setMutationEvents(boolean bl) {
        this.mutationEvents = bl;
    }

    void splitData(Node node, Node node2, int n) {
        Vector vector = this.ranges;
        if (vector != null) {
            int n2 = vector.size();
            for (int i = 0; i != n2; ++i) {
                ((RangeImpl)this.ranges.elementAt(i)).receiveSplitData(node, node2, n);
            }
        }
    }

    class EnclosingAttr
    implements Serializable {
        AttrImpl node;
        String oldvalue;

        EnclosingAttr() {
        }
    }

    class LEntry
    implements Serializable {
        EventListener listener;
        String type;
        boolean useCapture;

        LEntry(String string2, EventListener eventListener, boolean bl) {
            this.type = string2;
            this.listener = eventListener;
            this.useCapture = bl;
        }
    }
}

