/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom3.TypeInfo;
import org.apache.xerces.util.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementImpl
extends ParentNode
implements Element,
TypeInfo {
    static final long serialVersionUID = 3717253516652722278L;
    protected AttributeMap attributes;
    protected String name;

    protected ElementImpl() {
    }

    public ElementImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl);
        this.name = string2;
        this.needsSyncData(true);
    }

    @Override
    public Node cloneNode(boolean bl) {
        ElementImpl elementImpl = (ElementImpl)super.cloneNode(bl);
        AttributeMap attributeMap = this.attributes;
        if (attributeMap != null) {
            elementImpl.attributes = (AttributeMap)attributeMap.cloneMap(elementImpl);
        }
        return elementImpl;
    }

    @Override
    public String getAttribute(String object) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        AttributeMap attributeMap = this.attributes;
        String string2 = "";
        if (attributeMap == null) {
            return "";
        }
        object = (object = (Attr)attributeMap.getNamedItem((String)object)) == null ? string2 : object.getValue();
        return object;
    }

    @Override
    public String getAttributeNS(String object, String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        AttributeMap attributeMap = this.attributes;
        String string3 = "";
        if (attributeMap == null) {
            return "";
        }
        object = (object = (Attr)attributeMap.getNamedItemNS((String)object, string2)) == null ? string3 : object.getValue();
        return object;
    }

    @Override
    public Attr getAttributeNode(String string2) {
        AttributeMap attributeMap;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attributeMap = this.attributes) == null) {
            return null;
        }
        return (Attr)attributeMap.getNamedItem(string2);
    }

    @Override
    public Attr getAttributeNodeNS(String string2, String string3) {
        AttributeMap attributeMap;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attributeMap = this.attributes) == null) {
            return null;
        }
        return (Attr)attributeMap.getNamedItemNS(string2, string3);
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes;
    }

    @Override
    public String getBaseURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        String string2 = this.ownerNode.getBaseURI();
        Object object = this.attributes;
        Object object2 = string2;
        if (object != null) {
            object = (Attr)((NamedNodeMapImpl)object).getNamedItem("xml:base");
            object2 = string2;
            if (object != null) {
                object = object.getNodeValue();
                object2 = string2;
                if (((String)object).length() != 0) {
                    try {
                        object2 = new URI(string2, (String)object);
                        object2 = ((URI)object2).toString();
                        return object2;
                    }
                    catch (URI.MalformedURIException malformedURIException) {
                        object2 = null;
                    }
                }
            }
        }
        return object2;
    }

    protected NamedNodeMapImpl getDefaultAttributes() {
        ParentNode parentNode = (DocumentTypeImpl)this.ownerDocument.getDoctype();
        if (parentNode == null) {
            return null;
        }
        if ((parentNode = (ElementDefinitionImpl)((DocumentTypeImpl)parentNode).getElements().getNamedItem(this.getNodeName())) == null) {
            return null;
        }
        return (NamedNodeMapImpl)((ElementDefinitionImpl)parentNode).getAttributes();
    }

    @Override
    public NodeList getElementsByTagName(String string2) {
        return new DeepNodeListImpl(this, string2);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string2, String string3) {
        return new DeepNodeListImpl(this, string2, string3);
    }

    @Override
    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    public TypeInfo getSchemaTypeInfo() {
        return this;
    }

    @Override
    public String getTagName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public String getTypeName() {
        return null;
    }

    @Override
    public String getTypeNamespace() {
        return null;
    }

    protected int getXercesAttribute(String string2, String string3) {
        AttributeMap attributeMap;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attributeMap = this.attributes) == null) {
            return -1;
        }
        return attributeMap.getNamedItemIndex(string2, string3);
    }

    @Override
    public boolean hasAttribute(String string2) {
        boolean bl = this.getAttributeNode(string2) != null;
        return bl;
    }

    @Override
    public boolean hasAttributeNS(String string2, String string3) {
        boolean bl = this.getAttributeNodeNS(string2, string3) != null;
        return bl;
    }

    @Override
    public boolean hasAttributes() {
        AttributeMap attributeMap;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        boolean bl = (attributeMap = this.attributes) != null && attributeMap.getLength() != 0;
        return bl;
    }

    @Override
    public boolean isEqualNode(Node object) {
        Node node;
        if (!super.isEqualNode((Node)object)) {
            return false;
        }
        boolean bl = this.hasAttributes();
        if (bl != (node = (Element)object).hasAttributes()) {
            return false;
        }
        if (bl) {
            object = this.getAttributes();
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = object.getLength();
            if (n != namedNodeMap.getLength()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                Node node2;
                node = object.item(i);
                if (!(node.getLocalName() == null ? (node2 = namedNodeMap.getNamedItem(node.getNodeName())) == null || !((NodeImpl)node).isEqualNode(node2) : (node2 = namedNodeMap.getNamedItemNS(node.getNamespaceURI(), node.getLocalName())) == null || !((NodeImpl)node).isEqualNode(node2))) continue;
                return false;
            }
        }
        return true;
    }

    void moveSpecifiedAttributes(ElementImpl elementImpl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (elementImpl.hasAttributes()) {
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            this.attributes.moveSpecifiedAttributes(elementImpl.attributes);
        }
    }

    @Override
    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode childNode = this.firstChild;
        while (true) {
            if (childNode == null) {
                if (this.attributes != null) {
                    for (int i = 0; i < this.attributes.getLength(); ++i) {
                        this.attributes.item(i).normalize();
                    }
                }
                this.isNormalized(true);
                return;
            }
            ChildNode childNode2 = childNode.nextSibling;
            if (childNode.getNodeType() == 3) {
                if (childNode2 != null && childNode2.getNodeType() == 3) {
                    ((Text)((Object)childNode)).appendData(childNode2.getNodeValue());
                    this.removeChild(childNode2);
                    continue;
                }
                if (childNode.getNodeValue().length() == 0) {
                    this.removeChild(childNode);
                }
            } else if (childNode.getNodeType() == 1) {
                childNode.normalize();
            }
            childNode = childNode2;
        }
    }

    protected void reconcileDefaultAttributes() {
        if (this.attributes != null) {
            NamedNodeMapImpl namedNodeMapImpl = this.getDefaultAttributes();
            this.attributes.reconcileDefaults(namedNodeMapImpl);
        }
    }

    @Override
    public void removeAttribute(String string2) {
        AttributeMap attributeMap;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attributeMap = this.attributes) == null) {
            return;
        }
        attributeMap.safeRemoveNamedItem(string2);
    }

    @Override
    public void removeAttributeNS(String string2, String string3) {
        AttributeMap attributeMap;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attributeMap = this.attributes) == null) {
            return;
        }
        attributeMap.safeRemoveNamedItemNS(string2, string3);
    }

    @Override
    public Attr removeAttributeNode(Attr attr2) throws DOMException {
        AttributeMap attributeMap;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attributeMap = this.attributes) != null) {
            return (Attr)attributeMap.removeItem(attr2, true);
        }
        throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
    }

    void rename(String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = string2;
        this.reconcileDefaultAttributes();
    }

    @Override
    public void setAttribute(String object, String string2) {
        Attr attr2;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr2 = this.getAttributeNode((String)object)) == null) {
            object = this.getOwnerDocument().createAttribute((String)object);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            object.setNodeValue(string2);
            this.attributes.setNamedItem((Node)object);
        } else {
            attr2.setNodeValue(string2);
        }
    }

    @Override
    public void setAttributeNS(String object, String object2, String string2) {
        String string3;
        String string4;
        int n;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((n = ((String)object2).indexOf(58)) < 0) {
            string4 = object2;
            string3 = null;
        } else {
            string3 = ((String)object2).substring(0, n);
            string4 = ((String)object2).substring(n + 1);
        }
        Attr attr2 = this.getAttributeNodeNS((String)object, string4);
        if (attr2 == null) {
            object = this.getOwnerDocument().createAttributeNS((String)object, (String)object2);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            object.setNodeValue(string2);
            this.attributes.setNamedItemNS((Node)object);
        } else {
            object2 = (AttrNSImpl)attr2;
            object = string4;
            if (string3 != null) {
                object = new StringBuffer();
                ((StringBuffer)object).append(string3);
                ((StringBuffer)object).append(":");
                ((StringBuffer)object).append(string4);
                object = ((StringBuffer)object).toString();
            }
            ((AttrImpl)object2).name = object;
            attr2.setNodeValue(string2);
        }
    }

    @Override
    public Attr setAttributeNode(Attr attr2) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (!this.isReadOnly()) {
                if (attr2.getOwnerDocument() != this.ownerDocument) {
                    throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
                }
            } else {
                throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItem(attr2);
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr2) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (!this.isReadOnly()) {
                if (attr2.getOwnerDocument() != this.ownerDocument) {
                    throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
                }
            } else {
                throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItemNS(attr2);
    }

    @Override
    public void setIdAttribute(String object, boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        object = this.getAttributeNode((String)object);
        if (this.ownerDocument.errorChecking) {
            if (!this.isReadOnly()) {
                if (object.getOwnerElement() != this) {
                    throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
                }
            } else {
                throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            }
        }
        ((AttrImpl)object).isIdAttribute(bl);
        if (!bl) {
            this.ownerDocument.removeIdentifier(object.getValue());
        } else {
            this.ownerDocument.putIdentifier(object.getValue(), this);
        }
    }

    @Override
    public void setIdAttributeNS(String object, String object2, boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        object2 = this.getAttributeNodeNS((String)object, (String)object2);
        if (this.ownerDocument.errorChecking) {
            if (!this.isReadOnly()) {
                if (object2.getOwnerElement() != this) {
                    throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
                }
            } else {
                throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            }
        }
        ((AttrImpl)object2).isIdAttribute(bl);
        object = this.ownerDocument;
        object2 = object2.getValue();
        if (!bl) {
            ((CoreDocumentImpl)object).removeIdentifier((String)object2);
        } else {
            ((CoreDocumentImpl)object).putIdentifier((String)object2, this);
        }
    }

    @Override
    public void setIdAttributeNode(Attr attr2, boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (!this.isReadOnly()) {
                if (attr2.getOwnerElement() != this) {
                    throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
                }
            } else {
                throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            }
        }
        ((AttrImpl)attr2).isIdAttribute(bl);
        if (!bl) {
            this.ownerDocument.removeIdentifier(attr2.getValue());
        } else {
            this.ownerDocument.putIdentifier(attr2.getValue(), this);
        }
    }

    @Override
    void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        super.setOwnerDocument(coreDocumentImpl);
        AttributeMap attributeMap = this.attributes;
        if (attributeMap != null) {
            attributeMap.setOwnerDocument(coreDocumentImpl);
        }
    }

    @Override
    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        AttributeMap attributeMap = this.attributes;
        if (attributeMap != null) {
            attributeMap.setReadOnly(bl, true);
        }
    }

    protected int setXercesAttributeNode(Attr attr2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes.addItem(attr2);
    }

    protected void setupDefaultAttributes() {
        NamedNodeMapImpl namedNodeMapImpl = this.getDefaultAttributes();
        if (namedNodeMapImpl != null) {
            this.attributes = new AttributeMap(this, namedNodeMapImpl);
        }
    }

    @Override
    protected void synchronizeData() {
        this.needsSyncData(false);
        boolean bl = this.ownerDocument.getMutationEvents();
        this.ownerDocument.setMutationEvents(false);
        this.setupDefaultAttributes();
        this.ownerDocument.setMutationEvents(bl);
    }
}

