/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.util.URI;
import org.apache.xerces.xni.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;

public class ElementNSImpl
extends ElementImpl {
    static final long serialVersionUID = -9142310625494392642L;
    static final String xmlURI = "http://www.w3.org/XML/1998/namespace";
    protected String localName;
    protected String namespaceURI;
    transient XSTypeDefinition type;

    protected ElementNSImpl() {
    }

    protected ElementNSImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl, string2);
    }

    protected ElementNSImpl(CoreDocumentImpl coreDocumentImpl, String string2, String string3) throws DOMException {
        super(coreDocumentImpl, string3);
        this.setName(string2, string3);
    }

    protected ElementNSImpl(CoreDocumentImpl coreDocumentImpl, String string2, String string3, String string4) throws DOMException {
        super(coreDocumentImpl, string3);
        this.localName = string4;
        this.namespaceURI = string2;
    }

    private void setName(String string2, String string3) {
        String string4;
        this.namespaceURI = string2;
        if (string2 != null) {
            string4 = string2.length() == 0 ? null : string2;
            this.namespaceURI = string4;
        }
        int n = string3.indexOf(58);
        int n2 = string3.lastIndexOf(58);
        this.ownerDocument().checkNamespaceWF(string3, n, n2);
        if (n < 0) {
            this.localName = string3;
            this.ownerDocument().checkQName(null, this.localName);
            if (string3.equals("xmlns") && (string2 == null || !string2.equals(NamespaceContext.XMLNS_URI)) || string2 != null && string2.equals(NamespaceContext.XMLNS_URI) && !string3.equals("xmlns")) {
                throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
            }
        } else {
            string4 = string3.substring(0, n);
            this.localName = string3.substring(n2 + 1);
            this.ownerDocument().checkQName(string4, this.localName);
            this.ownerDocument().checkDOMNSErr(string4, string2);
        }
    }

    @Override
    public String getBaseURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        String string2 = this.ownerNode.getBaseURI();
        Object object = string2;
        if (this.attributes != null) {
            Object object2 = (Attr)this.attributes.getNamedItemNS(xmlURI, "base");
            object = string2;
            if (object2 != null) {
                object2 = object2.getNodeValue();
                object = string2;
                if (((String)object2).length() != 0) {
                    try {
                        object = new URI(string2);
                        URI uRI = new URI((URI)object, (String)object2);
                        object = uRI.toString();
                        return object;
                    }
                    catch (URI.MalformedURIException malformedURIException) {
                        object = null;
                    }
                }
            }
        }
        return object;
    }

    @Override
    public String getLocalName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.localName;
    }

    @Override
    public String getNamespaceURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    @Override
    public String getPrefix() {
        int n;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        String string2 = (n = this.name.indexOf(58)) < 0 ? null : this.name.substring(0, n);
        return string2;
    }

    @Override
    public String getTypeName() {
        XSTypeDefinition xSTypeDefinition = this.type;
        if (xSTypeDefinition != null) {
            return xSTypeDefinition.getName();
        }
        return null;
    }

    @Override
    public String getTypeNamespace() {
        XSTypeDefinition xSTypeDefinition = this.type;
        if (xSTypeDefinition != null) {
            return xSTypeDefinition.getNamespace();
        }
        return null;
    }

    void rename(String string2, String string3) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = string3;
        this.setName(string2, string3);
        this.reconcileDefaultAttributes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPrefix(String string2) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument().errorChecking) {
            if (this.isReadOnly()) throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            if (string2 != null && string2.length() != 0) {
                if (!CoreDocumentImpl.isXMLName(string2)) throw new DOMException(5, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null));
                if (this.namespaceURI == null || string2.indexOf(58) >= 0) throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
                if (string2.equals("xml") && !this.namespaceURI.equals(xmlURI)) {
                    throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
                }
            }
        }
        if (string2 != null && string2.length() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            stringBuffer.append(":");
            stringBuffer.append(this.localName);
            string2 = stringBuffer.toString();
        } else {
            string2 = this.localName;
        }
        this.name = string2;
    }

    public void setType(XSTypeDefinition xSTypeDefinition) {
        this.type = xSTypeDefinition;
    }

    protected void setValues(CoreDocumentImpl coreDocumentImpl, String string2, String string3, String string4) {
        this.firstChild = null;
        this.previousSibling = null;
        this.nextSibling = null;
        this.fNodeListCache = null;
        this.attributes = null;
        this.flags = (short)0;
        this.setOwnerDocument(coreDocumentImpl);
        this.needsSyncData(true);
        this.name = string3;
        this.localName = string4;
        this.namespaceURI = string2;
    }
}

