/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.ParentNode;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;

public class EntityReferenceImpl
extends ParentNode
implements EntityReference {
    static final long serialVersionUID = -7381452955687102062L;
    protected String baseURI;
    protected String name;

    public EntityReferenceImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl);
        this.name = string2;
        this.isReadOnly(true);
        this.needsSyncChildren(true);
    }

    @Override
    public Node cloneNode(boolean bl) {
        EntityReferenceImpl entityReferenceImpl = (EntityReferenceImpl)super.cloneNode(bl);
        entityReferenceImpl.setReadOnly(true, bl);
        return entityReferenceImpl;
    }

    @Override
    public String getBaseURI() {
        Object object;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.baseURI == null && (object = this.getOwnerDocument().getDoctype()) != null && (object = object.getEntities()) != null && (object = (EntityImpl)object.getNamedItem(this.getNodeName())) != null) {
            return ((EntityImpl)object).getBaseURI();
        }
        return this.baseURI;
    }

    protected String getEntityRefValue() {
        block9: {
            block12: {
                Object object;
                block11: {
                    block10: {
                        if (this.needsSyncChildren()) {
                            this.synchronizeChildren();
                        }
                        if (this.firstChild == null) break block9;
                        if (this.firstChild.getNodeType() != 5) break block10;
                        object = ((EntityReferenceImpl)this.firstChild).getEntityRefValue();
                        break block11;
                    }
                    if (this.firstChild.getNodeType() != 3) break block12;
                    object = this.firstChild.getNodeValue();
                }
                if (this.firstChild.nextSibling == null) {
                    return object;
                }
                StringBuffer stringBuffer = new StringBuffer((String)object);
                object = this.firstChild;
                while (true) {
                    ChildNode childNode;
                    if ((childNode = ((ChildNode)object).nextSibling) == null) {
                        return stringBuffer.toString();
                    }
                    if (childNode.getNodeType() == 5) {
                        object = ((EntityReferenceImpl)childNode).getEntityRefValue();
                    } else {
                        if (childNode.getNodeType() != 3) break;
                        object = childNode.getNodeValue();
                    }
                    stringBuffer.append((String)object);
                    object = childNode;
                }
            }
            return null;
        }
        return "";
    }

    @Override
    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public short getNodeType() {
        return 5;
    }

    public void setBaseURI(String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.baseURI = string2;
    }

    @Override
    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (bl2) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                childNode.setReadOnly(bl, true);
                childNode = childNode.nextSibling;
            }
        }
        this.isReadOnly(bl);
    }

    @Override
    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
        Object object = this.getOwnerDocument().getDoctype();
        if (object != null && (object = object.getEntities()) != null) {
            if ((object = (EntityImpl)object.getNamedItem(this.getNodeName())) == null) {
                return;
            }
            this.isReadOnly(false);
            object = ((ParentNode)object).getFirstChild();
            while (true) {
                if (object == null) {
                    this.setReadOnly(true, true);
                    break;
                }
                this.insertBefore(object.cloneNode(true), null);
                object = object.getNextSibling();
            }
        }
    }
}

