/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap,
Serializable {
    protected static final short CHANGED = 2;
    protected static final short HASDEFAULTS = 4;
    protected static final short READONLY = 1;
    static final long serialVersionUID = -7039242451046758020L;
    protected short flags;
    protected Vector nodes;
    protected NodeImpl ownerNode;

    protected NamedNodeMapImpl(NodeImpl nodeImpl) {
        this.ownerNode = nodeImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int addItem(Node node) {
        int n = this.findNamePoint(node.getNamespaceURI(), node.getLocalName());
        if (n >= 0) {
            NodeImpl nodeImpl = (NodeImpl)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
            return n;
        }
        n = this.findNamePoint(node.getNodeName(), 0);
        if (n >= 0) {
            NodeImpl nodeImpl = (NodeImpl)this.nodes.elementAt(n);
        } else {
            int n2;
            n = n2 = -1 - n;
            if (this.nodes == null) {
                this.nodes = new Vector(5, 10);
                n = n2;
            }
        }
        this.nodes.insertElementAt(node, n);
        return n;
    }

    final void changed(boolean bl) {
        int n = bl ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = (short)n;
    }

    final boolean changed() {
        boolean bl = (this.flags & 2) != 0;
        return bl;
    }

    protected void cloneContent(NamedNodeMapImpl namedNodeMapImpl) {
        int n;
        Cloneable cloneable = namedNodeMapImpl.nodes;
        if (cloneable != null && (n = ((Vector)cloneable).size()) != 0) {
            if (this.nodes == null) {
                this.nodes = new Vector(n);
            }
            this.nodes.setSize(n);
            for (int i = 0; i < n; ++i) {
                cloneable = (NodeImpl)namedNodeMapImpl.nodes.elementAt(i);
                NodeImpl nodeImpl = (NodeImpl)((NodeImpl)cloneable).cloneNode(true);
                nodeImpl.isSpecified(((NodeImpl)cloneable).isSpecified());
                this.nodes.setElementAt(nodeImpl, i);
            }
        }
    }

    protected Vector cloneMap(Vector vector) {
        Vector vector2 = vector;
        if (vector == null) {
            vector2 = new Vector(5, 10);
        }
        vector2.setSize(0);
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                vector2.insertElementAt(this.nodes.elementAt(i), i);
            }
        }
        return vector2;
    }

    public NamedNodeMapImpl cloneMap(NodeImpl serializable) {
        serializable = new NamedNodeMapImpl((NodeImpl)serializable);
        ((NamedNodeMapImpl)serializable).cloneContent(this);
        return serializable;
    }

    protected int findNamePoint(String string2, int n) {
        Vector vector = this.nodes;
        int n2 = 0;
        int n3 = 0;
        if (vector != null) {
            n2 = vector.size() - 1;
            while (true) {
                if (n > n2) {
                    n2 = n3;
                    if (n <= n3) break;
                    n2 = n;
                    break;
                }
                n3 = (n + n2) / 2;
                int n4 = string2.compareTo(((Node)this.nodes.elementAt(n3)).getNodeName());
                if (n4 == 0) {
                    return n3;
                }
                if (n4 < 0) {
                    n2 = n3 - 1;
                    continue;
                }
                n = n3 + 1;
            }
        }
        return -1 - n2;
    }

    protected int findNamePoint(String string2, String string3) {
        if (this.nodes == null) {
            return -1;
        }
        if (string3 == null) {
            return -1;
        }
        int n = 0;
        while (n < this.nodes.size()) {
            NodeImpl nodeImpl = (NodeImpl)this.nodes.elementAt(n);
            String string4 = nodeImpl.getNamespaceURI();
            String string5 = nodeImpl.getLocalName();
            if (string2 == null ? string4 == null && (string3.equals(string5) || string5 == null && string3.equals(nodeImpl.getNodeName())) : string2.equals(string4) && string3.equals(string5)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected Object getItem(int n) {
        Vector vector = this.nodes;
        if (vector != null) {
            return vector.elementAt(n);
        }
        return null;
    }

    @Override
    public int getLength() {
        Vector vector = this.nodes;
        int n = vector != null ? vector.size() : 0;
        return n;
    }

    @Override
    public Node getNamedItem(String object) {
        int n = this.findNamePoint((String)object, 0);
        object = n < 0 ? null : (Node)this.nodes.elementAt(n);
        return object;
    }

    protected int getNamedItemIndex(String string2, String string3) {
        return this.findNamePoint(string2, string3);
    }

    @Override
    public Node getNamedItemNS(String object, String string2) {
        int n = this.findNamePoint((String)object, string2);
        object = n < 0 ? null : (Node)this.nodes.elementAt(n);
        return object;
    }

    boolean getReadOnly() {
        return this.isReadOnly();
    }

    final void hasDefaults(boolean bl) {
        int n = bl ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = (short)n;
    }

    final boolean hasDefaults() {
        boolean bl = (this.flags & 4) != 0;
        return bl;
    }

    final void isReadOnly(boolean bl) {
        int n = bl ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = (short)n;
    }

    final boolean isReadOnly() {
        short s = this.flags;
        boolean bl = true;
        if ((s & 1) == 0) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Node item(int n) {
        Object object = this.nodes;
        object = object != null && n < ((Vector)object).size() ? (Node)this.nodes.elementAt(n) : null;
        return object;
    }

    protected boolean precedes(Node node, Node node2) {
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                Node node3 = (Node)this.nodes.elementAt(i);
                if (node3 == node) {
                    return true;
                }
                if (node3 != node2) continue;
                return false;
            }
        }
        return false;
    }

    public void removeAll() {
        Vector vector = this.nodes;
        if (vector != null) {
            vector.removeAllElements();
        }
    }

    protected void removeItem(int n) {
        Vector vector = this.nodes;
        if (vector != null && n < vector.size()) {
            this.nodes.removeElementAt(n);
        }
    }

    @Override
    public Node removeNamedItem(String object) throws DOMException {
        if (!this.isReadOnly()) {
            int n = this.findNamePoint((String)object, 0);
            if (n >= 0) {
                object = (NodeImpl)this.nodes.elementAt(n);
                this.nodes.removeElementAt(n);
                return object;
            }
            throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    @Override
    public Node removeNamedItemNS(String object, String string2) throws DOMException {
        if (!this.isReadOnly()) {
            int n = this.findNamePoint((String)object, string2);
            if (n >= 0) {
                object = (NodeImpl)this.nodes.elementAt(n);
                this.nodes.removeElementAt(n);
                return object;
            }
            throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        boolean bl = this.isReadOnly();
        NodeImpl nodeImpl = null;
        if (!bl) {
            if (node.getOwnerDocument() == this.ownerNode.ownerDocument()) {
                int n = this.findNamePoint(node.getNodeName(), 0);
                if (n >= 0) {
                    nodeImpl = (NodeImpl)this.nodes.elementAt(n);
                    this.nodes.setElementAt(node, n);
                    node = nodeImpl;
                } else {
                    if (this.nodes == null) {
                        this.nodes = new Vector(5, 10);
                    }
                    this.nodes.insertElementAt(node, -1 - n);
                    node = nodeImpl;
                }
                return node;
            }
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        NodeImpl nodeImpl;
        boolean bl = this.isReadOnly();
        Object var3_3 = null;
        if (bl) throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        if (node.getOwnerDocument() != this.ownerNode.ownerDocument()) throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        int n = this.findNamePoint(node.getNamespaceURI(), node.getLocalName());
        if (n >= 0) {
            nodeImpl = (NodeImpl)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
            return nodeImpl;
        }
        n = this.findNamePoint(node.getNodeName(), 0);
        if (n >= 0) {
            nodeImpl = (NodeImpl)this.nodes.elementAt(n);
        } else {
            int n2;
            n = n2 = -1 - n;
            nodeImpl = var3_3;
            if (this.nodes == null) {
                this.nodes = new Vector(5, 10);
                n = n2;
                nodeImpl = var3_3;
            }
        }
        this.nodes.insertElementAt(node, n);
        return nodeImpl;
    }

    void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                ((NodeImpl)this.item(i)).setOwnerDocument(coreDocumentImpl);
            }
        }
    }

    void setReadOnly(boolean bl, boolean bl2) {
        Vector vector;
        this.isReadOnly(bl);
        if (bl2 && (vector = this.nodes) != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                ((NodeImpl)this.nodes.elementAt(i)).setReadOnly(bl, bl2);
            }
        }
    }
}

