/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeIteratorImpl
implements NodeIterator {
    private Node fCurrentNode;
    private boolean fDetach = false;
    private DocumentImpl fDocument;
    private boolean fEntityReferenceExpansion;
    private boolean fForward = true;
    private NodeFilter fNodeFilter;
    private Node fRoot;
    private int fWhatToShow = -1;

    public NodeIteratorImpl(DocumentImpl documentImpl, Node node, int n, NodeFilter nodeFilter, boolean bl) {
        this.fDocument = documentImpl;
        this.fRoot = node;
        this.fCurrentNode = null;
        this.fWhatToShow = n;
        this.fNodeFilter = nodeFilter;
        this.fEntityReferenceExpansion = bl;
    }

    boolean acceptNode(Node node) {
        NodeFilter nodeFilter = this.fNodeFilter;
        boolean bl = false;
        boolean bl2 = false;
        if (nodeFilter == null) {
            int n = this.fWhatToShow;
            if ((1 << node.getNodeType() - 1 & n) != 0) {
                bl2 = true;
            }
            return bl2;
        }
        bl2 = bl;
        if ((this.fWhatToShow & 1 << node.getNodeType() - 1) != 0) {
            bl2 = bl;
            if (this.fNodeFilter.acceptNode(node) == 1) {
                bl2 = true;
            }
        }
        return bl2;
    }

    @Override
    public void detach() {
        this.fDetach = true;
        this.fDocument.removeNodeIterator(this);
    }

    @Override
    public boolean getExpandEntityReferences() {
        return this.fEntityReferenceExpansion;
    }

    @Override
    public NodeFilter getFilter() {
        return this.fNodeFilter;
    }

    @Override
    public Node getRoot() {
        return this.fRoot;
    }

    @Override
    public int getWhatToShow() {
        return this.fWhatToShow;
    }

    Node matchNodeOrParent(Node node) {
        Node node2;
        Node node3 = node2 = this.fCurrentNode;
        if (node2 == null) {
            return null;
        }
        while (node3 != this.fRoot) {
            if (node == node3) {
                return node3;
            }
            node3 = node3.getParentNode();
        }
        return null;
    }

    @Override
    public Node nextNode() {
        if (!this.fDetach) {
            Node node;
            boolean bl;
            if (this.fRoot == null) {
                return null;
            }
            Node node2 = this.fCurrentNode;
            boolean bl2 = false;
            do {
                if (bl2) {
                    return null;
                }
                node = !this.fForward && node2 != null ? this.fCurrentNode : (!this.fEntityReferenceExpansion && node2 != null && node2.getNodeType() == 5 ? this.nextNode(node2, false) : this.nextNode(node2, true));
                this.fForward = true;
                if (node == null) {
                    return null;
                }
                bl = this.acceptNode(node);
                node2 = node;
                bl2 = bl;
            } while (!bl);
            this.fCurrentNode = node;
            return node;
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    Node nextNode(Node node, boolean bl) {
        if (node == null) {
            return this.fRoot;
        }
        if (bl && node.hasChildNodes()) {
            return node.getFirstChild();
        }
        if (node == this.fRoot) {
            return null;
        }
        Node node2 = node.getNextSibling();
        if (node2 != null) {
            return node2;
        }
        while ((node = node.getParentNode()) != null && node != this.fRoot) {
            node2 = node.getNextSibling();
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    @Override
    public Node previousNode() {
        if (!this.fDetach) {
            Node node;
            if (this.fRoot != null && (node = this.fCurrentNode) != null) {
                Node node2;
                boolean bl;
                boolean bl2 = false;
                do {
                    if (bl2) {
                        return null;
                    }
                    node2 = this.fForward && node != null ? this.fCurrentNode : this.previousNode(node);
                    this.fForward = false;
                    if (node2 == null) {
                        return null;
                    }
                    bl = this.acceptNode(node2);
                    node = node2;
                    bl2 = bl;
                } while (!bl);
                this.fCurrentNode = node2;
                return node2;
            }
            return null;
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    Node previousNode(Node node) {
        block7: {
            block8: {
                if (node == this.fRoot) {
                    return null;
                }
                Node node2 = node.getPreviousSibling();
                if (node2 == null) {
                    return node.getParentNode();
                }
                node = node2;
                if (!node2.hasChildNodes()) break block7;
                node = node2;
                if (this.fEntityReferenceExpansion) break block8;
                node = node2;
                if (node2 == null) break block8;
                node = node2;
                if (node2.getNodeType() == 5) break block7;
                node = node2;
            }
            while (node.hasChildNodes()) {
                node = node.getLastChild();
            }
        }
        return node;
    }

    public void removeNode(Node node) {
        if (node == null) {
            return;
        }
        Node node2 = this.matchNodeOrParent(node);
        if (node2 == null) {
            return;
        }
        if (this.fForward) {
            this.fCurrentNode = this.previousNode(node2);
        } else {
            node = this.nextNode(node2, false);
            if (node != null) {
                this.fCurrentNode = node;
            } else {
                this.fCurrentNode = this.previousNode(node2);
                this.fForward = true;
            }
        }
    }
}

