/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeListCache;
import org.apache.xerces.dom.ParentNode$1;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ParentNode
extends ChildNode {
    static final long serialVersionUID = 2815829867152120872L;
    protected transient NodeListCache fNodeListCache = null;
    protected ChildNode firstChild = null;
    protected CoreDocumentImpl ownerDocument;

    public ParentNode() {
    }

    protected ParentNode(CoreDocumentImpl coreDocumentImpl) {
        super(coreDocumentImpl);
        this.ownerDocument = coreDocumentImpl;
    }

    static /* synthetic */ int access$000(ParentNode parentNode) {
        return parentNode.nodeListGetLength();
    }

    static /* synthetic */ Node access$100(ParentNode parentNode, int n) {
        return parentNode.nodeListItem(n);
    }

    private int nodeListGetLength() {
        Serializable serializable = this.fNodeListCache;
        int n = 0;
        if (serializable == null) {
            serializable = this.firstChild;
            if (serializable == null) {
                return 0;
            }
            if (serializable == this.lastChild()) {
                return 1;
            }
            this.fNodeListCache = this.ownerDocument.getNodeListCache(this);
        }
        if (this.fNodeListCache.fLength == -1) {
            if (this.fNodeListCache.fChildIndex != -1 && this.fNodeListCache.fChild != null) {
                n = this.fNodeListCache.fChildIndex;
                serializable = this.fNodeListCache.fChild;
            } else {
                serializable = this.firstChild;
            }
            while (true) {
                if (serializable == null) {
                    this.fNodeListCache.fLength = n;
                    break;
                }
                ++n;
                serializable = ((ChildNode)serializable).nextSibling;
            }
        }
        return this.fNodeListCache.fLength;
    }

    private Node nodeListItem(int n) {
        boolean bl;
        int n2;
        Serializable serializable;
        block14: {
            Serializable serializable2 = this.fNodeListCache;
            serializable = null;
            if (serializable2 == null) {
                if (this.firstChild == this.lastChild()) {
                    if (n == 0) {
                        serializable = this.firstChild;
                    }
                    return serializable;
                }
                this.fNodeListCache = this.ownerDocument.getNodeListCache(this);
            }
            int n3 = this.fNodeListCache.fChildIndex;
            serializable2 = this.fNodeListCache.fChild;
            boolean bl2 = false;
            if (n3 != -1 && serializable2 != null) {
                if (n3 < n) {
                    while (true) {
                        n2 = ++n3;
                        serializable = serializable2;
                        bl = bl2;
                        if (n3 >= n) break block14;
                        if (serializable2 == null) {
                            n2 = n3;
                            serializable = serializable2;
                            bl = bl2;
                            break block14;
                        }
                        serializable2 = ((ChildNode)serializable2).nextSibling;
                    }
                }
                n2 = n3;
                serializable = serializable2;
                bl = bl2;
                if (n3 > n) {
                    while (true) {
                        n2 = --n3;
                        serializable = serializable2;
                        bl = bl2;
                        if (n3 <= n) break;
                        if (serializable2 == null) {
                            n2 = n3;
                            serializable = serializable2;
                            bl = bl2;
                            break;
                        }
                        serializable2 = ((ChildNode)serializable2).previousSibling();
                    }
                }
            } else {
                serializable = this.firstChild;
                for (n2 = 0; n2 < n && serializable != null; ++n2) {
                    serializable = serializable.nextSibling;
                }
                bl = true;
            }
        }
        if (!(bl || serializable != this.firstChild && serializable != this.lastChild())) {
            this.fNodeListCache.fChildIndex = -1;
            this.fNodeListCache.fChild = null;
            this.ownerDocument.freeNodeListCache(this.fNodeListCache);
        } else {
            this.fNodeListCache.fChildIndex = n2;
            this.fNodeListCache.fChild = serializable;
        }
        return serializable;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.needsSyncChildren(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }

    void checkNormalizationAfterInsert(ChildNode childNode) {
        block3: {
            block4: {
                block2: {
                    if (childNode.getNodeType() != 3) break block2;
                    ChildNode childNode2 = childNode.previousSibling();
                    childNode = childNode.nextSibling;
                    if ((childNode2 == null || childNode2.getNodeType() != 3) && (childNode == null || childNode.getNodeType() != 3)) break block3;
                    break block4;
                }
                if (childNode.isNormalized()) break block3;
            }
            this.isNormalized(false);
        }
    }

    void checkNormalizationAfterRemove(ChildNode childNode) {
        if (childNode != null && childNode.getNodeType() == 3 && (childNode = childNode.nextSibling) != null && childNode.getNodeType() == 3) {
            this.isNormalized(false);
        }
    }

    @Override
    public Node cloneNode(boolean bl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ParentNode parentNode = (ParentNode)super.cloneNode(bl);
        parentNode.ownerDocument = this.ownerDocument;
        parentNode.firstChild = null;
        parentNode.fNodeListCache = null;
        if (bl) {
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                parentNode.appendChild(childNode.cloneNode(true));
                childNode = childNode.nextSibling;
            }
        }
        return parentNode;
    }

    @Override
    public NodeList getChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this;
    }

    protected final NodeList getChildNodesUnoptimized() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return new ParentNode$1(this);
    }

    @Override
    public Node getFirstChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    @Override
    public Node getLastChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.lastChild();
    }

    @Override
    public int getLength() {
        return this.nodeListGetLength();
    }

    @Override
    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    @Override
    public String getTextContent() throws DOMException {
        Node node = this.getFirstChild();
        CharSequence charSequence = "";
        if (node != null) {
            if (node.getNextSibling() == null) {
                if (this.hasTextContent(node)) {
                    charSequence = node.getNodeValue();
                }
                return charSequence;
            }
            charSequence = new StringBuffer();
            this.getTextContent((StringBuffer)charSequence);
            return ((StringBuffer)charSequence).toString();
        }
        return "";
    }

    @Override
    void getTextContent(StringBuffer stringBuffer) throws DOMException {
        Node node = this.getFirstChild();
        while (node != null) {
            if (this.hasTextContent(node)) {
                ((NodeImpl)node).getTextContent(stringBuffer);
            }
            node = node.getNextSibling();
        }
        return;
    }

    @Override
    public boolean hasChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        boolean bl = this.firstChild != null;
        return bl;
    }

    final boolean hasTextContent(Node node) {
        boolean bl = node.getNodeType() != 8 && node.getNodeType() != 7 && (node.getNodeType() != 3 || !((TextImpl)node).isIgnorableWhitespace());
        return bl;
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.internalInsertBefore(node, node2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Node internalInsertBefore(Node node, Node object, boolean bl) throws DOMException {
        NodeImpl nodeImpl;
        Node node2;
        boolean bl2 = this.ownerDocument.errorChecking;
        if (node.getNodeType() == 11) {
            if (bl2) {
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (!this.ownerDocument.isKidOK(this, node3)) throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
                }
            }
            while (true) {
                if (!node.hasChildNodes()) {
                    return node;
                }
                this.insertBefore(node.getFirstChild(), (Node)object);
            }
        }
        if (node == object) {
            object = object.getNextSibling();
            this.removeChild(node);
            this.insertBefore(node, (Node)object);
            return node;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl2) {
            if (this.isReadOnly()) throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            node2 = node.getOwnerDocument();
            if (node2 != (nodeImpl = this.ownerDocument)) throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            if (!((CoreDocumentImpl)nodeImpl).isKidOK(this, node)) throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
            if (object != null && object.getParentNode() != this) {
                throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
            }
            boolean bl3 = true;
            for (node2 = this; bl3 && node2 != null; node2 = ((NodeImpl)node2).parentNode()) {
                bl3 = node != node2;
            }
            if (!bl3) {
                throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
            }
        }
        this.ownerDocument.insertingNode(this, bl);
        node2 = (ChildNode)node;
        nodeImpl = ((ChildNode)node2).parentNode();
        if (nodeImpl != null) {
            nodeImpl.removeChild(node2);
        }
        nodeImpl = (ChildNode)object;
        ((NodeImpl)node2).ownerNode = this;
        ((NodeImpl)node2).isOwned(true);
        ChildNode childNode = this.firstChild;
        if (childNode == null) {
            this.firstChild = node2;
            ((NodeImpl)node2).isFirstChild(true);
            ((ChildNode)node2).previousSibling = node2;
        } else if (nodeImpl == null) {
            object = childNode.previousSibling;
            ((ChildNode)object).nextSibling = node2;
            ((ChildNode)node2).previousSibling = object;
            this.firstChild.previousSibling = node2;
        } else if (object == childNode) {
            childNode.isFirstChild(false);
            ((ChildNode)node2).nextSibling = this.firstChild;
            ((ChildNode)node2).previousSibling = this.firstChild.previousSibling;
            this.firstChild.previousSibling = node2;
            this.firstChild = node2;
            ((NodeImpl)node2).isFirstChild(true);
        } else {
            object = ((ChildNode)nodeImpl).previousSibling;
            ((ChildNode)node2).nextSibling = nodeImpl;
            ((ChildNode)object).nextSibling = node2;
            ((ChildNode)nodeImpl).previousSibling = node2;
            ((ChildNode)node2).previousSibling = object;
        }
        this.changed();
        object = this.fNodeListCache;
        if (object != null) {
            if (((NodeListCache)object).fLength != -1) {
                object = this.fNodeListCache;
                ++((NodeListCache)object).fLength;
            }
            if (this.fNodeListCache.fChildIndex != -1) {
                if (this.fNodeListCache.fChild == nodeImpl) {
                    this.fNodeListCache.fChild = node2;
                } else {
                    this.fNodeListCache.fChildIndex = -1;
                }
            }
        }
        this.ownerDocument.insertedNode(this, (NodeImpl)node2, bl);
        this.checkNormalizationAfterInsert((ChildNode)node2);
        return node;
    }

    Node internalRemoveChild(Node object, boolean bl) throws DOMException {
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        if (coreDocumentImpl.errorChecking) {
            if (!this.isReadOnly()) {
                if (object != null && object.getParentNode() != this) {
                    throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
                }
            } else {
                throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            }
        }
        ChildNode childNode = (ChildNode)object;
        coreDocumentImpl.removingNode(this, childNode, bl);
        object = this.fNodeListCache;
        if (object != null) {
            if (((NodeListCache)object).fLength != -1) {
                object = this.fNodeListCache;
                --((NodeListCache)object).fLength;
            }
            if (this.fNodeListCache.fChildIndex != -1) {
                if (this.fNodeListCache.fChild == childNode) {
                    object = this.fNodeListCache;
                    --((NodeListCache)object).fChildIndex;
                    this.fNodeListCache.fChild = childNode.previousSibling();
                } else {
                    this.fNodeListCache.fChildIndex = -1;
                }
            }
        }
        if (childNode == this.firstChild) {
            childNode.isFirstChild(false);
            this.firstChild = object = childNode.nextSibling;
            if (object != null) {
                ((NodeImpl)object).isFirstChild(true);
                this.firstChild.previousSibling = childNode.previousSibling;
            }
        } else {
            ChildNode childNode2;
            ChildNode childNode3 = childNode.previousSibling;
            childNode3.nextSibling = childNode2 = childNode.nextSibling;
            object = childNode2;
            if (childNode2 == null) {
                object = this.firstChild;
            }
            ((ChildNode)object).previousSibling = childNode3;
        }
        object = childNode.previousSibling();
        childNode.ownerNode = coreDocumentImpl;
        childNode.isOwned(false);
        childNode.nextSibling = null;
        childNode.previousSibling = null;
        this.changed();
        coreDocumentImpl.removedNode(this, bl);
        this.checkNormalizationAfterRemove((ChildNode)object);
        return childNode;
    }

    @Override
    public boolean isEqualNode(Node node) {
        if (!super.isEqualNode(node)) {
            return false;
        }
        Node node2 = this.getFirstChild();
        for (node = node.getFirstChild(); node2 != null && node != null; node2 = node2.getNextSibling(), node = node.getNextSibling()) {
            if (((NodeImpl)node2).isEqualNode(node)) continue;
            return false;
        }
        return node2 == node;
    }

    @Override
    public Node item(int n) {
        return this.nodeListItem(n);
    }

    final ChildNode lastChild() {
        ChildNode childNode = this.firstChild;
        childNode = childNode != null ? childNode.previousSibling : null;
        return childNode;
    }

    final void lastChild(ChildNode childNode) {
        ChildNode childNode2 = this.firstChild;
        if (childNode2 != null) {
            childNode2.previousSibling = childNode;
        }
    }

    @Override
    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode childNode = this.firstChild;
        while (true) {
            if (childNode == null) {
                this.isNormalized(true);
                return;
            }
            childNode.normalize();
            childNode = childNode.nextSibling;
        }
    }

    @Override
    CoreDocumentImpl ownerDocument() {
        return this.ownerDocument;
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        return this.internalRemoveChild(node, false);
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.ownerDocument.replacingNode(this);
        this.internalInsertBefore(node, node2, true);
        if (node != node2) {
            this.internalRemoveChild(node2, true);
        }
        this.ownerDocument.replacedNode(this);
        return node2;
    }

    @Override
    void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        super.setOwnerDocument(coreDocumentImpl);
        this.ownerDocument = coreDocumentImpl;
        ChildNode childNode = this.firstChild;
        while (childNode != null) {
            childNode.setOwnerDocument(coreDocumentImpl);
            childNode = childNode.nextSibling;
        }
        return;
    }

    @Override
    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (bl2) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                if (childNode.getNodeType() != 5) {
                    childNode.setReadOnly(bl, true);
                }
                childNode = childNode.nextSibling;
            }
        }
    }

    @Override
    public void setTextContent(String string2) throws DOMException {
        while (true) {
            Node node;
            if ((node = this.getFirstChild()) == null) {
                if (string2 != null) {
                    this.appendChild(this.ownerDocument().createTextNode(string2));
                }
                return;
            }
            this.removeChild(node);
        }
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
    }
}

