/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.RangeExceptionImpl;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.ranges.RangeException;

public class RangeImpl
implements Range {
    static final int CLONE_CONTENTS = 2;
    static final int DELETE_CONTENTS = 3;
    static final int EXTRACT_CONTENTS = 1;
    Node fDeleteNode = null;
    boolean fDetach = false;
    DocumentImpl fDocument;
    Node fEndContainer;
    int fEndOffset;
    Node fInsertNode = null;
    boolean fIsCollapsed;
    Node fRemoveChild = null;
    Node fSplitNode = null;
    Node fStartContainer;
    int fStartOffset;

    public RangeImpl(DocumentImpl documentImpl) {
        this.fDocument = documentImpl;
        this.fStartContainer = documentImpl;
        this.fEndContainer = documentImpl;
        this.fStartOffset = 0;
        this.fEndOffset = 0;
        this.fDetach = false;
    }

    private Node getRootContainer(Node node) {
        Node node2 = node;
        if (node == null) {
            return null;
        }
        while (node2.getParentNode() != null) {
            node2 = node2.getParentNode();
        }
        return node2;
    }

    private Node getSelectedNode(Node node, int n) {
        Node node2;
        if (node.getNodeType() == 3) {
            return node;
        }
        if (n < 0) {
            return node;
        }
        for (node2 = node.getFirstChild(); node2 != null && n > 0; --n, node2 = node2.getNextSibling()) {
        }
        if (node2 != null) {
            return node2;
        }
        return node;
    }

    private boolean hasLegalRootContainer(Node node) {
        if (node == null) {
            return false;
        }
        short s = this.getRootContainer(node).getNodeType();
        return s == 2 || s == 9 || s == 11;
    }

    private boolean isLegalContainedNode(Node node) {
        if (node == null) {
            return false;
        }
        short s = node.getNodeType();
        return s != 2 && s != 6 && s != 9 && s != 11 && s != 12;
    }

    private boolean isLegalContainer(Node node) {
        Node node2 = node;
        if (node == null) {
            return false;
        }
        while (true) {
            if (node2 == null) {
                return true;
            }
            short s = node2.getNodeType();
            if (s == 6 || s == 10 || s == 12) break;
            node2 = node2.getParentNode();
        }
        return false;
    }

    private DocumentFragment traverseCommonAncestors(Node node, Node node2, int n) {
        DocumentFragment documentFragment = n != 3 ? this.fDocument.createDocumentFragment() : null;
        Node node3 = this.traverseLeftBoundary(node, n);
        if (documentFragment != null) {
            documentFragment.appendChild(node3);
        }
        node3 = node.getParentNode();
        int n2 = this.indexOf(node, node3);
        n2 = this.indexOf(node2, node3) - (n2 + 1);
        node3 = node.getNextSibling();
        while (true) {
            if (n2 <= 0) {
                node2 = this.traverseRightBoundary(node2, n);
                if (documentFragment != null) {
                    documentFragment.appendChild(node2);
                }
                if (n != 2) {
                    this.setStartAfter(node);
                    this.collapse(true);
                }
                return documentFragment;
            }
            Node node4 = node3.getNextSibling();
            node3 = this.traverseFullySelected(node3, n);
            if (documentFragment != null) {
                documentFragment.appendChild(node3);
            }
            --n2;
            node3 = node4;
        }
    }

    private DocumentFragment traverseCommonEndContainer(Node node, int n) {
        DocumentFragment documentFragment = n != 3 ? this.fDocument.createDocumentFragment() : null;
        Node node2 = this.traverseLeftBoundary(node, n);
        if (documentFragment != null) {
            documentFragment.appendChild(node2);
        }
        int n2 = this.indexOf(node, this.fEndContainer);
        n2 = this.fEndOffset - (n2 + 1);
        node2 = node.getNextSibling();
        while (true) {
            if (n2 <= 0) {
                if (n != 2) {
                    this.setStartAfter(node);
                    this.collapse(true);
                }
                return documentFragment;
            }
            Node node3 = node2.getNextSibling();
            node2 = this.traverseFullySelected(node2, n);
            if (documentFragment != null) {
                documentFragment.appendChild(node2);
            }
            --n2;
            node2 = node3;
        }
    }

    private DocumentFragment traverseCommonStartContainer(Node node, int n) {
        int n2;
        DocumentFragment documentFragment = n != 3 ? this.fDocument.createDocumentFragment() : null;
        Node node2 = this.traverseRightBoundary(node, n);
        if (documentFragment != null) {
            documentFragment.appendChild(node2);
        }
        if ((n2 = this.indexOf(node, this.fStartContainer) - this.fStartOffset) <= 0) {
            if (n != 2) {
                this.setEndBefore(node);
                this.collapse(false);
            }
            return documentFragment;
        }
        node2 = node.getPreviousSibling();
        while (true) {
            if (n2 <= 0) {
                if (n != 2) {
                    this.setEndBefore(node);
                    this.collapse(false);
                }
                return documentFragment;
            }
            Node node3 = node2.getPreviousSibling();
            node2 = this.traverseFullySelected(node2, n);
            if (documentFragment != null) {
                documentFragment.insertBefore(node2, documentFragment.getFirstChild());
            }
            --n2;
            node2 = node3;
        }
    }

    private DocumentFragment traverseContents(int n) throws DOMException {
        Node node;
        Node node2 = this.fStartContainer;
        if (node2 != null && (node = this.fEndContainer) != null) {
            if (!this.fDetach) {
                if (node2 == node) {
                    return this.traverseSameContainer(n);
                }
                node2 = node.getParentNode();
                int n2 = 0;
                int n3 = 0;
                while (true) {
                    Node node3 = node;
                    node = node2;
                    if (node == null) {
                        node2 = this.fStartContainer;
                        while (true) {
                            if ((node2 = (node = node2).getParentNode()) == null) {
                                n3 = n2 - n3;
                                node2 = this.fStartContainer;
                                while (true) {
                                    if (n3 <= 0) {
                                        node = this.fEndContainer;
                                        while (true) {
                                            if (n3 >= 0) {
                                                Node node4 = node2.getParentNode();
                                                node3 = node.getParentNode();
                                                Node node5 = node;
                                                node = node3;
                                                node3 = node2;
                                                node2 = node4;
                                                while (true) {
                                                    if (node2 == node) {
                                                        return this.traverseCommonAncestors(node3, node5, n);
                                                    }
                                                    node5 = node2.getParentNode();
                                                    node4 = node.getParentNode();
                                                    node3 = node2;
                                                    node2 = node5;
                                                    node5 = node;
                                                    node = node4;
                                                }
                                            }
                                            node = node.getParentNode();
                                            ++n3;
                                        }
                                    }
                                    node2 = node2.getParentNode();
                                    --n3;
                                }
                            }
                            if (node2 == this.fEndContainer) {
                                return this.traverseCommonEndContainer(node, n);
                            }
                            ++n2;
                        }
                    }
                    if (node == this.fStartContainer) {
                        return this.traverseCommonStartContainer(node3, n);
                    }
                    ++n3;
                    node2 = node.getParentNode();
                }
            }
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return null;
    }

    private Node traverseFullySelected(Node node, int n) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return null;
                }
                node.getParentNode().removeChild(node);
                return null;
            }
            return node.cloneNode(true);
        }
        if (node.getNodeType() != 10) {
            return node;
        }
        throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
    }

    private Node traverseLeftBoundary(Node node, int n) {
        Node node2 = this.getSelectedNode(this.getStartContainer(), this.getStartOffset());
        boolean bl = node2 != this.getStartContainer();
        if (node2 == node) {
            return this.traverseNode(node2, bl, true, n);
        }
        Node node3 = node2.getParentNode();
        Node node4 = this.traverseNode(node3, false, true, n);
        block0: while (node3 != null) {
            while (true) {
                Node node5;
                if (node2 == null) {
                    if (node3 == node) {
                        return node4;
                    }
                    node2 = node3.getNextSibling();
                    node3 = node3.getParentNode();
                    node5 = this.traverseNode(node3, false, true, n);
                    if (n != 3) {
                        node5.appendChild(node4);
                    }
                    node4 = node5;
                    continue block0;
                }
                node5 = node2.getNextSibling();
                node2 = this.traverseNode(node2, bl, true, n);
                if (n != 3) {
                    node4.appendChild(node2);
                }
                node2 = node5;
                bl = true;
            }
            break;
        }
        return null;
    }

    private Node traverseNode(Node node, boolean bl, boolean bl2, int n) {
        if (bl) {
            return this.traverseFullySelected(node, n);
        }
        if (node.getNodeType() == 3) {
            return this.traverseTextNode(node, bl2, n);
        }
        return this.traversePartiallySelected(node, n);
    }

    private Node traversePartiallySelected(Node node, int n) {
        if (n != 1 && n != 2) {
            return null;
        }
        return node.cloneNode(false);
    }

    private Node traverseRightBoundary(Node node, int n) {
        Node node2 = this.getSelectedNode(this.fEndContainer, this.fEndOffset - 1);
        boolean bl = node2 != this.fEndContainer;
        if (node2 == node) {
            return this.traverseNode(node2, bl, false, n);
        }
        Node node3 = node2.getParentNode();
        Node node4 = this.traverseNode(node3, false, false, n);
        block0: while (node3 != null) {
            while (true) {
                Node node5;
                if (node2 == null) {
                    if (node3 == node) {
                        return node4;
                    }
                    node2 = node3.getPreviousSibling();
                    node3 = node3.getParentNode();
                    node5 = this.traverseNode(node3, false, false, n);
                    if (n != 3) {
                        node5.appendChild(node4);
                    }
                    node4 = node5;
                    continue block0;
                }
                node5 = node2.getPreviousSibling();
                node2 = this.traverseNode(node2, bl, false, n);
                if (n != 3) {
                    node4.insertBefore(node2, node4.getFirstChild());
                }
                node2 = node5;
                bl = true;
            }
            break;
        }
        return null;
    }

    private DocumentFragment traverseSameContainer(int n) {
        DocumentFragment documentFragment = n != 3 ? this.fDocument.createDocumentFragment() : null;
        if (this.fStartOffset == this.fEndOffset) {
            return documentFragment;
        }
        if (this.fStartContainer.getNodeType() == 3) {
            String string2 = this.fStartContainer.getNodeValue().substring(this.fStartOffset, this.fEndOffset);
            if (n != 2) {
                TextImpl textImpl = (TextImpl)this.fStartContainer;
                int n2 = this.fStartOffset;
                textImpl.deleteData(n2, this.fEndOffset - n2);
                this.collapse(true);
            }
            if (n == 3) {
                return null;
            }
            documentFragment.appendChild(this.fDocument.createTextNode(string2));
            return documentFragment;
        }
        Node node = this.getSelectedNode(this.fStartContainer, this.fStartOffset);
        int n3 = this.fEndOffset - this.fStartOffset;
        while (true) {
            if (n3 <= 0) {
                if (n != 2) {
                    this.collapse(true);
                }
                return documentFragment;
            }
            Node node2 = node.getNextSibling();
            node = this.traverseFullySelected(node, n);
            if (documentFragment != null) {
                documentFragment.appendChild(node);
            }
            --n3;
            node = node2;
        }
    }

    private Node traverseTextNode(Node node, boolean bl, int n) {
        String string2;
        String string3 = node.getNodeValue();
        if (bl) {
            int n2 = this.getStartOffset();
            string2 = string3.substring(n2);
            string3 = string3.substring(0, n2);
        } else {
            int n3 = this.getEndOffset();
            string2 = string3.substring(0, n3);
            string3 = string3.substring(n3);
        }
        if (n != 2) {
            node.setNodeValue(string3);
        }
        if (n == 3) {
            return null;
        }
        node = node.cloneNode(false);
        node.setNodeValue(string2);
        return node;
    }

    void checkIndex(Node node, int n) throws DOMException {
        block5: {
            block8: {
                block7: {
                    block6: {
                        if (n < 0) break block5;
                        short s = node.getNodeType();
                        if (s == 3 || s == 4 || s == 8 || s == 7) break block6;
                        if (n > node.getChildNodes().getLength()) {
                            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
                        }
                        break block7;
                    }
                    if (n > node.getNodeValue().length()) break block8;
                }
                return;
            }
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
    }

    @Override
    public DocumentFragment cloneContents() throws DOMException {
        return this.traverseContents(2);
    }

    @Override
    public Range cloneRange() {
        if (!this.fDetach) {
            Range range = this.fDocument.createRange();
            range.setStart(this.fStartContainer, this.fStartOffset);
            range.setEnd(this.fEndContainer, this.fEndOffset);
            return range;
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    @Override
    public void collapse(boolean bl) {
        if (!this.fDetach) {
            if (bl) {
                this.fEndContainer = this.fStartContainer;
                this.fEndOffset = this.fStartOffset;
            } else {
                this.fStartContainer = this.fEndContainer;
                this.fStartOffset = this.fEndOffset;
            }
            return;
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public short compareBoundaryPoints(short var1_1, Range var2_2) throws DOMException {
        if (!this.fDetach) {
            if (var1_1 == 0) {
                var3_3 = var2_2.getStartContainer();
                var4_4 = this.fStartContainer;
                var1_1 = (short)var2_2.getStartOffset();
                var2_2 = var4_4;
lbl7:
                // 2 sources

                while (true) {
                    var5_5 = this.fStartOffset;
                    break;
                }
            } else if (var1_1 == 1) {
                var3_3 = var2_2.getStartContainer();
                var4_4 = this.fEndContainer;
                var1_1 = (short)var2_2.getStartOffset();
                var2_2 = var4_4;
lbl15:
                // 2 sources

                while (true) {
                    var5_5 = this.fEndOffset;
                    break;
                }
            } else {
                if (var1_1 == 3) {
                    var3_3 = var2_2.getEndContainer();
                    var4_4 = this.fStartContainer;
                    var1_1 = (short)var2_2.getEndOffset();
                    var2_2 = var4_4;
                    ** continue;
                }
                var3_3 = var2_2.getEndContainer();
                var4_4 = this.fEndContainer;
                var1_1 = (short)var2_2.getEndOffset();
                var2_2 = var4_4;
                ** continue;
            }
            var6_6 = 0;
            if (var3_3 == var2_2) {
                if (var1_1 < var5_5) {
                    return 1;
                }
                if (var1_1 == var5_5) {
                    return 0;
                }
                return -1;
            }
            var4_4 = var2_2.getParentNode();
            var7_7 = var2_2;
            while (true) {
                if (var4_4 == null) {
                    var4_4 = var3_3.getParentNode();
                    var7_7 = var3_3;
                    while (true) {
                        if (var4_4 == null) {
                            var4_4 = var3_3;
                            var1_1 = var6_6;
                            while (true) {
                                if (var4_4 == null) {
                                    var4_4 = var2_2;
                                    while (true) {
                                        if (var4_4 == null) {
                                            while (true) {
                                                if (var1_1 <= 0) {
                                                    var4_4 = var2_2;
                                                    while (true) {
                                                        if (var1_1 >= 0) {
                                                            var2_2 = var3_3;
                                                            var3_3 = var4_4;
                                                            do {
                                                                var8_9 = var2_2;
                                                                var9_8 = var3_3;
                                                                var4_4 = var8_9.getParentNode();
                                                                var3_3 = var7_7 = var9_8.getParentNode();
                                                                var2_2 = var4_4;
                                                            } while (var4_4 != var7_7);
                                                            var2_2 = var8_9.getNextSibling();
                                                            while (true) {
                                                                if (var2_2 == null) {
                                                                    return -1;
                                                                }
                                                                if (var2_2 == var9_8) {
                                                                    return 1;
                                                                }
                                                                var2_2 = var2_2.getNextSibling();
                                                            }
                                                        }
                                                        var4_4 = var4_4.getParentNode();
                                                        var1_1 = (short)(var1_1 + 1);
                                                    }
                                                }
                                                var3_3 = var3_3.getParentNode();
                                                var1_1 = (short)(var1_1 - 1);
                                            }
                                        }
                                        var1_1 = (short)(var1_1 - 1);
                                        var4_4 = var4_4.getParentNode();
                                    }
                                }
                                var1_1 = (short)(var1_1 + 1);
                                var4_4 = var4_4.getParentNode();
                            }
                        }
                        if (var4_4 == var2_2) {
                            if (this.indexOf((Node)var7_7, (Node)var2_2) < var5_5) {
                                return 1;
                            }
                            return -1;
                        }
                        var9_8 = var4_4.getParentNode();
                        var7_7 = var4_4;
                        var4_4 = var9_8;
                    }
                }
                if (var4_4 == var3_3) {
                    if (var1_1 <= this.indexOf((Node)var7_7, (Node)var3_3)) {
                        return 1;
                    }
                    return -1;
                }
                var9_8 = var4_4.getParentNode();
                var7_7 = var4_4;
                var4_4 = var9_8;
            }
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    @Override
    public void deleteContents() throws DOMException {
        this.traverseContents(3);
    }

    void deleteData(CharacterData characterData, int n, int n2) {
        this.fDeleteNode = characterData;
        characterData.deleteData(n, n2);
        this.fDeleteNode = null;
    }

    @Override
    public void detach() {
        this.fDetach = true;
        this.fDocument.removeRange(this);
    }

    @Override
    public DocumentFragment extractContents() throws DOMException {
        return this.traverseContents(1);
    }

    @Override
    public boolean getCollapsed() {
        boolean bl = this.fStartContainer == this.fEndContainer && this.fStartOffset == this.fEndOffset;
        return bl;
    }

    @Override
    public Node getCommonAncestorContainer() {
        Vector<Node> vector = new Vector<Node>();
        Node node = this.fStartContainer;
        while (true) {
            if (node == null) {
                Vector<Node> vector2 = new Vector<Node>();
                node = this.fEndContainer;
                while (true) {
                    if (node == null) {
                        int n = vector.size() - 1;
                        node = null;
                        for (int i = vector2.size() - 1; n >= 0 && i >= 0 && vector.elementAt(n) == vector2.elementAt(i); --n, --i) {
                            node = vector.elementAt(n);
                        }
                        return node;
                    }
                    vector2.addElement(node);
                    node = node.getParentNode();
                }
            }
            vector.addElement(node);
            node = node.getParentNode();
        }
    }

    @Override
    public Node getEndContainer() {
        return this.fEndContainer;
    }

    @Override
    public int getEndOffset() {
        return this.fEndOffset;
    }

    @Override
    public Node getStartContainer() {
        return this.fStartContainer;
    }

    @Override
    public int getStartOffset() {
        return this.fStartOffset;
    }

    int indexOf(Node node, Node node2) {
        if (node.getParentNode() != node2) {
            return -1;
        }
        int n = 0;
        node2 = node2.getFirstChild();
        while (node2 != node) {
            ++n;
            node2 = node2.getNextSibling();
        }
        return n;
    }

    void insertData(CharacterData characterData, int n, String string2) {
        this.fInsertNode = characterData;
        characterData.insertData(n, string2);
        this.fInsertNode = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void insertNode(Node node) throws DOMException, RangeException {
        int n;
        int n2;
        block13: {
            Node node2;
            block16: {
                block15: {
                    Node node3;
                    block14: {
                        if (node == null) {
                            return;
                        }
                        if (this.fDetach) throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
                        if (this.fDocument != node.getOwnerDocument()) throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
                        n2 = node.getNodeType();
                        if (n2 == 2) throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
                        if (n2 == 6) throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
                        if (n2 == 12) throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
                        if (n2 == 9) throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
                        n2 = this.fStartContainer.getNodeType();
                        n = 0;
                        if (n2 != 3) break block13;
                        node3 = this.fStartContainer.getParentNode();
                        n2 = node3.getChildNodes().getLength();
                        node2 = this.fStartContainer.cloneNode(false);
                        ((TextImpl)node2).setNodeValueInternal(node2.getNodeValue().substring(this.fStartOffset));
                        Node node4 = this.fStartContainer;
                        ((TextImpl)node4).setNodeValueInternal(node4.getNodeValue().substring(0, this.fStartOffset));
                        node4 = this.fStartContainer.getNextSibling();
                        if (node4 != null) {
                            if (node3 != null) {
                                node3.insertBefore(node, node4);
                                node3.insertBefore(node2, node4);
                            }
                        } else if (node3 != null) {
                            node3.appendChild(node);
                            node3.appendChild(node2);
                        }
                        if ((node = this.fEndContainer) != this.fStartContainer) break block14;
                        this.fEndContainer = node2;
                        n2 = this.fEndOffset - this.fStartOffset;
                        break block15;
                    }
                    if (node != node3) break block16;
                    n2 = this.fEndOffset + (node3.getChildNodes().getLength() - n2);
                }
                this.fEndOffset = n2;
            }
            this.signalSplitData(this.fStartContainer, node2, this.fStartOffset);
            return;
        }
        Node node5 = this.fEndContainer;
        n2 = node5 == this.fStartContainer ? node5.getChildNodes().getLength() : 0;
        for (node5 = this.fStartContainer.getFirstChild(); n < this.fStartOffset && node5 != null; node5 = node5.getNextSibling(), ++n) {
        }
        if (node5 != null) {
            this.fStartContainer.insertBefore(node, node5);
        } else {
            this.fStartContainer.appendChild(node);
        }
        node = this.fEndContainer;
        if (node != this.fStartContainer) return;
        this.fEndOffset += node.getChildNodes().getLength() - n2;
    }

    public void insertedNodeFromDOM(Node node) {
        int n;
        int n2;
        Node node2;
        if (node == null) {
            return;
        }
        if (this.fInsertNode == node) {
            return;
        }
        Node node3 = node.getParentNode();
        if (node3 == (node2 = this.fStartContainer) && (n2 = this.indexOf(node, node2)) < (n = this.fStartOffset)) {
            this.fStartOffset = n + 1;
        }
        if (node3 == (node2 = this.fEndContainer) && (n2 = this.indexOf(node, node2)) < (n = this.fEndOffset)) {
            this.fEndOffset = n + 1;
        }
    }

    boolean isAncestorOf(Node node, Node node2) {
        while (node2 != null) {
            if (node2 == node) {
                return true;
            }
            node2 = node2.getParentNode();
        }
        return false;
    }

    Node nextNode(Node node, boolean bl) {
        Node node2;
        if (node == null) {
            return null;
        }
        if (bl && (node2 = node.getFirstChild()) != null) {
            return node2;
        }
        node2 = node.getNextSibling();
        if (node2 != null) {
            return node2;
        }
        while ((node = node.getParentNode()) != null && node != this.fDocument) {
            node2 = node.getNextSibling();
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void receiveDeletedText(Node node, int n, int n2) {
        int n3;
        if (node == null) {
            return;
        }
        if (this.fDeleteNode == node) {
            return;
        }
        Node node2 = this.fStartContainer;
        if (node == node2 && node2.getNodeType() == 3) {
            n3 = this.fStartOffset;
            int n4 = n + n2;
            if (n3 > n4) {
                this.fStartOffset = n3 - n4 + n;
            } else if (n3 > n) {
                this.fStartOffset = n;
            }
        }
        if (node != (node2 = this.fEndContainer)) return;
        if (node2.getNodeType() != 3) return;
        n3 = this.fEndOffset;
        if (n3 > (n2 += n)) {
            n += n3 - n2;
        } else if (n3 <= n) return;
        this.fEndOffset = n;
    }

    void receiveInsertedText(Node node, int n, int n2) {
        int n3;
        if (node == null) {
            return;
        }
        if (this.fInsertNode == node) {
            return;
        }
        Node node2 = this.fStartContainer;
        if (node == node2 && node2.getNodeType() == 3 && n < (n3 = this.fStartOffset)) {
            this.fStartOffset = n3 + n2;
        }
        if (node == (node2 = this.fEndContainer) && node2.getNodeType() == 3 && n < (n3 = this.fEndOffset)) {
            this.fEndOffset = n3 + n2;
        }
    }

    void receiveReplacedText(Node node) {
        if (node == null) {
            return;
        }
        Node node2 = this.fStartContainer;
        if (node == node2 && node2.getNodeType() == 3) {
            this.fStartOffset = 0;
        }
        if (node == (node2 = this.fEndContainer) && node2.getNodeType() == 3) {
            this.fEndOffset = 0;
        }
    }

    void receiveSplitData(Node node, Node node2, int n) {
        if (node != null && node2 != null) {
            int n2;
            if (this.fSplitNode == node) {
                return;
            }
            Node node3 = this.fStartContainer;
            if (node == node3 && node3.getNodeType() == 3 && (n2 = this.fStartOffset) > n) {
                this.fStartOffset = n2 - n;
                this.fStartContainer = node2;
            }
            if (node == (node3 = this.fEndContainer) && node3.getNodeType() == 3 && (n2 = this.fEndOffset) > n) {
                this.fEndOffset = n2 - n;
                this.fEndContainer = node2;
            }
        }
    }

    Node removeChild(Node node, Node node2) {
        this.fRemoveChild = node2;
        node = node.removeChild(node2);
        this.fRemoveChild = null;
        return node;
    }

    void removeNode(Node node) {
        int n;
        int n2;
        Node node2;
        if (node == null) {
            return;
        }
        if (this.fRemoveChild == node) {
            return;
        }
        Node node3 = node.getParentNode();
        if (node3 == (node2 = this.fStartContainer) && (n2 = this.indexOf(node, node2)) < (n = this.fStartOffset)) {
            this.fStartOffset = n - 1;
        }
        if (node3 == (node2 = this.fEndContainer) && (n = this.indexOf(node, node2)) < (n2 = this.fEndOffset)) {
            this.fEndOffset = n2 - 1;
        }
        if (node3 != (node2 = this.fStartContainer) || node3 != this.fEndContainer) {
            if (this.isAncestorOf(node, node2)) {
                this.fStartContainer = node3;
                this.fStartOffset = this.indexOf(node, node3);
            }
            if (this.isAncestorOf(node, this.fEndContainer)) {
                this.fEndContainer = node3;
                this.fEndOffset = this.indexOf(node, node3);
            }
        }
    }

    @Override
    public void selectNode(Node node) throws RangeException {
        if (!this.fDetach) {
            if (this.isLegalContainer(node.getParentNode()) && this.isLegalContainedNode(node)) {
                Node node2 = node.getParentNode();
                if (node2 != null) {
                    this.fStartContainer = node2;
                    this.fEndContainer = node2;
                    int n = 0;
                    while (true) {
                        if (node == null) {
                            this.fStartOffset = --n;
                            this.fEndOffset = n + 1;
                            break;
                        }
                        ++n;
                        node = node.getPreviousSibling();
                    }
                }
                return;
            }
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void selectNodeContents(Node var1_1) throws RangeException {
        if (!this.fDetach) {
            if (this.isLegalContainer(var1_1)) {
                block6: {
                    this.fStartContainer = var1_1;
                    this.fEndContainer = var1_1;
                    var2_2 = var1_1.getFirstChild();
                    var3_3 = 0;
                    var4_4 = 0;
                    this.fStartOffset = 0;
                    var1_1 = var2_2;
                    if (var2_2 == null) {
                        var3_3 = var4_4;
lbl12:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
                    }
lbl14:
                    // 3 sources

                    while (true) {
                        if (var1_1 == null) {
                            ** continue;
                        }
                        break block6;
                        break;
                    }
                    this.fEndOffset = var3_3;
                    return;
                }
                ++var3_3;
                var1_1 = var1_1.getNextSibling();
                ** continue;
            }
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    @Override
    public void setEnd(Node node, int n) throws RangeException, DOMException {
        if (!this.fDetach) {
            if (this.isLegalContainer(node)) {
                this.checkIndex(node, n);
                this.fEndContainer = node;
                this.fEndOffset = n;
                return;
            }
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    @Override
    public void setEndAfter(Node node) throws RangeException {
        if (!this.fDetach) {
            if (this.hasLegalRootContainer(node) && this.isLegalContainedNode(node)) {
                this.fEndContainer = node.getParentNode();
                int n = 0;
                while (true) {
                    if (node == null) {
                        this.fEndOffset = n;
                        return;
                    }
                    ++n;
                    node = node.getPreviousSibling();
                }
            }
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    @Override
    public void setEndBefore(Node node) throws RangeException {
        if (!this.fDetach) {
            if (this.hasLegalRootContainer(node) && this.isLegalContainedNode(node)) {
                this.fEndContainer = node.getParentNode();
                int n = 0;
                while (true) {
                    if (node == null) {
                        this.fEndOffset = n - 1;
                        return;
                    }
                    ++n;
                    node = node.getPreviousSibling();
                }
            }
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    @Override
    public void setStart(Node node, int n) throws RangeException, DOMException {
        if (!this.fDetach) {
            if (this.isLegalContainer(node)) {
                this.checkIndex(node, n);
                this.fStartContainer = node;
                this.fStartOffset = n;
                return;
            }
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    @Override
    public void setStartAfter(Node node) throws RangeException {
        if (!this.fDetach) {
            if (this.hasLegalRootContainer(node) && this.isLegalContainedNode(node)) {
                this.fStartContainer = node.getParentNode();
                int n = 0;
                while (true) {
                    if (node == null) {
                        this.fStartOffset = n;
                        return;
                    }
                    ++n;
                    node = node.getPreviousSibling();
                }
            }
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    @Override
    public void setStartBefore(Node node) throws RangeException {
        if (!this.fDetach) {
            if (this.hasLegalRootContainer(node) && this.isLegalContainedNode(node)) {
                this.fStartContainer = node.getParentNode();
                int n = 0;
                while (true) {
                    if (node == null) {
                        this.fStartOffset = n - 1;
                        return;
                    }
                    ++n;
                    node = node.getPreviousSibling();
                }
            }
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    void signalSplitData(Node node, Node node2, int n) {
        this.fSplitNode = node;
        this.fDocument.splitData(node, node2, n);
        this.fSplitNode = null;
    }

    @Override
    public void surroundContents(Node node) throws DOMException, RangeException {
        if (node == null) {
            return;
        }
        if (!this.fDetach) {
            short s = node.getNodeType();
            if (s != 2 && s != 6 && s != 12 && s != 10 && s != 9 && s != 11) {
                this.getCommonAncestorContainer();
                Node node2 = this.fStartContainer;
                Node node3 = this.fEndContainer;
                Node node4 = node2;
                if (node2.getNodeType() == 3) {
                    node4 = this.fStartContainer.getParentNode();
                }
                if (this.fEndContainer.getNodeType() == 3) {
                    node3 = this.fEndContainer.getParentNode();
                }
                if (node4 == node3) {
                    node4 = this.extractContents();
                    this.insertNode(node);
                    node.appendChild(node4);
                    this.selectNode(node);
                    return;
                }
                throw new RangeExceptionImpl(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "BAD_BOUNDARYPOINTS_ERR", null));
            }
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }

    @Override
    public String toString() {
        if (!this.fDetach) {
            int n;
            Node node;
            Node node2 = this.fStartContainer;
            Node node3 = this.fEndContainer;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fStartContainer.getNodeType() != 3 && this.fStartContainer.getNodeType() != 4) {
                node2 = node = node2.getFirstChild();
                if (this.fStartOffset > 0) {
                    n = 0;
                    while (true) {
                        node2 = node;
                        if (n >= this.fStartOffset) break;
                        if (node == null) {
                            node2 = node;
                            break;
                        }
                        node = node.getNextSibling();
                        ++n;
                    }
                }
                node = node2;
                if (node2 == null) {
                    node = this.nextNode(this.fStartContainer, false);
                }
            } else {
                node = this.fStartContainer;
                if (node == this.fEndContainer) {
                    stringBuffer.append(node.getNodeValue().substring(this.fStartOffset, this.fEndOffset));
                    return stringBuffer.toString();
                }
                stringBuffer.append(node.getNodeValue().substring(this.fStartOffset));
                node = this.nextNode(node2, true);
            }
            Node node4 = node;
            node2 = node3;
            if (this.fEndContainer.getNodeType() != 3) {
                node4 = node;
                node2 = node3;
                if (this.fEndContainer.getNodeType() != 4) {
                    n = this.fEndOffset;
                    for (node2 = this.fEndContainer.getFirstChild(); n > 0 && node2 != null; --n, node2 = node2.getNextSibling()) {
                    }
                    if (node2 == null) {
                        node2 = this.nextNode(this.fEndContainer, false);
                        node4 = node;
                    } else {
                        node4 = node;
                    }
                }
            }
            while (true) {
                if (node4 == node2 || node4 == null) {
                    if (this.fEndContainer.getNodeType() == 3 || this.fEndContainer.getNodeType() == 4) {
                        stringBuffer.append(this.fEndContainer.getNodeValue().substring(0, this.fEndOffset));
                    }
                    return stringBuffer.toString();
                }
                if (node4.getNodeType() == 3 || node4.getNodeType() == 4) {
                    stringBuffer.append(node4.getNodeValue());
                }
                node4 = this.nextNode(node4, true);
            }
        }
        throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
    }
}

