/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CharacterDataImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements CharacterData,
Text {
    static final long serialVersionUID = -5294980852957403469L;

    public TextImpl() {
    }

    public TextImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl, string2);
    }

    private boolean canModify(Node node) {
        while (node != null) {
            short s = node.getNodeType();
            if (s == 5 ? !this.canModify(node.getFirstChild()) : s != 3 && s != 4) {
                return false;
            }
            node = node.getNextSibling();
        }
        return true;
    }

    private boolean getWholeText(Node node, StringBuffer stringBuffer) {
        while (node != null) {
            short s = node.getNodeType();
            if (s == 5) {
                if (this.getWholeText(node.getFirstChild(), stringBuffer)) {
                    return true;
                }
            } else {
                if (s != 3 && s != 4) {
                    return true;
                }
                ((NodeImpl)node).getTextContent(stringBuffer);
            }
            node = node.getNextSibling();
        }
        return false;
    }

    @Override
    public String getNodeName() {
        return "#text";
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public String getWholeText() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.nextSibling == null) {
            return this.data;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.data != null && this.data.length() != 0) {
            stringBuffer.append(this.data);
        }
        this.getWholeText(this.nextSibling, stringBuffer);
        return stringBuffer.toString();
    }

    public boolean isIgnorableWhitespace() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    public boolean isWhitespaceInElementContent() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    public String removeData() {
        String string2 = this.data;
        this.data = "";
        return string2;
    }

    public void replaceData(String string2) {
        this.data = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Text replaceWholeText(String object) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (!this.canModify(this.nextSibling)) throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        Node node = this.getParentNode();
        if ((object == null || ((String)object).length() == 0) && node != null) {
            node.removeChild(this);
            return null;
        }
        if (this.isReadOnly()) {
            object = this.ownerDocument().createTextNode((String)object);
            if (node == null) return object;
            node.insertBefore((Node)object, this);
            node.removeChild(this);
        } else {
            this.setData((String)object);
            object = this;
        }
        Node node2;
        while ((node2 = object.getNextSibling()) != null) {
            node.removeChild(node2);
        }
        return object;
    }

    public void setIgnorableWhitespace(boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isIgnorableWhitespace(bl);
    }

    public void setValues(CoreDocumentImpl coreDocumentImpl, String string2) {
        this.flags = (short)0;
        this.nextSibling = null;
        this.previousSibling = null;
        this.setOwnerDocument(coreDocumentImpl);
        this.data = string2;
    }

    @Override
    public Text splitText(int n) throws DOMException {
        if (!this.isReadOnly()) {
            if (this.needsSyncData()) {
                this.synchronizeData();
            }
            if (n >= 0 && n <= this.data.length()) {
                Text text = this.getOwnerDocument().createTextNode(this.data.substring(n));
                this.setNodeValue(this.data.substring(0, n));
                Node node = this.getParentNode();
                if (node != null) {
                    node.insertBefore(text, this.nextSibling);
                }
                return text;
            }
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
    }
}

