/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class TreeWalkerImpl
implements TreeWalker {
    Node fCurrentNode;
    private boolean fEntityReferenceExpansion = false;
    NodeFilter fNodeFilter;
    Node fRoot;
    int fWhatToShow = -1;

    public TreeWalkerImpl(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        this.fCurrentNode = node;
        this.fRoot = node;
        this.fWhatToShow = n;
        this.fNodeFilter = nodeFilter;
        this.fEntityReferenceExpansion = bl;
    }

    short acceptNode(Node node) {
        if (this.fNodeFilter == null) {
            int n = this.fWhatToShow;
            if ((1 << node.getNodeType() - 1 & n) != 0) {
                return 1;
            }
            return 3;
        }
        if ((this.fWhatToShow & 1 << node.getNodeType() - 1) != 0) {
            return this.fNodeFilter.acceptNode(node);
        }
        return 3;
    }

    @Override
    public Node firstChild() {
        Node node = this.fCurrentNode;
        if (node == null) {
            return null;
        }
        if ((node = this.getFirstChild(node)) != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    @Override
    public Node getCurrentNode() {
        return this.fCurrentNode;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return this.fEntityReferenceExpansion;
    }

    @Override
    public NodeFilter getFilter() {
        return this.fNodeFilter;
    }

    Node getFirstChild(Node node) {
        if (node == null) {
            return null;
        }
        if (!this.fEntityReferenceExpansion && node.getNodeType() == 5) {
            return null;
        }
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3 && node2.hasChildNodes()) {
            Node node3 = this.getFirstChild(node2);
            if (node3 == null) {
                return this.getNextSibling(node2, node);
            }
            return node3;
        }
        return this.getNextSibling(node2, node);
    }

    Node getLastChild(Node node) {
        if (node == null) {
            return null;
        }
        if (!this.fEntityReferenceExpansion && node.getNodeType() == 5) {
            return null;
        }
        Node node2 = node.getLastChild();
        if (node2 == null) {
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3 && node2.hasChildNodes()) {
            Node node3 = this.getLastChild(node2);
            if (node3 == null) {
                return this.getPreviousSibling(node2, node);
            }
            return node3;
        }
        return this.getPreviousSibling(node2, node);
    }

    Node getNextSibling(Node node) {
        return this.getNextSibling(node, this.fRoot);
    }

    Node getNextSibling(Node node, Node node2) {
        if (node != null && node != node2) {
            Node node3 = node.getNextSibling();
            if (node3 == null) {
                if ((node = node.getParentNode()) != null && node != node2 && this.acceptNode(node) == 3) {
                    return this.getNextSibling(node, node2);
                }
                return null;
            }
            short s = this.acceptNode(node3);
            if (s == 1) {
                return node3;
            }
            if (s == 3) {
                Node node4;
                node = node4 = this.getFirstChild(node3);
                if (node4 == null) {
                    node = this.getNextSibling(node3, node2);
                }
                return node;
            }
            return this.getNextSibling(node3, node2);
        }
        return null;
    }

    Node getParentNode(Node node) {
        if (node != null && node != this.fRoot) {
            if ((node = node.getParentNode()) == null) {
                return null;
            }
            if (this.acceptNode(node) == 1) {
                return node;
            }
            return this.getParentNode(node);
        }
        return null;
    }

    Node getPreviousSibling(Node node) {
        return this.getPreviousSibling(node, this.fRoot);
    }

    Node getPreviousSibling(Node node, Node node2) {
        if (node != null && node != node2) {
            Node node3 = node.getPreviousSibling();
            if (node3 == null) {
                if ((node = node.getParentNode()) != null && node != node2 && this.acceptNode(node) == 3) {
                    return this.getPreviousSibling(node, node2);
                }
                return null;
            }
            short s = this.acceptNode(node3);
            if (s == 1) {
                return node3;
            }
            if (s == 3) {
                Node node4;
                node = node4 = this.getLastChild(node3);
                if (node4 == null) {
                    node = this.getPreviousSibling(node3, node2);
                }
                return node;
            }
            return this.getPreviousSibling(node3, node2);
        }
        return null;
    }

    @Override
    public Node getRoot() {
        return this.fRoot;
    }

    @Override
    public int getWhatToShow() {
        return this.fWhatToShow;
    }

    @Override
    public Node lastChild() {
        Node node = this.fCurrentNode;
        if (node == null) {
            return null;
        }
        if ((node = this.getLastChild(node)) != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    @Override
    public Node nextNode() {
        Node node;
        Node node2 = this.fCurrentNode;
        if (node2 == null) {
            return null;
        }
        if ((node2 = this.getFirstChild(node2)) != null) {
            this.fCurrentNode = node2;
            return node2;
        }
        node2 = this.getNextSibling(this.fCurrentNode);
        if (node2 != null) {
            this.fCurrentNode = node2;
            return node2;
        }
        node2 = this.fCurrentNode;
        do {
            if ((node2 = this.getParentNode(node2)) != null) continue;
            return null;
        } while ((node = this.getNextSibling(node2)) == null);
        this.fCurrentNode = node;
        return node;
    }

    @Override
    public Node nextSibling() {
        Node node = this.fCurrentNode;
        if (node == null) {
            return null;
        }
        if ((node = this.getNextSibling(node)) != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    @Override
    public Node parentNode() {
        Node node = this.fCurrentNode;
        if (node == null) {
            return null;
        }
        if ((node = this.getParentNode(node)) != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    @Override
    public Node previousNode() {
        Node node = this.fCurrentNode;
        if (node == null) {
            return null;
        }
        Node node2 = this.getPreviousSibling(node);
        if (node2 == null) {
            node = this.getParentNode(this.fCurrentNode);
            if (node != null) {
                this.fCurrentNode = node;
                return node;
            }
            return null;
        }
        Node node3 = node = this.getLastChild(node2);
        while (true) {
            if (node == null) {
                if (node3 != null) {
                    this.fCurrentNode = node3;
                    return node3;
                }
                if (node2 != null) {
                    this.fCurrentNode = node2;
                    return node2;
                }
                return null;
            }
            Node node4 = this.getLastChild(node);
            node3 = node;
            node = node4;
        }
    }

    @Override
    public Node previousSibling() {
        Node node = this.fCurrentNode;
        if (node == null) {
            return null;
        }
        if ((node = this.getPreviousSibling(node)) != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    @Override
    public void setCurrentNode(Node node) {
        this.fCurrentNode = node;
    }

    public void setWhatShow(int n) {
        this.fWhatToShow = n;
    }
}

