/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.EOFException;
import java.io.IOException;
import org.apache.xerces.impl.XMLDocumentFragmentScannerImpl;
import org.apache.xerces.impl.XMLScanner;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDScanner;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLDocumentScannerImpl
extends XMLDocumentFragmentScannerImpl {
    protected static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String DTD_SCANNER = "http://apache.org/xml/properties/internal/dtd-scanner";
    private static final Boolean[] FEATURE_DEFAULTS;
    protected static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final Object[] PROPERTY_DEFAULTS;
    private static final String[] RECOGNIZED_FEATURES;
    private static final String[] RECOGNIZED_PROPERTIES;
    protected static final int SCANNER_STATE_DTD_EXTERNAL = 18;
    protected static final int SCANNER_STATE_DTD_EXTERNAL_DECLS = 19;
    protected static final int SCANNER_STATE_DTD_INTERNAL_DECLS = 17;
    protected static final int SCANNER_STATE_PROLOG = 5;
    protected static final int SCANNER_STATE_TRAILING_MISC = 12;
    protected static final int SCANNER_STATE_XML_DECL = 0;
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected XMLDocumentFragmentScannerImpl.Dispatcher fDTDDispatcher;
    protected XMLDTDScanner fDTDScanner;
    protected boolean fDisallowDoctype = false;
    protected String fDoctypeName;
    protected String fDoctypePublicId;
    protected String fDoctypeSystemId;
    protected boolean fLoadExternalDTD = true;
    protected NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected XMLDocumentFragmentScannerImpl.Dispatcher fPrologDispatcher;
    protected boolean fScanningDTD;
    protected boolean fSeenDoctypeDecl;
    private XMLString fString;
    private XMLStringBuffer fStringBuffer;
    private String[] fStrings;
    protected XMLDocumentFragmentScannerImpl.Dispatcher fTrailingMiscDispatcher;
    protected ValidationManager fValidationManager;
    protected XMLDocumentFragmentScannerImpl.Dispatcher fXMLDeclDispatcher = new XMLDeclDispatcher();

    static {
        RECOGNIZED_FEATURES = new String[]{LOAD_EXTERNAL_DTD, DISALLOW_DOCTYPE_DECL_FEATURE};
        FEATURE_DEFAULTS = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        RECOGNIZED_PROPERTIES = new String[]{DTD_SCANNER, VALIDATION_MANAGER};
        PROPERTY_DEFAULTS = new Object[]{null, null};
    }

    public XMLDocumentScannerImpl() {
        this.fPrologDispatcher = new PrologDispatcher();
        this.fDTDDispatcher = new DTDDispatcher();
        this.fTrailingMiscDispatcher = new TrailingMiscDispatcher();
        this.fStrings = new String[3];
        this.fString = new XMLString();
        this.fStringBuffer = new XMLStringBuffer();
    }

    @Override
    protected XMLDocumentFragmentScannerImpl.Dispatcher createContentDispatcher() {
        return new ContentDispatcher();
    }

    @Override
    public void endEntity(String string2) throws XNIException {
        super.endEntity(string2);
        if (this.fDocumentHandler != null && string2.equals("[xml]")) {
            this.fDocumentHandler.endDocument(null);
        }
    }

    @Override
    public Boolean getFeatureDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_FEATURES).length) {
            if (stringArray[n].equals(string2)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return super.getFeatureDefault(string2);
    }

    @Override
    public Object getPropertyDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_PROPERTIES).length) {
            if (stringArray[n].equals(string2)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return super.getPropertyDefault(string2);
    }

    @Override
    public String[] getRecognizedFeatures() {
        String[] stringArray = super.getRecognizedFeatures();
        int n = stringArray != null ? stringArray.length : 0;
        String[] stringArray2 = RECOGNIZED_FEATURES;
        String[] stringArray3 = new String[stringArray2.length + n];
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        }
        System.arraycopy(stringArray2, 0, stringArray3, n, stringArray2.length);
        return stringArray3;
    }

    @Override
    public String[] getRecognizedProperties() {
        String[] stringArray = super.getRecognizedProperties();
        int n = stringArray != null ? stringArray.length : 0;
        String[] stringArray2 = RECOGNIZED_PROPERTIES;
        String[] stringArray3 = new String[stringArray2.length + n];
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        }
        System.arraycopy(stringArray2, 0, stringArray3, n, stringArray2.length);
        return stringArray3;
    }

    @Override
    protected String getScannerStateName(int n) {
        if (n != 0) {
            if (n != 5) {
                if (n != 12) {
                    switch (n) {
                        default: {
                            return super.getScannerStateName(n);
                        }
                        case 19: {
                            return "SCANNER_STATE_DTD_EXTERNAL_DECLS";
                        }
                        case 18: {
                            return "SCANNER_STATE_DTD_EXTERNAL";
                        }
                        case 17: 
                    }
                    return "SCANNER_STATE_DTD_INTERNAL_DECLS";
                }
                return "SCANNER_STATE_TRAILING_MISC";
            }
            return "SCANNER_STATE_PROLOG";
        }
        return "SCANNER_STATE_XML_DECL";
    }

    @Override
    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        super.reset(xMLComponentManager);
        this.fDoctypeName = null;
        this.fDoctypePublicId = null;
        this.fDoctypeSystemId = null;
        this.fSeenDoctypeDecl = false;
        this.fNamespaceContext.reset();
        try {
            this.fLoadExternalDTD = xMLComponentManager.getFeature(LOAD_EXTERNAL_DTD);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fLoadExternalDTD = true;
        }
        try {
            this.fDisallowDoctype = xMLComponentManager.getFeature(DISALLOW_DOCTYPE_DECL_FEATURE);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fDisallowDoctype = false;
        }
        this.fDTDScanner = (XMLDTDScanner)xMLComponentManager.getProperty(DTD_SCANNER);
        try {
            this.fValidationManager = (ValidationManager)xMLComponentManager.getProperty(VALIDATION_MANAGER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidationManager = null;
        }
        this.fScanningDTD = false;
        this.setScannerState(0);
        this.setDispatcher(this.fXMLDeclDispatcher);
    }

    protected boolean scanDoctypeDecl() throws IOException, XNIException {
        if (!this.fEntityScanner.skipSpaces()) {
            this.reportFatalError("MSG_SPACE_REQUIRED_BEFORE_ROOT_ELEMENT_TYPE_IN_DOCTYPEDECL", null);
        }
        String[] stringArray = this.fEntityScanner.scanName();
        this.fDoctypeName = stringArray;
        if (stringArray == null) {
            this.reportFatalError("MSG_ROOT_ELEMENT_TYPE_REQUIRED", null);
        }
        boolean bl = this.fEntityScanner.skipSpaces();
        boolean bl2 = true;
        if (bl) {
            this.scanExternalID(this.fStrings, false);
            stringArray = this.fStrings;
            this.fDoctypeSystemId = stringArray[0];
            this.fDoctypePublicId = stringArray[1];
            this.fEntityScanner.skipSpaces();
        }
        bl = this.fDoctypeSystemId != null;
        this.fHasExternalDTD = bl;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(this.fDoctypeName, this.fDoctypePublicId, this.fDoctypeSystemId, null);
        }
        bl = bl2;
        if (!this.fEntityScanner.skipChar(91)) {
            this.fEntityScanner.skipSpaces();
            if (!this.fEntityScanner.skipChar(62)) {
                this.reportFatalError("DoctypedeclUnterminated", new Object[]{this.fDoctypeName});
            }
            --this.fMarkupDepth;
            bl = false;
        }
        return bl;
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
        super.setFeature(string2, bl);
        if (string2.startsWith("http://apache.org/xml/features/")) {
            if ((string2 = string2.substring(31)).equals("nonvalidating/load-external-dtd")) {
                this.fLoadExternalDTD = bl;
                return;
            }
            if (string2.equals("disallow-doctype-decl")) {
                this.fDisallowDoctype = bl;
            }
        }
    }

    @Override
    public void setInputSource(XMLInputSource xMLInputSource) throws IOException {
        this.fEntityManager.setEntityHandler(this);
        this.fEntityManager.startDocumentEntity(xMLInputSource);
    }

    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        super.setProperty(string2, object);
        if (string2.startsWith("http://apache.org/xml/properties/") && string2.substring(33).equals("internal/dtd-scanner")) {
            this.fDTDScanner = (XMLDTDScanner)object;
        }
    }

    @Override
    public void startEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3) throws XNIException {
        super.startEntity(string2, xMLResourceIdentifier, string3);
        if (!string2.equals("[xml]") && this.fEntityScanner.isExternal()) {
            this.setScannerState(16);
        }
        if (this.fDocumentHandler != null && string2.equals("[xml]")) {
            this.fDocumentHandler.startDocument(this.fEntityScanner, string3, this.fNamespaceContext, null);
        }
    }

    protected class ContentDispatcher
    extends XMLDocumentFragmentScannerImpl.FragmentContentDispatcher {
        protected ContentDispatcher() {
        }

        @Override
        protected boolean elementDepthIsZeroHook() throws IOException, XNIException {
            XMLDocumentScannerImpl.this.setScannerState(12);
            XMLDocumentScannerImpl xMLDocumentScannerImpl = XMLDocumentScannerImpl.this;
            xMLDocumentScannerImpl.setDispatcher(xMLDocumentScannerImpl.fTrailingMiscDispatcher);
            return true;
        }

        @Override
        protected void endOfFileHook(EOFException eOFException) throws IOException, XNIException {
            XMLDocumentScannerImpl.this.reportFatalError("PrematureEOF", null);
        }

        @Override
        protected boolean scanForDoctypeHook() throws IOException, XNIException {
            if (XMLDocumentScannerImpl.this.fEntityScanner.skipString("DOCTYPE")) {
                XMLDocumentScannerImpl.this.setScannerState(4);
                return true;
            }
            return false;
        }

        @Override
        protected boolean scanRootElementHook() throws IOException, XNIException {
            if (XMLDocumentScannerImpl.this.scanStartElement()) {
                XMLDocumentScannerImpl.this.setScannerState(12);
                XMLDocumentScannerImpl xMLDocumentScannerImpl = XMLDocumentScannerImpl.this;
                xMLDocumentScannerImpl.setDispatcher(xMLDocumentScannerImpl.fTrailingMiscDispatcher);
                return true;
            }
            return false;
        }
    }

    protected final class DTDDispatcher
    implements XMLDocumentFragmentScannerImpl.Dispatcher {
        protected DTDDispatcher() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean dispatch(boolean bl) throws IOException, XNIException {
            XMLDocumentScannerImpl.this.fEntityManager.setEntityHandler(null);
            try {
                Object object;
                Object object2;
                block15: {
                    boolean bl2;
                    object2 = new XMLResourceIdentifierImpl();
                    block11: do {
                        switch (XMLDocumentScannerImpl.this.fScannerState) {
                            default: {
                                break block15;
                            }
                            case 19: {
                                if (XMLDocumentScannerImpl.this.fDTDScanner.scanDTDExternalSubset(true)) break;
                                XMLDocumentScannerImpl.this.setScannerState(5);
                                object2 = XMLDocumentScannerImpl.this;
                                ((XMLDocumentFragmentScannerImpl)object2).setDispatcher(((XMLDocumentScannerImpl)object2).fPrologDispatcher);
                                XMLDocumentScannerImpl.this.fEntityManager.setEntityHandler(XMLDocumentScannerImpl.this);
                                XMLDocumentScannerImpl.this.fEntityManager.setEntityHandler(XMLDocumentScannerImpl.this);
                                return true;
                            }
                            case 18: {
                                ((XMLResourceIdentifierImpl)object2).setValues(XMLDocumentScannerImpl.this.fDoctypePublicId, XMLDocumentScannerImpl.this.fDoctypeSystemId, null, null);
                                object = XMLDocumentScannerImpl.this.fEntityManager.resolveEntity((XMLResourceIdentifier)object2);
                                XMLDocumentScannerImpl.this.fDTDScanner.setInputSource((XMLInputSource)object);
                                XMLDocumentScannerImpl.this.setScannerState(19);
                                bl2 = true;
                                continue block11;
                            }
                            case 17: {
                                object = XMLDocumentScannerImpl.this.fDTDScanner;
                                boolean bl3 = XMLDocumentScannerImpl.this.fStandalone;
                                boolean bl4 = XMLDocumentScannerImpl.this.fHasExternalDTD && XMLDocumentScannerImpl.this.fLoadExternalDTD;
                                if (object.scanDTDInternalSubset(true, bl3, bl4)) break;
                                if (!XMLDocumentScannerImpl.this.fEntityScanner.skipChar(93)) {
                                    XMLDocumentScannerImpl.this.reportFatalError("EXPECTED_SQUARE_BRACKET_TO_CLOSE_INTERNAL_SUBSET", null);
                                }
                                XMLDocumentScannerImpl.this.fEntityScanner.skipSpaces();
                                if (!XMLDocumentScannerImpl.this.fEntityScanner.skipChar(62)) {
                                    object = XMLDocumentScannerImpl.this;
                                    ((XMLScanner)object).reportFatalError("DoctypedeclUnterminated", new Object[]{((XMLDocumentScannerImpl)object).fDoctypeName});
                                }
                                object = XMLDocumentScannerImpl.this;
                                --((XMLDocumentFragmentScannerImpl)object).fMarkupDepth;
                                if (!(XMLDocumentScannerImpl.this.fDoctypeSystemId == null || !XMLDocumentScannerImpl.this.fValidation && !XMLDocumentScannerImpl.this.fLoadExternalDTD || XMLDocumentScannerImpl.this.fValidationManager != null && XMLDocumentScannerImpl.this.fValidationManager.isCachedDTD())) {
                                    XMLDocumentScannerImpl.this.setScannerState(18);
                                    break;
                                }
                                XMLDocumentScannerImpl.this.setScannerState(5);
                                object2 = XMLDocumentScannerImpl.this;
                                ((XMLDocumentFragmentScannerImpl)object2).setDispatcher(((XMLDocumentScannerImpl)object2).fPrologDispatcher);
                                XMLDocumentScannerImpl.this.fEntityManager.setEntityHandler(XMLDocumentScannerImpl.this);
                                XMLDocumentScannerImpl.this.fEntityManager.setEntityHandler(XMLDocumentScannerImpl.this);
                                return true;
                            }
                        }
                        bl2 = false;
                    } while (bl || bl2);
                    XMLDocumentScannerImpl.this.fEntityManager.setEntityHandler(XMLDocumentScannerImpl.this);
                    return true;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DTDDispatcher#dispatch: scanner state=");
                stringBuffer.append(XMLDocumentScannerImpl.this.fScannerState);
                stringBuffer.append(" (");
                object = XMLDocumentScannerImpl.this;
                stringBuffer.append(((XMLDocumentScannerImpl)object).getScannerStateName(((XMLDocumentFragmentScannerImpl)object).fScannerState));
                stringBuffer.append(')');
                object2 = new XNIException(stringBuffer.toString());
                throw object2;
            }
            catch (Throwable throwable) {
            }
            catch (EOFException eOFException) {
                XMLDocumentScannerImpl.this.reportFatalError("PrematureEOF", null);
                XMLDocumentScannerImpl.this.fEntityManager.setEntityHandler(XMLDocumentScannerImpl.this);
                return false;
            }
            XMLDocumentScannerImpl.this.fEntityManager.setEntityHandler(XMLDocumentScannerImpl.this);
            throw throwable;
        }
    }

    protected final class PrologDispatcher
    implements XMLDocumentFragmentScannerImpl.Dispatcher {
        protected PrologDispatcher() {
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean dispatch(boolean var1_1) throws IOException, XNIException {
            try {
                do {
                    block24: {
                        block25: {
                            block30: {
                                block28: {
                                    block27: {
                                        block29: {
                                            block26: {
                                                switch (XMLDocumentScannerImpl.this.fScannerState) {
                                                    default: {
                                                        break block24;
                                                    }
                                                    case 7: {
                                                        XMLDocumentScannerImpl.this.reportFatalError("ContentIllegalInProlog", null);
                                                        XMLDocumentScannerImpl.this.fEntityScanner.scanChar();
                                                    }
                                                    case 8: {
                                                        var2_2 = XMLDocumentScannerImpl.this;
                                                        var3_3 = "ReferenceIllegalInProlog";
                                                        break block25;
                                                    }
                                                    case 5: {
                                                        XMLDocumentScannerImpl.this.fEntityScanner.skipSpaces();
                                                        if (XMLDocumentScannerImpl.this.fEntityScanner.skipChar(60)) {
                                                            XMLDocumentScannerImpl.this.setScannerState(1);
                                                            ** break;
                                                        }
                                                        if (XMLDocumentScannerImpl.this.fEntityScanner.skipChar(38)) {
                                                            XMLDocumentScannerImpl.this.setScannerState(8);
                                                            ** break;
                                                        }
                                                        XMLDocumentScannerImpl.this.setScannerState(7);
                                                        ** break;
                                                    }
                                                    case 4: {
                                                        if (XMLDocumentScannerImpl.this.fDisallowDoctype) {
                                                            XMLDocumentScannerImpl.this.reportFatalError("DoctypeNotAllowed", null);
                                                        }
                                                        if (XMLDocumentScannerImpl.this.fSeenDoctypeDecl) {
                                                            XMLDocumentScannerImpl.this.reportFatalError("AlreadySeenDoctype", null);
                                                        }
                                                        XMLDocumentScannerImpl.this.fSeenDoctypeDecl = true;
                                                        if (XMLDocumentScannerImpl.this.scanDoctypeDecl()) {
                                                            XMLDocumentScannerImpl.this.setScannerState(17);
                                                            var3_3 = XMLDocumentScannerImpl.this;
                                                            var3_3.setDispatcher(var3_3.fDTDDispatcher);
                                                            return true;
                                                        }
                                                        if (!(XMLDocumentScannerImpl.this.fDoctypeSystemId == null || !XMLDocumentScannerImpl.this.fValidation && !XMLDocumentScannerImpl.this.fLoadExternalDTD || XMLDocumentScannerImpl.this.fValidationManager != null && XMLDocumentScannerImpl.this.fValidationManager.isCachedDTD())) {
                                                            XMLDocumentScannerImpl.this.setScannerState(18);
                                                            var3_3 = XMLDocumentScannerImpl.this;
                                                            var3_3.setDispatcher(var3_3.fDTDDispatcher);
                                                            return true;
                                                        }
                                                        XMLDocumentScannerImpl.this.fDTDScanner.setInputSource(null);
                                                        ** GOTO lbl48
                                                    }
                                                    case 3: {
                                                        XMLDocumentScannerImpl.this.scanPI();
                                                        ** GOTO lbl48
                                                    }
                                                    case 2: {
                                                        XMLDocumentScannerImpl.this.scanComment();
lbl48:
                                                        // 3 sources

                                                        XMLDocumentScannerImpl.this.setScannerState(5);
                                                        break block24;
                                                    }
                                                    case 1: 
                                                }
                                                var3_3 = XMLDocumentScannerImpl.this;
                                                ++var3_3.fMarkupDepth;
                                                if (!XMLDocumentScannerImpl.this.fEntityScanner.skipChar(63)) break block26;
                                                XMLDocumentScannerImpl.this.setScannerState(3);
                                                break block27;
                                            }
                                            var5_6 = XMLDocumentScannerImpl.this.fEntityScanner.skipChar(33);
                                            var3_3 = "MarkupNotRecognizedInProlog";
                                            if (!var5_6) break block28;
                                            if (!XMLDocumentScannerImpl.this.fEntityScanner.skipChar(45)) break block29;
                                            if (!XMLDocumentScannerImpl.this.fEntityScanner.skipChar(45)) {
                                                XMLDocumentScannerImpl.this.reportFatalError("InvalidCommentStart", null);
                                            }
                                            XMLDocumentScannerImpl.this.setScannerState(2);
                                            break block27;
                                        }
                                        if (!XMLDocumentScannerImpl.this.fEntityScanner.skipString("DOCTYPE")) break block30;
                                        XMLDocumentScannerImpl.this.setScannerState(4);
                                    }
                                    var4_5 = true;
                                    continue;
                                }
                                if (XMLChar.isNameStart(XMLDocumentScannerImpl.this.fEntityScanner.peekChar())) {
                                    XMLDocumentScannerImpl.this.setScannerState(6);
                                    var3_3 = XMLDocumentScannerImpl.this;
                                    var3_3.setDispatcher(var3_3.fContentDispatcher);
                                    return true;
                                }
                            }
                            var2_2 = XMLDocumentScannerImpl.this;
                        }
                        var2_2.reportFatalError((String)var3_3, null);
                    }
                    var4_5 = false;
                } while (var1_1 || var4_5);
                if (var1_1) {
                    if (XMLDocumentScannerImpl.this.fEntityScanner.scanChar() != 60) {
                        XMLDocumentScannerImpl.this.reportFatalError("RootElementRequired", null);
                    }
                    XMLDocumentScannerImpl.this.setScannerState(6);
                    var3_3 = XMLDocumentScannerImpl.this;
                    var3_3.setDispatcher(var3_3.fContentDispatcher);
                }
                return true;
            }
            catch (EOFException var3_4) {
                XMLDocumentScannerImpl.this.reportFatalError("PrematureEOF", null);
                return false;
            }
        }
    }

    protected final class TrailingMiscDispatcher
    implements XMLDocumentFragmentScannerImpl.Dispatcher {
        protected TrailingMiscDispatcher() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean dispatch(boolean var1_1) throws IOException, XNIException {
            block6: do {
                block18: {
                    block17: {
                        block15: {
                            block16: {
                                block14: {
                                    var2_2 = false;
                                    var3_3 = XMLDocumentScannerImpl.this.fScannerState;
                                    if (var3_3 == 1) ** GOTO lbl45
                                    if (var3_3 == 2) ** GOTO lbl40
                                    if (var3_3 == 3) ** GOTO lbl37
                                    if (var3_3 == 7) ** GOTO lbl27
                                    if (var3_3 == 8) ** GOTO lbl22
                                    if (var3_3 == 12) break block14;
                                    if (var3_3 != 14) continue;
                                    return false;
                                }
                                XMLDocumentScannerImpl.this.fEntityScanner.skipSpaces();
                                if (XMLDocumentScannerImpl.this.fEntityScanner.skipChar(60)) {
                                    XMLDocumentScannerImpl.this.setScannerState(1);
                                } else {
                                    XMLDocumentScannerImpl.this.setScannerState(7);
                                }
                                break block15;
lbl22:
                                // 1 sources

                                XMLDocumentScannerImpl.this.reportFatalError("ReferenceIllegalInTrailingMisc", null);
                                var4_4 = XMLDocumentScannerImpl.this;
lbl24:
                                // 4 sources

                                while (true) {
                                    var4_4.setScannerState(12);
                                    continue block6;
                                    break;
                                }
lbl27:
                                // 1 sources

                                if (XMLDocumentScannerImpl.this.fEntityScanner.peekChar() != -1) break block16;
                                XMLDocumentScannerImpl.this.setScannerState(14);
                                return false;
                            }
                            XMLDocumentScannerImpl.this.reportFatalError("ContentIllegalInTrailingMisc", null);
                            XMLDocumentScannerImpl.this.fEntityScanner.scanChar();
                            var4_4 = XMLDocumentScannerImpl.this;
                            ** GOTO lbl24
lbl37:
                            // 1 sources

                            XMLDocumentScannerImpl.this.scanPI();
                            var4_4 = XMLDocumentScannerImpl.this;
                            ** GOTO lbl24
lbl40:
                            // 1 sources

                            if (!XMLDocumentScannerImpl.this.fEntityScanner.skipString("--")) {
                                XMLDocumentScannerImpl.this.reportFatalError("InvalidCommentStart", null);
                            }
                            XMLDocumentScannerImpl.this.scanComment();
                            var4_4 = XMLDocumentScannerImpl.this;
                            ** continue;
lbl45:
                            // 1 sources

                            var4_4 = XMLDocumentScannerImpl.this;
                            ++var4_4.fMarkupDepth;
                            if (!XMLDocumentScannerImpl.this.fEntityScanner.skipChar(63)) break block17;
                            XMLDocumentScannerImpl.this.setScannerState(3);
                        }
lbl50:
                        // 3 sources

                        while (true) {
                            var2_2 = true;
                            continue block6;
                            break;
                        }
                    }
                    if (!XMLDocumentScannerImpl.this.fEntityScanner.skipChar(33)) break block18;
                    XMLDocumentScannerImpl.this.setScannerState(2);
                    ** GOTO lbl50
                }
                var5_6 = XMLDocumentScannerImpl.this.fEntityScanner.skipChar(47);
                if (!var5_6) ** GOTO lbl64
                XMLDocumentScannerImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
                ** continue;
lbl64:
                // 1 sources

                if (XMLChar.isNameStart(XMLDocumentScannerImpl.this.fEntityScanner.peekChar())) {
                    XMLDocumentScannerImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
                    XMLDocumentScannerImpl.this.scanStartElement();
                    XMLDocumentScannerImpl.this.setScannerState(7);
                    continue;
                }
                XMLDocumentScannerImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
            } while (var1_1 || var2_2);
            return true;
            catch (EOFException var4_5) {
                if (XMLDocumentScannerImpl.this.fMarkupDepth != 0) {
                    XMLDocumentScannerImpl.this.reportFatalError("PrematureEOF", null);
                    return false;
                }
                XMLDocumentScannerImpl.this.setScannerState(14);
                return false;
            }
        }
    }

    protected final class XMLDeclDispatcher
    implements XMLDocumentFragmentScannerImpl.Dispatcher {
        protected XMLDeclDispatcher() {
        }

        @Override
        public boolean dispatch(boolean bl) throws IOException, XNIException {
            XMLDocumentScannerImpl.this.setScannerState(5);
            Object object = XMLDocumentScannerImpl.this;
            ((XMLDocumentFragmentScannerImpl)object).setDispatcher(((XMLDocumentScannerImpl)object).fPrologDispatcher);
            try {
                block6: {
                    if (XMLDocumentScannerImpl.this.fEntityScanner.skipString("<?xml")) {
                        object = XMLDocumentScannerImpl.this;
                        ++((XMLDocumentFragmentScannerImpl)object).fMarkupDepth;
                        if (XMLChar.isName(XMLDocumentScannerImpl.this.fEntityScanner.peekChar())) {
                            XMLDocumentScannerImpl.this.fStringBuffer.clear();
                            XMLDocumentScannerImpl.this.fStringBuffer.append("xml");
                            while (true) {
                                if (!XMLChar.isName(XMLDocumentScannerImpl.this.fEntityScanner.peekChar())) {
                                    object = XMLDocumentScannerImpl.this.fSymbolTable.addSymbol(((XMLDocumentScannerImpl)XMLDocumentScannerImpl.this).fStringBuffer.ch, ((XMLDocumentScannerImpl)XMLDocumentScannerImpl.this).fStringBuffer.offset, ((XMLDocumentScannerImpl)XMLDocumentScannerImpl.this).fStringBuffer.length);
                                    XMLDocumentScannerImpl xMLDocumentScannerImpl = XMLDocumentScannerImpl.this;
                                    xMLDocumentScannerImpl.scanPIData((String)object, xMLDocumentScannerImpl.fString);
                                    break block6;
                                }
                                XMLDocumentScannerImpl.this.fStringBuffer.append((char)XMLDocumentScannerImpl.this.fEntityScanner.scanChar());
                            }
                        }
                        XMLDocumentScannerImpl.this.scanXMLDeclOrTextDecl(false);
                    }
                }
                XMLDocumentScannerImpl.this.fEntityManager.fCurrentEntity.mayReadChunks = true;
                return true;
            }
            catch (EOFException eOFException) {
                XMLDocumentScannerImpl.this.reportFatalError("PrematureEOF", null);
                return false;
            }
        }
    }
}

