/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.util.DefaultErrorHandler;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;

public class XMLErrorReporter
implements XMLComponent {
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final Boolean[] FEATURE_DEFAULTS;
    private static final Object[] PROPERTY_DEFAULTS;
    private static final String[] RECOGNIZED_FEATURES;
    private static final String[] RECOGNIZED_PROPERTIES;
    public static final short SEVERITY_ERROR = 1;
    public static final short SEVERITY_FATAL_ERROR = 2;
    public static final short SEVERITY_WARNING = 0;
    protected boolean fContinueAfterFatalError;
    protected XMLErrorHandler fDefaultErrorHandler;
    protected XMLErrorHandler fErrorHandler;
    protected Locale fLocale;
    protected XMLLocator fLocator;
    protected Hashtable fMessageFormatters = new Hashtable();

    static {
        RECOGNIZED_FEATURES = new String[]{CONTINUE_AFTER_FATAL_ERROR};
        FEATURE_DEFAULTS = new Boolean[]{null};
        RECOGNIZED_PROPERTIES = new String[]{ERROR_HANDLER};
        PROPERTY_DEFAULTS = new Object[]{null};
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public boolean getFeature(String string2) throws XMLConfigurationException {
        if (string2.startsWith("http://apache.org/xml/features/") && string2.substring(31).equals("continue-after-fatal-error")) {
            return this.fContinueAfterFatalError;
        }
        return false;
    }

    @Override
    public Boolean getFeatureDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_FEATURES).length) {
            if (stringArray[n].equals(string2)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public MessageFormatter getMessageFormatter(String string2) {
        return (MessageFormatter)this.fMessageFormatters.get(string2);
    }

    @Override
    public Object getPropertyDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_PROPERTIES).length) {
            if (stringArray[n].equals(string2)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    @Override
    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void putMessageFormatter(String string2, MessageFormatter messageFormatter) {
        this.fMessageFormatters.put(string2, messageFormatter);
    }

    public MessageFormatter removeMessageFormatter(String string2) {
        return (MessageFormatter)this.fMessageFormatters.remove(string2);
    }

    public void reportError(String string2, String string3, Object[] objectArray, short s) throws XNIException {
        this.reportError(this.fLocator, string2, string3, objectArray, s);
    }

    public void reportError(XMLLocator object, String string2, String string3, Object[] object2, short s) throws XNIException {
        Object object3 = this.getMessageFormatter(string2);
        if (object3 != null) {
            object2 = object3.formatMessage(this.fLocale, string3, (Object[])object2);
        } else {
            object3 = new StringBuffer();
            ((StringBuffer)object3).append(string2);
            ((StringBuffer)object3).append('#');
            ((StringBuffer)object3).append(string3);
            int n = object2 != null ? ((Object[])object2).length : 0;
            if (n > 0) {
                ((StringBuffer)object3).append('?');
                for (int i = 0; i < n; ++i) {
                    ((StringBuffer)object3).append(object2[i]);
                    if (i >= n - 1) continue;
                    ((StringBuffer)object3).append('&');
                }
            }
            object2 = ((StringBuffer)object3).toString();
        }
        object3 = new XMLParseException((XMLLocator)object, (String)object2);
        object2 = this.fErrorHandler;
        object = object2;
        if (object2 == null) {
            if (this.fDefaultErrorHandler == null) {
                this.fDefaultErrorHandler = new DefaultErrorHandler();
            }
            object = this.fDefaultErrorHandler;
        }
        if (s != 0) {
            if (s != 1) {
                if (s == 2) {
                    object.fatalError(string2, string3, (XMLParseException)object3);
                    if (!this.fContinueAfterFatalError) {
                        throw object3;
                    }
                }
            } else {
                object.error(string2, string3, (XMLParseException)object3);
            }
        } else {
            object.warning(string2, string3, (XMLParseException)object3);
        }
    }

    @Override
    public void reset(XMLComponentManager xMLComponentManager) throws XNIException {
        try {
            this.fContinueAfterFatalError = xMLComponentManager.getFeature(CONTINUE_AFTER_FATAL_ERROR);
        }
        catch (XNIException xNIException) {
            this.fContinueAfterFatalError = false;
        }
        this.fErrorHandler = (XMLErrorHandler)xMLComponentManager.getProperty(ERROR_HANDLER);
    }

    public void setDocumentLocator(XMLLocator xMLLocator) {
        this.fLocator = xMLLocator;
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
        if (string2.startsWith("http://apache.org/xml/features/") && string2.substring(31).equals("continue-after-fatal-error")) {
            this.fContinueAfterFatalError = bl;
        }
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        if (string2.startsWith("http://apache.org/xml/properties/") && string2.substring(33).equals("internal/error-handler")) {
            this.fErrorHandler = (XMLErrorHandler)object;
        }
    }
}

