/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLDocumentFragmentScannerImpl;
import org.apache.xerces.impl.XMLDocumentScannerImpl;
import org.apache.xerces.impl.dtd.XMLDTDValidatorFilter;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;

public class XMLNSDocumentScannerImpl
extends XMLDocumentScannerImpl {
    protected boolean fBindNamespaces;
    private XMLDTDValidatorFilter fDTDValidator;
    protected int fLength = 0;
    protected String[] fLocalpart;
    protected boolean fPerformValidation;
    protected String[] fUri = new String[4];

    public XMLNSDocumentScannerImpl() {
        this.fLocalpart = new String[4];
    }

    private final void checkDuplicates(QName qName, XMLAttributesImpl stringArray) {
        int n = 0;
        while (true) {
            int n2;
            if (n >= (n2 = this.fLength)) {
                this.fLength = n2 + 1;
                String[] stringArray2 = this.fUri;
                if (n2 == stringArray2.length) {
                    stringArray = new String[stringArray2.length + 4];
                    String[] stringArray3 = new String[stringArray2.length + 4];
                    System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                    stringArray2 = this.fLocalpart;
                    System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                    this.fUri = stringArray;
                    this.fLocalpart = stringArray3;
                }
                this.fUri[n2] = qName.uri;
                this.fLocalpart[n2] = qName.localpart;
                return;
            }
            if (qName.uri == this.fUri[n] && this.fLocalpart[n].equals(qName.localpart)) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributeNSNotUnique", new Object[]{this.fElementQName.rawname, qName.rawname, qName.uri}, (short)2);
            }
            ++n;
        }
    }

    @Override
    protected XMLDocumentFragmentScannerImpl.Dispatcher createContentDispatcher() {
        return new NSContentDispatcher();
    }

    @Override
    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        super.reset(xMLComponentManager);
        this.fPerformValidation = false;
        this.fBindNamespaces = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void scanAttribute(XMLAttributesImpl xMLAttributesImpl) throws IOException, XNIException {
        this.fEntityScanner.scanQName(this.fAttributeQName);
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            this.reportFatalError("EqRequiredInAttribute", new Object[]{this.fAttributeQName.rawname});
        }
        this.fEntityScanner.skipSpaces();
        int n = xMLAttributesImpl.getLength();
        Object object = this.fAttributeQName;
        Object object2 = XMLSymbols.fCDATASymbol;
        Object object3 = null;
        xMLAttributesImpl.addAttribute((QName)object, (String)object2, null);
        if (n == xMLAttributesImpl.getLength()) {
            this.reportFatalError("AttributeNotUnique", new Object[]{this.fCurrentElement.rawname, this.fAttributeQName.rawname});
        }
        boolean bl = this.fHasExternalDTD && !this.fStandalone;
        this.scanAttributeValue(this.fTempString, this.fTempString2, this.fAttributeQName.rawname, xMLAttributesImpl, n, bl);
        String string2 = this.fTempString.toString();
        xMLAttributesImpl.setValue(n, string2);
        xMLAttributesImpl.setNonNormalizedValue(n, this.fTempString2.toString());
        xMLAttributesImpl.setSpecified(n, true);
        if (!this.fBindNamespaces) return;
        object2 = this.fAttributeQName.localpart;
        object = this.fAttributeQName.prefix != null ? this.fAttributeQName.prefix : XMLSymbols.EMPTY_STRING;
        if (object != XMLSymbols.PREFIX_XMLNS && (object != XMLSymbols.EMPTY_STRING || object2 != XMLSymbols.PREFIX_XMLNS)) {
            if (this.fAttributeQName.prefix == null) return;
            object3 = this.fNamespaceContext;
            object = this.fAttributeQName.prefix;
        } else {
            string2 = this.fSymbolTable.addSymbol(string2);
            if (object == XMLSymbols.PREFIX_XMLNS && object2 == XMLSymbols.PREFIX_XMLNS) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{this.fAttributeQName}, (short)2);
            }
            if (string2 == NamespaceContext.XMLNS_URI) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{this.fAttributeQName}, (short)2);
            }
            if (object2 == XMLSymbols.PREFIX_XML) {
                if (string2 != NamespaceContext.XML_URI) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{this.fAttributeQName}, (short)2);
                }
            } else if (string2 == NamespaceContext.XML_URI) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{this.fAttributeQName}, (short)2);
            }
            object = object2 != XMLSymbols.PREFIX_XMLNS ? object2 : XMLSymbols.EMPTY_STRING;
            if (string2 == XMLSymbols.EMPTY_STRING && object2 != XMLSymbols.PREFIX_XMLNS) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "EmptyPrefixedAttName", new Object[]{this.fAttributeQName}, (short)2);
            }
            object2 = this.fNamespaceContext;
            if (string2.length() != 0) {
                object3 = string2;
            }
            object2.declarePrefix((String)object, (String)object3);
            object3 = this.fNamespaceContext;
            object = XMLSymbols.PREFIX_XMLNS;
        }
        xMLAttributesImpl.setURI(n, object3.getURI((String)object));
    }

    @Override
    protected int scanEndElement() throws IOException, XNIException {
        this.fElementStack.popElement(this.fElementQName);
        if (!this.fEntityScanner.skipString(this.fElementQName.rawname)) {
            this.reportFatalError("ETagRequired", new Object[]{this.fElementQName.rawname});
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("ETagUnterminated", new Object[]{this.fElementQName.rawname});
        }
        --this.fMarkupDepth;
        --this.fMarkupDepth;
        if (this.fMarkupDepth < this.fEntityStack[this.fEntityDepth - 1]) {
            this.reportFatalError("ElementEntityMismatch", new Object[]{this.fCurrentElement.rawname});
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(this.fElementQName, null);
            if (this.fBindNamespaces) {
                this.fNamespaceContext.popContext();
            }
        }
        return this.fMarkupDepth;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean scanStartElement() throws IOException, XNIException {
        boolean bl;
        block17: {
            int n;
            int n2;
            String string2;
            String string3;
            block19: {
                block18: {
                    block20: {
                        this.fEntityScanner.scanQName(this.fElementQName);
                        if (!this.fBindNamespaces) break block18;
                        this.fNamespaceContext.pushContext();
                        string2 = string3 = this.fElementQName.rawname;
                        if (this.fScannerState != 6) break block19;
                        string2 = string3;
                        if (!this.fPerformValidation) break block19;
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_GRAMMAR_NOT_FOUND", new Object[]{string3}, (short)1);
                        if (this.fDoctypeName == null) break block20;
                        string2 = string3;
                        if (this.fDoctypeName.equals(string3)) break block19;
                    }
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RootElementTypeMustMatchDoctypedecl", new Object[]{this.fDoctypeName, string3}, (short)1);
                    string2 = string3;
                    break block19;
                }
                string2 = null;
            }
            this.fCurrentElement = this.fElementStack.pushElement(this.fElementQName);
            this.fAttributes.removeAllAttributes();
            while (true) {
                block23: {
                    block22: {
                        block21: {
                            bl = this.fEntityScanner.skipSpaces();
                            n2 = this.fEntityScanner.peekChar();
                            if (n2 != 62) break block21;
                            this.fEntityScanner.scanChar();
                            bl = false;
                            break block22;
                        }
                        if (n2 != 47) break block23;
                        this.fEntityScanner.scanChar();
                        if (!this.fEntityScanner.skipChar(62)) {
                            this.reportFatalError("ElementUnterminated", new Object[]{string2});
                        }
                        bl = true;
                    }
                    if (this.fBindNamespaces) {
                        if (this.fElementQName.prefix == XMLSymbols.PREFIX_XMLNS) {
                            this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementXMLNSPrefix", new Object[]{this.fElementQName.rawname}, (short)2);
                        }
                        string2 = this.fElementQName.prefix != null ? this.fElementQName.prefix : XMLSymbols.EMPTY_STRING;
                        this.fCurrentElement.uri = this.fElementQName.uri = this.fNamespaceContext.getURI(string2);
                        if (this.fElementQName.prefix == null && this.fElementQName.uri != null) {
                            this.fElementQName.prefix = XMLSymbols.EMPTY_STRING;
                        }
                        if (this.fElementQName.prefix != null && this.fElementQName.uri == null) {
                            this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementPrefixUnbound", new Object[]{this.fElementQName.prefix, this.fElementQName.rawname}, (short)2);
                        }
                        n = this.fAttributes.getLength();
                        this.fLength = 0;
                        break;
                    }
                    break block17;
                }
                if (!this.isValidNameStartChar(n2) || !bl) {
                    this.reportFatalError("ElementUnterminated", new Object[]{string2});
                }
                this.scanAttribute(this.fAttributes);
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.fAttributes.getName(n2, this.fAttributeQName);
                string2 = this.fAttributeQName.prefix != null ? this.fAttributeQName.prefix : XMLSymbols.EMPTY_STRING;
                string3 = this.fNamespaceContext.getURI(string2);
                if (this.fAttributeQName.uri == null || this.fAttributeQName.uri != string3) {
                    if (string2 == XMLSymbols.EMPTY_STRING) continue;
                    this.fAttributeQName.uri = string3;
                    if (string3 == null) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributePrefixUnbound", new Object[]{string2, this.fAttributeQName.rawname}, (short)2);
                    }
                    this.fAttributes.setURI(n2, string3);
                }
                this.checkDuplicates(this.fAttributeQName, this.fAttributes);
            }
        }
        if (this.fDocumentHandler == null) return bl;
        if (!bl) {
            this.fDocumentHandler.startElement(this.fElementQName, this.fAttributes, null);
            return bl;
        }
        --this.fMarkupDepth;
        if (this.fMarkupDepth < this.fEntityStack[this.fEntityDepth - 1]) {
            this.reportFatalError("ElementEntityMismatch", new Object[]{this.fCurrentElement.rawname});
        }
        this.fDocumentHandler.emptyElement(this.fElementQName, this.fAttributes, null);
        if (this.fBindNamespaces) {
            this.fNamespaceContext.popContext();
        }
        this.fElementStack.popElement(this.fElementQName);
        return bl;
    }

    public void setDTDValidator(XMLDTDValidatorFilter xMLDTDValidatorFilter) {
        this.fDTDValidator = xMLDTDValidatorFilter;
    }

    protected final class NSContentDispatcher
    extends XMLDocumentScannerImpl.ContentDispatcher {
        protected NSContentDispatcher() {
        }

        @Override
        protected boolean scanRootElementHook() throws IOException, XNIException {
            Object object;
            if (XMLNSDocumentScannerImpl.this.fDTDValidator == null) {
                XMLNSDocumentScannerImpl.this.fBindNamespaces = true;
            } else if (!XMLNSDocumentScannerImpl.this.fDTDValidator.hasGrammar()) {
                XMLNSDocumentScannerImpl.this.fBindNamespaces = true;
                object = XMLNSDocumentScannerImpl.this;
                ((XMLNSDocumentScannerImpl)object).fPerformValidation = ((XMLNSDocumentScannerImpl)object).fDTDValidator.validate();
                XMLDocumentSource xMLDocumentSource = XMLNSDocumentScannerImpl.this.fDTDValidator.getDocumentSource();
                object = XMLNSDocumentScannerImpl.this.fDTDValidator.getDocumentHandler();
                xMLDocumentSource.setDocumentHandler((XMLDocumentHandler)object);
                if (object != null) {
                    object.setDocumentSource(xMLDocumentSource);
                }
                XMLNSDocumentScannerImpl.this.fDTDValidator.setDocumentSource(null);
                XMLNSDocumentScannerImpl.this.fDTDValidator.setDocumentHandler(null);
            }
            if (XMLNSDocumentScannerImpl.this.scanStartElement()) {
                XMLNSDocumentScannerImpl.this.setScannerState(12);
                object = XMLNSDocumentScannerImpl.this;
                ((XMLDocumentFragmentScannerImpl)object).setDispatcher(((XMLDocumentScannerImpl)object).fTrailingMiscDispatcher);
                return true;
            }
            return false;
        }
    }
}

