/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;

public class XMLNamespaceBinder
implements XMLComponent,
XMLDocumentFilter {
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final Boolean[] FEATURE_DEFAULTS;
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final Object[] PROPERTY_DEFAULTS;
    private static final String[] RECOGNIZED_FEATURES;
    private static final String[] RECOGNIZED_PROPERTIES;
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private QName fAttributeQName = new QName();
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    protected XMLErrorReporter fErrorReporter;
    private NamespaceContext fNamespaceContext;
    protected boolean fNamespaces;
    protected boolean fOnlyPassPrefixMappingEvents;
    protected SymbolTable fSymbolTable;

    static {
        RECOGNIZED_FEATURES = new String[]{NAMESPACES};
        FEATURE_DEFAULTS = new Boolean[]{null};
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER};
        PROPERTY_DEFAULTS = new Object[]{null, null};
    }

    @Override
    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.characters(xMLString, augmentations);
        }
    }

    @Override
    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.comment(xMLString, augmentations);
        }
    }

    @Override
    public void doctypeDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.doctypeDecl(string2, string3, string4, augmentations);
        }
    }

    @Override
    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.handleStartElement(qName, xMLAttributes, augmentations, true);
            this.handleEndElement(qName, augmentations, true);
        } else {
            XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
            if (xMLDocumentHandler != null) {
                xMLDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
            }
        }
    }

    @Override
    public void endCDATA(Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.endCDATA(augmentations);
        }
    }

    @Override
    public void endDocument(Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.endDocument(augmentations);
        }
    }

    @Override
    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.handleEndElement(qName, augmentations, false);
        } else {
            XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
            if (xMLDocumentHandler != null) {
                xMLDocumentHandler.endElement(qName, augmentations);
            }
        }
    }

    @Override
    public void endGeneralEntity(String string2, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.endGeneralEntity(string2, augmentations);
        }
    }

    @Override
    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    @Override
    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    @Override
    public Boolean getFeatureDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_FEATURES).length) {
            if (stringArray[n].equals(string2)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public boolean getOnlyPassPrefixMappingEvents() {
        return this.fOnlyPassPrefixMappingEvents;
    }

    @Override
    public Object getPropertyDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_PROPERTIES).length) {
            if (stringArray[n].equals(string2)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    @Override
    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    protected void handleEndElement(QName qName, Augmentations augmentations, boolean bl) throws XNIException {
        Object object = qName.prefix != null ? qName.prefix : XMLSymbols.EMPTY_STRING;
        qName.uri = this.fNamespaceContext.getURI((String)object);
        if (qName.uri != null) {
            qName.prefix = object;
        }
        if ((object = this.fDocumentHandler) != null && !this.fOnlyPassPrefixMappingEvents && !bl) {
            object.endElement(qName, augmentations);
        }
        this.fNamespaceContext.popContext();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, boolean bl) throws XNIException {
        String string2;
        Object object;
        Object object2;
        this.fNamespaceContext.pushContext();
        if (qName.prefix == XMLSymbols.PREFIX_XMLNS) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementXMLNSPrefix", new Object[]{qName.rawname}, (short)2);
        }
        int n = xMLAttributes.getLength();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                object2 = qName.prefix != null ? qName.prefix : XMLSymbols.EMPTY_STRING;
                qName.uri = this.fNamespaceContext.getURI((String)object2);
                if (qName.prefix == null && qName.uri != null) {
                    qName.prefix = XMLSymbols.EMPTY_STRING;
                }
                if (qName.prefix != null && qName.uri == null) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementPrefixUnbound", new Object[]{qName.prefix, qName.rawname}, (short)2);
                }
                break;
            }
            object = xMLAttributes.getLocalName(n2);
            object2 = xMLAttributes.getPrefix(n2);
            if (object2 == XMLSymbols.PREFIX_XMLNS || object2 == XMLSymbols.EMPTY_STRING && object == XMLSymbols.PREFIX_XMLNS) {
                string2 = this.fSymbolTable.addSymbol(xMLAttributes.getValue(n2));
                if (object2 == XMLSymbols.PREFIX_XMLNS && object == XMLSymbols.PREFIX_XMLNS) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                }
                if (string2 == NamespaceContext.XMLNS_URI) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                }
                if (object == XMLSymbols.PREFIX_XML) {
                    if (string2 != NamespaceContext.XML_URI) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                    }
                } else if (string2 == NamespaceContext.XML_URI) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                }
                object2 = object != XMLSymbols.PREFIX_XMLNS ? object : XMLSymbols.EMPTY_STRING;
                if (this.prefixBoundToNullURI(string2, (String)object)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "EmptyPrefixedAttName", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                } else {
                    object = this.fNamespaceContext;
                    if (string2.length() == 0) {
                        string2 = null;
                    }
                    object.declarePrefix((String)object2, string2);
                }
            }
            ++n2;
        }
        n2 = 0;
        while (true) {
            block29: {
                block28: {
                    block27: {
                        if (n2 >= n) break;
                        xMLAttributes.getName(n2, this.fAttributeQName);
                        object2 = this.fAttributeQName.prefix != null ? this.fAttributeQName.prefix : XMLSymbols.EMPTY_STRING;
                        string2 = this.fAttributeQName.rawname;
                        if (string2 != XMLSymbols.PREFIX_XMLNS) break block27;
                        this.fAttributeQName.uri = this.fNamespaceContext.getURI(XMLSymbols.PREFIX_XMLNS);
                        break block28;
                    }
                    if (object2 == XMLSymbols.EMPTY_STRING) break block29;
                    this.fAttributeQName.uri = this.fNamespaceContext.getURI((String)object2);
                    if (this.fAttributeQName.uri == null) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributePrefixUnbound", new Object[]{object2, string2}, (short)2);
                    }
                }
                xMLAttributes.setName(n2, this.fAttributeQName);
            }
            ++n2;
        }
        int n3 = xMLAttributes.getLength();
        n2 = 0;
        block2: while (true) {
            if (n2 >= n3 - 1) {
                object2 = this.fDocumentHandler;
                if (object2 == null) return;
                if (this.fOnlyPassPrefixMappingEvents) return;
                if (bl) {
                    object2.emptyElement(qName, xMLAttributes, augmentations);
                    return;
                }
                object2.startElement(qName, xMLAttributes, augmentations);
                return;
            }
            object2 = xMLAttributes.getLocalName(n2);
            String string3 = xMLAttributes.getURI(n2);
            n = ++n2;
            while (true) {
                if (n >= n3) continue block2;
                object = xMLAttributes.getLocalName(n);
                string2 = xMLAttributes.getURI(n);
                if (object2 == object && string3 == string2) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributeNSNotUnique", new Object[]{qName.rawname, object2, string3}, (short)2);
                }
                ++n;
            }
            break;
        }
    }

    @Override
    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    protected boolean prefixBoundToNullURI(String string2, String string3) {
        boolean bl = string2 == XMLSymbols.EMPTY_STRING && string3 != XMLSymbols.PREFIX_XMLNS;
        return bl;
    }

    @Override
    public void processingInstruction(String string2, XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.processingInstruction(string2, xMLString, augmentations);
        }
    }

    @Override
    public void reset(XMLComponentManager xMLComponentManager) throws XNIException {
        try {
            this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNamespaces = true;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    @Override
    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
    }

    public void setOnlyPassPrefixMappingEvents(boolean bl) {
        this.fOnlyPassPrefixMappingEvents = bl;
    }

    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        if (string2.startsWith("http://apache.org/xml/properties/")) {
            if ((string2 = string2.substring(33)).equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
            } else if (string2.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
            }
        }
    }

    @Override
    public void startCDATA(Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.startCDATA(augmentations);
        }
    }

    @Override
    public void startDocument(XMLLocator xMLLocator, String string2, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.startDocument(xMLLocator, string2, namespaceContext, augmentations);
        }
    }

    @Override
    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.handleStartElement(qName, xMLAttributes, augmentations, false);
        } else {
            XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
            if (xMLDocumentHandler != null) {
                xMLDocumentHandler.startElement(qName, xMLAttributes, augmentations);
            }
        }
    }

    @Override
    public void startGeneralEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.startGeneralEntity(string2, xMLResourceIdentifier, string3, augmentations);
        }
    }

    @Override
    public void textDecl(String string2, String string3, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.textDecl(string2, string3, augmentations);
        }
    }

    @Override
    public void xmlDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            xMLDocumentHandler.xmlDecl(string2, string3, string4, augmentations);
        }
    }
}

