/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;

public abstract class XMLScanner
implements XMLComponent {
    protected static final boolean DEBUG_ATTR_NORMALIZATION = false;
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String fAmpSymbol;
    protected static final String fAposSymbol;
    protected static final String fEncodingSymbol;
    protected static final String fGtSymbol;
    protected static final String fLtSymbol;
    protected static final String fQuotSymbol;
    protected static final String fStandaloneSymbol;
    protected static final String fVersionSymbol;
    protected String fCharRefLiteral = null;
    protected int fEntityDepth;
    protected XMLEntityManager fEntityManager;
    protected XMLEntityScanner fEntityScanner;
    protected XMLErrorReporter fErrorReporter;
    protected boolean fNotifyCharRefs = false;
    protected boolean fReportEntity;
    protected XMLResourceIdentifierImpl fResourceIdentifier;
    protected boolean fScanningAttribute;
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();
    protected SymbolTable fSymbolTable;
    protected boolean fValidation = false;

    static {
        fVersionSymbol = "version".intern();
        fEncodingSymbol = "encoding".intern();
        fStandaloneSymbol = "standalone".intern();
        fAmpSymbol = "amp".intern();
        fLtSymbol = "lt".intern();
        fGtSymbol = "gt".intern();
        fQuotSymbol = "quot".intern();
        fAposSymbol = "apos".intern();
    }

    public XMLScanner() {
        this.fResourceIdentifier = new XMLResourceIdentifierImpl();
    }

    private void init() {
        this.fEntityScanner = null;
        this.fEntityDepth = 0;
        this.fReportEntity = true;
        this.fResourceIdentifier.clear();
    }

    public void endEntity(String string2) throws XNIException {
        --this.fEntityDepth;
    }

    public boolean getFeature(String string2) throws XMLConfigurationException {
        if (VALIDATION.equals(string2)) {
            return this.fValidation;
        }
        if (NOTIFY_CHAR_REFS.equals(string2)) {
            return this.fNotifyCharRefs;
        }
        throw new XMLConfigurationException(0, string2);
    }

    @Override
    public abstract Boolean getFeatureDefault(String var1);

    @Override
    public abstract Object getPropertyDefault(String var1);

    @Override
    public abstract String[] getRecognizedFeatures();

    @Override
    public abstract String[] getRecognizedProperties();

    protected boolean isInvalid(int n) {
        return XMLChar.isInvalid(n);
    }

    protected boolean isInvalidLiteral(int n) {
        return XMLChar.isInvalid(n);
    }

    protected boolean isValidNameChar(int n) {
        return XMLChar.isName(n);
    }

    protected boolean isValidNameStartChar(int n) {
        return XMLChar.isNameStart(n);
    }

    protected void normalizeWhitespace(XMLString xMLString) {
        int n = xMLString.offset;
        int n2 = xMLString.length;
        int n3 = xMLString.offset;
        while (n3 < n + n2) {
            if (XMLChar.isSpace(xMLString.ch[n3])) {
                xMLString.ch[n3] = (char)32;
            }
            ++n3;
        }
        return;
    }

    protected void reportFatalError(String string2, Object[] objectArray) throws XNIException {
        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", string2, objectArray, (short)2);
    }

    protected void reset() {
        this.init();
        this.fValidation = true;
        this.fNotifyCharRefs = false;
    }

    @Override
    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)xMLComponentManager.getProperty(ENTITY_MANAGER);
        this.init();
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fNotifyCharRefs = xMLComponentManager.getFeature(NOTIFY_CHAR_REFS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNotifyCharRefs = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void scanAttributeValue(XMLString xMLString, XMLString xMLString2, String string2, XMLAttributes object, int n, boolean bl) throws IOException, XNIException {
        int n2;
        block28: {
            n2 = this.fEntityScanner.peekChar();
            if (n2 != 39 && n2 != 34) {
                this.reportFatalError("OpenQuoteExpected", new Object[]{string2});
            }
            this.fEntityScanner.scanChar();
            int n3 = this.fEntityDepth;
            n = this.fEntityScanner.scanLiteral(n2, xMLString);
            this.fStringBuffer2.clear();
            this.fStringBuffer2.append(xMLString);
            this.normalizeWhitespace(xMLString);
            if (n == n2) break block28;
            this.fScanningAttribute = true;
            this.fStringBuffer.clear();
            while (true) {
                int n4;
                block31: {
                    int n5;
                    block43: {
                        block40: {
                            block36: {
                                block41: {
                                    block39: {
                                        block42: {
                                            block38: {
                                                block29: {
                                                    block37: {
                                                        block35: {
                                                            block34: {
                                                                block33: {
                                                                    block32: {
                                                                        block30: {
                                                                            this.fStringBuffer.append(xMLString);
                                                                            if (n != 38) break block29;
                                                                            this.fEntityScanner.skipChar(38);
                                                                            if (n3 == this.fEntityDepth) {
                                                                                this.fStringBuffer2.append('&');
                                                                            }
                                                                            if (!this.fEntityScanner.skipChar(35)) break block30;
                                                                            if (n3 == this.fEntityDepth) {
                                                                                this.fStringBuffer2.append('#');
                                                                            }
                                                                            this.scanCharReferenceValue(this.fStringBuffer, this.fStringBuffer2);
                                                                            break block31;
                                                                        }
                                                                        object = this.fEntityScanner.scanName();
                                                                        if (object == null) {
                                                                            this.reportFatalError("NameRequiredInReference", null);
                                                                        } else if (n3 == this.fEntityDepth) {
                                                                            this.fStringBuffer2.append((String)object);
                                                                        }
                                                                        if (!this.fEntityScanner.skipChar(59)) {
                                                                            this.reportFatalError("SemicolonRequiredInReference", new Object[]{object});
                                                                        } else if (n3 == this.fEntityDepth) {
                                                                            this.fStringBuffer2.append(';');
                                                                        }
                                                                        if (object != fAmpSymbol) break block32;
                                                                        this.fStringBuffer.append('&');
                                                                        break block31;
                                                                    }
                                                                    if (object != fAposSymbol) break block33;
                                                                    this.fStringBuffer.append('\'');
                                                                    break block31;
                                                                }
                                                                if (object != fLtSymbol) break block34;
                                                                this.fStringBuffer.append('<');
                                                                break block31;
                                                            }
                                                            if (object != fGtSymbol) break block35;
                                                            object = this.fStringBuffer;
                                                            n5 = n = 62;
                                                            break block36;
                                                        }
                                                        if (object != fQuotSymbol) break block37;
                                                        this.fStringBuffer.append('\"');
                                                        break block31;
                                                    }
                                                    if (this.fEntityManager.isExternalEntity((String)object)) {
                                                        this.reportFatalError("ReferenceToExternalEntity", new Object[]{object});
                                                        break block31;
                                                    } else {
                                                        if (!this.fEntityManager.isDeclaredEntity((String)object)) {
                                                            if (bl) {
                                                                if (this.fValidation) {
                                                                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{object}, (short)1);
                                                                }
                                                            } else {
                                                                this.reportFatalError("EntityNotDeclared", new Object[]{object});
                                                            }
                                                        }
                                                        this.fEntityManager.startEntity((String)object, true);
                                                    }
                                                    break block31;
                                                }
                                                if (n != 60) break block38;
                                                this.reportFatalError("LessthanInAttValue", new Object[]{null, string2});
                                                this.fEntityScanner.scanChar();
                                                if (n3 != this.fEntityDepth) break block31;
                                                break block39;
                                            }
                                            if (n == 37 || n == 93) break block40;
                                            n4 = 10;
                                            if (n == 10 || n == 13) break block41;
                                            if (n == -1 || !XMLChar.isHighSurrogate(n)) break block42;
                                            if (this.scanSurrogates(this.fStringBuffer3)) {
                                                this.fStringBuffer.append(this.fStringBuffer3);
                                                if (n3 == this.fEntityDepth) {
                                                    this.fStringBuffer2.append(this.fStringBuffer3);
                                                }
                                            }
                                            break block31;
                                        }
                                        if (n == -1 || !this.isInvalidLiteral(n)) break block31;
                                        this.reportFatalError("InvalidCharInAttValue", new Object[]{Integer.toString(n, 16)});
                                        this.fEntityScanner.scanChar();
                                        if (n3 != this.fEntityDepth) break block31;
                                    }
                                    object = this.fStringBuffer2;
                                    n5 = n = (int)((char)n);
                                    break block43;
                                }
                                this.fEntityScanner.scanChar();
                                this.fStringBuffer.append(' ');
                                if (n3 != this.fEntityDepth) break block31;
                                object = this.fStringBuffer2;
                                n5 = n4;
                            }
                            ((XMLStringBuffer)object).append((char)n5);
                            break block31;
                        }
                        this.fEntityScanner.scanChar();
                        object = this.fStringBuffer;
                        n5 = n;
                        ((XMLStringBuffer)object).append((char)n5);
                        if (n3 != this.fEntityDepth) break block31;
                        object = this.fStringBuffer2;
                    }
                    ((XMLStringBuffer)object).append((char)n5);
                }
                n4 = this.fEntityScanner.scanLiteral(n2, xMLString);
                if (n3 == this.fEntityDepth) {
                    this.fStringBuffer2.append(xMLString);
                }
                this.normalizeWhitespace(xMLString);
                n = n4;
                if (n4 != n2) continue;
                n = n4;
                if (n3 == this.fEntityDepth) break;
            }
            this.fStringBuffer.append(xMLString);
            xMLString.setValues(this.fStringBuffer);
            this.fScanningAttribute = false;
        }
        xMLString2.setValues(this.fStringBuffer2);
        if (this.fEntityScanner.scanChar() != n2) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{string2});
        }
    }

    protected int scanCharReferenceValue(XMLStringBuffer object, XMLStringBuffer object2) throws IOException, XNIException {
        char c;
        int n;
        boolean bl;
        if (this.fEntityScanner.skipChar(120)) {
            if (object2 != null) {
                ((XMLStringBuffer)object2).append('x');
            }
            this.fStringBuffer3.clear();
            do {
                if (!(bl = (n = this.fEntityScanner.peekChar()) >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70)) continue;
                if (object2 != null) {
                    ((XMLStringBuffer)object2).append((char)n);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)n);
            } while (bl);
            bl = true;
        } else {
            this.fStringBuffer3.clear();
            do {
                if (!(bl = (n = this.fEntityScanner.peekChar()) >= 48 && n <= 57)) continue;
                if (object2 != null) {
                    ((XMLStringBuffer)object2).append((char)n);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)n);
            } while (bl);
            bl = false;
        }
        if (!this.fEntityScanner.skipChar(59)) {
            this.reportFatalError("SemicolonRequiredInCharRef", null);
        }
        if (object2 != null) {
            ((XMLStringBuffer)object2).append(';');
        }
        object2 = this.fStringBuffer3.toString();
        n = bl ? 16 : 10;
        try {
            n = Integer.parseInt((String)object2, n);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (this.isInvalid(n)) {
            this.reportFatalError("InvalidCharRef", new Object[]{Integer.toString(n, 16)});
        }
        if (!XMLChar.isSupplemental(n)) {
            char c2;
            c = c2 = (char)n;
        } else {
            char c3;
            ((XMLStringBuffer)object).append(XMLChar.highSurrogate(n));
            c = c3 = XMLChar.lowSurrogate(n);
        }
        ((XMLStringBuffer)object).append(c);
        if (this.fNotifyCharRefs && n != -1) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("#");
            object = bl ? "x" : "";
            ((StringBuffer)object2).append((String)object);
            ((StringBuffer)object2).append(this.fStringBuffer3.toString());
            object = ((StringBuffer)object2).toString();
            if (!this.fScanningAttribute) {
                this.fCharRefLiteral = object;
            }
        }
        return n;
    }

    protected void scanComment(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        xMLStringBuffer.clear();
        while (true) {
            if (!this.fEntityScanner.scanData("--", xMLStringBuffer)) {
                if (!this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("DashDashInComment", null);
                }
                return;
            }
            int n = this.fEntityScanner.peekChar();
            if (n == -1) continue;
            if (XMLChar.isHighSurrogate(n)) {
                this.scanSurrogates(xMLStringBuffer);
            }
            if (!this.isInvalidLiteral(n)) continue;
            this.reportFatalError("InvalidCharInComment", new Object[]{Integer.toHexString(n)});
            this.fEntityScanner.scanChar();
        }
    }

    protected void scanExternalID(String[] stringArray, boolean bl) throws IOException, XNIException {
        Object object;
        Object object2;
        boolean bl2 = this.fEntityScanner.skipString("PUBLIC");
        Object object3 = null;
        if (bl2) {
            if (!this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterPUBLIC", null);
            }
            this.scanPubidLiteral(this.fString);
            object = object2 = this.fString.toString();
            if (!this.fEntityScanner.skipSpaces()) {
                object = object2;
                if (!bl) {
                    this.reportFatalError("SpaceRequiredBetweenPublicAndSystem", null);
                    object = object2;
                }
            }
        } else {
            object = null;
        }
        if (object != null || this.fEntityScanner.skipString("SYSTEM")) {
            int n;
            if (object == null && !this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterSYSTEM", null);
            }
            if ((n = this.fEntityScanner.peekChar()) != 39 && n != 34) {
                if (object != null && bl) {
                    stringArray[0] = null;
                    stringArray[1] = object;
                    return;
                }
                this.reportFatalError("QuoteRequiredInSystemID", null);
            }
            this.fEntityScanner.scanChar();
            object3 = object2 = this.fString;
            if (this.fEntityScanner.scanLiteral(n, (XMLString)object2) != n) {
                this.fStringBuffer.clear();
                do {
                    this.fStringBuffer.append((XMLString)object2);
                    int n2 = this.fEntityScanner.peekChar();
                    if (!XMLChar.isMarkup(n2) && n2 != 93) continue;
                    this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
                } while (this.fEntityScanner.scanLiteral(n, (XMLString)object2) != n);
                this.fStringBuffer.append((XMLString)object2);
                object3 = this.fStringBuffer;
            }
            object3 = ((XMLString)object3).toString();
            if (!this.fEntityScanner.skipChar(n)) {
                this.reportFatalError("SystemIDUnterminated", null);
            }
        }
        stringArray[0] = object3;
        stringArray[1] = object;
    }

    protected void scanPI() throws IOException, XNIException {
        this.fReportEntity = false;
        String string2 = this.fEntityScanner.scanName();
        if (string2 == null) {
            this.reportFatalError("PITargetRequired", null);
        }
        this.scanPIData(string2, this.fString);
        this.fReportEntity = true;
    }

    protected void scanPIData(String string2, XMLString xMLString) throws IOException, XNIException {
        int n;
        if (string2.length() == 3) {
            n = Character.toLowerCase(string2.charAt(0));
            char c = Character.toLowerCase(string2.charAt(1));
            char c2 = Character.toLowerCase(string2.charAt(2));
            if (n == 120 && c == 'm' && c2 == 'l') {
                this.reportFatalError("ReservedPITarget", null);
            }
        }
        if (!this.fEntityScanner.skipSpaces()) {
            if (this.fEntityScanner.skipString("?>")) {
                xMLString.clear();
                return;
            }
            this.reportFatalError("SpaceRequiredInPI", null);
        }
        this.fStringBuffer.clear();
        if (this.fEntityScanner.scanData("?>", this.fStringBuffer)) {
            do {
                if ((n = this.fEntityScanner.peekChar()) == -1) continue;
                if (XMLChar.isHighSurrogate(n)) {
                    this.scanSurrogates(this.fStringBuffer);
                    continue;
                }
                if (!this.isInvalidLiteral(n)) continue;
                this.reportFatalError("InvalidCharInPI", new Object[]{Integer.toHexString(n)});
                this.fEntityScanner.scanChar();
            } while (this.fEntityScanner.scanData("?>", this.fStringBuffer));
        }
        xMLString.setValues(this.fStringBuffer);
    }

    public String scanPseudoAttribute(boolean bl, XMLString object) throws IOException, XNIException {
        String string2;
        String string3 = this.fEntityScanner.scanName();
        XMLEntityManager.print(this.fEntityManager.getCurrentEntity());
        if (string3 == null) {
            this.reportFatalError("PseudoAttrNameExpected", null);
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            string2 = bl ? "EqRequiredInTextDecl" : "EqRequiredInXMLDecl";
            this.reportFatalError(string2, new Object[]{string3});
        }
        this.fEntityScanner.skipSpaces();
        int n = this.fEntityScanner.peekChar();
        if (n != 39 && n != 34) {
            string2 = bl ? "QuoteRequiredInTextDecl" : "QuoteRequiredInXMLDecl";
            this.reportFatalError(string2, new Object[]{string3});
        }
        this.fEntityScanner.scanChar();
        int n2 = this.fEntityScanner.scanLiteral(n, (XMLString)object);
        if (n2 != n) {
            int n3;
            this.fStringBuffer2.clear();
            do {
                this.fStringBuffer2.append((XMLString)object);
                if (n2 != -1) {
                    if (n2 != 38 && n2 != 37 && n2 != 60 && n2 != 93) {
                        if (XMLChar.isHighSurrogate(n2)) {
                            this.scanSurrogates(this.fStringBuffer2);
                        } else if (this.isInvalidLiteral(n2)) {
                            string2 = bl ? "InvalidCharInTextDecl" : "InvalidCharInXMLDecl";
                            this.reportFatalError(string2, new Object[]{Integer.toString(n2, 16)});
                            this.fEntityScanner.scanChar();
                        }
                    } else {
                        this.fStringBuffer2.append((char)this.fEntityScanner.scanChar());
                    }
                }
                n2 = n3 = this.fEntityScanner.scanLiteral(n, (XMLString)object);
            } while (n3 != n);
            this.fStringBuffer2.append((XMLString)object);
            ((XMLString)object).setValues(this.fStringBuffer2);
        }
        if (!this.fEntityScanner.skipChar(n)) {
            object = bl ? "CloseQuoteMissingInTextDecl" : "CloseQuoteMissingInXMLDecl";
            this.reportFatalError((String)object, new Object[]{string3});
        }
        return string3;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean scanPubidLiteral(XMLString var1_1) throws IOException, XNIException {
        var2_2 = this.fEntityScanner.scanChar();
        if (var2_2 != 39 && var2_2 != 34) {
            var1_1 = "QuoteRequiredInPublicID";
lbl4:
            // 2 sources

            while (true) {
                this.reportFatalError((String)var1_1, null);
                return false;
            }
        }
        this.fStringBuffer.clear();
        var3_3 = true;
        var4_4 = true;
        while (true) {
            if ((var5_5 = this.fEntityScanner.scanChar()) != 32 && var5_5 != 10 && var5_5 != 13) {
                if (var5_5 == var2_2) {
                    if (var3_3) {
                        var6_6 = this.fStringBuffer;
                        --var6_6.length;
                    }
                    var1_1.setValues(this.fStringBuffer);
                    return var4_4;
                }
                if (XMLChar.isPubid(var5_5)) {
                    this.fStringBuffer.append((char)var5_5);
                    var3_3 = false;
                    continue;
                }
                if (var5_5 == -1) {
                    var1_1 = "PublicIDUnterminated";
                    ** continue;
                }
                this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(var5_5)});
                var4_4 = false;
                continue;
            }
            if (var3_3) continue;
            this.fStringBuffer.append(' ');
            var3_3 = true;
        }
    }

    protected boolean scanSurrogates(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        int n = this.fEntityScanner.scanChar();
        int n2 = this.fEntityScanner.peekChar();
        if (!XMLChar.isLowSurrogate(n2)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(n, 16)});
            return false;
        }
        this.fEntityScanner.scanChar();
        char c = (char)n;
        char c2 = (char)n2;
        n2 = XMLChar.supplemental(c, c2);
        if (this.isInvalid(n2)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(n2, 16)});
            return false;
        }
        xMLStringBuffer.append(c);
        xMLStringBuffer.append(c2);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void scanXMLDeclOrTextDecl(boolean var1_1, String[] var2_2) throws IOException, XNIException {
        var3_3 = this.fEntityScanner.skipSpaces();
        var4_4 = this.fEntityManager.getCurrentEntity();
        var5_5 = var4_4.literal;
        var4_4.literal = false;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = null;
        var9_9 = null;
        var10_10 = null;
        while (true) {
            block31: {
                block32: {
                    block35: {
                        block33: {
                            block34: {
                                if (this.fEntityScanner.peekChar() == 63) {
                                    if (var5_5) {
                                        var4_4.literal = true;
                                    }
                                    if (var1_1 && var6_6 != 3) {
                                        this.reportFatalError("MorePseudoAttributes", null);
                                    }
                                    if (var1_1) {
                                        if (var7_7 == 0 && var9_9 == null) {
                                            this.reportFatalError("EncodingDeclRequired", null);
                                        }
                                    } else if (var7_7 == 0 && var8_8 == null) {
                                        this.reportFatalError("VersionInfoRequired", null);
                                    }
                                    if (!this.fEntityScanner.skipChar(63)) {
                                        this.reportFatalError("XMLDeclUnterminated", null);
                                    }
                                    if (!this.fEntityScanner.skipChar(62)) {
                                        this.reportFatalError("XMLDeclUnterminated", null);
                                    }
                                    var2_2[0] = var8_8;
                                    var2_2[1] = var9_9;
                                    var2_2[2] = var10_10;
                                    return;
                                }
                                var11_11 = this.scanPseudoAttribute(var1_1, this.fString);
                                var12_12 = "SpaceRequiredBeforeEncodingInTextDecl";
                                if (var6_6 == 0) break block32;
                                if (var6_6 == 1) break block33;
                                if (var6_6 != 2) {
                                    this.reportFatalError("NoMorePseudoAttributes", null);
lbl36:
                                    // 2 sources

                                    while (true) {
                                        var7_7 = var6_6;
                                        var12_12 = var9_9;
                                        break block31;
                                        break;
                                    }
                                }
                                if (var11_11 != XMLScanner.fStandaloneSymbol) break block34;
                                if (!var3_3) {
                                    this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                                }
                                var12_12 = var10_10 = this.fString.toString();
                                if (var10_10.equals("yes")) ** GOTO lbl50
                                var12_12 = var10_10;
                                if (var10_10.equals("no")) ** GOTO lbl50
                                var12_12 = var10_10;
lbl48:
                                // 2 sources

                                while (true) {
                                    this.reportFatalError("SDDeclInvalid", null);
lbl50:
                                    // 5 sources

                                    while (true) {
                                        var10_10 = var12_12;
                                        var12_12 = var9_9;
                                        while (true) {
                                            var7_7 = 3;
                                            break block31;
                                            break;
                                        }
                                        break;
                                    }
                                    break;
                                }
                            }
                            while (true) {
                                this.reportFatalError("EncodingDeclRequired", null);
                                ** continue;
                                break;
                            }
                        }
                        if (var11_11 != XMLScanner.fEncodingSymbol) break block35;
                        if (!var3_3) {
                            if (!var1_1) {
                                var12_12 = "SpaceRequiredBeforeEncodingInXMLDecl";
                            }
                            this.reportFatalError(var12_12, null);
                        }
                        var12_12 = this.fString.toString();
                        var7_7 = var1_1 ? 3 : 2;
                        break block31;
                    }
                    if (var1_1 || var11_11 != XMLScanner.fStandaloneSymbol) ** continue;
                    if (!var3_3) {
                        this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                    }
                    var12_12 = var10_10 = this.fString.toString();
                    if (var10_10.equals("yes")) ** GOTO lbl50
                    var12_12 = var10_10;
                    if (!var10_10.equals("no")) ** break;
                    ** continue;
                    var12_12 = var10_10;
                    ** continue;
                }
                if (var11_11 == XMLScanner.fVersionSymbol) {
                    if (!var3_3) {
                        var12_12 = var1_1 != false ? "SpaceRequiredBeforeVersionInTextDecl" : "SpaceRequiredBeforeVersionInXMLDecl";
                        this.reportFatalError(var12_12, null);
                    }
                    if (!this.versionSupported(var8_8 = this.fString.toString())) {
                        this.reportFatalError("VersionNotSupported", new Object[]{var8_8});
                    }
                    var7_7 = 1;
                    var12_12 = var9_9;
                } else if (var11_11 == XMLScanner.fEncodingSymbol) {
                    if (!var1_1) {
                        this.reportFatalError("VersionInfoRequired", null);
                    }
                    if (!var3_3) {
                        if (!var1_1) {
                            var12_12 = "SpaceRequiredBeforeEncodingInXMLDecl";
                        }
                        this.reportFatalError(var12_12, null);
                    }
                    var12_12 = this.fString.toString();
                    if (var1_1) ** continue;
                    var7_7 = 2;
                } else if (var1_1) {
                    this.reportFatalError("EncodingDeclRequired", null);
                    var7_7 = var6_6;
                    var12_12 = var9_9;
                } else {
                    this.reportFatalError("VersionInfoRequired", null);
                    var12_12 = var9_9;
                    var7_7 = var6_6;
                }
            }
            var3_3 = this.fEntityScanner.skipSpaces();
            var13_13 = 1;
            var6_6 = var7_7;
            var7_7 = var13_13;
            var9_9 = var12_12;
        }
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
        if (VALIDATION.equals(string2)) {
            this.fValidation = bl;
        } else if (NOTIFY_CHAR_REFS.equals(string2)) {
            this.fNotifyCharRefs = bl;
        }
    }

    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        if (string2.startsWith("http://apache.org/xml/properties/")) {
            if ((string2 = string2.substring(33)).equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
            } else if (string2.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
            } else if (string2.equals("internal/entity-manager")) {
                this.fEntityManager = (XMLEntityManager)object;
            }
        }
    }

    public void startEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3) throws XNIException {
        ++this.fEntityDepth;
        this.fEntityScanner = this.fEntityManager.getEntityScanner();
    }

    protected boolean versionSupported(String string2) {
        return string2.equals("1.0");
    }
}

