/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.EOFException;
import java.io.IOException;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLVersionDetector {
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final char[] XML11_VERSION = new char[]{'1', '.', '1'};
    protected static final String fVersionSymbol = "version".intern();
    protected static final String fXMLSymbol = "[xml]".intern();
    protected String fEncoding = null;
    protected XMLEntityManager fEntityManager;
    protected XMLErrorReporter fErrorReporter;
    private final char[] fExpectedVersionString;
    protected SymbolTable fSymbolTable;
    private XMLString fVersionNum = new XMLString();

    public XMLVersionDetector() {
        this.fExpectedVersionString = new char[]{'<', '?', 'x', 'm', 'l', ' ', 'v', 'e', 'r', 's', 'i', 'o', 'n', '=', ' ', ' ', ' ', ' ', ' '};
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixupCurrentEntity(XMLEntityManager object, char[] cArray, int n) {
        object = ((XMLEntityManager)object).getCurrentEntity();
        if (((XMLEntityManager.ScannedEntity)object).count - ((XMLEntityManager.ScannedEntity)object).position + n > ((XMLEntityManager.ScannedEntity)object).ch.length) {
            char[] cArray2 = ((XMLEntityManager.ScannedEntity)object).ch;
            ((XMLEntityManager.ScannedEntity)object).ch = new char[((XMLEntityManager.ScannedEntity)object).count + n - ((XMLEntityManager.ScannedEntity)object).position + 1];
            System.arraycopy(cArray2, 0, ((XMLEntityManager.ScannedEntity)object).ch, 0, cArray2.length);
        }
        if (((XMLEntityManager.ScannedEntity)object).position < n) {
            System.arraycopy(((XMLEntityManager.ScannedEntity)object).ch, ((XMLEntityManager.ScannedEntity)object).position, ((XMLEntityManager.ScannedEntity)object).ch, n, ((XMLEntityManager.ScannedEntity)object).count - ((XMLEntityManager.ScannedEntity)object).position);
            ((XMLEntityManager.ScannedEntity)object).count += n - ((XMLEntityManager.ScannedEntity)object).position;
        } else {
            for (int i = n; i < ((XMLEntityManager.ScannedEntity)object).position; ++i) {
                ((XMLEntityManager.ScannedEntity)object).ch[i] = (char)32;
            }
        }
        System.arraycopy(cArray, 0, ((XMLEntityManager.ScannedEntity)object).ch, 0, n);
        ((XMLEntityManager.ScannedEntity)object).position = 0;
        ((XMLEntityManager.ScannedEntity)object).lineNumber = 1;
        ((XMLEntityManager.ScannedEntity)object).columnNumber = 1;
    }

    public short determineDocVersion(XMLInputSource object) throws IOException {
        int n;
        int n2;
        block16: {
            block15: {
                block14: {
                    block13: {
                        XMLEntityManager xMLEntityManager = this.fEntityManager;
                        String string2 = fXMLSymbol;
                        n2 = 0;
                        this.fEncoding = xMLEntityManager.setupCurrentEntity(string2, (XMLInputSource)object, false, true);
                        this.fEntityManager.setScannerVersion((short)2);
                        object = this.fEntityManager.getEntityScanner();
                        if (((XMLEntityScanner)object).skipString("<?xml")) break block13;
                        return 1;
                    }
                    if (((XMLEntityScanner)object).skipSpaces()) break block14;
                    this.fixupCurrentEntity(this.fEntityManager, this.fExpectedVersionString, 5);
                    return 1;
                }
                if (((XMLEntityScanner)object).skipString("version")) break block15;
                this.fixupCurrentEntity(this.fEntityManager, this.fExpectedVersionString, 6);
                return 1;
            }
            ((XMLEntityScanner)object).skipSpaces();
            if (((XMLEntityScanner)object).scanChar() == 61) break block16;
            this.fixupCurrentEntity(this.fEntityManager, this.fExpectedVersionString, 13);
            return 1;
        }
        try {
            ((XMLEntityScanner)object).skipSpaces();
            n = ((XMLEntityScanner)object).scanChar();
            this.fExpectedVersionString[14] = (char)n;
            n = 0;
        }
        catch (EOFException eOFException) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "PrematureEOF", null, (short)2);
            return 1;
        }
        while (true) {
            block17: {
                if (n < XML11_VERSION.length) break block17;
                this.fExpectedVersionString[18] = (char)((XMLEntityScanner)object).scanChar();
                this.fixupCurrentEntity(this.fEntityManager, this.fExpectedVersionString, 19);
                n = n2;
                while (true) {
                    object = XML11_VERSION;
                    if (n >= ((Object)object).length || this.fExpectedVersionString[n + 15] != object[n]) {
                        if (n == ((Object)object).length) {
                            return 2;
                        }
                        return 1;
                    }
                    ++n;
                    continue;
                    break;
                }
            }
            this.fExpectedVersionString[n + 15] = (char)((XMLEntityScanner)object).scanChar();
            ++n;
            continue;
            break;
        }
    }

    public void reset(XMLComponentManager object) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)object.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)object.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)object.getProperty(ENTITY_MANAGER);
        int n = 14;
        while (n < ((Object)(object = (Object)this.fExpectedVersionString)).length) {
            object[n] = (char)32;
            ++n;
        }
        return;
    }

    public void startDocumentParsing(XMLEntityHandler xMLEntityHandler, short s) {
        short s2;
        XMLEntityManager xMLEntityManager;
        short s3 = 1;
        if (s == 1) {
            xMLEntityManager = this.fEntityManager;
            s2 = s3;
        } else {
            xMLEntityManager = this.fEntityManager;
            s2 = s = (short)2;
        }
        xMLEntityManager.setScannerVersion(s2);
        this.fEntityManager.setEntityHandler(xMLEntityHandler);
        xMLEntityHandler.startEntity(fXMLSymbol, this.fEntityManager.getCurrentResourceIdentifier(), this.fEncoding);
    }
}

