/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import org.apache.xerces.impl.XMLDTDScannerImpl;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.DTDGrammarBucket;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.dtd.XMLDTDProcessor;
import org.apache.xerces.util.DefaultErrorHandler;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLDTDLoader
extends XMLDTDProcessor
implements XMLGrammarLoader {
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String[] LOADER_RECOGNIZED_PROPERTIES;
    private static final String[] RECOGNIZED_FEATURES;
    protected static final String STANDARD_URI_CONFORMANT_FEATURE = "http://apache.org/xml/features/standard-uri-conformant";
    protected XMLDTDScannerImpl fDTDScanner;
    protected XMLEntityManager fEntityManager;
    protected XMLEntityResolver fEntityResolver;
    protected Locale fLocale;
    private boolean fStrictURI = false;

    static {
        RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/warn-on-duplicate-attdef", "http://apache.org/xml/features/scanner/notify-char-refs", STANDARD_URI_CONFORMANT_FEATURE};
        LOADER_RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", ERROR_HANDLER, ENTITY_RESOLVER, "http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/internal/validator/dtd"};
    }

    public XMLDTDLoader() {
        this(new SymbolTable());
    }

    public XMLDTDLoader(SymbolTable symbolTable) {
        this(symbolTable, null);
    }

    public XMLDTDLoader(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this(symbolTable, xMLGrammarPool, null, new XMLEntityManager());
    }

    XMLDTDLoader(SymbolTable object, XMLGrammarPool xMLGrammarPool, XMLErrorReporter xMLErrorReporter, XMLEntityResolver xMLEntityResolver) {
        this.fSymbolTable = object;
        this.fGrammarPool = xMLGrammarPool;
        object = xMLErrorReporter;
        if (xMLErrorReporter == null) {
            object = new XMLErrorReporter();
            ((XMLErrorReporter)object).setProperty(ERROR_HANDLER, new DefaultErrorHandler());
        }
        this.fErrorReporter = object;
        this.fEntityResolver = xMLEntityResolver;
        this.fEntityManager = xMLEntityResolver instanceof XMLEntityManager ? (XMLEntityManager)xMLEntityResolver : new XMLEntityManager();
        this.fEntityManager.setProperty("http://apache.org/xml/properties/internal/error-reporter", object);
        this.fDTDScanner = object = new XMLDTDScannerImpl(this.fSymbolTable, this.fErrorReporter, this.fEntityManager);
        ((XMLDTDScannerImpl)object).setDTDHandler(this);
        this.fDTDScanner.setDTDContentModelHandler(this);
        this.reset();
    }

    @Override
    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    @Override
    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    @Override
    public boolean getFeature(String string2) throws XMLConfigurationException {
        if (string2.equals("http://xml.org/sax/features/validation")) {
            return this.fValidation;
        }
        if (string2.equals("http://apache.org/xml/features/validation/warn-on-duplicate-attdef")) {
            return this.fWarnDuplicateAttdef;
        }
        if (string2.equals("http://apache.org/xml/features/scanner/notify-char-refs")) {
            return this.fDTDScanner.getFeature(string2);
        }
        throw new XMLConfigurationException(0, string2);
    }

    @Override
    public Locale getLocale() {
        return this.fLocale;
    }

    @Override
    public Object getProperty(String string2) throws XMLConfigurationException {
        if (string2.equals("http://apache.org/xml/properties/internal/symbol-table")) {
            return this.fSymbolTable;
        }
        if (string2.equals("http://apache.org/xml/properties/internal/error-reporter")) {
            return this.fErrorReporter;
        }
        if (string2.equals(ERROR_HANDLER)) {
            return this.fErrorReporter.getErrorHandler();
        }
        if (string2.equals(ENTITY_RESOLVER)) {
            return this.fEntityResolver;
        }
        if (string2.equals("http://apache.org/xml/properties/internal/grammar-pool")) {
            return this.fGrammarPool;
        }
        if (string2.equals("http://apache.org/xml/properties/internal/validator/dtd")) {
            return this.fValidator;
        }
        throw new XMLConfigurationException(0, string2);
    }

    @Override
    public String[] getRecognizedProperties() {
        return (String[])LOADER_RECOGNIZED_PROPERTIES.clone();
    }

    @Override
    public Grammar loadGrammar(XMLInputSource xMLInputSource) throws IOException, XNIException {
        this.reset();
        String string2 = XMLEntityManager.expandSystemId(xMLInputSource.getSystemId(), xMLInputSource.getBaseSystemId(), this.fStrictURI);
        this.fDTDGrammar = new DTDGrammar(this.fSymbolTable, new XMLDTDDescription(xMLInputSource.getPublicId(), xMLInputSource.getSystemId(), xMLInputSource.getBaseSystemId(), string2, null));
        this.fGrammarBucket = new DTDGrammarBucket();
        this.fGrammarBucket.setStandalone(false);
        this.fGrammarBucket.setActiveGrammar(this.fDTDGrammar);
        this.fDTDScanner.setInputSource(xMLInputSource);
        try {
            this.fDTDScanner.scanDTDExternalSubset(true);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (this.fDTDGrammar != null && this.fGrammarPool != null) {
            this.fGrammarPool.cacheGrammars("http://www.w3.org/TR/REC-xml", new Grammar[]{this.fDTDGrammar});
        }
        return this.fDTDGrammar;
    }

    @Override
    protected void reset() {
        super.reset();
        this.fDTDScanner.reset();
        this.fEntityManager.reset();
    }

    @Override
    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fEntityResolver = xMLEntityResolver;
    }

    @Override
    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, xMLErrorHandler);
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
        block6: {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!string2.equals("http://xml.org/sax/features/validation")) break block2;
                            this.fValidation = bl;
                            break block3;
                        }
                        if (!string2.equals("http://apache.org/xml/features/validation/warn-on-duplicate-attdef")) break block4;
                        this.fWarnDuplicateAttdef = bl;
                        break block3;
                    }
                    if (!string2.equals("http://apache.org/xml/features/scanner/notify-char-refs")) break block5;
                    this.fDTDScanner.setFeature(string2, bl);
                    break block3;
                }
                if (!string2.equals(STANDARD_URI_CONFORMANT_FEATURE)) break block6;
                this.fStrictURI = bl;
            }
            return;
        }
        throw new XMLConfigurationException(0, string2);
    }

    @Override
    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        block7: {
            block6: {
                block5: {
                    if (!string2.equals("http://apache.org/xml/properties/internal/symbol-table")) break block5;
                    this.fSymbolTable = (SymbolTable)object;
                    break block6;
                }
                if (!string2.equals("http://apache.org/xml/properties/internal/error-reporter")) break block7;
                this.fErrorReporter = (XMLErrorReporter)object;
            }
            this.fDTDScanner.setProperty(string2, object);
            this.fEntityManager.setProperty(string2, object);
            return;
        }
        if (string2.equals(ERROR_HANDLER)) {
            this.fErrorReporter.setProperty(string2, object);
            return;
        }
        if (string2.equals(ENTITY_RESOLVER)) {
            this.fEntityResolver = (XMLEntityResolver)object;
            return;
        }
        if (!string2.equals("http://apache.org/xml/properties/internal/grammar-pool")) throw new XMLConfigurationException(0, string2);
        this.fGrammarPool = (XMLGrammarPool)object;
    }
}

