/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.DTDGrammarBucket;
import org.apache.xerces.impl.dtd.XMLDTDValidator;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDContentModelFilter;
import org.apache.xerces.xni.parser.XMLDTDContentModelSource;
import org.apache.xerces.xni.parser.XMLDTDFilter;
import org.apache.xerces.xni.parser.XMLDTDSource;

public class XMLDTDProcessor
implements XMLComponent,
XMLDTDFilter,
XMLDTDContentModelFilter {
    protected static final String DTD_VALIDATOR = "http://apache.org/xml/properties/internal/validator/dtd";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final Boolean[] FEATURE_DEFAULTS;
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    private static final Object[] PROPERTY_DEFAULTS;
    private static final String[] RECOGNIZED_FEATURES;
    private static final String[] RECOGNIZED_PROPERTIES;
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final int TOP_LEVEL_SCOPE = -1;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String WARN_ON_DUPLICATE_ATTDEF = "http://apache.org/xml/features/validation/warn-on-duplicate-attdef";
    protected XMLDTDContentModelHandler fDTDContentModelHandler;
    protected XMLDTDContentModelSource fDTDContentModelSource;
    private String fDTDElementDeclName = null;
    private Vector fDTDElementDecls;
    protected DTDGrammar fDTDGrammar;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDSource fDTDSource;
    protected boolean fDTDValidation;
    private XMLEntityDecl fEntityDecl = new XMLEntityDecl();
    protected XMLErrorReporter fErrorReporter;
    protected DTDGrammarBucket fGrammarBucket;
    protected XMLGrammarPool fGrammarPool;
    protected boolean fInDTDIgnore;
    protected Locale fLocale;
    private boolean fMixed;
    private Vector fMixedElementTypes;
    private Hashtable fNDataDeclNotations = new Hashtable();
    private Hashtable fNotationEnumVals;
    private boolean fPerformValidation;
    protected SymbolTable fSymbolTable;
    private Hashtable fTableOfIDAttributeNames;
    private Hashtable fTableOfNOTATIONAttributeNames;
    protected boolean fValidation;
    protected XMLDTDValidator fValidator;
    protected boolean fWarnDuplicateAttdef;

    static {
        RECOGNIZED_FEATURES = new String[]{VALIDATION, WARN_ON_DUPLICATE_ATTDEF, NOTIFY_CHAR_REFS};
        FEATURE_DEFAULTS = new Boolean[]{null, Boolean.FALSE, null};
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER, GRAMMAR_POOL, DTD_VALIDATOR};
        PROPERTY_DEFAULTS = new Object[]{null, null, null, null};
    }

    public XMLDTDProcessor() {
        this.fMixedElementTypes = new Vector();
        this.fDTDElementDecls = new Vector();
    }

    protected static void checkStandaloneEntityRef(String string2, DTDGrammar dTDGrammar, XMLEntityDecl xMLEntityDecl, XMLErrorReporter xMLErrorReporter) throws XNIException {
        int n = dTDGrammar.getEntityDeclIndex(string2);
        if (n > -1) {
            dTDGrammar.getEntityDecl(n, xMLEntityDecl);
            if (xMLEntityDecl.inExternal) {
                xMLErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_REFERENCE_TO_EXTERNALLY_DECLARED_ENTITY_WHEN_STANDALONE", new Object[]{string2}, (short)1);
            }
        }
    }

    private void init() {
        if (this.fValidation) {
            if (this.fNotationEnumVals == null) {
                this.fNotationEnumVals = new Hashtable();
            }
            this.fNotationEnumVals.clear();
            this.fTableOfIDAttributeNames = new Hashtable();
            this.fTableOfNOTATIONAttributeNames = new Hashtable();
        }
    }

    private boolean normalizeDefaultAttrValue(XMLString xMLString) {
        int n = xMLString.length;
        n = xMLString.offset;
        int n2 = xMLString.offset + xMLString.length;
        int n3 = xMLString.offset;
        boolean bl = true;
        while (true) {
            boolean bl2;
            int n4;
            if (n3 >= n2) {
                if (n != n2) {
                    n4 = n;
                    if (bl) {
                        n4 = n - 1;
                    }
                    xMLString.length = n4 - xMLString.offset;
                    return true;
                }
                return false;
            }
            if (xMLString.ch[n3] == ' ') {
                n4 = n;
                bl2 = bl;
                if (!bl) {
                    xMLString.ch[n] = (char)32;
                    n4 = n + 1;
                    bl2 = true;
                }
            } else {
                if (n != n3) {
                    xMLString.ch[n] = xMLString.ch[n3];
                }
                n4 = n + 1;
                bl2 = false;
            }
            ++n3;
            n = n4;
            bl = bl2;
        }
    }

    @Override
    public void any(Augmentations augmentations) throws XNIException {
        XMLDTDContentModelHandler xMLDTDContentModelHandler = this.fDTDGrammar;
        if (xMLDTDContentModelHandler != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).any(augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.any(augmentations);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void attributeDecl(String string2, String string3, String string4, String[] stringArray, String string5, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        Object object;
        block20: {
            boolean bl;
            block19: {
                block23: {
                    StringTokenizer stringTokenizer;
                    block24: {
                        int n;
                        block22: {
                            block21: {
                                if (string4 != XMLSymbols.fCDATASymbol && xMLString != null) {
                                    this.normalizeDefaultAttrValue(xMLString);
                                }
                                if (!this.fValidation) break block20;
                                object = this.fDTDGrammar;
                                if (object == null) {
                                    object = this.fGrammarBucket.getActiveGrammar();
                                }
                                if (((DTDGrammar)object).getAttributeDeclIndex(((DTDGrammar)object).getElementDeclIndex(string2), string3) != -1) {
                                    if (this.fWarnDuplicateAttdef) {
                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ATTRIBUTE_DEFINITION", new Object[]{string2, string3}, (short)0);
                                    }
                                    bl = true;
                                } else {
                                    bl = false;
                                }
                                if (string4 == XMLSymbols.fIDSymbol) {
                                    if (xMLString != null && xMLString.length != 0 && (string5 == null || string5 != XMLSymbols.fIMPLIEDSymbol && string5 != XMLSymbols.fREQUIREDSymbol)) {
                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "IDDefaultTypeInvalid", new Object[]{string3}, (short)1);
                                    }
                                    if (!this.fTableOfIDAttributeNames.containsKey(string2)) {
                                        this.fTableOfIDAttributeNames.put(string2, string3);
                                    } else if (!bl) {
                                        object = (String)this.fTableOfIDAttributeNames.get(string2);
                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_MORE_THAN_ONE_ID_ATTRIBUTE", new Object[]{string2, object, string3}, (short)1);
                                    }
                                }
                                if (string4 == XMLSymbols.fNOTATIONSymbol) {
                                    n = 0;
                                    while (true) {
                                        if (n >= stringArray.length) {
                                            if (!this.fTableOfNOTATIONAttributeNames.containsKey(string2)) {
                                                this.fTableOfNOTATIONAttributeNames.put(string2, string3);
                                                break;
                                            }
                                            if (bl) break;
                                            object = (String)this.fTableOfNOTATIONAttributeNames.get(string2);
                                            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_MORE_THAN_ONE_NOTATION_ATTRIBUTE", new Object[]{string2, object, string3}, (short)1);
                                            break;
                                        }
                                        this.fNotationEnumVals.put(stringArray[n], string3);
                                        ++n;
                                    }
                                }
                                if (xMLString == null || string5 != null && (string5 == null || string5 != XMLSymbols.fFIXEDSymbol)) break block20;
                                object = xMLString.toString();
                                if (string4 == XMLSymbols.fNMTOKENSSymbol || string4 == XMLSymbols.fENTITIESSymbol || string4 == XMLSymbols.fIDREFSSymbol) break block21;
                                bl = !(string4 != XMLSymbols.fENTITYSymbol && string4 != XMLSymbols.fIDSymbol && string4 != XMLSymbols.fIDREFSymbol && string4 != XMLSymbols.fNOTATIONSymbol ? (string4 == XMLSymbols.fNMTOKENSymbol || string4 == XMLSymbols.fENUMERATIONSymbol) && !this.isValidNmtoken((String)object) : !this.isValidName((String)object));
                                if (string4 != XMLSymbols.fNOTATIONSymbol && string4 != XMLSymbols.fENUMERATIONSymbol) break block19;
                                bl = false;
                                break block22;
                            }
                            stringTokenizer = new StringTokenizer((String)object);
                            if (!stringTokenizer.hasMoreTokens()) break block23;
                            break block24;
                        }
                        for (n = 0; n < stringArray.length; ++n) {
                            if (!xMLString.equals(stringArray[n])) continue;
                            bl = true;
                        }
                        break block19;
                    }
                    do {
                        String string6 = stringTokenizer.nextToken();
                        if (!(string4 == XMLSymbols.fNMTOKENSSymbol ? !this.isValidNmtoken(string6) : (string4 == XMLSymbols.fENTITIESSymbol || string4 == XMLSymbols.fIDREFSSymbol) && !this.isValidName(string6))) continue;
                        bl = false;
                        break block19;
                    } while (stringTokenizer.hasMoreTokens());
                }
                bl = true;
            }
            if (!bl) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ATT_DEFAULT_INVALID", new Object[]{string3, object}, (short)1);
            }
        }
        if ((object = this.fDTDGrammar) != null) {
            ((DTDGrammar)object).attributeDecl(string2, string3, string4, stringArray, string5, xMLString, xMLString2, augmentations);
        }
        if ((object = this.fDTDHandler) != null) {
            object.attributeDecl(string2, string3, string4, stringArray, string5, xMLString, xMLString2, augmentations);
        }
    }

    @Override
    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).comment(xMLString, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.comment(xMLString, augmentations);
        }
    }

    @Override
    public void element(String string2, Augmentations augmentations) throws XNIException {
        XMLDTDContentModelHandler xMLDTDContentModelHandler;
        if (this.fMixed && this.fValidation) {
            if (this.fMixedElementTypes.contains(string2)) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "DuplicateTypeInMixedContent", new Object[]{this.fDTDElementDeclName, string2}, (short)1);
            } else {
                this.fMixedElementTypes.addElement(string2);
            }
        }
        if ((xMLDTDContentModelHandler = this.fDTDGrammar) != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).element(string2, augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.element(string2, augmentations);
        }
    }

    @Override
    public void elementDecl(String string2, String string3, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler;
        if (this.fValidation) {
            if (this.fDTDElementDecls.contains(string2)) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ELEMENT_ALREADY_DECLARED", new Object[]{string2}, (short)1);
            } else {
                this.fDTDElementDecls.addElement(string2);
            }
        }
        if ((xMLDTDHandler = this.fDTDGrammar) != null) {
            ((DTDGrammar)xMLDTDHandler).elementDecl(string2, string3, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.elementDecl(string2, string3, augmentations);
        }
    }

    @Override
    public void empty(Augmentations augmentations) throws XNIException {
        XMLDTDContentModelHandler xMLDTDContentModelHandler = this.fDTDGrammar;
        if (xMLDTDContentModelHandler != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).empty(augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.empty(augmentations);
        }
    }

    @Override
    public void endAttlist(Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).endAttlist(augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.endAttlist(augmentations);
        }
    }

    @Override
    public void endConditional(Augmentations augmentations) throws XNIException {
        this.fInDTDIgnore = false;
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).endConditional(augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.endConditional(augmentations);
        }
    }

    @Override
    public void endContentModel(Augmentations augmentations) throws XNIException {
        XMLDTDContentModelHandler xMLDTDContentModelHandler = this.fDTDGrammar;
        if (xMLDTDContentModelHandler != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).endContentModel(augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.endContentModel(augmentations);
        }
    }

    @Override
    public void endDTD(Augmentations augmentations) throws XNIException {
        Object object = this.fDTDGrammar;
        if (object != null) {
            ((DTDGrammar)object).endDTD(augmentations);
            object = this.fGrammarPool;
            if (object != null) {
                object.cacheGrammars("http://www.w3.org/TR/REC-xml", new Grammar[]{this.fDTDGrammar});
            }
        }
        if (this.fValidation) {
            object = this.fDTDGrammar;
            if (object == null) {
                object = this.fGrammarBucket.getActiveGrammar();
            }
            Object object2 = this.fNDataDeclNotations.keys();
            block0: while (true) {
                String string2;
                Object object3;
                if (!object2.hasMoreElements()) {
                    object3 = this.fNotationEnumVals.keys();
                    while (true) {
                        if (!object3.hasMoreElements()) {
                            this.fTableOfIDAttributeNames = null;
                            this.fTableOfNOTATIONAttributeNames = null;
                            break block0;
                        }
                        object2 = (String)object3.nextElement();
                        string2 = (String)this.fNotationEnumVals.get(object2);
                        if (((DTDGrammar)object).getNotationDeclIndex((String)object2) != -1) continue;
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_NOTATION_NOT_DECLARED_FOR_NOTATIONTYPE_ATTRIBUTE", new Object[]{string2, object2}, (short)1);
                    }
                }
                object3 = (String)object2.nextElement();
                string2 = (String)this.fNDataDeclNotations.get(object3);
                if (((DTDGrammar)object).getNotationDeclIndex(string2) != -1) continue;
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_NOTATION_NOT_DECLARED_FOR_UNPARSED_ENTITYDECL", new Object[]{object3, string2}, (short)1);
            }
        }
        if ((object = this.fDTDHandler) != null) {
            object.endDTD(augmentations);
        }
    }

    @Override
    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).endExternalSubset(augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.endExternalSubset(augmentations);
        }
    }

    @Override
    public void endGroup(Augmentations augmentations) throws XNIException {
        XMLDTDContentModelHandler xMLDTDContentModelHandler = this.fDTDGrammar;
        if (xMLDTDContentModelHandler != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).endGroup(augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.endGroup(augmentations);
        }
    }

    @Override
    public void endParameterEntity(String string2, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).endParameterEntity(string2, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.endParameterEntity(string2, augmentations);
        }
    }

    @Override
    public void externalEntityDecl(String string2, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler == null) {
            xMLDTDHandler = this.fGrammarBucket.getActiveGrammar();
        }
        if (((DTDGrammar)xMLDTDHandler).getEntityDeclIndex(string2) == -1) {
            xMLDTDHandler = this.fDTDGrammar;
            if (xMLDTDHandler != null) {
                ((DTDGrammar)xMLDTDHandler).externalEntityDecl(string2, xMLResourceIdentifier, augmentations);
            }
            if ((xMLDTDHandler = this.fDTDHandler) != null) {
                xMLDTDHandler.externalEntityDecl(string2, xMLResourceIdentifier, augmentations);
            }
        }
    }

    @Override
    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    @Override
    public XMLDTDContentModelSource getDTDContentModelSource() {
        return this.fDTDContentModelSource;
    }

    @Override
    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    @Override
    public XMLDTDSource getDTDSource() {
        return this.fDTDSource;
    }

    @Override
    public Boolean getFeatureDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_FEATURES).length) {
            if (stringArray[n].equals(string2)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public Object getPropertyDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_PROPERTIES).length) {
            if (stringArray[n].equals(string2)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    @Override
    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    @Override
    public void ignoredCharacters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).ignoredCharacters(xMLString, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.ignoredCharacters(xMLString, augmentations);
        }
    }

    @Override
    public void internalEntityDecl(String string2, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler == null) {
            xMLDTDHandler = this.fGrammarBucket.getActiveGrammar();
        }
        if (((DTDGrammar)xMLDTDHandler).getEntityDeclIndex(string2) == -1) {
            xMLDTDHandler = this.fDTDGrammar;
            if (xMLDTDHandler != null) {
                ((DTDGrammar)xMLDTDHandler).internalEntityDecl(string2, xMLString, xMLString2, augmentations);
            }
            if ((xMLDTDHandler = this.fDTDHandler) != null) {
                xMLDTDHandler.internalEntityDecl(string2, xMLString, xMLString2, augmentations);
            }
        }
    }

    protected boolean isValidName(String string2) {
        return XMLChar.isValidName(string2);
    }

    protected boolean isValidNmtoken(String string2) {
        return XMLChar.isValidNmtoken(string2);
    }

    @Override
    public void notationDecl(String string2, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).notationDecl(string2, xMLResourceIdentifier, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.notationDecl(string2, xMLResourceIdentifier, augmentations);
        }
    }

    @Override
    public void occurrence(short s, Augmentations augmentations) throws XNIException {
        XMLDTDContentModelHandler xMLDTDContentModelHandler = this.fDTDGrammar;
        if (xMLDTDContentModelHandler != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).occurrence(s, augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.occurrence(s, augmentations);
        }
    }

    @Override
    public void pcdata(Augmentations augmentations) {
        this.fMixed = true;
        XMLDTDContentModelHandler xMLDTDContentModelHandler = this.fDTDGrammar;
        if (xMLDTDContentModelHandler != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).pcdata(augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.pcdata(augmentations);
        }
    }

    @Override
    public void processingInstruction(String string2, XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).processingInstruction(string2, xMLString, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.processingInstruction(string2, xMLString, augmentations);
        }
    }

    protected void reset() {
        this.fDTDGrammar = null;
        this.fInDTDIgnore = false;
        this.fNDataDeclNotations.clear();
        this.init();
    }

    @Override
    public void reset(XMLComponentManager object) throws XMLConfigurationException {
        try {
            this.fValidation = object.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        boolean bl = !object.getFeature("http://apache.org/xml/features/validation/schema");
        try {
            this.fDTDValidation = bl;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fDTDValidation = true;
        }
        try {
            this.fWarnDuplicateAttdef = object.getFeature(WARN_ON_DUPLICATE_ATTDEF);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fWarnDuplicateAttdef = false;
        }
        this.fErrorReporter = (XMLErrorReporter)object.getProperty(ERROR_REPORTER);
        this.fSymbolTable = (SymbolTable)object.getProperty(SYMBOL_TABLE);
        try {
            this.fGrammarPool = (XMLGrammarPool)object.getProperty(GRAMMAR_POOL);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fGrammarPool = null;
        }
        try {
            this.fValidator = (XMLDTDValidator)object.getProperty(DTD_VALIDATOR);
        }
        catch (ClassCastException | XMLConfigurationException runtimeException) {
            this.fValidator = null;
        }
        object = this.fValidator;
        this.fGrammarBucket = object != null ? ((XMLDTDValidator)object).getGrammarBucket() : null;
        this.reset();
    }

    @Override
    public void separator(short s, Augmentations augmentations) throws XNIException {
        XMLDTDContentModelHandler xMLDTDContentModelHandler = this.fDTDGrammar;
        if (xMLDTDContentModelHandler != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).separator(s, augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.separator(s, augmentations);
        }
    }

    @Override
    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
        this.fDTDContentModelHandler = xMLDTDContentModelHandler;
    }

    @Override
    public void setDTDContentModelSource(XMLDTDContentModelSource xMLDTDContentModelSource) {
        this.fDTDContentModelSource = xMLDTDContentModelSource;
    }

    @Override
    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fDTDHandler = xMLDTDHandler;
    }

    @Override
    public void setDTDSource(XMLDTDSource xMLDTDSource) {
        this.fDTDSource = xMLDTDSource;
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
    }

    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException {
    }

    @Override
    public void startAttlist(String string2, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).startAttlist(string2, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.startAttlist(string2, augmentations);
        }
    }

    @Override
    public void startConditional(short s, Augmentations augmentations) throws XNIException {
        boolean bl = true;
        if (s != 1) {
            bl = false;
        }
        this.fInDTDIgnore = bl;
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).startConditional(s, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.startConditional(s, augmentations);
        }
    }

    @Override
    public void startContentModel(String string2, Augmentations augmentations) throws XNIException {
        XMLDTDContentModelHandler xMLDTDContentModelHandler;
        if (this.fValidation) {
            this.fDTDElementDeclName = string2;
            this.fMixedElementTypes.removeAllElements();
        }
        if ((xMLDTDContentModelHandler = this.fDTDGrammar) != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).startContentModel(string2, augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.startContentModel(string2, augmentations);
        }
    }

    @Override
    public void startDTD(XMLLocator xMLLocator, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler;
        this.fNDataDeclNotations.clear();
        this.fDTDElementDecls.removeAllElements();
        if (!this.fGrammarBucket.getActiveGrammar().isImmutable()) {
            this.fDTDGrammar = this.fGrammarBucket.getActiveGrammar();
        }
        if ((xMLDTDHandler = this.fDTDGrammar) != null) {
            ((DTDGrammar)xMLDTDHandler).startDTD(xMLLocator, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.startDTD(xMLLocator, augmentations);
        }
    }

    @Override
    public void startExternalSubset(XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).startExternalSubset(xMLResourceIdentifier, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.startExternalSubset(xMLResourceIdentifier, augmentations);
        }
    }

    @Override
    public void startGroup(Augmentations augmentations) throws XNIException {
        this.fMixed = false;
        XMLDTDContentModelHandler xMLDTDContentModelHandler = this.fDTDGrammar;
        if (xMLDTDContentModelHandler != null) {
            ((DTDGrammar)xMLDTDContentModelHandler).startGroup(augmentations);
        }
        if ((xMLDTDContentModelHandler = this.fDTDContentModelHandler) != null) {
            xMLDTDContentModelHandler.startGroup(augmentations);
        }
    }

    @Override
    public void startParameterEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler;
        if (this.fPerformValidation && this.fDTDGrammar != null && this.fGrammarBucket.getStandalone()) {
            XMLDTDProcessor.checkStandaloneEntityRef(string2, this.fDTDGrammar, this.fEntityDecl, this.fErrorReporter);
        }
        if ((xMLDTDHandler = this.fDTDGrammar) != null) {
            ((DTDGrammar)xMLDTDHandler).startParameterEntity(string2, xMLResourceIdentifier, string3, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.startParameterEntity(string2, xMLResourceIdentifier, string3, augmentations);
        }
    }

    @Override
    public void textDecl(String string2, String string3, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler = this.fDTDGrammar;
        if (xMLDTDHandler != null) {
            ((DTDGrammar)xMLDTDHandler).textDecl(string2, string3, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.textDecl(string2, string3, augmentations);
        }
    }

    @Override
    public void unparsedEntityDecl(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        XMLDTDHandler xMLDTDHandler;
        if (this.fValidation) {
            this.fNDataDeclNotations.put(string2, string3);
        }
        if ((xMLDTDHandler = this.fDTDGrammar) != null) {
            ((DTDGrammar)xMLDTDHandler).unparsedEntityDecl(string2, xMLResourceIdentifier, string3, augmentations);
        }
        if ((xMLDTDHandler = this.fDTDHandler) != null) {
            xMLDTDHandler.unparsedEntityDecl(string2, xMLResourceIdentifier, string3, augmentations);
        }
    }
}

