/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import java.io.IOException;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.DTDGrammarBucket;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.dtd.XMLDTDProcessor;
import org.apache.xerces.impl.dtd.XMLDTDValidatorFilter;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.dv.DTDDVFactory;
import org.apache.xerces.impl.dv.DatatypeValidator;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;

public class XMLDTDValidator
implements XMLComponent,
XMLDocumentFilter,
XMLDTDValidatorFilter {
    protected static final String DATATYPE_VALIDATOR_FACTORY = "http://apache.org/xml/properties/internal/datatype-validator-factory";
    private static final boolean DEBUG_ATTRIBUTES = false;
    private static final boolean DEBUG_ELEMENT_CHILDREN = false;
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final Boolean[] FEATURE_DEFAULTS;
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final Object[] PROPERTY_DEFAULTS;
    private static final String[] RECOGNIZED_FEATURES;
    private static final String[] RECOGNIZED_PROPERTIES;
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final int TOP_LEVEL_SCOPE = -1;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String WARN_ON_DUPLICATE_ATTDEF = "http://apache.org/xml/features/validation/warn-on-duplicate-attdef";
    private StringBuffer fBuffer;
    private int[] fContentSpecTypeStack;
    private int fCurrentContentSpecType;
    private final QName fCurrentElement;
    private int fCurrentElementIndex;
    protected DTDGrammar fDTDGrammar;
    protected boolean fDTDValidation;
    protected DTDDVFactory fDatatypeValidatorFactory;
    protected XMLLocator fDocLocation;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    protected boolean fDynamicValidation;
    private QName[] fElementChildren;
    private int fElementChildrenLength;
    private int[] fElementChildrenOffsetStack;
    private int fElementDepth;
    private int[] fElementIndexStack;
    private QName[] fElementQNamePartsStack;
    private XMLEntityDecl fEntityDecl;
    protected XMLErrorReporter fErrorReporter;
    protected DTDGrammarBucket fGrammarBucket;
    protected XMLGrammarPool fGrammarPool;
    private boolean fInCDATASection;
    private boolean fInElementContent;
    protected NamespaceContext fNamespaceContext = null;
    protected boolean fNamespaces;
    private boolean fPerformValidation;
    private final QName fRootElement;
    private String fSchemaType;
    protected boolean fSeenDoctypeDecl;
    private boolean fSeenRootElement;
    protected SymbolTable fSymbolTable;
    private XMLAttributeDecl fTempAttDecl;
    private XMLElementDecl fTempElementDecl;
    private QName fTempQName;
    protected DatatypeValidator fValENTITIES;
    protected DatatypeValidator fValENTITY;
    protected DatatypeValidator fValID;
    protected DatatypeValidator fValIDRef;
    protected DatatypeValidator fValIDRefs;
    protected DatatypeValidator fValNMTOKEN;
    protected DatatypeValidator fValNMTOKENS;
    protected DatatypeValidator fValNOTATION;
    protected boolean fValidation;
    protected ValidationManager fValidationManager = null;
    protected ValidationState fValidationState = new ValidationState();
    protected boolean fWarnDuplicateAttdef;

    static {
        RECOGNIZED_FEATURES = new String[]{NAMESPACES, VALIDATION, DYNAMIC_VALIDATION};
        FEATURE_DEFAULTS = new Boolean[]{null, null, Boolean.FALSE};
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER, GRAMMAR_POOL, DATATYPE_VALIDATOR_FACTORY, VALIDATION_MANAGER};
        PROPERTY_DEFAULTS = new Object[]{null, null, null, null, null};
    }

    public XMLDTDValidator() {
        int n = 0;
        this.fSeenDoctypeDecl = false;
        this.fCurrentElement = new QName();
        this.fCurrentElementIndex = -1;
        this.fCurrentContentSpecType = -1;
        this.fRootElement = new QName();
        this.fInCDATASection = false;
        this.fElementIndexStack = new int[8];
        this.fContentSpecTypeStack = new int[8];
        this.fElementQNamePartsStack = new QName[8];
        this.fElementChildren = new QName[32];
        this.fElementChildrenLength = 0;
        this.fElementChildrenOffsetStack = new int[32];
        this.fElementDepth = -1;
        this.fSeenRootElement = false;
        this.fInElementContent = false;
        this.fTempElementDecl = new XMLElementDecl();
        this.fTempAttDecl = new XMLAttributeDecl();
        this.fEntityDecl = new XMLEntityDecl();
        this.fTempQName = new QName();
        this.fBuffer = new StringBuffer();
        while (true) {
            QName[] qNameArray;
            if (n >= (qNameArray = this.fElementQNamePartsStack).length) {
                this.fGrammarBucket = new DTDGrammarBucket();
                return;
            }
            qNameArray[n] = new QName();
            ++n;
        }
    }

    private void charDataInContent() {
        Object object;
        Object object2 = this.fElementChildren;
        if (((QName[])object2).length <= this.fElementChildrenLength) {
            object = new QName[((QName[])object2).length * 2];
            System.arraycopy(object2, 0, object, 0, ((QName[])object2).length);
            this.fElementChildren = object;
        }
        object2 = this.fElementChildren;
        int n = this.fElementChildrenLength;
        object = object2[n];
        object2 = object;
        if (object == null) {
            while (true) {
                if (n >= ((QName[])(object2 = this.fElementChildren)).length) {
                    object2 = object2[this.fElementChildrenLength];
                    break;
                }
                object2[n] = new QName();
                ++n;
            }
        }
        object2.clear();
        ++this.fElementChildrenLength;
    }

    private int checkContent(int n, QName[] qNameArray, int n2, int n3) throws XNIException {
        block7: {
            block6: {
                block5: {
                    this.fDTDGrammar.getElementDecl(n, this.fTempElementDecl);
                    String string2 = this.fCurrentElement.rawname;
                    n = this.fCurrentContentSpecType;
                    if (n != 1) break block5;
                    if (n3 != 0) {
                        return 0;
                    }
                    break block6;
                }
                if (n != 0 && (n == 2 || n == 3)) break block7;
            }
            return -1;
        }
        return this.fTempElementDecl.contentModelValidator.validate(qNameArray, n2, n3);
    }

    private void ensureStackCapacity(int n) {
        Object[] objectArray = this.fElementQNamePartsStack;
        if (n == objectArray.length) {
            int n2 = n * 2;
            Object[] objectArray2 = new int[n2];
            objectArray2 = new QName[n2];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            this.fElementQNamePartsStack = (QName[])objectArray2;
            if (objectArray2[n] == null) {
                for (int i = n; i < (objectArray = this.fElementQNamePartsStack).length; ++i) {
                    objectArray[i] = new QName();
                }
            }
            objectArray = new int[n2];
            System.arraycopy(this.fElementIndexStack, 0, objectArray, 0, n);
            this.fElementIndexStack = (int[])objectArray;
            objectArray = new int[n2];
            System.arraycopy(this.fContentSpecTypeStack, 0, objectArray, 0, n);
            this.fContentSpecTypeStack = (int[])objectArray;
        }
    }

    private String getAttributeTypeName(XMLAttributeDecl object) {
        switch (((XMLAttributeDecl)object).simpleType.type) {
            default: {
                return XMLSymbols.fCDATASymbol;
            }
            case 6: {
                return XMLSymbols.fNOTATIONSymbol;
            }
            case 5: {
                object = ((XMLAttributeDecl)object).simpleType.list ? XMLSymbols.fNMTOKENSSymbol : XMLSymbols.fNMTOKENSymbol;
                return object;
            }
            case 4: {
                object = ((XMLAttributeDecl)object).simpleType.list ? XMLSymbols.fIDREFSSymbol : XMLSymbols.fIDREFSymbol;
                return object;
            }
            case 3: {
                return XMLSymbols.fIDSymbol;
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('(');
                int n = 0;
                while (true) {
                    if (n >= ((XMLAttributeDecl)object).simpleType.enumeration.length) {
                        stringBuffer.append(')');
                        return this.fSymbolTable.addSymbol(stringBuffer.toString());
                    }
                    if (n > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(((XMLAttributeDecl)object).simpleType.enumeration[n]);
                    ++n;
                }
            }
            case 1: 
        }
        object = ((XMLAttributeDecl)object).simpleType.list ? XMLSymbols.fENTITIESSymbol : XMLSymbols.fENTITYSymbol;
        return object;
    }

    private int getContentSpecType(int n) {
        int n2;
        int n3 = n2 = -1;
        if (n > -1) {
            n3 = n2;
            if (this.fDTDGrammar.getElementDecl(n, this.fTempElementDecl)) {
                n3 = this.fTempElementDecl.type;
            }
        }
        return n3;
    }

    private boolean normalizeAttrValue(XMLAttributes xMLAttributes, int n) {
        String string2 = xMLAttributes.getValue(n);
        int n2 = string2.length();
        Object object = new char[n2];
        this.fBuffer.setLength(0);
        string2.getChars(0, string2.length(), (char[])object, 0);
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        boolean bl2 = true;
        while (true) {
            boolean bl3;
            int n6;
            if (n3 >= n2) {
                if (n4 > 0 && ((StringBuffer)(object = (Object)this.fBuffer)).charAt(n5 = n4 - 1) == ' ') {
                    this.fBuffer.setLength(n5);
                }
                object = this.fBuffer.toString();
                xMLAttributes.setValue(n, (String)object);
                return string2.equals(object) ^ true;
            }
            if (object[n3] == ' ') {
                boolean bl4 = bl;
                int n7 = n5;
                if (bl) {
                    bl4 = false;
                    n7 = 1;
                }
                n6 = n4;
                bl = bl4;
                n5 = n7;
                bl3 = bl2;
                if (n7 != 0) {
                    n6 = n4;
                    bl = bl4;
                    n5 = n7;
                    bl3 = bl2;
                    if (!bl2) {
                        this.fBuffer.append((char)object[n3]);
                        n6 = n4 + 1;
                        n5 = 0;
                        bl = bl4;
                        bl3 = bl2;
                    }
                }
            } else {
                this.fBuffer.append(object[n3]);
                n6 = n4 + 1;
                bl = true;
                n5 = 0;
                bl3 = false;
            }
            ++n3;
            n4 = n6;
            bl2 = bl3;
        }
    }

    private final void rootElementSpecified(QName object) throws XNIException {
        if (this.fPerformValidation) {
            String string2 = this.fRootElement.rawname;
            object = ((QName)object).rawname;
            if (string2 == null || !string2.equals(object)) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RootElementTypeMustMatchDoctypedecl", new Object[]{string2, object}, (short)1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void addDTDDefaultAttrsAndValidate(QName var1_1, int var2_2, XMLAttributes var3_3) throws XNIException {
        block29: {
            if (var2_2 == -1 || (var4_4 = this.fDTDGrammar) == null) break block29;
            var5_5 = var4_4.getFirstAttributeDeclIndex(var2_2);
            block0: while (true) {
                block30: {
                    if (var5_5 != -1) break block30;
                    var6_6 = var3_3.getLength();
                    var5_5 = 0;
                    block1: while (true) {
                        if (var5_5 >= var6_6) {
                            return;
                        }
                        var7_7 = var3_3.getQName(var5_5);
                        if (this.fPerformValidation && this.fGrammarBucket.getStandalone() && (var4_4 = var3_3.getNonNormalizedValue(var5_5)) != null && (var4_4 = this.getExternalEntityRefInAttrValue((String)var4_4)) != null) {
                            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_REFERENCE_TO_EXTERNALLY_DECLARED_ENTITY_WHEN_STANDALONE", new Object[]{var4_4}, (short)1);
                        }
                        var8_8 = this.fDTDGrammar.getFirstAttributeDeclIndex(var2_2);
                        while (true) {
                            block33: {
                                block32: {
                                    block31: {
                                        if (var8_8 != -1) break block31;
                                        var9_9 = 0;
                                        break block32;
                                    }
                                    this.fDTDGrammar.getAttributeDecl(var8_8, this.fTempAttDecl);
                                    if (this.fTempAttDecl.name.rawname != var7_7) break block33;
                                    var9_9 = 1;
                                }
                                if (var9_9 == 0) {
                                    if (this.fPerformValidation) {
                                        var4_4 = var1_1.rawname;
                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ATTRIBUTE_NOT_DECLARED", new Object[]{var4_4, var7_7}, (short)1);
                                    }
                                } else {
                                    var10_10 = this.getAttributeTypeName(this.fTempAttDecl);
                                    var3_3.setType(var5_5, var10_10);
                                    var11_11 = var3_3.getValue(var5_5);
                                    var4_4 = var11_11;
                                    if (var3_3.isSpecified(var5_5)) {
                                        var4_4 = var11_11;
                                        if (var10_10 != XMLSymbols.fCDATASymbol) {
                                            var12_14 = this.normalizeAttrValue(var3_3, var5_5);
                                            var4_4 = var3_3.getValue(var5_5);
                                            if (this.fPerformValidation && this.fGrammarBucket.getStandalone() && var12_14 && this.fDTDGrammar.getAttributeDeclIsExternal(var8_8)) {
                                                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ATTVALUE_CHANGED_DURING_NORMALIZATION_WHEN_STANDALONE", new Object[]{var7_7, var11_11, var4_4}, (short)1);
                                            }
                                        }
                                    }
                                    if (this.fPerformValidation) {
                                        if (this.fTempAttDecl.simpleType.defaultType == 1 && !var4_4.equals(var10_10 = this.fTempAttDecl.simpleType.defaultValue)) {
                                            var11_11 = var1_1.localpart;
                                            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_FIXED_ATTVALUE_INVALID", new Object[]{var11_11, var7_7, var4_4, var10_10}, (short)1);
                                        }
                                        if (this.fTempAttDecl.simpleType.type == 1 || this.fTempAttDecl.simpleType.type == 2 || this.fTempAttDecl.simpleType.type == 3 || this.fTempAttDecl.simpleType.type == 4 || this.fTempAttDecl.simpleType.type == 5 || this.fTempAttDecl.simpleType.type == 6) {
                                            this.validateDTDattribute(var1_1, (String)var4_4, this.fTempAttDecl);
                                        }
                                    }
                                }
                                ++var5_5;
                                continue block1;
                            }
                            var8_8 = this.fDTDGrammar.getNextAttributeDeclIndex(var8_8);
                        }
                        break;
                    }
                }
                this.fDTDGrammar.getAttributeDecl(var5_5, this.fTempAttDecl);
                var11_11 = this.fTempAttDecl.name.prefix;
                var7_7 = this.fTempAttDecl.name.localpart;
                var10_10 = this.fTempAttDecl.name.rawname;
                var13_12 = this.getAttributeTypeName(this.fTempAttDecl);
                var8_8 = this.fTempAttDecl.simpleType.defaultType;
                var4_4 = null;
                if (this.fTempAttDecl.simpleType.defaultValue != null) {
                    var4_4 = this.fTempAttDecl.simpleType.defaultValue;
                }
                var8_8 = var8_8 == 2 ? 1 : 0;
                var9_9 = var13_12 == XMLSymbols.fCDATASymbol ? 1 : 0;
                if (var9_9 != 0 && var8_8 == 0 && var4_4 == null) ** GOTO lbl69
                var6_6 = var3_3.getLength();
                var9_9 = 0;
                while (true) {
                    block36: {
                        block35: {
                            block34: {
                                if (var9_9 < var6_6) break block34;
lbl69:
                                // 2 sources

                                var9_9 = 0;
                                break block35;
                            }
                            if (var3_3.getQName(var9_9) != var10_10) break block36;
                            var9_9 = 1;
                        }
                        if (var9_9 == 0) {
                            if (var8_8 != 0) {
                                if (this.fPerformValidation) {
                                    var4_4 = var1_1.localpart;
                                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_REQUIRED_ATTRIBUTE_NOT_SPECIFIED", new Object[]{var4_4, var10_10}, (short)1);
                                }
                            } else if (var4_4 != null) {
                                if (this.fPerformValidation && this.fGrammarBucket.getStandalone() && this.fDTDGrammar.getAttributeDeclIsExternal(var5_5)) {
                                    var14_13 = var1_1.localpart;
                                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DEFAULTED_ATTRIBUTE_NOT_SPECIFIED", new Object[]{var14_13, var10_10}, (short)1);
                                }
                                if (this.fNamespaces && (var8_8 = var10_10.indexOf(58)) != -1) {
                                    var11_11 = var10_10.substring(0, var8_8);
                                    var11_11 = this.fSymbolTable.addSymbol(var11_11);
                                    var7_7 = var10_10.substring(var8_8 + 1);
                                    var7_7 = this.fSymbolTable.addSymbol(var7_7);
                                }
                                this.fTempQName.setValues(var11_11, var7_7, var10_10, this.fTempAttDecl.name.uri);
                                var3_3.addAttribute(this.fTempQName, var13_12, (String)var4_4);
                            }
                        }
                        var5_5 = this.fDTDGrammar.getNextAttributeDeclIndex(var5_5);
                        continue block0;
                    }
                    ++var9_9;
                }
                break;
            }
        }
    }

    @Override
    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        int n = xMLString.offset;
        while (true) {
            block14: {
                XMLDocumentHandler xMLDocumentHandler;
                boolean bl;
                block13: {
                    block12: {
                        int n2 = xMLString.offset;
                        int n3 = xMLString.length;
                        bl = false;
                        if (n < n2 + n3) break block12;
                        n = 1;
                        break block13;
                    }
                    if (this.isSpace(xMLString.ch[n])) break block14;
                    n = 0;
                }
                if (this.fInElementContent && n != 0 && !this.fInCDATASection && (xMLDocumentHandler = this.fDocumentHandler) != null) {
                    xMLDocumentHandler.ignorableWhitespace(xMLString, augmentations);
                } else {
                    bl = true;
                }
                if (this.fPerformValidation) {
                    if (this.fInElementContent) {
                        if (this.fGrammarBucket.getStandalone() && this.fDTDGrammar.getElementDeclIsExternal(this.fCurrentElementIndex) && n != 0) {
                            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_WHITE_SPACE_IN_ELEMENT_CONTENT_WHEN_STANDALONE", null, (short)1);
                        }
                        if (n == 0) {
                            this.charDataInContent();
                        }
                    }
                    if (this.fCurrentContentSpecType == 1) {
                        this.charDataInContent();
                    }
                }
                if (bl && (xMLDocumentHandler = this.fDocumentHandler) != null) {
                    xMLDocumentHandler.characters(xMLString, augmentations);
                }
                return;
            }
            ++n;
        }
    }

    @Override
    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.comment(xMLString, augmentations);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doctypeDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
        this.fSeenDoctypeDecl = true;
        Object object = this.fRootElement;
        Object object2 = null;
        ((QName)object).setValues(null, string2, string2, null);
        try {
            object2 = object = XMLEntityManager.expandSystemId(string4, this.fDocLocation.getExpandedSystemId(), false);
        }
        catch (IOException iOException) {}
        object2 = new XMLDTDDescription(string3, string4, this.fDocLocation.getExpandedSystemId(), (String)object2, string2);
        this.fDTDGrammar = object = this.fGrammarBucket.getGrammar((XMLGrammarDescription)object2);
        if (object == null && (object = this.fGrammarPool) != null) {
            this.fDTDGrammar = (DTDGrammar)object.retrieveGrammar((XMLGrammarDescription)object2);
        }
        if (this.fDTDGrammar == null) {
            this.fDTDGrammar = new DTDGrammar(this.fSymbolTable, (XMLDTDDescription)object2);
        } else {
            this.fValidationManager.setCachedDTD(true);
        }
        this.fGrammarBucket.setActiveGrammar(this.fDTDGrammar);
        object2 = this.fDocumentHandler;
        if (object2 != null) {
            object2.doctypeDecl(string2, string3, string4, augmentations);
        }
    }

    @Override
    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        boolean bl = this.handleStartElement(qName, xMLAttributes, augmentations);
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
        }
        if (!bl) {
            this.handleEndElement(qName, augmentations, true);
        }
    }

    @Override
    public void endCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = false;
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.endCDATA(augmentations);
        }
    }

    @Override
    public void endDocument(Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.endDocument(augmentations);
        }
    }

    @Override
    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.handleEndElement(qName, augmentations, false);
    }

    @Override
    public void endGeneralEntity(String string2, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.endGeneralEntity(string2, augmentations);
        }
    }

    protected void endNamespaceScope(QName object, Augmentations augmentations, boolean bl) {
        object = this.fDocumentHandler;
        if (object != null && !bl) {
            object.endElement(this.fCurrentElement, augmentations);
        }
    }

    @Override
    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    @Override
    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    protected String getExternalEntityRefInAttrValue(String string2) {
        int n = string2.length();
        int n2 = string2.indexOf(38);
        while (n2 != -1) {
            int n3 = n2 + 1;
            if (n3 < n && string2.charAt(n3) != '#') {
                String string3 = string2.substring(n3, string2.indexOf(59, n3));
                n2 = this.fDTDGrammar.getEntityDeclIndex(string3 = this.fSymbolTable.addSymbol(string3));
                if (n2 > -1) {
                    this.fDTDGrammar.getEntityDecl(n2, this.fEntityDecl);
                    if (this.fEntityDecl.inExternal || (string3 = this.getExternalEntityRefInAttrValue(this.fEntityDecl.value)) != null) {
                        return string3;
                    }
                }
            }
            n2 = string2.indexOf(38, n3);
        }
        return null;
    }

    @Override
    public Boolean getFeatureDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_FEATURES).length) {
            if (stringArray[n].equals(string2)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    DTDGrammarBucket getGrammarBucket() {
        return this.fGrammarBucket;
    }

    @Override
    public Object getPropertyDefault(String string2) {
        int n = 0;
        String[] stringArray;
        while (n < (stringArray = RECOGNIZED_PROPERTIES).length) {
            if (stringArray[n].equals(string2)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    @Override
    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    protected void handleEndElement(QName object, Augmentations augmentations, boolean bl) throws XNIException {
        int n;
        int n2 = this.fElementDepth;
        boolean bl2 = true;
        this.fElementDepth = n = n2 - 1;
        if (this.fPerformValidation) {
            int n3;
            Object object2;
            int n4;
            n2 = this.fCurrentElementIndex;
            if (n2 != -1 && this.fCurrentContentSpecType != -1 && (n4 = this.checkContent(n2, (QName[])(object2 = this.fElementChildren), n3 = this.fElementChildrenOffsetStack[n + 1] + 1, n = this.fElementChildrenLength - n3)) != -1) {
                this.fDTDGrammar.getElementDecl(n2, this.fTempElementDecl);
                n3 = this.fTempElementDecl.type;
                object2 = "MSG_CONTENT_INVALID";
                if (n3 == 1) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_CONTENT_INVALID", new Object[]{((QName)object).rawname, "EMPTY"}, (short)1);
                } else {
                    if (n4 == n) {
                        object2 = "MSG_CONTENT_INCOMPLETE";
                    }
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", (String)object2, new Object[]{((QName)object).rawname, this.fDTDGrammar.getContentSpecAsString(n2)}, (short)1);
                }
            }
            this.fElementChildrenLength = this.fElementChildrenOffsetStack[this.fElementDepth + 1] + 1;
        }
        this.endNamespaceScope(this.fCurrentElement, augmentations, bl);
        n2 = this.fElementDepth;
        if (n2 >= -1) {
            if (n2 < 0) {
                this.fCurrentElement.clear();
                this.fCurrentElementIndex = -1;
                this.fCurrentContentSpecType = -1;
                this.fInElementContent = false;
                if (this.fPerformValidation && (object = this.fValidationState.checkIDRefID()) != null) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ELEMENT_WITH_ID_REQUIRED", new Object[]{object}, (short)1);
                }
                return;
            }
            this.fCurrentElement.setValues(this.fElementQNamePartsStack[n2]);
            object = this.fElementIndexStack;
            n2 = this.fElementDepth;
            this.fCurrentElementIndex = (int)object[n2];
            this.fCurrentContentSpecType = n2 = this.fContentSpecTypeStack[n2];
            bl = n2 == 3 ? bl2 : false;
            this.fInElementContent = bl;
            return;
        }
        throw new RuntimeException("FWK008 Element stack underflow");
    }

    protected boolean handleStartElement(QName object, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        int n;
        boolean bl;
        Object object2;
        if (!this.fSeenRootElement) {
            this.fPerformValidation = this.validate();
            this.fSeenRootElement = true;
            this.fValidationManager.setEntityState(this.fDTDGrammar);
            this.fValidationManager.setGrammarFound(this.fSeenDoctypeDecl);
            this.rootElementSpecified((QName)object);
        }
        if ((object2 = this.fDTDGrammar) == null) {
            bl = this.fPerformValidation;
            if (!bl) {
                this.fCurrentElementIndex = -1;
                this.fCurrentContentSpecType = -1;
                this.fInElementContent = false;
            }
            if (bl) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_GRAMMAR_NOT_FOUND", new Object[]{((QName)object).rawname}, (short)1);
            }
            if ((object2 = this.fDocumentSource) != null) {
                object2.setDocumentHandler(this.fDocumentHandler);
                object = this.fDocumentHandler;
                if (object != null) {
                    object.setDocumentSource(this.fDocumentSource);
                }
                return true;
            }
        } else {
            this.fCurrentElementIndex = n = ((DTDGrammar)object2).getElementDeclIndex((QName)object);
            this.fCurrentContentSpecType = n = (int)this.fDTDGrammar.getContentSpecType(n);
            if (n == -1 && this.fPerformValidation) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ELEMENT_NOT_DECLARED", new Object[]{((QName)object).rawname}, (short)1);
            } else {
                this.addDTDDefaultAttrsAndValidate((QName)object, this.fCurrentElementIndex, xMLAttributes);
            }
        }
        bl = this.fCurrentContentSpecType == 3;
        this.fInElementContent = bl;
        this.fElementDepth = n = this.fElementDepth + 1;
        if (this.fPerformValidation) {
            Object object3;
            object2 = this.fElementChildrenOffsetStack;
            if (((Object)object2).length <= n) {
                object3 = new int[((Object)object2).length * 2];
                System.arraycopy(object2, 0, object3, 0, ((Object)object2).length);
                this.fElementChildrenOffsetStack = object3;
            }
            object2 = this.fElementChildrenOffsetStack;
            n = this.fElementDepth;
            int n2 = this.fElementChildrenLength;
            object2[n] = n2;
            object2 = this.fElementChildren;
            if (((QName[])object2).length <= n2) {
                object3 = new QName[n2 * 2];
                System.arraycopy(object2, 0, object3, 0, ((QName[])object2).length);
                this.fElementChildren = (QName[])object3;
            }
            object2 = this.fElementChildren;
            n = this.fElementChildrenLength;
            object3 = object2[n];
            object2 = object3;
            if (object3 == null) {
                while (true) {
                    if (n >= ((Object)(object2 = this.fElementChildren)).length) {
                        object2 = object2[this.fElementChildrenLength];
                        break;
                    }
                    object2[n] = new QName();
                    ++n;
                }
            }
            ((QName)object2).setValues((QName)object);
            ++this.fElementChildrenLength;
        }
        this.fCurrentElement.setValues((QName)object);
        this.ensureStackCapacity(this.fElementDepth);
        this.fElementQNamePartsStack[this.fElementDepth].setValues(this.fCurrentElement);
        object2 = this.fElementIndexStack;
        n = this.fElementDepth;
        object2[n] = (QName)this.fCurrentElementIndex;
        this.fContentSpecTypeStack[n] = this.fCurrentContentSpecType;
        this.startNamespaceScope((QName)object, xMLAttributes, augmentations);
        return false;
    }

    @Override
    public final boolean hasGrammar() {
        boolean bl = this.fDTDGrammar != null;
        return bl;
    }

    @Override
    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    protected void init() {
        if (this.fValidation || this.fDynamicValidation) {
            try {
                this.fValID = this.fDatatypeValidatorFactory.getBuiltInDV(XMLSymbols.fIDSymbol);
                this.fValIDRef = this.fDatatypeValidatorFactory.getBuiltInDV(XMLSymbols.fIDREFSymbol);
                this.fValIDRefs = this.fDatatypeValidatorFactory.getBuiltInDV(XMLSymbols.fIDREFSSymbol);
                this.fValENTITY = this.fDatatypeValidatorFactory.getBuiltInDV(XMLSymbols.fENTITYSymbol);
                this.fValENTITIES = this.fDatatypeValidatorFactory.getBuiltInDV(XMLSymbols.fENTITIESSymbol);
                this.fValNMTOKEN = this.fDatatypeValidatorFactory.getBuiltInDV(XMLSymbols.fNMTOKENSymbol);
                this.fValNMTOKENS = this.fDatatypeValidatorFactory.getBuiltInDV(XMLSymbols.fNMTOKENSSymbol);
                this.fValNOTATION = this.fDatatypeValidatorFactory.getBuiltInDV(XMLSymbols.fNOTATIONSymbol);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    protected boolean invalidStandaloneAttDef(QName qName, QName qName2) {
        return true;
    }

    protected boolean isSpace(int n) {
        return XMLChar.isSpace(n);
    }

    @Override
    public void processingInstruction(String string2, XMLString xMLString, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.processingInstruction(string2, xMLString, augmentations);
        }
    }

    @Override
    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        ValidationManager validationManager;
        this.fDTDGrammar = null;
        this.fSeenDoctypeDecl = false;
        this.fInCDATASection = false;
        this.fSeenRootElement = false;
        this.fInElementContent = false;
        this.fCurrentElementIndex = -1;
        this.fCurrentContentSpecType = -1;
        this.fRootElement.clear();
        try {
            this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNamespaces = true;
        }
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        boolean bl = !xMLComponentManager.getFeature("http://apache.org/xml/features/validation/schema");
        try {
            this.fDTDValidation = bl;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fDTDValidation = true;
        }
        try {
            this.fDynamicValidation = xMLComponentManager.getFeature(DYNAMIC_VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fDynamicValidation = false;
        }
        try {
            this.fWarnDuplicateAttdef = xMLComponentManager.getFeature(WARN_ON_DUPLICATE_ATTDEF);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fWarnDuplicateAttdef = false;
        }
        try {
            this.fSchemaType = (String)xMLComponentManager.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fSchemaType = null;
        }
        this.fValidationManager = validationManager = (ValidationManager)xMLComponentManager.getProperty(VALIDATION_MANAGER);
        validationManager.addValidationState(this.fValidationState);
        this.fValidationState.resetIDTables();
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        try {
            this.fGrammarPool = (XMLGrammarPool)xMLComponentManager.getProperty(GRAMMAR_POOL);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fGrammarPool = null;
        }
        this.fGrammarBucket.clear();
        this.fDatatypeValidatorFactory = (DTDDVFactory)xMLComponentManager.getProperty(DATATYPE_VALIDATOR_FACTORY);
        this.fElementDepth = -1;
        this.fElementChildrenLength = 0;
        this.init();
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    @Override
    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XMLConfigurationException {
    }

    @Override
    public void setProperty(String string2, Object object) throws XMLConfigurationException {
    }

    @Override
    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.fPerformValidation && this.fInElementContent) {
            this.charDataInContent();
        }
        this.fInCDATASection = true;
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.startCDATA(augmentations);
        }
    }

    @Override
    public void startDocument(XMLLocator xMLLocator, String string2, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        Object object = this.fGrammarPool;
        if (object != null) {
            object = object.retrieveInitialGrammarSet("http://www.w3.org/TR/REC-xml");
            for (int i = 0; i < ((Grammar[])object).length; ++i) {
                this.fGrammarBucket.putGrammar((DTDGrammar)object[i]);
            }
        }
        this.fDocLocation = xMLLocator;
        this.fNamespaceContext = namespaceContext;
        object = this.fDocumentHandler;
        if (object != null) {
            object.startDocument(xMLLocator, string2, namespaceContext, augmentations);
        }
    }

    @Override
    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.handleStartElement(qName, xMLAttributes, augmentations);
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.startElement(qName, xMLAttributes, augmentations);
        }
    }

    @Override
    public void startGeneralEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler;
        if (this.fPerformValidation && this.fDTDGrammar != null && this.fGrammarBucket.getStandalone()) {
            XMLDTDProcessor.checkStandaloneEntityRef(string2, this.fDTDGrammar, this.fEntityDecl, this.fErrorReporter);
        }
        if ((xMLDocumentHandler = this.fDocumentHandler) != null) {
            xMLDocumentHandler.startGeneralEntity(string2, xMLResourceIdentifier, string3, augmentations);
        }
    }

    protected void startNamespaceScope(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) {
    }

    @Override
    public void textDecl(String string2, String string3, Augmentations augmentations) throws XNIException {
        XMLDocumentHandler xMLDocumentHandler = this.fDocumentHandler;
        if (xMLDocumentHandler != null) {
            xMLDocumentHandler.textDecl(string2, string3, augmentations);
        }
    }

    @Override
    public final boolean validate() {
        boolean bl;
        bl = this.fSchemaType != Constants.NS_XMLSCHEMA && (!(bl = this.fDynamicValidation) && this.fValidation || bl && this.fSeenDoctypeDecl) && (this.fDTDValidation || this.fSeenDoctypeDecl);
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    protected void validateDTDattribute(QName var1_1, String var2_5, XMLAttributeDecl var3_7) throws XNIException {
        block4 : switch (var3_7.simpleType.type) {
            default: {
                break;
            }
            case 5: {
                var4_8 = var3_7.simpleType.list;
                if (!var4_8) ** GOTO lbl13
                try {
                    var1_1 = this.fValNMTOKENS;
                    var3_7 = this.fValidationState;
lbl10:
                    // 2 sources

                    while (true) {
                        var1_1.validate(var2_5, (ValidationContext)var3_7);
                        break block4;
                        break;
                    }
lbl13:
                    // 1 sources

                    var1_1 = this.fValNMTOKEN;
                    var3_7 = this.fValidationState;
                    ** continue;
                }
                catch (InvalidDatatypeValueException var1_2) {
                    if (var4_8) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "NMTOKENSInvalid", new Object[]{var2_5}, (short)1);
                        break;
                    }
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "NMTOKENInvalid", new Object[]{var2_5}, (short)1);
                    break;
                }
            }
            case 4: {
                var4_9 = var3_7.simpleType.list;
                if (!var4_9) ** GOTO lbl31
                try {
                    var3_7 = this.fValIDRefs;
                    var1_1 = this.fValidationState;
lbl28:
                    // 2 sources

                    while (true) {
                        var3_7.validate(var2_5, (ValidationContext)var1_1);
                        break block4;
                        break;
                    }
lbl31:
                    // 1 sources

                    var3_7 = this.fValIDRef;
                    var1_1 = this.fValidationState;
                    ** continue;
                }
                catch (InvalidDatatypeValueException var2_6) {
                    var1_1 = var2_6.getKey();
                    if (var4_9) {
                        var1_1 = "IDREFSInvalid";
                    }
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", (String)var1_1, var2_6.getArgs(), (short)1);
                    break;
                }
            }
            case 3: {
                try {
                    this.fValID.validate(var2_5, this.fValidationState);
                }
                catch (InvalidDatatypeValueException var1_3) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", var1_3.getKey(), var1_3.getArgs(), (short)1);
                }
                break;
            }
            case 2: 
            case 6: {
                var5_10 = var3_7.simpleType.enumeration;
                if (var5_10 == null) {
                    while (true) {
                        var6_11 = 0;
                        break;
                    }
                } else {
                    var6_11 = 0;
                    while (true) {
                        if (var6_11 >= var5_10.length) ** continue;
                        if (var2_5 == var5_10[var6_11] || var2_5.equals(var5_10[var6_11])) break;
                        ++var6_11;
                    }
                    var6_11 = 1;
                }
                if (var6_11 != 0) break;
                var1_1 = new StringBuffer();
                if (var5_10 != null) {
                    for (var6_11 = 0; var6_11 < var5_10.length; ++var6_11) {
                        var7_12 = new StringBuffer();
                        var7_12.append(var5_10[var6_11]);
                        var7_12.append(" ");
                        var1_1.append(var7_12.toString());
                    }
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ATTRIBUTE_VALUE_NOT_IN_LIST", new Object[]{var3_7.name.rawname, var2_5, var1_1}, (short)1);
                break;
            }
            case 1: {
                if (!var3_7.simpleType.list) ** GOTO lbl82
                try {
                    var3_7 = this.fValENTITIES;
                    var1_1 = this.fValidationState;
lbl79:
                    // 2 sources

                    while (true) {
                        var3_7.validate(var2_5, (ValidationContext)var1_1);
                        break block4;
                        break;
                    }
lbl82:
                    // 1 sources

                    var3_7 = this.fValENTITY;
                    var1_1 = this.fValidationState;
                    ** continue;
                }
                catch (InvalidDatatypeValueException var1_4) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", var1_4.getKey(), var1_4.getArgs(), (short)1);
                }
            }
        }
    }

    @Override
    public void xmlDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
        Object object = this.fGrammarBucket;
        boolean bl = string4 != null && string4.equals("yes");
        ((DTDGrammarBucket)object).setStandalone(bl);
        object = this.fDocumentHandler;
        if (object != null) {
            object.xmlDecl(string2, string3, string4, augmentations);
        }
    }
}

