/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.xni.QName;

public class CMLeaf
extends CMNode {
    private QName fElement;
    private int fPosition;

    public CMLeaf(QName qName) {
        super(0);
        QName qName2;
        this.fElement = qName2 = new QName();
        this.fPosition = -1;
        qName2.setValues(qName);
    }

    public CMLeaf(QName qName, int n) {
        super(0);
        QName qName2;
        this.fElement = qName2 = new QName();
        this.fPosition = -1;
        qName2.setValues(qName);
        this.fPosition = n;
    }

    @Override
    protected void calcFirstPos(CMStateSet cMStateSet) {
        int n = this.fPosition;
        if (n == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(n);
        }
    }

    @Override
    protected void calcLastPos(CMStateSet cMStateSet) {
        int n = this.fPosition;
        if (n == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(n);
        }
    }

    final QName getElement() {
        return this.fElement;
    }

    final int getPosition() {
        return this.fPosition;
    }

    @Override
    public boolean isNullable() {
        boolean bl = this.fPosition == -1;
        return bl;
    }

    final void setPosition(int n) {
        this.fPosition = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.fElement.toString());
        stringBuffer.append(" (");
        stringBuffer.append(this.fElement.uri);
        stringBuffer.append(',');
        stringBuffer.append(this.fElement.localpart);
        stringBuffer.append(')');
        if (this.fPosition >= 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(" (Pos:");
            stringBuffer2.append(new Integer(this.fPosition).toString());
            stringBuffer2.append(")");
            stringBuffer.append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }
}

