/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

public class CMStateSet {
    int fBitCount;
    int fBits1;
    int fBits2;
    byte[] fByteArray;
    int fByteCount;

    public CMStateSet(int n) {
        this.fBitCount = n;
        if (n >= 0) {
            if (n > 64) {
                int n2;
                this.fByteCount = n2 = n / 8;
                if (n % 8 != 0) {
                    this.fByteCount = n2 + 1;
                }
                this.fByteArray = new byte[this.fByteCount];
            }
            this.zeroBits();
            return;
        }
        throw new RuntimeException("ImplementationMessages.VAL_CMSI");
    }

    public boolean equals(Object object) {
        if (!(object instanceof CMStateSet)) {
            return false;
        }
        return this.isSameSet((CMStateSet)object);
    }

    public final boolean getBit(int n) {
        int n2 = this.fBitCount;
        if (n < n2) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (n2 < 65) {
                n2 = 1 << n % 32;
                if (n < 32) {
                    if ((this.fBits1 & n2) != 0) {
                        bl3 = true;
                    }
                    return bl3;
                }
                bl3 = bl;
                if ((this.fBits2 & n2) != 0) {
                    bl3 = true;
                }
                return bl3;
            }
            n2 = (byte)(1 << n % 8);
            bl3 = bl2;
            if ((this.fByteArray[n >> 3] & n2) != 0) {
                bl3 = true;
            }
            return bl3;
        }
        throw new RuntimeException("ImplementationMessages.VAL_CMSI");
    }

    public int hashCode() {
        if (this.fBitCount < 65) {
            return this.fBits1 + this.fBits2 * 31;
        }
        int n = 0;
        int n2 = this.fByteCount - 1;
        while (n2 >= 0) {
            n = n * 31 + this.fByteArray[n2];
            --n2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void intersection(CMStateSet cMStateSet) {
        if (this.fBitCount < 65) {
            this.fBits1 &= cMStateSet.fBits1;
            int n = this.fBits2;
            this.fBits2 = cMStateSet.fBits2 & n;
            return;
        }
        int n = this.fByteCount - 1;
        while (n >= 0) {
            byte[] byArray = this.fByteArray;
            byArray[n] = (byte)(byArray[n] & cMStateSet.fByteArray[n]);
            --n;
        }
        return;
    }

    public final boolean isEmpty() {
        int n = this.fBitCount;
        boolean bl = false;
        if (n < 65) {
            boolean bl2 = bl;
            if (this.fBits1 == 0) {
                bl2 = bl;
                if (this.fBits2 == 0) {
                    bl2 = true;
                }
            }
            return bl2;
        }
        n = this.fByteCount - 1;
        while (n >= 0) {
            if (this.fByteArray[n] != 0) {
                return false;
            }
            --n;
        }
        return true;
    }

    final boolean isSameSet(CMStateSet cMStateSet) {
        int n = this.fBitCount;
        int n2 = cMStateSet.fBitCount;
        boolean bl = false;
        if (n != n2) {
            return false;
        }
        if (n < 65) {
            boolean bl2 = bl;
            if (this.fBits1 == cMStateSet.fBits1) {
                bl2 = bl;
                if (this.fBits2 == cMStateSet.fBits2) {
                    bl2 = true;
                }
            }
            return bl2;
        }
        n = this.fByteCount - 1;
        while (n >= 0) {
            if (this.fByteArray[n] != cMStateSet.fByteArray[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public final void setBit(int n) {
        int n2 = this.fBitCount;
        if (n < n2) {
            if (n2 < 65) {
                n2 = 1 << n % 32;
                if (n < 32) {
                    this.fBits1 = n = this.fBits1 & n2;
                    this.fBits1 = n | n2;
                } else {
                    this.fBits2 = n = this.fBits2 & n2;
                    this.fBits2 = n | n2;
                }
            } else {
                n2 = (byte)(1 << n % 8);
                byte[] byArray = this.fByteArray;
                byArray[n >>= 3] = (byte)(byArray[n] & n2);
                byArray[n] = (byte)(n2 | byArray[n]);
            }
            return;
        }
        throw new RuntimeException("ImplementationMessages.VAL_CMSI");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setTo(CMStateSet cMStateSet) {
        int n = this.fBitCount;
        if (n != cMStateSet.fBitCount) throw new RuntimeException("ImplementationMessages.VAL_CMSI");
        if (n < 65) {
            this.fBits1 = cMStateSet.fBits1;
            this.fBits2 = cMStateSet.fBits2;
            return;
        }
        n = this.fByteCount - 1;
        while (n >= 0) {
            this.fByteArray[n] = cMStateSet.fByteArray[n];
            --n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("{");
            n = 0;
        }
        catch (RuntimeException runtimeException) {
            return stringBuffer.toString();
        }
        while (true) {
            if (n >= this.fBitCount) {
                stringBuffer.append(" }");
                return stringBuffer.toString();
            }
            if (this.getBit(n)) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(" ");
                stringBuffer2.append(n);
                stringBuffer.append(stringBuffer2.toString());
            }
            ++n;
            continue;
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void union(CMStateSet cMStateSet) {
        if (this.fBitCount < 65) {
            this.fBits1 |= cMStateSet.fBits1;
            int n = this.fBits2;
            this.fBits2 = cMStateSet.fBits2 | n;
            return;
        }
        int n = this.fByteCount - 1;
        while (n >= 0) {
            byte[] byArray = this.fByteArray;
            byArray[n] = (byte)(byArray[n] | cMStateSet.fByteArray[n]);
            --n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zeroBits() {
        if (this.fBitCount < 65) {
            this.fBits1 = 0;
            this.fBits2 = 0;
            return;
        }
        int n = this.fByteCount - 1;
        while (n >= 0) {
            this.fByteArray[n] = (byte)0;
            --n;
        }
        return;
    }
}

