/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.util;

public final class Base64 {
    private static final int BASELENGTH = 255;
    private static final int EIGHTBIT = 8;
    private static final int FOURBYTE = 4;
    private static final int LOOKUPLENGTH = 64;
    private static final char PAD = '=';
    private static final int SIGN = -128;
    private static final int SIXBIT = 6;
    private static final int SIXTEENBIT = 16;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final byte[] base64Alphabet = new byte[255];
    private static final boolean fDebug = false;
    private static final char[] lookUpBase64Alphabet = new char[64];

    static {
        int n = 0;
        int n2 = 0;
        while (true) {
            if (n2 >= 255) {
                n2 = 90;
                while (true) {
                    if (n2 < 65) {
                        n2 = 122;
                        while (true) {
                            int n3 = 26;
                            if (n2 < 97) {
                                n2 = 57;
                                while (true) {
                                    int n4 = 52;
                                    if (n2 < 48) {
                                        Object[] objectArray = base64Alphabet;
                                        objectArray[43] = (byte)62;
                                        objectArray[47] = (byte)63;
                                        n2 = 0;
                                        while (true) {
                                            if (n2 > 25) {
                                                n2 = 0;
                                                while (true) {
                                                    if (n3 > 51) {
                                                        n3 = n4;
                                                        n2 = n;
                                                        while (true) {
                                                            if (n3 > 61) {
                                                                objectArray = lookUpBase64Alphabet;
                                                                objectArray[62] = (char)43;
                                                                objectArray[63] = (char)47;
                                                                return;
                                                            }
                                                            Base64.lookUpBase64Alphabet[n3] = (char)(n2 + 48);
                                                            ++n3;
                                                            ++n2;
                                                        }
                                                    }
                                                    Base64.lookUpBase64Alphabet[n3] = (char)(n2 + 97);
                                                    ++n3;
                                                    ++n2;
                                                }
                                            }
                                            Base64.lookUpBase64Alphabet[n2] = (char)(n2 + 65);
                                            ++n2;
                                        }
                                    }
                                    Base64.base64Alphabet[n2] = (byte)(n2 - 48 + 52);
                                    --n2;
                                }
                            }
                            Base64.base64Alphabet[n2] = (byte)(n2 - 97 + 26);
                            --n2;
                        }
                    }
                    Base64.base64Alphabet[n2] = (byte)(n2 - 65);
                    --n2;
                }
            }
            Base64.base64Alphabet[n2] = (byte)-1;
            ++n2;
        }
    }

    public static byte[] decode(String object) {
        Object var1_1 = null;
        if (object == null) {
            return null;
        }
        char[] cArray = ((String)object).toCharArray();
        Object object2 = Base64.removeWhiteSpace(cArray);
        if (object2 % 4 != 0) {
            return null;
        }
        int n = object2 / 4;
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n * 3];
        int n2 = 0;
        int n3 = 0;
        object2 = 0;
        while (true) {
            char c;
            Object object3;
            char c2;
            Object object4;
            char c3;
            if (n2 >= n - 1) {
                n = n3 + 1;
                c3 = cArray[n3];
                object = var1_1;
                if (Base64.isData(c3)) {
                    object4 = n + 1;
                    c2 = cArray[n];
                    if (!Base64.isData(c2)) {
                        object = var1_1;
                    } else {
                        byte[] byArray2 = base64Alphabet;
                        n = byArray2[c3];
                        n3 = byArray2[c2];
                        c2 = cArray[object4];
                        c3 = cArray[object4 + 1];
                        if (Base64.isData(c2) && Base64.isData(c3)) {
                            object3 = byArray2[c2];
                            object4 = byArray2[c3];
                            n2 = object2 + 1;
                            byArray[object2] = (byte)(n << 2 | n3 >> 4);
                            byArray[n2] = (byte)((n3 & 0xF) << 4 | object3 >> 2 & 0xF);
                            byArray[n2 + 1] = (byte)(object4 | object3 << 6);
                            return byArray;
                        }
                        if (Base64.isPad(c2) && Base64.isPad(c3)) {
                            if ((n3 & 0xF) != 0) {
                                return null;
                            }
                            object = new byte[(n2 *= 3) + 1];
                            System.arraycopy(byArray, 0, object, 0, n2);
                            object[object2] = (byte)(n << 2 | n3 >> 4);
                            return object;
                        }
                        object = var1_1;
                        if (!Base64.isPad(c2)) {
                            object = var1_1;
                            if (Base64.isPad(c3)) {
                                object4 = byArray2[c2];
                                if ((object4 & 3) != 0) {
                                    return null;
                                }
                                object = new byte[(n2 *= 3) + 2];
                                System.arraycopy(byArray, 0, object, 0, n2);
                                object[object2] = (byte)(n << 2 | n3 >> 4);
                                object[object2 + 1] = (byte)(object4 >> 2 & 0xF | (n3 & 0xF) << 4);
                            }
                        }
                    }
                }
                return object;
            }
            object3 = n3 + 1;
            c3 = cArray[n3];
            if (!Base64.isData(c3)) break;
            object4 = object3 + 1;
            c2 = cArray[object3];
            if (!Base64.isData(c2)) break;
            n3 = object4 + 1;
            char c4 = cArray[object4];
            if (!Base64.isData(c4) || !Base64.isData(c = cArray[n3])) break;
            object = base64Alphabet;
            Object object5 = object[c3];
            Object object6 = object[c2];
            object3 = object[c4];
            object4 = object[c];
            int n4 = object2 + 1;
            byArray[object2] = (byte)(object5 << 2 | object6 >> 4);
            object5 = n4 + 1;
            byArray[n4] = (byte)((object6 & 0xF) << 4 | object3 >> 2 & 0xF);
            object2 = object5 + true;
            byArray[object5] = (byte)(object3 << 6 | object4);
            ++n2;
            ++n3;
        }
        return null;
    }

    public static String encode(byte[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        int n2 = 8;
        if ((n *= 8) == 0) {
            return "";
        }
        int n3 = n % 24;
        int n4 = n / 24;
        n = n3 != 0 ? n4 + 1 : n4;
        int n5 = 19;
        int n6 = (n - 1) / 19 + 1;
        char[] cArray = new char[n * 4 + n6];
        int n7 = 0;
        n = 0;
        int n8 = 0;
        int n9 = 0;
        block0: while (true) {
            char[] cArray2;
            int n10;
            int n11;
            byte by;
            int n12;
            if (n7 >= n6 - 1) {
                n7 = n8;
                while (true) {
                    if (n9 >= n4) {
                        if (n3 == n2) {
                            n7 = objectArray[n7];
                            n9 = (byte)(n7 & 3);
                            n8 = n7 >> 2;
                            if ((n7 & 0xFFFFFF80) != 0) {
                                n8 ^= 0xC0;
                            }
                            n7 = (byte)n8;
                            n8 = n + 1;
                            objectArray = lookUpBase64Alphabet;
                            cArray[n] = (char)objectArray[n7];
                            n = n8 + 1;
                            cArray[n8] = (char)objectArray[n9 << 4];
                            n9 = n + 1;
                            cArray[n] = (char)61;
                            n8 = n9 + 1;
                            cArray[n9] = (char)61;
                        } else {
                            n8 = n;
                            if (n3 == 16) {
                                n12 = objectArray[n7];
                                n2 = objectArray[n7 + 1];
                                n9 = (byte)(n2 & 0xF);
                                n7 = (byte)(n12 & 3);
                                n8 = n12 >> 2;
                                if ((n12 & 0xFFFFFF80) != 0) {
                                    n8 ^= 0xC0;
                                }
                                n12 = (byte)n8;
                                n8 = n2 >> 4;
                                if ((n2 & 0xFFFFFF80) != 0) {
                                    n8 ^= 0xF0;
                                }
                                n8 = (byte)n8;
                                n2 = n + 1;
                                objectArray = lookUpBase64Alphabet;
                                cArray[n] = (char)objectArray[n12];
                                n = n2 + 1;
                                cArray[n2] = (char)objectArray[n8 | n7 << 4];
                                n7 = n + 1;
                                cArray[n] = (char)objectArray[n9 << 2];
                                n8 = n7 + 1;
                                cArray[n7] = (char)61;
                            }
                        }
                        cArray[n8] = (char)10;
                        return new String(cArray);
                    }
                    n12 = n7 + 1;
                    by = objectArray[n7];
                    n8 = n12 + 1;
                    n11 = objectArray[n12];
                    n7 = n8 + 1;
                    n12 = objectArray[n8];
                    n5 = (byte)(n11 & 0xF);
                    n6 = (byte)(by & 3);
                    n8 = by >> 2;
                    if ((by & 0xFFFFFF80) != 0) {
                        n8 ^= 0xC0;
                    }
                    by = (byte)n8;
                    n8 = n11 >> 4;
                    if ((n11 & 0xFFFFFF80) != 0) {
                        n8 ^= 0xF0;
                    }
                    n11 = (byte)n8;
                    n8 = (n12 & 0xFFFFFF80) == 0 ? n12 >> 6 : n12 >> 6 ^ 0xFC;
                    n8 = (byte)n8;
                    n10 = n + 1;
                    cArray2 = lookUpBase64Alphabet;
                    cArray[n] = cArray2[by];
                    n = n10 + 1;
                    cArray[n10] = cArray2[n11 | n6 << 4];
                    n6 = n + 1;
                    cArray[n] = cArray2[n5 << 2 | n8];
                    n = n6 + 1;
                    cArray[n6] = cArray2[n12 & 0x3F];
                    ++n9;
                }
            }
            n12 = 0;
            while (true) {
                if (n12 >= n5) {
                    cArray[n] = (char)10;
                    ++n7;
                    ++n;
                    continue block0;
                }
                n5 = n8 + 1;
                n10 = objectArray[n8];
                n2 = n5 + 1;
                byte by2 = objectArray[n5];
                n5 = objectArray[n2];
                by = (byte)(by2 & 0xF);
                n11 = (byte)(n10 & 3);
                n8 = n10 >> 2;
                if ((n10 & 0xFFFFFF80) != 0) {
                    n8 ^= 0xC0;
                }
                n10 = (byte)n8;
                n8 = by2 >> 4;
                if ((by2 & 0xFFFFFF80) != 0) {
                    n8 ^= 0xF0;
                }
                by2 = (byte)n8;
                n8 = n5 >> 6;
                if ((n5 & 0xFFFFFF80) != 0) {
                    n8 ^= 0xFC;
                }
                n8 = (byte)n8;
                int n13 = n + 1;
                cArray2 = lookUpBase64Alphabet;
                cArray[n] = cArray2[n10];
                n = n13 + 1;
                cArray[n13] = cArray2[n11 << 4 | by2];
                n11 = n + 1;
                cArray[n] = cArray2[by << 2 | n8];
                n = n11 + 1;
                cArray[n11] = cArray2[n5 & 0x3F];
                ++n9;
                ++n12;
                n8 = n2 + 1;
                n2 = 8;
                n5 = 19;
            }
            break;
        }
    }

    protected static boolean isBase64(char c) {
        boolean bl = Base64.isWhiteSpace(c) || Base64.isPad(c) || Base64.isData(c);
        return bl;
    }

    protected static boolean isData(char c) {
        boolean bl = base64Alphabet[c] != -1;
        return bl;
    }

    protected static boolean isPad(char c) {
        boolean bl = c == '=';
        return bl;
    }

    protected static boolean isWhiteSpace(char c) {
        boolean bl = c == ' ' || c == '\r' || c == '\n' || c == '\t';
        return bl;
    }

    protected static int removeWhiteSpace(char[] cArray) {
        int n = 0;
        if (cArray == null) {
            return 0;
        }
        int n2 = cArray.length;
        int n3 = 0;
        while (n < n2) {
            int n4 = n3;
            if (!Base64.isWhiteSpace(cArray[n])) {
                cArray[n3] = cArray[n];
                n4 = n3 + 1;
            }
            ++n;
            n3 = n4;
        }
        return n3;
    }
}

