/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.xs.TypeValidator;

public abstract class AbstractDateTimeDV
extends TypeValidator {
    protected static final int CY = 0;
    protected static final int D = 2;
    protected static final int DAY = 15;
    private static final boolean DEBUG = false;
    protected static final int M = 1;
    protected static final int MONTH = 1;
    protected static final int TOTAL_SIZE = 8;
    protected static final int YEAR = 2000;
    protected static final int h = 3;
    protected static final int hh = 0;
    protected static final int m = 4;
    protected static final int mm = 1;
    protected static final int ms = 6;
    protected static final int s = 5;
    protected static final int utc = 7;

    private void cloneDate(int[] nArray, int[] nArray2) {
        System.arraycopy(nArray, 0, nArray2, 0, 8);
    }

    private boolean isLeapYear(int n) {
        boolean bl = n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void append(StringBuffer stringBuffer, int n, int n2) {
        int n3;
        block9: {
            block5: {
                String string2;
                block7: {
                    block8: {
                        block6: {
                            n3 = n;
                            if (n < 0) {
                                stringBuffer.append('-');
                                n3 = -n;
                            }
                            if (n2 != 4) break block5;
                            if (n3 >= 10) break block6;
                            string2 = "000";
                            break block7;
                        }
                        if (n3 >= 100) break block8;
                        string2 = "00";
                        break block7;
                    }
                    if (n3 >= 1000) break block9;
                    string2 = "0";
                }
                stringBuffer.append(string2);
                break block9;
            }
            if (n2 != 2) {
                if (n3 == 0) return;
                stringBuffer.append((char)n3);
                return;
            }
            if (n3 < 10) {
                stringBuffer.append('0');
            }
        }
        stringBuffer.append(n3);
    }

    @Override
    public int compare(Object object, Object object2) {
        return this.compareDates(((DateTimeData)object).data, ((DateTimeData)object2).data, true);
    }

    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        if (nArray[7] == nArray2[7]) {
            return this.compareOrder(nArray, nArray2);
        }
        int[] nArray3 = new int[8];
        int[] nArray4 = new int[2];
        if (nArray[7] == 90) {
            this.cloneDate(nArray2, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 43;
            this.normalize(nArray3, nArray4);
            short s = this.compareOrder(nArray, nArray3);
            this.cloneDate(nArray2, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 45;
            this.normalize(nArray3, nArray4);
            short s2 = this.compareOrder(nArray, nArray3);
            if (s < 0 && s2 > 0 || s == 0 && s2 == 0) {
                return 2;
            }
            short s3 = s != 2 ? s : s2;
            return s3;
        }
        if (nArray2[7] == 90) {
            this.cloneDate(nArray, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 45;
            this.normalize(nArray3, nArray4);
            short s = this.compareOrder(nArray3, nArray2);
            this.cloneDate(nArray, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 43;
            this.normalize(nArray3, nArray4);
            short s4 = this.compareOrder(nArray3, nArray2);
            if (s < 0 && s4 > 0 || s == 0 && s4 == 0) {
                return 2;
            }
            short s5 = s != 2 ? s : s4;
            return s5;
        }
        return 2;
    }

    protected short compareOrder(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < 8) {
            if (nArray[n] < nArray2[n]) {
                return -1;
            }
            if (nArray[n] > nArray2[n]) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    protected String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(25);
        this.append(stringBuffer, nArray[0], 4);
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[1], 2);
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[2], 2);
        stringBuffer.append('T');
        this.append(stringBuffer, nArray[3], 2);
        stringBuffer.append(':');
        this.append(stringBuffer, nArray[4], 2);
        stringBuffer.append(':');
        this.append(stringBuffer, nArray[5], 2);
        stringBuffer.append('.');
        stringBuffer.append(nArray[6]);
        this.append(stringBuffer, (char)nArray[7], 0);
        return stringBuffer.toString();
    }

    protected int fQuotient(int n, int n2) {
        return (int)Math.floor((float)n / (float)n2);
    }

    protected int fQuotient(int n, int n2, int n3) {
        return this.fQuotient(n - n2, n3 - n2);
    }

    protected int findUTCSign(String string2, int n, int n2) {
        while (true) {
            if (n >= n2) {
                return -1;
            }
            char c = string2.charAt(n);
            if (c == 'Z' || c == '+' || c == '-') break;
            ++n;
        }
        return n;
    }

    @Override
    public short getAllowedFacets() {
        return 2552;
    }

    protected int getDate(String string2, int n, int n2, int[] nArray) throws RuntimeException {
        n2 = this.getYearMonth(string2, n, n2, nArray);
        n = n2 + 1;
        if (string2.charAt(n2) == '-') {
            n2 = n + 2;
            nArray[2] = this.parseInt(string2, n, n2);
            return n2;
        }
        throw new RuntimeException("CCYY-MM must be followed by '-' sign");
    }

    protected void getTime(String string2, int n, int n2, int[] nArray, int[] nArray2) throws RuntimeException {
        block5: {
            block6: {
                block10: {
                    block9: {
                        block7: {
                            block8: {
                                int n3 = n + 2;
                                nArray[3] = this.parseInt(string2, n, n3);
                                n = n3 + 1;
                                if (string2.charAt(n3) != ':') break block5;
                                int n4 = n + 2;
                                nArray[4] = this.parseInt(string2, n, n4);
                                n3 = n4 + 1;
                                if (string2.charAt(n4) != ':') break block6;
                                n = n3 + 2;
                                nArray[5] = this.parseInt(string2, n3, n);
                                if (n == n2) {
                                    return;
                                }
                                n3 = string2.charAt(n) == '.' ? n : -1;
                                n4 = this.findUTCSign(string2, n, n2);
                                if (n3 != -1) {
                                    n = n4 < 0 ? n2 : n4;
                                    nArray[6] = this.parseInt(string2, n3 + 1, n);
                                }
                                if (n4 <= 0) break block7;
                                if (n != n4) break block8;
                                this.getTimeZone(string2, nArray, n4, n2, nArray2);
                                break block9;
                            }
                            throw new RuntimeException("Error in parsing time zone");
                        }
                        if (n != n2) break block10;
                    }
                    return;
                }
                throw new RuntimeException("Error in parsing time zone");
            }
            throw new RuntimeException("Error in parsing time zone");
        }
        throw new RuntimeException("Error in parsing time zone");
    }

    protected void getTimeZone(String string2, int[] nArray, int n, int n2, int[] nArray2) throws RuntimeException {
        nArray[7] = string2.charAt(n);
        if (string2.charAt(n) == 'Z') {
            if (n2 <= n + 1) {
                return;
            }
            throw new RuntimeException("Error in parsing time zone");
        }
        if (n <= n2 - 6) {
            int n3 = ++n + 2;
            nArray2[0] = this.parseInt(string2, n, n3);
            n = n3 + 1;
            if (string2.charAt(n3) == ':') {
                n3 = n + 2;
                nArray2[1] = this.parseInt(string2, n, n3);
                if (n3 == n2) {
                    return;
                }
                throw new RuntimeException("Error in parsing time zone");
            }
            throw new RuntimeException("Error in parsing time zone");
        }
        throw new RuntimeException("Error in parsing time zone");
    }

    protected int getYearMonth(String string2, int n, int n2, int[] nArray) throws RuntimeException {
        int n3 = n;
        if (string2.charAt(0) == '-') {
            n3 = n + 1;
        }
        if ((n = this.indexOf(string2, n3, n2, '-')) != -1) {
            n2 = n - n3;
            if (n2 >= 4) {
                if (n2 > 4 && string2.charAt(n3) == '0') {
                    throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
                }
                nArray[0] = this.parseIntYear(string2, n);
                if (string2.charAt(n) == '-') {
                    n2 = ++n + 2;
                    nArray[1] = this.parseInt(string2, n, n2);
                    return n2;
                }
                throw new RuntimeException("CCYY must be followed by '-' sign");
            }
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        throw new RuntimeException("Year separator is missing or misplaced");
    }

    protected int indexOf(String string2, int n, int n2, char c) {
        while (n < n2) {
            if (string2.charAt(n) == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int maxDayInMonthFor(int n, int n2) {
        if (n2 != 4 && n2 != 6 && n2 != 9 && n2 != 11) {
            if (n2 == 2) {
                if (this.isLeapYear(n)) {
                    return 29;
                }
                return 28;
            }
            return 31;
        }
        return 30;
    }

    protected int mod(int n, int n2, int n3) {
        return n - n3 * n2;
    }

    protected int modulo(int n, int n2, int n3) {
        return this.mod(n -= n2, n3 -= n2, this.fQuotient(n, n3)) + n2;
    }

    protected void normalize(int[] nArray, int[] nArray2) {
        int n = nArray[7] == 43 ? -1 : 1;
        int n2 = nArray[4] + nArray2[1] * n;
        int n3 = this.fQuotient(n2, 60);
        nArray[4] = this.mod(n2, 60, n3);
        n2 = nArray[3] + n * nArray2[0] + n3;
        n = this.fQuotient(n2, 24);
        nArray[3] = this.mod(n2, 24, n);
        nArray[2] = nArray[2] + n;
        while (true) {
            n = this.maxDayInMonthFor(nArray[0], nArray[1]);
            if (nArray[2] < 1) {
                nArray[2] = nArray[2] + this.maxDayInMonthFor(nArray[0], nArray[1] - 1);
                n = -1;
            } else {
                if (nArray[2] <= n) break;
                nArray[2] = nArray[2] - n;
                n = 1;
            }
            n = nArray[1] + n;
            nArray[1] = this.modulo(n, 1, 13);
            nArray[0] = nArray[0] + this.fQuotient(n, 1, 13);
        }
        nArray[7] = 90;
    }

    protected int parseInt(String string2, int n, int n2) throws NumberFormatException {
        int n3;
        int n4 = 0;
        while ((n3 = TypeValidator.getDigit(string2.charAt(n))) >= 0) {
            if (n4 >= -214748364) {
                if ((n4 *= 10) >= -2147483647 + n3) {
                    int n5 = n4 - n3;
                    n3 = n + 1;
                    n4 = n5;
                    n = n3;
                    if (n3 < n2) continue;
                    return -n5;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("'");
                stringBuffer.append(string2.toString());
                stringBuffer.append("' has wrong format");
                throw new NumberFormatException(stringBuffer.toString());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("'");
            stringBuffer.append(string2.toString());
            stringBuffer.append("' has wrong format");
            throw new NumberFormatException(stringBuffer.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        stringBuffer.append(string2.toString());
        stringBuffer.append("' has wrong format");
        throw new NumberFormatException(stringBuffer.toString());
    }

    protected int parseIntYear(String string2, int n) {
        block6: {
            block7: {
                int n2;
                boolean bl;
                int n3;
                int n4 = 0;
                if (string2.charAt(0) == '-') {
                    n3 = Integer.MIN_VALUE;
                    bl = true;
                    n2 = 1;
                } else {
                    n3 = -2147483647;
                    bl = false;
                    n2 = 0;
                }
                int n5 = n3 / 10;
                while (true) {
                    if (n2 >= n) {
                        if (bl) {
                            if (n2 > 1) {
                                return n4;
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("'");
                            stringBuffer.append(string2.toString());
                            stringBuffer.append("' has wrong format");
                            throw new NumberFormatException(stringBuffer.toString());
                        }
                        return -n4;
                    }
                    int n6 = TypeValidator.getDigit(string2.charAt(n2));
                    if (n6 < 0) break block6;
                    if (n4 < n5) break block7;
                    if ((n4 *= 10) < n3 + n6) break;
                    n4 -= n6;
                    ++n2;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("'");
                stringBuffer.append(string2.toString());
                stringBuffer.append("' has wrong format");
                throw new NumberFormatException(stringBuffer.toString());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("'");
            stringBuffer.append(string2.toString());
            stringBuffer.append("' has wrong format");
            throw new NumberFormatException(stringBuffer.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        stringBuffer.append(string2.toString());
        stringBuffer.append("' has wrong format");
        throw new NumberFormatException(stringBuffer.toString());
    }

    protected void parseTimeZone(String string2, int n, int n2, int[] nArray, int[] nArray2) throws RuntimeException {
        if (n < n2) {
            if ((n = this.findUTCSign(string2, n, n2)) >= 0) {
                this.getTimeZone(string2, nArray, n, n2, nArray2);
            } else {
                throw new RuntimeException("Error in month parsing");
            }
        }
    }

    protected void resetDateObj(int[] nArray) {
        int n = 0;
        while (n < 8) {
            nArray[n] = 0;
            ++n;
        }
        return;
    }

    protected void validateDateTime(int[] nArray, int[] nArray2) {
        if (nArray[0] != 0) {
            if (nArray[1] >= 1 && nArray[1] <= 12) {
                if (nArray[2] <= this.maxDayInMonthFor(nArray[0], nArray[1]) && nArray[2] >= 1) {
                    if (nArray[3] <= 23 && nArray[3] >= 0) {
                        if (nArray[4] <= 59 && nArray[4] >= 0) {
                            if (nArray[5] <= 60 && nArray[5] >= 0) {
                                if (nArray2[0] <= 14 && nArray2[0] >= -14) {
                                    if (nArray2[1] <= 59 && nArray2[1] >= -59) {
                                        return;
                                    }
                                    throw new RuntimeException("Minute must have values 0-59");
                                }
                                throw new RuntimeException("Time zone should have range -14..+14");
                            }
                            throw new RuntimeException("Second must have values 0-60");
                        }
                        throw new RuntimeException("Minute must have values 0-59");
                    }
                    throw new RuntimeException("Hour must have values 0-23");
                }
                throw new RuntimeException("The day must have values 1 to 31");
            }
            throw new RuntimeException("The month must have values 1 to 12");
        }
        throw new RuntimeException("The year \"0000\" is an illegal year value");
    }

    static final class DateTimeData {
        private String canonical;
        final int[] data;
        final AbstractDateTimeDV type;

        public DateTimeData(int[] nArray, AbstractDateTimeDV abstractDateTimeDV) {
            this.data = nArray;
            this.type = abstractDateTimeDV;
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof DateTimeData;
            boolean bl2 = false;
            if (!bl) {
                return false;
            }
            object = ((DateTimeData)object).data;
            if (this.type.compareDates(this.data, (int[])object, true) == 0) {
                bl2 = true;
            }
            return bl2;
        }

        public String toString() {
            synchronized (this) {
                if (this.canonical == null) {
                    this.canonical = this.type.dateToString(this.data);
                }
                String string2 = this.canonical;
                return string2;
            }
        }
    }
}

