/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class DayDV
extends AbstractDateTimeDV {
    private static final int DAY_SIZE = 5;

    @Override
    protected String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(6);
        stringBuffer.append('-');
        stringBuffer.append('-');
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[2], 2);
        this.append(stringBuffer, (char)nArray[7], 0);
        return stringBuffer.toString();
    }

    @Override
    public Object getActualValue(String string2, ValidationContext object) throws InvalidDatatypeValueException {
        try {
            object = new AbstractDateTimeDV.DateTimeData(this.parse(string2), this);
            return object;
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "gDay"});
        }
    }

    protected int[] parse(String string2) throws SchemaDateTimeException {
        int n = string2.length();
        int[] nArray = new int[8];
        int[] nArray2 = new int[2];
        if (string2.charAt(0) == '-' && string2.charAt(1) == '-' && string2.charAt(2) == '-') {
            nArray[0] = 2000;
            nArray[1] = 1;
            nArray[2] = this.parseInt(string2, 3, 5);
            if (5 < n) {
                int n2 = this.findUTCSign(string2, 5, n);
                if (n2 >= 0) {
                    this.getTimeZone(string2, nArray, n2, n, nArray2);
                } else {
                    throw new SchemaDateTimeException("Error in day parsing");
                }
            }
            this.validateDateTime(nArray, nArray2);
            if (nArray[7] != 0 && nArray[7] != 90) {
                this.normalize(nArray, nArray2);
            }
            return nArray;
        }
        throw new SchemaDateTimeException("Error in day parsing");
    }
}

