/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class DecimalDV
extends TypeValidator {
    @Override
    public final int compare(Object object, Object object2) {
        return ((XDecimal)object).compareTo((XDecimal)object2);
    }

    @Override
    public Object getActualValue(String string2, ValidationContext object) throws InvalidDatatypeValueException {
        try {
            object = new XDecimal(string2);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "decimal"});
        }
    }

    @Override
    public final short getAllowedFacets() {
        return 4088;
    }

    @Override
    public final int getFractionDigits(Object object) {
        return ((XDecimal)object).fracDigits;
    }

    @Override
    public final int getTotalDigits(Object object) {
        return ((XDecimal)object).totalDigits;
    }

    static class XDecimal {
        private String canonical;
        int fracDigits = 0;
        String fvalue = "";
        int intDigits = 0;
        boolean integer = false;
        String ivalue = "";
        int sign = 1;
        int totalDigits = 0;

        XDecimal(String string2) throws NumberFormatException {
            this.initD(string2);
        }

        XDecimal(String string2, boolean bl) throws NumberFormatException {
            if (bl) {
                this.initI(string2);
            } else {
                this.initD(string2);
            }
        }

        private int intComp(XDecimal xDecimal) {
            int n = this.intDigits;
            int n2 = xDecimal.intDigits;
            int n3 = 1;
            int n4 = 1;
            int n5 = 1;
            if (n != n2) {
                n4 = n > n2 ? n5 : -1;
                return n4;
            }
            n5 = this.ivalue.compareTo(xDecimal.ivalue);
            if (n5 != 0) {
                n4 = n5 > 0 ? n3 : -1;
                return n4;
            }
            n3 = this.fvalue.compareTo(xDecimal.fvalue);
            if (n3 == 0) {
                n4 = 0;
            } else if (n3 <= 0) {
                n4 = -1;
            }
            return n4;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void makeCanonical() {
            CharSequence charSequence;
            int n = this.sign;
            if (n == 0) {
                String string2 = this.integer ? "0" : "0.0";
                this.canonical = string2;
                return;
            }
            if (this.integer && n > 0) {
                charSequence = this.ivalue;
            } else {
                charSequence = new StringBuffer(this.totalDigits + 3);
                if (this.sign == -1) {
                    ((StringBuffer)charSequence).append('-');
                }
                if (this.intDigits != 0) {
                    ((StringBuffer)charSequence).append(this.ivalue);
                } else {
                    ((StringBuffer)charSequence).append('0');
                }
                if (!this.integer) {
                    ((StringBuffer)charSequence).append('.');
                    if (this.fracDigits != 0) {
                        ((StringBuffer)charSequence).append(this.fvalue);
                    } else {
                        ((StringBuffer)charSequence).append('0');
                    }
                }
                charSequence = ((StringBuffer)charSequence).toString();
            }
            this.canonical = charSequence;
        }

        public int compareTo(XDecimal xDecimal) {
            int n = this.sign;
            int n2 = xDecimal.sign;
            if (n != n2) {
                n = n > n2 ? 1 : -1;
                return n;
            }
            if (n == 0) {
                return 0;
            }
            return n * this.intComp(xDecimal);
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (object == this) {
                return true;
            }
            if (!(object instanceof XDecimal)) {
                return false;
            }
            object = (XDecimal)object;
            int n = this.sign;
            if (n != ((XDecimal)object).sign) {
                return false;
            }
            if (n == 0) {
                return true;
            }
            if (this.intDigits != ((XDecimal)object).intDigits || this.fracDigits != ((XDecimal)object).fracDigits || !this.ivalue.equals(((XDecimal)object).ivalue) || !this.fvalue.equals(((XDecimal)object).fvalue)) {
                bl = false;
            }
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        void initD(String string2) throws NumberFormatException {
            int n;
            int n2;
            int n3 = string2.length();
            if (n3 == 0) throw new NumberFormatException();
            int n4 = string2.charAt(0);
            int n5 = 1;
            if (n4 != 43) {
                if (string2.charAt(0) == '-') {
                    this.sign = -1;
                } else {
                    n5 = 0;
                }
            }
            for (n4 = n5; n4 < n3 && string2.charAt(n4) == '0'; ++n4) {
            }
            for (n2 = n4; n2 < n3 && TypeValidator.isDigit(string2.charAt(n2)); ++n2) {
            }
            if (n2 < n3) {
                if (string2.charAt(n2) != '.') throw new NumberFormatException();
                n = n2 + 1;
            } else {
                n3 = 0;
                n = 0;
            }
            int n6 = n3;
            if (n5 == n2) {
                if (n == n3) throw new NumberFormatException();
                n6 = n3;
            }
            while (n6 > n && string2.charAt(n6 - 1) == '0') {
                --n6;
            }
            n5 = n;
            while (true) {
                if (n5 >= n6) {
                    this.intDigits = n5 = n2 - n4;
                    this.fracDigits = n3 = n6 - n;
                    this.totalDigits = n5 + n3;
                    if (n5 > 0) {
                        this.ivalue = string2.substring(n4, n2);
                        if (this.fracDigits <= 0) return;
                    } else if (n3 <= 0) {
                        this.sign = 0;
                        return;
                    }
                    this.fvalue = string2.substring(n, n6);
                    return;
                }
                if (!TypeValidator.isDigit(string2.charAt(n5))) throw new NumberFormatException();
                ++n5;
            }
        }

        /*
         * Unable to fully structure code
         */
        void initI(String var1_1) throws NumberFormatException {
            var2_2 = var1_1.length();
            if (var2_2 != 0) {
                if (var1_1.charAt(0) == '+') lbl-1000:
                // 2 sources

                {
                    while (true) {
                        var3_3 = 1;
                        break;
                    }
                } else {
                    if (var1_1.charAt(0) == '-') {
                        this.sign = -1;
                        ** continue;
                    }
                    var3_3 = 0;
                }
                for (var4_4 = var3_3; var4_4 < var2_2 && var1_1.charAt(var4_4) == '0'; ++var4_4) {
                }
                for (var5_5 = var4_4; var5_5 < var2_2 && TypeValidator.isDigit(var1_1.charAt(var5_5)); ++var5_5) {
                }
                if (var5_5 >= var2_2) {
                    if (var3_3 != var5_5) {
                        this.intDigits = var3_3 = var5_5 - var4_4;
                        this.fracDigits = 0;
                        this.totalDigits = var3_3;
                        if (var3_3 > 0) {
                            this.ivalue = var1_1.substring(var4_4, var5_5);
                        } else {
                            this.sign = 0;
                        }
                        this.integer = true;
                        return;
                    }
                    throw new NumberFormatException();
                }
                throw new NumberFormatException();
            }
            throw new NumberFormatException();
        }

        public String toString() {
            synchronized (this) {
                if (this.canonical == null) {
                    this.makeCanonical();
                }
                String string2 = this.canonical;
                return string2;
            }
        }
    }
}

