/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class DoubleDV
extends TypeValidator {
    @Override
    public int compare(Object object, Object object2) {
        return ((XDouble)object).compareTo((XDouble)object2);
    }

    @Override
    public Object getActualValue(String string2, ValidationContext object) throws InvalidDatatypeValueException {
        try {
            object = new XDouble(string2);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "double"});
        }
    }

    @Override
    public short getAllowedFacets() {
        return 2552;
    }

    private static final class XDouble {
        private String canonical;
        private double value;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public XDouble(String string2) throws NumberFormatException {
            try {
                this.value = Double.parseDouble(string2);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                double d;
                if (string2.equals("INF")) {
                    d = Double.POSITIVE_INFINITY;
                } else if (string2.equals("-INF")) {
                    d = Double.NEGATIVE_INFINITY;
                } else {
                    if (!string2.equals("NaN")) throw numberFormatException;
                    d = Double.NaN;
                }
                this.value = d;
                return;
            }
        }

        private int compareTo(XDouble xDouble) {
            double d = this.value;
            double d2 = xDouble.value;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            if (d == d2) {
                return 0;
            }
            if (d != d && d2 != d2) {
                return 0;
            }
            return 2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XDouble)) {
                return false;
            }
            object = (XDouble)object;
            double d = this.value;
            double d2 = ((XDouble)object).value;
            if (d == d2) {
                return true;
            }
            return d != d && d2 != d2;
        }

        /*
         * Unable to fully structure code
         */
        public String toString() {
            synchronized (this) {
                block19: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        if (this.canonical != null) break block19;
                                        var1_1 = this.value;
                                        if (var1_1 != Infinity) break block20;
                                        var3_2 = "INF";
lbl7:
                                        // 5 sources

                                        while (true) {
                                            this.canonical = var3_2;
                                            break block19;
                                            break;
                                        }
                                    }
                                    if (var1_1 != -Infinity) break block21;
                                    var3_2 = "-INF";
                                    ** GOTO lbl7
                                }
                                if (var1_1 == var1_1) break block22;
                                var3_2 = "NaN";
                                ** GOTO lbl7
                            }
                            if (var1_1 != 0.0) break block23;
                            var3_2 = "0.0E1";
                            ** GOTO lbl7
                        }
                        var3_2 = Double.toString(var1_1);
                        this.canonical = var3_2;
                        if (var3_2.indexOf(69) != -1) break block19;
                        var4_4 = this.canonical.length();
                        var3_2 = new char[var4_4 + 3];
                        this.canonical.getChars(0, var4_4, (char[])var3_2, 0);
                        var5_5 = var3_2[0] == 45 ? 2 : 1;
                        var1_1 = this.value;
                        if (var1_1 >= 1.0 || var1_1 <= -1.0) break block24;
                        var7_7 = var6_6 = var5_5 + 1;
                        while (true) {
                            block25: {
                                if (var3_2[var7_7] == 48) break block25;
                                var3_2[var5_5 - 1] = (char)var3_2[var7_7];
                                var3_2[var5_5] = (char)46;
                                var8_9 = var7_7 + 1;
                                var9_11 = var6_6;
                                while (true) {
                                    block26: {
                                        if (var8_9 < var4_4) break block26;
                                        var9_11 = var7_7 - var5_5;
                                        var5_5 = var7_7 = var4_4 - var9_11;
                                        if (var7_7 == var6_6) {
                                            var3_2[var7_7] = (char)48;
                                            var5_5 = var7_7 + 1;
                                        }
                                        var6_6 = var5_5 + 1;
                                        var3_2[var5_5] = (char)69;
                                        var5_5 = var6_6 + 1;
                                        var3_2[var6_6] = (char)45;
                                        var6_6 = var5_5 + 1;
                                        var3_2[var5_5] = (char)(var9_11 + 48);
                                        ** GOTO lbl81
                                    }
                                    var3_2[var9_11] = (char)var3_2[var8_9];
                                    ++var8_9;
                                    ++var9_11;
                                }
                            }
                            ++var7_7;
                        }
                    }
                    var6_6 = var9_12 = this.canonical.indexOf(46);
                    while (true) {
                        block27: {
                            if (var6_6 > var5_5) break block27;
                            var3_2[var5_5] = (char)46;
                            var6_6 = var4_4;
                            while (true) {
                                block28: {
                                    if (var3_2[var8_10 = var6_6 - 1] == 48) break block28;
                                    var7_8 = var6_6;
                                    if (var3_2[var8_10] == 46) {
                                        var7_8 = var6_6 + 1;
                                    }
                                    var8_10 = var7_8 + 1;
                                    var3_2[var7_8] = (char)69;
                                    var6_6 = var8_10 + 1;
                                    var3_2[var8_10] = (char)(var9_12 - var5_5 + 48);
lbl81:
                                    // 3 sources

                                    var3_2 = new String((char[])var3_2, 0, var6_6);
                                    ** continue;
                                }
                                --var6_6;
                            }
                        }
                        var3_2[var6_6] = (char)var3_2[var6_6 - 1];
                        --var6_6;
                    }
                }
                var3_2 = this.canonical;
                return var3_2;
            }
        }
    }
}

