/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class DurationDV
extends AbstractDateTimeDV {
    private static final int[][] DATETIMES;
    private int[][] fDuration = null;

    static {
        int[] nArray = new int[]{1696, 9, 1, 0, 0, 0, 0, 90};
        int[] nArray2 = new int[]{1903, 7, 1, 0, 0, 0, 0, 90};
        DATETIMES = new int[][]{nArray, {1697, 2, 1, 0, 0, 0, 0, 90}, {1903, 3, 1, 0, 0, 0, 0, 90}, nArray2};
    }

    private int[] addDuration(int[] nArray, int n, int[] nArray2) {
        this.resetDateObj(nArray2);
        int[][] nArray3 = DATETIMES;
        int n2 = nArray3[n][1] + nArray[1];
        nArray2[1] = this.modulo(n2, 1, 13);
        n2 = this.fQuotient(n2, 1, 13);
        nArray2[0] = nArray3[n][0] + nArray[0] + n2;
        n2 = nArray3[n][5] + nArray[5];
        int n3 = this.fQuotient(n2, 60);
        nArray2[5] = this.mod(n2, 60, n3);
        n3 = nArray3[n][4] + nArray[4] + n3;
        n2 = this.fQuotient(n3, 60);
        nArray2[4] = this.mod(n3, 60, n2);
        n3 = nArray3[n][3] + nArray[3] + n2;
        n2 = this.fQuotient(n3, 24);
        nArray2[3] = this.mod(n3, 24, n2);
        nArray2[2] = nArray3[n][2] + nArray[2] + n2;
        while (true) {
            n = this.maxDayInMonthFor(nArray2[0], nArray2[1]);
            if (nArray2[2] < 1) {
                nArray2[2] = nArray2[2] + this.maxDayInMonthFor(nArray2[0], nArray2[1] - 1);
                n = -1;
            } else {
                if (nArray2[2] <= n) break;
                nArray2[2] = nArray2[2] - n;
                n = 1;
            }
            n = nArray2[1] + n;
            nArray2[1] = this.modulo(n, 1, 13);
            nArray2[0] = nArray2[0] + this.fQuotient(n, 1, 13);
        }
        nArray2[7] = 90;
        return nArray2;
    }

    private short compareResults(short s, short s2, boolean bl) {
        if (s2 == 2) {
            return 2;
        }
        if (s != s2 && bl) {
            return 2;
        }
        short s3 = s;
        if (s != s2) {
            s3 = s;
            if (!bl) {
                if (s != 0 && s2 != 0) {
                    return 2;
                }
                s3 = s != 0 ? s : s2;
            }
        }
        return s3;
    }

    @Override
    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        short s;
        if (this.compareOrder(nArray, nArray2) == 0) {
            return 0;
        }
        if (this.fDuration == null) {
            this.fDuration = new int[2][8];
        }
        if ((s = this.compareOrder(this.addDuration(nArray, 0, this.fDuration[0]), this.addDuration(nArray2, 0, this.fDuration[1]))) == 2) {
            return 2;
        }
        if ((s = this.compareResults(s, this.compareOrder(this.addDuration(nArray, 1, this.fDuration[0]), this.addDuration(nArray2, 1, this.fDuration[1])), bl)) == 2) {
            return 2;
        }
        if ((s = this.compareResults(s, this.compareOrder(this.addDuration(nArray, 2, this.fDuration[0]), this.addDuration(nArray2, 2, this.fDuration[1])), bl)) == 2) {
            return 2;
        }
        return this.compareResults(s, this.compareOrder(this.addDuration(nArray, 3, this.fDuration[0]), this.addDuration(nArray2, 3, this.fDuration[1])), bl);
    }

    @Override
    protected String dateToString(int[] nArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(30);
        if (nArray[0] < 0) {
            stringBuffer.append('-');
            n = -1;
        } else {
            n = 1;
        }
        stringBuffer.append('P');
        stringBuffer.append(nArray[0] * n);
        stringBuffer.append('Y');
        stringBuffer.append(nArray[1] * n);
        stringBuffer.append('M');
        stringBuffer.append(nArray[2] * n);
        stringBuffer.append('D');
        stringBuffer.append('T');
        stringBuffer.append(nArray[3] * n);
        stringBuffer.append('H');
        stringBuffer.append(nArray[4] * n);
        stringBuffer.append('M');
        stringBuffer.append(nArray[5] * n);
        stringBuffer.append('.');
        stringBuffer.append(n * nArray[6]);
        stringBuffer.append('S');
        return stringBuffer.toString();
    }

    @Override
    public Object getActualValue(String string2, ValidationContext object) throws InvalidDatatypeValueException {
        try {
            object = new AbstractDateTimeDV.DateTimeData(this.parse(string2), this);
            return object;
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "duration"});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int[] parse(String string2) throws SchemaDateTimeException {
        int n = string2.length();
        int[] nArray = new int[8];
        int n2 = 0;
        int n3 = string2.charAt(0);
        if (n3 != 80 && n3 != 45) {
            throw new SchemaDateTimeException();
        }
        int n4 = n3 == 45 ? 45 : 0;
        nArray[7] = n4;
        int n5 = 1;
        if (n3 == 45) {
            if (string2.charAt(1) != 'P') throw new SchemaDateTimeException();
            n4 = 2;
        } else {
            n4 = 1;
        }
        int n6 = nArray[7] == 45 ? -1 : 1;
        int n7 = n3 = this.indexOf(string2, n4, n, 'T');
        if (n3 == -1) {
            n7 = n;
        }
        int n8 = this.indexOf(string2, n4, n7, 'Y');
        n3 = n4;
        if (n8 != -1) {
            nArray[0] = this.parseInt(string2, n4, n8) * n6;
            n3 = n8 + 1;
            n2 = 1;
        }
        n8 = this.indexOf(string2, n3, n7, 'M');
        n4 = n2;
        n2 = n3;
        if (n8 != -1) {
            nArray[1] = this.parseInt(string2, n3, n8) * n6;
            n2 = n8 + 1;
            n4 = 1;
        }
        n8 = this.indexOf(string2, n2, n7, 'D');
        n3 = n2;
        if (n8 != -1) {
            nArray[2] = this.parseInt(string2, n2, n8) * n6;
            n3 = n8 + 1;
            n4 = 1;
        }
        if (n == n7 && n3 != n) {
            throw new SchemaDateTimeException();
        }
        n2 = n4;
        if (n != n7) {
            n2 = n3 + 1;
            n7 = this.indexOf(string2, n2, n, 'H');
            n3 = n2;
            if (n7 != -1) {
                nArray[3] = this.parseInt(string2, n2, n7) * n6;
                n3 = n7 + 1;
                n4 = 1;
            }
            n7 = this.indexOf(string2, n3, n, 'M');
            n2 = n4;
            n4 = n3;
            if (n7 != -1) {
                nArray[4] = this.parseInt(string2, n3, n7) * n6;
                n4 = n7 + 1;
                n2 = 1;
            }
            if ((n3 = this.indexOf(string2, n4, n, 'S')) != -1) {
                n2 = this.indexOf(string2, n4, n3, '.');
                if (n2 > 0) {
                    nArray[5] = this.parseInt(string2, n4, n2) * n6;
                    nArray[6] = n6 * this.parseInt(string2, n2 + 1, n3);
                } else {
                    nArray[5] = n6 * this.parseInt(string2, n4, n3);
                }
                n4 = n3 + 1;
                n3 = n5;
            } else {
                n3 = n2;
            }
            if (n4 != n || string2.charAt(n4 - 1) == 'T') throw new SchemaDateTimeException();
            n2 = n3;
        }
        if (n2 == 0) throw new SchemaDateTimeException();
        return nArray;
    }
}

