/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class FloatDV
extends TypeValidator {
    @Override
    public int compare(Object object, Object object2) {
        return ((XFloat)object).compareTo((XFloat)object2);
    }

    @Override
    public Object getActualValue(String string2, ValidationContext object) throws InvalidDatatypeValueException {
        try {
            object = new XFloat(string2);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "float"});
        }
    }

    @Override
    public short getAllowedFacets() {
        return 2552;
    }

    private static final class XFloat {
        private String canonical;
        private float value;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public XFloat(String string2) throws NumberFormatException {
            try {
                this.value = Float.parseFloat(string2);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                float f;
                if (string2.equals("INF")) {
                    f = Float.POSITIVE_INFINITY;
                } else if (string2.equals("-INF")) {
                    f = Float.NEGATIVE_INFINITY;
                } else {
                    if (!string2.equals("NaN")) throw numberFormatException;
                    f = Float.NaN;
                }
                this.value = f;
                return;
            }
        }

        private int compareTo(XFloat xFloat) {
            float f = this.value;
            float f2 = xFloat.value;
            if (f < f2) {
                return -1;
            }
            if (f > f2) {
                return 1;
            }
            if (f == f2) {
                return 0;
            }
            if (f != f && f2 != f2) {
                return 0;
            }
            return 2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XFloat)) {
                return false;
            }
            object = (XFloat)object;
            float f = this.value;
            float f2 = ((XFloat)object).value;
            if (f == f2) {
                return true;
            }
            return f != f && f2 != f2;
        }

        /*
         * Unable to fully structure code
         */
        public String toString() {
            synchronized (this) {
                block19: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        if (this.canonical != null) break block19;
                                        var1_1 = this.value;
                                        if (var1_1 != Infinityf) break block20;
                                        var2_2 = "INF";
lbl7:
                                        // 5 sources

                                        while (true) {
                                            this.canonical = var2_2;
                                            break block19;
                                            break;
                                        }
                                    }
                                    if (var1_1 != -Infinityf) break block21;
                                    var2_2 = "-INF";
                                    ** GOTO lbl7
                                }
                                if (var1_1 == var1_1) break block22;
                                var2_2 = "NaN";
                                ** GOTO lbl7
                            }
                            if (var1_1 != 0.0f) break block23;
                            var2_2 = "0.0E1";
                            ** GOTO lbl7
                        }
                        var2_2 = Float.toString(var1_1);
                        this.canonical = var2_2;
                        if (var2_2.indexOf(69) != -1) break block19;
                        var3_4 = this.canonical.length();
                        var2_2 = new char[var3_4 + 3];
                        this.canonical.getChars(0, var3_4, (char[])var2_2, 0);
                        var4_5 = var2_2[0] == 45 ? 2 : 1;
                        var1_1 = this.value;
                        if (var1_1 >= 1.0f || var1_1 <= -1.0f) break block24;
                        var6_7 = var5_6 = var4_5 + 1;
                        while (true) {
                            block25: {
                                if (var2_2[var6_7] == 48) break block25;
                                var2_2[var4_5 - 1] = (char)var2_2[var6_7];
                                var2_2[var4_5] = (char)46;
                                var7_9 = var6_7 + 1;
                                var8_11 = var5_6;
                                while (true) {
                                    block26: {
                                        if (var7_9 < var3_4) break block26;
                                        var8_11 = var6_7 - var4_5;
                                        var4_5 = var6_7 = var3_4 - var8_11;
                                        if (var6_7 == var5_6) {
                                            var2_2[var6_7] = (char)48;
                                            var4_5 = var6_7 + 1;
                                        }
                                        var5_6 = var4_5 + 1;
                                        var2_2[var4_5] = (char)69;
                                        var4_5 = var5_6 + 1;
                                        var2_2[var5_6] = (char)45;
                                        var5_6 = var4_5 + 1;
                                        var2_2[var4_5] = (char)(var8_11 + 48);
                                        ** GOTO lbl81
                                    }
                                    var2_2[var8_11] = (char)var2_2[var7_9];
                                    ++var7_9;
                                    ++var8_11;
                                }
                            }
                            ++var6_7;
                        }
                    }
                    var5_6 = var8_12 = this.canonical.indexOf(46);
                    while (true) {
                        block27: {
                            if (var5_6 > var4_5) break block27;
                            var2_2[var4_5] = (char)46;
                            var5_6 = var3_4;
                            while (true) {
                                block28: {
                                    if (var2_2[var7_10 = var5_6 - 1] == 48) break block28;
                                    var6_8 = var5_6;
                                    if (var2_2[var7_10] == 46) {
                                        var6_8 = var5_6 + 1;
                                    }
                                    var7_10 = var6_8 + 1;
                                    var2_2[var6_8] = (char)69;
                                    var5_6 = var7_10 + 1;
                                    var2_2[var7_10] = (char)(var8_12 - var4_5 + 48);
lbl81:
                                    // 3 sources

                                    var2_2 = new String((char[])var2_2, 0, var5_6);
                                    ** continue;
                                }
                                --var5_6;
                            }
                        }
                        var2_2[var5_6] = (char)var2_2[var5_6 - 1];
                        --var5_6;
                    }
                }
                var2_2 = this.canonical;
                return var2_2;
            }
        }
    }
}

