/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.util.HexBin;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class HexBinaryDV
extends TypeValidator {
    @Override
    public Object getActualValue(String string2, ValidationContext object) throws InvalidDatatypeValueException {
        object = HexBin.decode(string2);
        if (object != null) {
            return new XHex((byte[])object);
        }
        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "hexBinary"});
    }

    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public int getDataLength(Object object) {
        return ((XHex)object).length();
    }

    private static final class XHex {
        private String canonical;
        final byte[] data;

        public XHex(byte[] byArray) {
            this.data = byArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof XHex)) {
                return false;
            }
            int n = this.data.length;
            object = ((XHex)object).data;
            if (n != ((Object)object).length) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (this.data[n2] != object[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public int length() {
            return this.data.length;
        }

        public String toString() {
            synchronized (this) {
                if (this.canonical == null) {
                    this.canonical = HexBin.encode(this.data);
                }
                String string2 = this.canonical;
                return string2;
            }
        }
    }
}

