/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDayDV
extends AbstractDateTimeDV {
    private static final int MONTHDAY_SIZE = 7;

    @Override
    protected String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append('-');
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[1], 2);
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[2], 2);
        this.append(stringBuffer, (char)nArray[7], 0);
        return stringBuffer.toString();
    }

    @Override
    public Object getActualValue(String string2, ValidationContext object) throws InvalidDatatypeValueException {
        try {
            object = new AbstractDateTimeDV.DateTimeData(this.parse(string2), this);
            return object;
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "gMonthDay"});
        }
    }

    protected int[] parse(String string2) throws SchemaDateTimeException {
        int n = string2.length();
        int[] nArray = new int[8];
        Object object = new int[2];
        nArray[0] = 2000;
        if (string2.charAt(0) == '-' && string2.charAt(1) == '-') {
            nArray[1] = this.parseInt(string2, 2, 4);
            if (string2.charAt(4) == '-') {
                nArray[2] = this.parseInt(string2, 5, 7);
                if (7 < n) {
                    int n2 = this.findUTCSign(string2, 7, n);
                    if (n2 >= 0) {
                        this.getTimeZone(string2, nArray, n2, n, (int[])object);
                    } else {
                        object = new StringBuffer();
                        ((StringBuffer)object).append("Error in month parsing:");
                        ((StringBuffer)object).append(string2);
                        throw new SchemaDateTimeException(((StringBuffer)object).toString());
                    }
                }
                this.validateDateTime(nArray, (int[])object);
                if (nArray[7] != 0 && nArray[7] != 90) {
                    this.normalize(nArray, (int[])object);
                }
                return nArray;
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("Invalid format for gMonthDay: ");
            ((StringBuffer)object).append(string2);
            throw new SchemaDateTimeException(((StringBuffer)object).toString());
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("Invalid format for gMonthDay: ");
        ((StringBuffer)object).append(string2);
        throw new SchemaDateTimeException(((StringBuffer)object).toString());
    }
}

