/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.QName;

public class QNameDV
extends TypeValidator {
    private static final String EMPTY_STRING = "".intern();

    @Override
    public Object getActualValue(String string2, ValidationContext validationContext) throws InvalidDatatypeValueException {
        String string3;
        String string4;
        int n = string2.indexOf(":");
        if (n > 0) {
            string4 = validationContext.getSymbol(string2.substring(0, n));
            string3 = string2.substring(n + 1);
        } else {
            string4 = EMPTY_STRING;
            string3 = string2;
        }
        if (string4.length() > 0 && !XMLChar.isValidNCName(string4)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "QName"});
        }
        if (XMLChar.isValidNCName(string3)) {
            String string5 = validationContext.getURI(string4);
            if (string4.length() > 0 && string5 == null) {
                throw new InvalidDatatypeValueException("UndeclaredPrefix", new Object[]{string2, string4});
            }
            return new XQName(string4, validationContext.getSymbol(string3), validationContext.getSymbol(string2), string5);
        }
        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "QName"});
    }

    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public int getDataLength(Object object) {
        return ((XQName)object).rawname.length();
    }

    private static final class XQName
    extends QName {
        public XQName(String string2, String string3, String string4, String string5) {
            this.setValues(string2, string3, string4, string5);
        }

        @Override
        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof QName;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (QName)object;
                bl3 = bl;
                if (this.uri == ((QName)object).uri) {
                    bl3 = bl;
                    if (this.localpart == ((QName)object).localpart) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        public String toString() {
            synchronized (this) {
                String string2 = this.rawname;
                return string2;
            }
        }
    }
}

