/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.apache.xerces.util.MessageFormatter;

public class ASCIIReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected byte[] fBuffer;
    private MessageFormatter fFormatter = null;
    protected InputStream fInputStream;
    private Locale fLocale = null;

    public ASCIIReader(InputStream inputStream, int n, MessageFormatter messageFormatter, Locale locale) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[n];
        this.fFormatter = messageFormatter;
        this.fLocale = locale;
    }

    public ASCIIReader(InputStream inputStream, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, 2048, messageFormatter, locale);
    }

    @Override
    public void close() throws IOException {
        this.fInputStream.close();
    }

    @Override
    public void mark(int n) throws IOException {
        this.fInputStream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        int n = this.fInputStream.read();
        if (n <= 128) {
            return n;
        }
        throw new IOException(this.fFormatter.formatMessage(this.fLocale, "InvalidASCII", new Object[]{Integer.toString(n)}));
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        byte by;
        byte[] byArray = this.fBuffer;
        int n3 = n2;
        if (n2 > byArray.length) {
            n3 = byArray.length;
        }
        n3 = this.fInputStream.read(byArray, 0, n3);
        n2 = 0;
        while (true) {
            if (n2 >= n3) {
                return n3;
            }
            by = this.fBuffer[n2];
            if (by > 128) break;
            cArray[n + n2] = (char)by;
            ++n2;
        }
        throw new IOException(this.fFormatter.formatMessage(this.fLocale, "InvalidASCII", new Object[]{Integer.toString(by)}));
    }

    @Override
    public boolean ready() throws IOException {
        return false;
    }

    @Override
    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.fInputStream.skip(l);
    }
}

