/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;

public class UCSReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final short UCS2BE = 2;
    public static final short UCS2LE = 1;
    public static final short UCS4BE = 8;
    public static final short UCS4LE = 4;
    protected byte[] fBuffer;
    protected short fEncoding;
    protected InputStream fInputStream;

    public UCSReader(InputStream inputStream, int n, short s) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[n];
        this.fEncoding = s;
    }

    public UCSReader(InputStream inputStream, short s) {
        this(inputStream, 8192, s);
    }

    @Override
    public void close() throws IOException {
        this.fInputStream.close();
    }

    @Override
    public void mark(int n) throws IOException {
        this.fInputStream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        int n = this.fInputStream.read() & 0xFF;
        if (n == 255) {
            return -1;
        }
        int n2 = this.fInputStream.read() & 0xFF;
        if (n2 == 255) {
            return -1;
        }
        int n3 = this.fEncoding;
        if (n3 >= 4) {
            n3 = this.fInputStream.read() & 0xFF;
            if (n3 == 255) {
                return -1;
            }
            int n4 = this.fInputStream.read() & 0xFF;
            if (n4 == 255) {
                return -1;
            }
            PrintStream printStream = System.err;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("b0 is ");
            stringBuffer.append(n & 0xFF);
            stringBuffer.append(" b1 ");
            stringBuffer.append(n2 & 0xFF);
            stringBuffer.append(" b2 ");
            stringBuffer.append(n3 & 0xFF);
            stringBuffer.append(" b3 ");
            stringBuffer.append(n4 & 0xFF);
            printStream.println(stringBuffer.toString());
            if (this.fEncoding == 8) {
                return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
            }
            n2 = (n4 << 24) + (n3 << 16) + (n2 << 8);
            return n2 + n;
        }
        if (n3 == 2) {
            return (n << 8) + n2;
        }
        n2 <<= 8;
        return n2 + n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        Object object;
        int n6;
        int n7;
        block17: {
            block16: {
                block15: {
                    n7 = this.fEncoding;
                    n6 = 1;
                    n7 = n7 >= 4 ? 2 : 1;
                    n7 = n2 << n7;
                    byte[] byArray = this.fBuffer;
                    n2 = n7;
                    if (n7 > byArray.length) {
                        n2 = byArray.length;
                    }
                    object = this.fInputStream;
                    n5 = 0;
                    n7 = ((InputStream)object).read(byArray, 0, n2);
                    if (n7 == -1) {
                        return -1;
                    }
                    if (this.fEncoding < 4) break block15;
                    n4 = 4 - (n7 & 3) & 3;
                    break block16;
                }
                n2 = n7;
                if ((n7 & 1) != 0) {
                    n2 = n7 + 1;
                    n7 = this.fInputStream.read();
                    this.fBuffer[n2] = n7 == -1 ? (byte)0 : (byte)((byte)n7);
                }
                break block17;
            }
            block0: for (n2 = 0; n2 < n4; ++n2) {
                n3 = this.fInputStream.read();
                if (n3 != -1) {
                    this.fBuffer[n7 + n2] = (byte)n3;
                    continue;
                }
                while (true) {
                    block18: {
                        if (n2 < n4) break block18;
                        n2 = n7 + n4;
                        break block0;
                    }
                    this.fBuffer[n7 + n2] = (byte)0;
                    ++n2;
                }
            }
        }
        n7 = n6;
        if (this.fEncoding >= 4) {
            n7 = 2;
        }
        n6 = n2 >> n7;
        n2 = 0;
        n7 = n5;
        while (n7 < n6) {
            int n8;
            object = this.fBuffer;
            n4 = n2 + 1;
            n5 = object[n2] & 0xFF;
            n2 = n4 + 1;
            n4 = object[n4] & 0xFF;
            n3 = this.fEncoding;
            if (n3 >= 4) {
                n8 = n2 + 1;
                n2 = object[n2] & 0xFF;
                int n9 = object[n8] & 0xFF;
                cArray[n + n7] = n3 == 8 ? (char)((char)((n5 << 24) + (n4 << 16) + (n2 << 8) + n9)) : (char)((char)((n9 << 24) + (n2 << 16) + (n4 << 8) + n5));
                n2 = n8 + 1;
            } else {
                n8 = n + n7;
                cArray[n8] = n3 == 2 ? (char)((char)((n5 << 8) + n4)) : (char)((char)((n4 << 8) + n5));
            }
            ++n7;
        }
        return n6;
    }

    @Override
    public boolean ready() throws IOException {
        return false;
    }

    @Override
    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        int n = this.fEncoding >= 4 ? 2 : 1;
        long l2 = this.fInputStream.skip(l << n);
        l = n | 1;
        long l3 = l2 >> n;
        if ((l & l2) == 0L) {
            return l3;
        }
        return l3 + 1L;
    }
}

