/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.util.Locale;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.util.MessageFormatter;

public class UTF8Reader
extends Reader {
    private static final boolean DEBUG_READ = false;
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected byte[] fBuffer;
    private MessageFormatter fFormatter = null;
    protected InputStream fInputStream;
    private Locale fLocale = null;
    protected int fOffset;
    private int fSurrogate = -1;

    public UTF8Reader(InputStream inputStream) {
        this(inputStream, 2048, new XMLMessageFormatter(), Locale.getDefault());
    }

    public UTF8Reader(InputStream inputStream, int n, MessageFormatter messageFormatter, Locale locale) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[n];
        this.fFormatter = messageFormatter;
        this.fLocale = locale;
    }

    public UTF8Reader(InputStream inputStream, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, 2048, messageFormatter, locale);
    }

    private void expectedByte(int n, int n2) throws UTFDataFormatException {
        throw new UTFDataFormatException(this.fFormatter.formatMessage(this.fLocale, "ExpectedByte", new Object[]{Integer.toString(n), Integer.toString(n2)}));
    }

    private void invalidByte(int n, int n2, int n3) throws UTFDataFormatException {
        throw new UTFDataFormatException(this.fFormatter.formatMessage(this.fLocale, "InvalidByte", new Object[]{Integer.toString(n), Integer.toString(n2)}));
    }

    private void invalidSurrogate(int n) throws UTFDataFormatException {
        new StringBuffer().append("high surrogate bits in UTF-8 sequence must not exceed 0x10 but found 0x");
        throw new UTFDataFormatException(this.fFormatter.formatMessage(this.fLocale, "InvalidHighSurrogate", new Object[]{Integer.toHexString(n)}));
    }

    @Override
    public void close() throws IOException {
        this.fInputStream.close();
    }

    @Override
    public void mark(int n) throws IOException {
        throw new IOException(this.fFormatter.formatMessage(this.fLocale, "OperationNotSupported", new Object[]{"mark()", "UTF-8"}));
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        int n = this.fSurrogate;
        int n2 = -1;
        int n3 = n;
        if (n == -1) {
            n3 = 0;
            if (this.fOffset == 0) {
                n2 = this.fInputStream.read();
            } else {
                n2 = this.fBuffer[0] & 0xFF;
                n3 = 1;
            }
            if (n2 == -1) {
                return -1;
            }
            if (n2 < 128) {
                return (char)n2;
            }
            if ((n2 & 0xE0) == 192) {
                if ((n3 = n3 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n3] & 0xFF) == -1) {
                    this.expectedByte(2, 2);
                }
                if ((n3 & 0xC0) == 128) return n3 & 0x3F | n2 << 6 & 0x7C0;
                this.invalidByte(2, 2, n3);
                return n3 & 0x3F | n2 << 6 & 0x7C0;
            }
            if ((n2 & 0xF0) == 224) {
                if (n3 == this.fOffset) {
                    n = this.fInputStream.read();
                } else {
                    n = this.fBuffer[n3] & 0xFF;
                    ++n3;
                }
                if (n == -1) {
                    this.expectedByte(2, 3);
                }
                if ((n & 0xC0) != 128) {
                    this.invalidByte(2, 3, n);
                }
                if ((n3 = n3 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n3] & 0xFF) == -1) {
                    this.expectedByte(3, 3);
                }
                if ((n3 & 0xC0) == 128) return n << 6 & 0xFC0 | n2 << 12 & 0xF000 | n3 & 0x3F;
                this.invalidByte(3, 3, n3);
                return n << 6 & 0xFC0 | n2 << 12 & 0xF000 | n3 & 0x3F;
            }
            if ((n2 & 0xF8) == 240) {
                int n4;
                if (n3 == this.fOffset) {
                    n = this.fInputStream.read();
                } else {
                    n = this.fBuffer[n3] & 0xFF;
                    ++n3;
                }
                if (n == -1) {
                    this.expectedByte(2, 4);
                }
                if ((n & 0xC0) != 128) {
                    this.invalidByte(2, 3, n);
                }
                if (n3 == this.fOffset) {
                    int n5 = this.fInputStream.read();
                    n4 = n3;
                    n3 = n5;
                } else {
                    n4 = this.fBuffer[n3] & 0xFF;
                    int n6 = n3 + 1;
                    n3 = n4;
                    n4 = n6;
                }
                if (n3 == -1) {
                    this.expectedByte(3, 4);
                }
                if ((n3 & 0xC0) != 128) {
                    this.invalidByte(3, 3, n3);
                }
                if ((n4 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4] & 0xFF) == -1) {
                    this.expectedByte(4, 4);
                }
                if ((n4 & 0xC0) != 128) {
                    this.invalidByte(4, 4, n4);
                }
                if ((n2 = n2 << 2 & 0x1C | n >> 4 & 3) > 16) {
                    this.invalidSurrogate(n2);
                }
                n = n << 2 & 0x3C | (n2 - 1 << 6 & 0x3C0 | 0xD800) | n3 >> 4 & 3;
                n2 = 0xDC00 | n3 << 6 & 0x3C0 | n4 & 0x3F;
                n3 = n;
            } else {
                this.invalidByte(1, 1, n2);
                return n;
            }
        }
        this.fSurrogate = n2;
        return n3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public int read(char[] objectArray, int n, int n2) throws IOException {
        byte[] byArray;
        int n3;
        int n4;
        void var2_11;
        int n5 = this.fSurrogate;
        if (n5 != -1) {
            n4 = var2_11 + true;
            objectArray[n4] = (char)n5;
            this.fSurrogate = -1;
            --n3;
        } else {
            n4 = var2_11;
        }
        n5 = this.fOffset;
        if (n5 == 0) {
            byArray = this.fBuffer;
            n5 = n3;
            if (n3 > byArray.length) {
                n5 = byArray.length;
            }
            if ((n3 = this.fInputStream.read(byArray, 0, n5)) == -1) {
                return -1;
            }
            n5 = n4 - var2_11 + n3;
        } else {
            this.fOffset = 0;
        }
        n3 = n5;
        int n6 = 0;
        while (true) {
            block21: {
                int n7;
                block62: {
                    block27: {
                        block45: {
                            int n8;
                            int n9;
                            int n10;
                            block59: {
                                block60: {
                                    block61: {
                                        block44: {
                                            block58: {
                                                block56: {
                                                    block57: {
                                                        block53: {
                                                            block54: {
                                                                block55: {
                                                                    block30: {
                                                                        block52: {
                                                                            block50: {
                                                                                block51: {
                                                                                    block47: {
                                                                                        block48: {
                                                                                            block49: {
                                                                                                block46: {
                                                                                                    block31: {
                                                                                                        block42: {
                                                                                                            block43: {
                                                                                                                block39: {
                                                                                                                    block40: {
                                                                                                                        block41: {
                                                                                                                            block38: {
                                                                                                                                block36: {
                                                                                                                                    block37: {
                                                                                                                                        block33: {
                                                                                                                                            block34: {
                                                                                                                                                block35: {
                                                                                                                                                    block32: {
                                                                                                                                                        block22: {
                                                                                                                                                            block28: {
                                                                                                                                                                block29: {
                                                                                                                                                                    block24: {
                                                                                                                                                                        block25: {
                                                                                                                                                                            block26: {
                                                                                                                                                                                block23: {
                                                                                                                                                                                    block20: {
                                                                                                                                                                                        if (n6 >= n5) {
                                                                                                                                                                                            return n3;
                                                                                                                                                                                        }
                                                                                                                                                                                        byArray = this.fBuffer;
                                                                                                                                                                                        n7 = byArray[n6] & 0xFF;
                                                                                                                                                                                        if (n7 >= 128) break block20;
                                                                                                                                                                                        objectArray[n4] = (char)n7;
                                                                                                                                                                                        ++n4;
                                                                                                                                                                                        break block21;
                                                                                                                                                                                    }
                                                                                                                                                                                    if ((n7 & 0xE0) != 192) break block22;
                                                                                                                                                                                    n10 = n6 + 1;
                                                                                                                                                                                    if (n10 >= n5) break block23;
                                                                                                                                                                                    n9 = byArray[n10] & 0xFF;
                                                                                                                                                                                    n6 = n3;
                                                                                                                                                                                    n3 = n9;
                                                                                                                                                                                    break block24;
                                                                                                                                                                                }
                                                                                                                                                                                n6 = this.fInputStream.read();
                                                                                                                                                                                if (n6 != -1) break block25;
                                                                                                                                                                                if (n4 <= var2_11) break block26;
                                                                                                                                                                                this.fBuffer[0] = (byte)n7;
                                                                                                                                                                                break block27;
                                                                                                                                                                            }
                                                                                                                                                                            this.expectedByte(2, 2);
                                                                                                                                                                        }
                                                                                                                                                                        n9 = n3 + 1;
                                                                                                                                                                        n3 = n6;
                                                                                                                                                                        n6 = n9;
                                                                                                                                                                    }
                                                                                                                                                                    if ((n3 & 0xC0) == 128) break block28;
                                                                                                                                                                    if (n4 <= var2_11) break block29;
                                                                                                                                                                    byte[] byArray2 = this.fBuffer;
                                                                                                                                                                    byArray2[0] = (byte)n7;
                                                                                                                                                                    byArray2[1] = (byte)n3;
                                                                                                                                                                    break block30;
                                                                                                                                                                }
                                                                                                                                                                this.invalidByte(2, 2, n3);
                                                                                                                                                            }
                                                                                                                                                            n9 = n4 + true;
                                                                                                                                                            objectArray[n4] = (char)(n3 & 0x3F | n7 << 6 & 0x7C0);
                                                                                                                                                            n3 = n6 - 1;
                                                                                                                                                            n4 = n9;
                                                                                                                                                            n6 = n10;
                                                                                                                                                            break block21;
                                                                                                                                                        }
                                                                                                                                                        if ((n7 & 0xF0) != 224) break block31;
                                                                                                                                                        n10 = n6 + 1;
                                                                                                                                                        if (n10 >= n5) break block32;
                                                                                                                                                        n6 = byArray[n10] & 0xFF;
                                                                                                                                                        break block33;
                                                                                                                                                    }
                                                                                                                                                    n6 = this.fInputStream.read();
                                                                                                                                                    if (n6 != -1) break block34;
                                                                                                                                                    if (n4 <= var2_11) break block35;
                                                                                                                                                    this.fBuffer[0] = (byte)n7;
                                                                                                                                                    break block27;
                                                                                                                                                }
                                                                                                                                                this.expectedByte(2, 3);
                                                                                                                                            }
                                                                                                                                            ++n3;
                                                                                                                                        }
                                                                                                                                        if ((n6 & 0xC0) == 128) break block36;
                                                                                                                                        if (n4 <= var2_11) break block37;
                                                                                                                                        byte[] byArray3 = this.fBuffer;
                                                                                                                                        byArray3[0] = (byte)n7;
                                                                                                                                        byArray3[1] = (byte)n6;
                                                                                                                                        break block30;
                                                                                                                                    }
                                                                                                                                    this.invalidByte(2, 3, n6);
                                                                                                                                }
                                                                                                                                if ((n9 = n10 + 1) >= n5) break block38;
                                                                                                                                n8 = this.fBuffer[n9] & 0xFF;
                                                                                                                                n10 = n3;
                                                                                                                                n3 = n8;
                                                                                                                                break block39;
                                                                                                                            }
                                                                                                                            n8 = this.fInputStream.read();
                                                                                                                            if (n8 != -1) break block40;
                                                                                                                            if (n4 <= var2_11) break block41;
                                                                                                                            byte[] byArray4 = this.fBuffer;
                                                                                                                            byArray4[0] = (byte)n7;
                                                                                                                            byArray4[1] = (byte)n6;
                                                                                                                            break block30;
                                                                                                                        }
                                                                                                                        this.expectedByte(3, 3);
                                                                                                                    }
                                                                                                                    n10 = n3 + 1;
                                                                                                                    n3 = n8;
                                                                                                                }
                                                                                                                if ((n3 & 0xC0) == 128) break block42;
                                                                                                                if (n4 <= var2_11) break block43;
                                                                                                                byte[] byArray5 = this.fBuffer;
                                                                                                                byArray5[0] = (byte)n7;
                                                                                                                byArray5[1] = (byte)n6;
                                                                                                                byArray5[2] = (byte)n3;
                                                                                                                break block44;
                                                                                                            }
                                                                                                            this.invalidByte(3, 3, n3);
                                                                                                        }
                                                                                                        n8 = n4 + 1;
                                                                                                        objectArray[n4] = (char)(n6 << 6 & 0xFC0 | n7 << 12 & 0xF000 | n3 & 0x3F);
                                                                                                        n3 = n10 - 2;
                                                                                                        n6 = n9;
                                                                                                        n4 = n8;
                                                                                                        break block21;
                                                                                                    }
                                                                                                    if ((n7 & 0xF8) != 240) break block45;
                                                                                                    n10 = n6 + 1;
                                                                                                    if (n10 >= n5) break block46;
                                                                                                    n6 = byArray[n10] & 0xFF;
                                                                                                    break block47;
                                                                                                }
                                                                                                n6 = this.fInputStream.read();
                                                                                                if (n6 != -1) break block48;
                                                                                                if (n4 <= var2_11) break block49;
                                                                                                this.fBuffer[0] = (byte)n7;
                                                                                                break block27;
                                                                                            }
                                                                                            this.expectedByte(2, 4);
                                                                                        }
                                                                                        ++n3;
                                                                                    }
                                                                                    if ((n6 & 0xC0) == 128) break block50;
                                                                                    if (n4 <= var2_11) break block51;
                                                                                    byte[] byArray6 = this.fBuffer;
                                                                                    byArray6[0] = (byte)n7;
                                                                                    byArray6[1] = (byte)n6;
                                                                                    break block30;
                                                                                }
                                                                                this.invalidByte(2, 4, n6);
                                                                            }
                                                                            if ((n9 = n10 + 1) >= n5) break block52;
                                                                            n10 = this.fBuffer[n9] & 0xFF;
                                                                            break block53;
                                                                        }
                                                                        n10 = this.fInputStream.read();
                                                                        if (n10 != -1) break block54;
                                                                        if (n4 <= var2_11) break block55;
                                                                        byte[] byArray7 = this.fBuffer;
                                                                        byArray7[0] = (byte)n7;
                                                                        byArray7[1] = (byte)n6;
                                                                    }
                                                                    this.fOffset = 2;
                                                                    return n4 - var2_11;
                                                                }
                                                                this.expectedByte(3, 4);
                                                            }
                                                            ++n3;
                                                        }
                                                        if ((n10 & 0xC0) == 128) break block56;
                                                        if (n4 <= var2_11) break block57;
                                                        byte[] byArray8 = this.fBuffer;
                                                        byArray8[0] = (byte)n7;
                                                        byArray8[1] = (byte)n6;
                                                        byArray8[2] = (byte)n10;
                                                        break block44;
                                                    }
                                                    this.invalidByte(3, 4, n10);
                                                }
                                                if ((n8 = n9 + 1) >= n5) break block58;
                                                n9 = this.fBuffer[n8] & 0xFF;
                                                break block59;
                                            }
                                            n9 = this.fInputStream.read();
                                            if (n9 != -1) break block60;
                                            if (n4 <= var2_11) break block61;
                                            byte[] byArray9 = this.fBuffer;
                                            byArray9[0] = (byte)n7;
                                            byArray9[1] = (byte)n6;
                                            byArray9[2] = (byte)n10;
                                        }
                                        this.fOffset = 3;
                                        return n4 - var2_11;
                                    }
                                    this.expectedByte(4, 4);
                                }
                                ++n3;
                            }
                            if ((n9 & 0xC0) != 128) {
                                if (n4 > var2_11) {
                                    byte[] byArray10 = this.fBuffer;
                                    byArray10[0] = (byte)n7;
                                    byArray10[1] = (byte)n6;
                                    byArray10[2] = (byte)n10;
                                    byArray10[3] = (byte)n9;
                                    this.fOffset = 4;
                                    return n4 - var2_11;
                                }
                                this.invalidByte(4, 4, n10);
                            }
                            if ((n7 = n7 << 2 & 0x1C | n6 >> 4 & 3) > 16) {
                                this.invalidSurrogate(n7);
                            }
                            int n11 = n10 & 0x3F;
                            n10 = n4 + 1;
                            objectArray[n4] = (char)((n6 & 0xF) << 2 | (n7 - 1 << 6 & 0x3C0 | 0xD800) | n11 >> 4);
                            n4 = n10 + 1;
                            objectArray[n10] = (char)(n9 & 0x3F | (0xDC00 | n11 << 6 & 0x3C0));
                            n3 -= 2;
                            n6 = n8;
                            break block21;
                        }
                        if (n4 <= var2_11) break block62;
                        byArray[0] = (byte)n7;
                    }
                    this.fOffset = 1;
                    return (int)(n4 - var2_11);
                }
                this.invalidByte(1, 1, n7);
            }
            ++n6;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return false;
    }

    @Override
    public void reset() throws IOException {
        this.fOffset = 0;
        this.fSurrogate = -1;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2;
        int n = this.fBuffer.length;
        char[] cArray = new char[n];
        long l3 = l;
        do {
            int n2 = (long)n < l3 ? n : (int)l3;
            n2 = this.read(cArray, 0, n2);
            l2 = l3;
            if (n2 <= 0) break;
            l3 = l2 = l3 - (long)n2;
        } while (l2 > 0L);
        return l - l2;
    }
}

