/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.msg;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.xerces.util.MessageFormatter;

public class XMLMessageFormatter
implements MessageFormatter {
    public static final String XMLNS_DOMAIN = "http://www.w3.org/TR/1999/REC-xml-names-19990114";
    public static final String XML_DOMAIN = "http://www.w3.org/TR/1998/REC-xml-19980210";
    private Locale fLocale = null;
    private ResourceBundle fResourceBundle = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String formatMessage(Locale object, String string2, Object[] objectArray) throws MissingResourceException {
        if (this.fResourceBundle == null || object != this.fLocale) {
            if (object != null) {
                this.fResourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.XMLMessages", (Locale)object);
                this.fLocale = object;
            }
            if (this.fResourceBundle == null) {
                this.fResourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.XMLMessages");
            }
        }
        try {
            String string3 = this.fResourceBundle.getString(string2);
            object = string3;
            if (objectArray != null) {
                try {
                    object = MessageFormat.format(string3, objectArray);
                }
                catch (Exception exception) {
                    string3 = this.fResourceBundle.getString("FormatFailed");
                    object = new StringBuffer();
                    ((StringBuffer)object).append(string3);
                    ((StringBuffer)object).append(" ");
                    ((StringBuffer)object).append(this.fResourceBundle.getString(string2));
                    object = ((StringBuffer)object).toString();
                }
            }
            if (object != null) return object;
            object = string2;
        }
        catch (MissingResourceException missingResourceException) {
            throw new MissingResourceException(string2, this.fResourceBundle.getString("BadMessageKey"), string2);
        }
        if (objectArray.length <= 0) return object;
        object = new StringBuffer(string2);
        ((StringBuffer)object).append('?');
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                ((StringBuffer)object).append('&');
            }
            ((StringBuffer)object).append(String.valueOf(objectArray[n]));
            ++n;
        }
        return string2;
    }
}

