/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.validation;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;

public class ValidationState
implements ValidationContext {
    private static final Object fNullValue = new Object();
    private EntityState fEntityState = null;
    private boolean fExtraChecking = true;
    private boolean fFacetChecking = true;
    private final Hashtable fIdRefTable;
    private final Hashtable fIdTable = new Hashtable();
    private NamespaceContext fNamespaceContext = null;
    private boolean fNormalize = true;
    private SymbolTable fSymbolTable = null;

    public ValidationState() {
        this.fIdRefTable = new Hashtable();
    }

    @Override
    public void addId(String string2) {
        this.fIdTable.put(string2, fNullValue);
    }

    @Override
    public void addIdRef(String string2) {
        this.fIdRefTable.put(string2, fNullValue);
    }

    public String checkIDRefID() {
        String string2;
        Enumeration enumeration = this.fIdRefTable.keys();
        do {
            if (enumeration.hasMoreElements()) continue;
            return null;
        } while (this.fIdTable.containsKey(string2 = (String)enumeration.nextElement()));
        return string2;
    }

    @Override
    public String getSymbol(String string2) {
        SymbolTable symbolTable = this.fSymbolTable;
        if (symbolTable != null) {
            return symbolTable.addSymbol(string2);
        }
        return string2.intern();
    }

    @Override
    public String getURI(String string2) {
        NamespaceContext namespaceContext = this.fNamespaceContext;
        if (namespaceContext != null) {
            return namespaceContext.getURI(string2);
        }
        return null;
    }

    @Override
    public boolean isEntityDeclared(String string2) {
        EntityState entityState = this.fEntityState;
        if (entityState != null) {
            return entityState.isEntityDeclared(this.getSymbol(string2));
        }
        return false;
    }

    @Override
    public boolean isEntityUnparsed(String string2) {
        EntityState entityState = this.fEntityState;
        if (entityState != null) {
            return entityState.isEntityUnparsed(this.getSymbol(string2));
        }
        return false;
    }

    @Override
    public boolean isIdDeclared(String string2) {
        return this.fIdTable.containsKey(string2);
    }

    @Override
    public boolean needExtraChecking() {
        return this.fExtraChecking;
    }

    @Override
    public boolean needFacetChecking() {
        return this.fFacetChecking;
    }

    @Override
    public boolean needToNormalize() {
        return this.fNormalize;
    }

    public void reset() {
        this.fExtraChecking = true;
        this.fFacetChecking = true;
        this.fIdTable.clear();
        this.fIdRefTable.clear();
        this.fEntityState = null;
        this.fNamespaceContext = null;
        this.fSymbolTable = null;
    }

    public void resetIDTables() {
        this.fIdTable.clear();
        this.fIdRefTable.clear();
    }

    public void setEntityState(EntityState entityState) {
        this.fEntityState = entityState;
    }

    public void setExtraChecking(boolean bl) {
        this.fExtraChecking = bl;
    }

    public void setFacetChecking(boolean bl) {
        this.fFacetChecking = bl;
    }

    public void setNamespaceSupport(NamespaceContext namespaceContext) {
        this.fNamespaceContext = namespaceContext;
    }

    public void setNormalizationRequired(boolean bl) {
        this.fNormalize = bl;
    }

    public void setSymbolTable(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }
}

