/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.text.CharacterIterator;
import org.apache.xerces.impl.xpath.regex.REUtil;

public class Match
implements Cloneable {
    int[] beginpos = null;
    char[] charSource = null;
    CharacterIterator ciSource = null;
    int[] endpos = null;
    int nofgroups = 0;
    String strSource = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object clone() {
        synchronized (this) {
            Match match = new Match();
            int n = this.nofgroups;
            if (n > 0) {
                match.setNumberOfGroups(n);
                Object object = this.ciSource;
                if (object != null) {
                    match.setSource((CharacterIterator)object);
                }
                if ((object = this.strSource) != null) {
                    match.setSource((String)object);
                }
                for (n = 0; n < this.nofgroups; ++n) {
                    match.setBeginning(n, this.getBeginning(n));
                    match.setEnd(n, this.getEnd(n));
                }
            }
            return match;
        }
    }

    public int getBeginning(int n) {
        Object object = this.beginpos;
        if (object != null) {
            if (n >= 0 && this.nofgroups > n) {
                return object[n];
            }
            object = new StringBuffer();
            object.append("The parameter must be less than ");
            object.append(this.nofgroups);
            object.append(": ");
            object.append(n);
            throw new IllegalArgumentException(object.toString());
        }
        throw new IllegalStateException("A result is not set.");
    }

    public String getCapturedText(int n) {
        Object object = this.beginpos;
        if (object != null) {
            if (n >= 0 && this.nofgroups > n) {
                int n2 = object[n];
                n = this.endpos[n];
                if (n2 >= 0 && n >= 0) {
                    object = this.ciSource;
                    object = object != null ? REUtil.substring((CharacterIterator)object, n2, n) : ((object = this.strSource) != null ? object.substring(n2, n) : new String(this.charSource, n2, n - n2));
                    return object;
                }
                return null;
            }
            object = new StringBuffer();
            object.append("The parameter must be less than ");
            object.append(this.nofgroups);
            object.append(": ");
            object.append(n);
            throw new IllegalArgumentException(object.toString());
        }
        throw new IllegalStateException("match() has never been called.");
    }

    public int getEnd(int n) {
        Object object = this.endpos;
        if (object != null) {
            if (n >= 0 && this.nofgroups > n) {
                return object[n];
            }
            object = new StringBuffer();
            object.append("The parameter must be less than ");
            object.append(this.nofgroups);
            object.append(": ");
            object.append(n);
            throw new IllegalArgumentException(object.toString());
        }
        throw new IllegalStateException("A result is not set.");
    }

    public int getNumberOfGroups() {
        int n = this.nofgroups;
        if (n > 0) {
            return n;
        }
        throw new IllegalStateException("A result is not set.");
    }

    protected void setBeginning(int n, int n2) {
        this.beginpos[n] = n2;
    }

    protected void setEnd(int n, int n2) {
        this.endpos[n] = n2;
    }

    protected void setNumberOfGroups(int n) {
        int n2 = this.nofgroups;
        this.nofgroups = n;
        if (n2 <= 0 || n2 < n || n * 2 < n2) {
            this.beginpos = new int[n];
            this.endpos = new int[n];
        }
        n2 = 0;
        while (n2 < n) {
            this.beginpos[n2] = -1;
            this.endpos[n2] = -1;
            ++n2;
        }
        return;
    }

    protected void setSource(String string2) {
        this.ciSource = null;
        this.strSource = string2;
        this.charSource = null;
    }

    protected void setSource(CharacterIterator characterIterator) {
        this.ciSource = characterIterator;
        this.strSource = null;
        this.charSource = null;
    }

    protected void setSource(char[] cArray) {
        this.ciSource = null;
        this.strSource = null;
        this.charSource = cArray;
    }
}

