/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.util.Vector;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.Token;

class Op {
    static final int ANCHOR = 5;
    static final int BACKREFERENCE = 16;
    static final int CAPTURE = 15;
    static final int CHAR = 1;
    static final int CLOSURE = 7;
    static final int CONDITION = 26;
    static final boolean COUNT = false;
    static final int DOT = 0;
    static final int INDEPENDENT = 24;
    static final int LOOKAHEAD = 20;
    static final int LOOKBEHIND = 22;
    static final int MODIFIER = 25;
    static final int NEGATIVELOOKAHEAD = 21;
    static final int NEGATIVELOOKBEHIND = 23;
    static final int NONGREEDYCLOSURE = 8;
    static final int NONGREEDYQUESTION = 10;
    static final int NRANGE = 4;
    static final int QUESTION = 9;
    static final int RANGE = 3;
    static final int STRING = 6;
    static final int UNION = 11;
    static int nofinstances;
    Op next = null;
    int type;

    protected Op(int n) {
        this.type = n;
    }

    static CharOp createAnchor(int n) {
        return new CharOp(5, n);
    }

    static CharOp createBackReference(int n) {
        return new CharOp(16, n);
    }

    static CharOp createCapture(int n, Op op) {
        CharOp charOp = new CharOp(15, n);
        charOp.next = op;
        return charOp;
    }

    static CharOp createChar(int n) {
        return new CharOp(1, n);
    }

    static ChildOp createClosure(int n) {
        return new ModifierOp(7, n, -1);
    }

    static ConditionOp createCondition(Op op, int n, Op op2, Op op3, Op op4) {
        op2 = new ConditionOp(26, n, op2, op3, op4);
        op2.next = op;
        return op2;
    }

    static Op createDot() {
        return new Op(0);
    }

    static ChildOp createIndependent(Op op, Op op2) {
        ChildOp childOp = new ChildOp(24);
        childOp.setChild(op2);
        childOp.next = op;
        return childOp;
    }

    static ChildOp createLook(int n, Op op, Op op2) {
        ChildOp childOp = new ChildOp(n);
        childOp.setChild(op2);
        childOp.next = op;
        return childOp;
    }

    static ModifierOp createModifier(Op op, Op op2, int n, int n2) {
        ModifierOp modifierOp = new ModifierOp(25, n, n2);
        modifierOp.setChild(op2);
        modifierOp.next = op;
        return modifierOp;
    }

    static ChildOp createNonGreedyClosure() {
        return new ChildOp(8);
    }

    static ChildOp createQuestion(boolean bl) {
        int n = bl ? 10 : 9;
        return new ChildOp(n);
    }

    static RangeOp createRange(Token token) {
        return new RangeOp(3, token);
    }

    static StringOp createString(String string2) {
        return new StringOp(6, string2);
    }

    static UnionOp createUnion(int n) {
        return new UnionOp(11, n);
    }

    Op elementAt(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Internal Error: type=");
        stringBuffer.append(this.type);
        throw new RuntimeException(stringBuffer.toString());
    }

    Op getChild() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Internal Error: type=");
        stringBuffer.append(this.type);
        throw new RuntimeException(stringBuffer.toString());
    }

    int getData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Internal Error: type=");
        stringBuffer.append(this.type);
        throw new RuntimeException(stringBuffer.toString());
    }

    int getData2() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Internal Error: type=");
        stringBuffer.append(this.type);
        throw new RuntimeException(stringBuffer.toString());
    }

    String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Internal Error: type=");
        stringBuffer.append(this.type);
        throw new RuntimeException(stringBuffer.toString());
    }

    RangeToken getToken() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Internal Error: type=");
        stringBuffer.append(this.type);
        throw new RuntimeException(stringBuffer.toString());
    }

    int size() {
        return 0;
    }

    static class CharOp
    extends Op {
        int charData;

        CharOp(int n, int n2) {
            super(n);
            this.charData = n2;
        }

        @Override
        int getData() {
            return this.charData;
        }
    }

    static class ChildOp
    extends Op {
        Op child;

        ChildOp(int n) {
            super(n);
        }

        @Override
        Op getChild() {
            return this.child;
        }

        void setChild(Op op) {
            this.child = op;
        }
    }

    static class ConditionOp
    extends Op {
        Op condition;
        Op no;
        int refNumber;
        Op yes;

        ConditionOp(int n, int n2, Op op, Op op2, Op op3) {
            super(n);
            this.refNumber = n2;
            this.condition = op;
            this.yes = op2;
            this.no = op3;
        }
    }

    static class ModifierOp
    extends ChildOp {
        int v1;
        int v2;

        ModifierOp(int n, int n2, int n3) {
            super(n);
            this.v1 = n2;
            this.v2 = n3;
        }

        @Override
        int getData() {
            return this.v1;
        }

        @Override
        int getData2() {
            return this.v2;
        }
    }

    static class RangeOp
    extends Op {
        Token tok;

        RangeOp(int n, Token token) {
            super(n);
            this.tok = token;
        }

        @Override
        RangeToken getToken() {
            return (RangeToken)this.tok;
        }
    }

    static class StringOp
    extends Op {
        String string;

        StringOp(int n, String string2) {
            super(n);
            this.string = string2;
        }

        @Override
        String getString() {
            return this.string;
        }
    }

    static class UnionOp
    extends Op {
        Vector branches;

        UnionOp(int n, int n2) {
            super(n);
            this.branches = new Vector(n2);
        }

        void addElement(Op op) {
            this.branches.addElement(op);
        }

        @Override
        Op elementAt(int n) {
            return (Op)this.branches.elementAt(n);
        }

        @Override
        int size() {
            return this.branches.size();
        }
    }
}

