/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.io.PrintStream;
import java.io.Serializable;
import org.apache.xerces.impl.xpath.regex.Token;

final class RangeToken
extends Token
implements Serializable {
    private static final int MAPSIZE = 256;
    boolean compacted;
    RangeToken icaseCache = null;
    int[] map = null;
    int nonMapIndex;
    int[] ranges;
    boolean sorted;

    RangeToken(int n) {
        super(n);
        this.setSorted(false);
    }

    static Token complementRanges(Token object) {
        if (((Token)object).type != 4 && ((Token)object).type != 5) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Token#complementRanges(): must be RANGE: ");
            stringBuffer.append(((Token)object).type);
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        Object object2 = (RangeToken)object;
        ((RangeToken)object2).sortRanges();
        ((RangeToken)object2).compactRanges();
        object = ((RangeToken)object2).ranges;
        int n = ((Object)object).length + 2;
        int n2 = 0;
        int n3 = n;
        if (object[0] == false) {
            n3 = n - 2;
        }
        Object object3 = object[((Object)object).length - 1];
        n = n3;
        if (object3 == 0x10FFFF) {
            n = n3 - 2;
        }
        object = Token.createRange();
        int[] nArray = new int[n];
        ((RangeToken)object).ranges = nArray;
        int[] nArray2 = ((RangeToken)object2).ranges;
        n3 = n2;
        if (nArray2[0] > 0) {
            nArray[0] = 0;
            nArray[1] = nArray2[0] - 1;
            n3 = 2;
        }
        n2 = 1;
        n = n3;
        n3 = n2;
        while (true) {
            if (n3 >= (nArray2 = ((RangeToken)object2).ranges).length - 2) {
                if (object3 != 0x10FFFF) {
                    object2 = ((RangeToken)object).ranges;
                    object2[n] = object3 + true;
                    object2[n + 1] = 0x10FFFF;
                }
                super.setCompacted();
                return object;
            }
            nArray = ((RangeToken)object).ranges;
            n2 = n + 1;
            nArray[n] = nArray2[n3] + 1;
            n = n2 + 1;
            nArray[n2] = nArray2[n3 + 1] - 1;
            n3 += 2;
        }
    }

    private void createMap() {
        this.map = new int[8];
        this.nonMapIndex = this.ranges.length;
        int n = 0;
        int n2 = 0;
        while (true) {
            if (n2 >= 8) {
                int[] nArray;
                for (n2 = n; n2 < (nArray = this.ranges).length; n2 += 2) {
                    int n3 = nArray[n2 + 1];
                    if (n < 256) {
                        for (n = nArray[n2]; n <= n3 && n < 256; ++n) {
                            nArray = this.map;
                            int n4 = n / 32;
                            nArray[n4] = nArray[n4] | 1 << (n & 0x1F);
                        }
                        if (n3 < 256) {
                            continue;
                        }
                    }
                    this.nonMapIndex = n2;
                    break;
                }
                return;
            }
            this.map[n2] = 0;
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String escapeCharInCharClass(int var0) {
        block12: {
            block7: {
                block8: {
                    block9: {
                        block10: {
                            block11: {
                                block6: {
                                    if (var0 == 9) break block7;
                                    if (var0 == 10) break block8;
                                    if (var0 == 12) break block9;
                                    if (var0 == 13) break block10;
                                    if (var0 == 27) break block11;
                                    if (var0 == 44 || var0 == 45) ** GOTO lbl-1000
                                    switch (var0) {
                                        default: {
                                            if (var0 < 32) {
                                                var1_1 = new StringBuffer();
                                                var1_1.append("0");
                                                var1_1.append(Integer.toHexString(var0));
                                                var2_2 = var1_1.toString();
                                                var1_1 = new StringBuffer();
                                                var1_1.append("\\x");
                                                var0 = var2_2.length() - 2;
lbl20:
                                                // 2 sources

                                                while (true) {
                                                    var1_1.append(var2_2.substring(var0, var2_2.length()));
                                                    break block6;
                                                    break;
                                                }
                                            }
                                            if (var0 >= 65536) {
                                                var1_1 = new StringBuffer();
                                                var1_1.append("0");
                                                var1_1.append(Integer.toHexString(var0));
                                                var2_2 = var1_1.toString();
                                                var1_1 = new StringBuffer();
                                                var1_1.append("\\v");
                                                var0 = var2_2.length() - 6;
                                                ** continue;
                                            }
                                            var1_1 = new StringBuffer();
                                            var2_3 = "";
                                            break;
                                        }
                                        case 91: 
                                        case 92: 
                                        case 93: 
                                        case 94: lbl-1000:
                                        // 2 sources

                                        {
                                            var1_1 = new StringBuffer();
                                            var2_3 = "\\";
                                        }
                                    }
                                    var1_1.append(var2_3);
                                    var1_1.append((char)var0);
                                }
                                var1_1 = var1_1.toString();
                                break block12;
                            }
                            var1_1 = "\\e";
                            break block12;
                        }
                        var1_1 = "\\r";
                        break block12;
                    }
                    var1_1 = "\\f";
                    break block12;
                }
                var1_1 = "\\n";
                break block12;
            }
            var1_1 = "\\t";
        }
        return var1_1;
    }

    private final boolean isCompacted() {
        return this.compacted;
    }

    private final boolean isSorted() {
        return this.sorted;
    }

    private final void setCompacted() {
        this.compacted = true;
    }

    private final void setSorted(boolean bl) {
        this.sorted = bl;
        if (!bl) {
            this.compacted = false;
        }
    }

    @Override
    protected void addRange(int n, int n2) {
        int n3;
        this.icaseCache = null;
        if (n > n2) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        int[] nArray = this.ranges;
        if (nArray == null) {
            int[] nArray2 = new int[2];
            this.ranges = nArray2;
            nArray2[0] = n;
            nArray2[1] = n2;
            this.setSorted(true);
        } else {
            int n4 = nArray.length;
            n3 = n4 - 1;
            if (nArray[n3] + 1 == n) {
                nArray[n3] = n2;
                return;
            }
            int[] nArray3 = new int[n4 + 2];
            System.arraycopy(nArray, 0, nArray3, 0, n4);
            this.ranges = nArray3;
            if (nArray3[n3] >= n) {
                this.setSorted(false);
            }
            nArray3 = this.ranges;
            nArray3[n4] = n;
            nArray3[n4 + 1] = n2;
            if (!this.sorted) {
                this.sortRanges();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void compactRanges() {
        int[] nArray = this.ranges;
        if (nArray == null) return;
        if (nArray.length <= 2) {
            return;
        }
        if (this.isCompacted()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        block0: while (true) {
            int n3;
            int[] nArray2;
            if (n >= (nArray2 = this.ranges).length) {
                if (n2 != nArray2.length) {
                    int[] nArray3 = new int[n2];
                    System.arraycopy(nArray2, 0, nArray3, 0, n2);
                    this.ranges = nArray3;
                }
                this.setCompacted();
                return;
            }
            if (n2 != n) {
                n3 = n + 1;
                nArray2[n2] = nArray2[n];
                n = n3 + 1;
                nArray2[n2 + 1] = nArray2[n3];
            } else {
                n += 2;
            }
            int n4 = n2 + 1;
            n3 = nArray2[n4];
            while (true) {
                int n5;
                int[] nArray4;
                if (n >= (nArray4 = this.ranges).length || (n5 = n3 + 1) < nArray4[n]) {
                    n2 += 2;
                    continue block0;
                }
                if (n5 == nArray4[n]) {
                    nArray4[n4] = nArray4[n + 1];
                    n3 = nArray4[n4];
                } else {
                    n5 = n + 1;
                    if (n3 < nArray4[n5]) {
                        if (n3 >= nArray4[n5]) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("Token#compactRanges(): Internel Error: [");
                            stringBuffer.append(this.ranges[n2]);
                            stringBuffer.append(",");
                            stringBuffer.append(this.ranges[n4]);
                            stringBuffer.append("] [");
                            stringBuffer.append(this.ranges[n]);
                            stringBuffer.append(",");
                            stringBuffer.append(this.ranges[n5]);
                            stringBuffer.append("]");
                            throw new RuntimeException(stringBuffer.toString());
                        }
                        nArray4[n4] = nArray4[n5];
                        n3 = nArray4[n4];
                    }
                }
                n += 2;
            }
            break;
        }
    }

    void dumpRanges() {
        System.err.print("RANGE: ");
        if (this.ranges == null) {
            System.err.println(" NULL");
        }
        int n = 0;
        while (true) {
            if (n >= this.ranges.length) {
                System.err.println("");
                return;
            }
            PrintStream printStream = System.err;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append(this.ranges[n]);
            stringBuffer.append(",");
            stringBuffer.append(this.ranges[n + 1]);
            stringBuffer.append("] ");
            printStream.print(stringBuffer.toString());
            n += 2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RangeToken getCaseInsensitiveToken() {
        synchronized (this) {
            RangeToken rangeToken = this.icaseCache;
            if (rangeToken != null) {
                return rangeToken;
            }
            rangeToken = this.type == 4 ? Token.createRange() : Token.createNRange();
            int n = 0;
            int n2 = 0;
            block7: while (true) {
                int n3;
                Object object;
                if (n2 >= ((int[])(object = this.ranges)).length) {
                    if (this.type == 4) {
                        object = Token.createRange();
                        n2 = n;
                    } else {
                        object = Token.createNRange();
                        n2 = n;
                    }
                    block8: while (true) {
                        int[] nArray;
                        if (n2 >= (nArray = rangeToken.ranges).length) {
                            ((RangeToken)object).mergeRanges(rangeToken);
                            ((RangeToken)object).mergeRanges(this);
                            ((RangeToken)object).compactRanges();
                            this.icaseCache = object;
                            return object;
                        }
                        n3 = nArray[n2];
                        while (true) {
                            if (n3 > rangeToken.ranges[n2 + 1]) {
                                n2 += 2;
                                continue block8;
                            }
                            if (n3 > 65535) {
                                ((RangeToken)object).addRange(n3, n3);
                            } else {
                                n = Character.toUpperCase((char)n3);
                                ((RangeToken)object).addRange(n, n);
                            }
                            ++n3;
                        }
                        break;
                    }
                }
                n3 = object[n2];
                while (true) {
                    if (n3 > this.ranges[n2 + 1]) {
                        n2 += 2;
                        continue block7;
                    }
                    if (n3 > 65535) {
                        rangeToken.addRange(n3, n3);
                    } else {
                        char c = Character.toUpperCase((char)n3);
                        rangeToken.addRange(c, c);
                    }
                    ++n3;
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void intersectRanges(Token object) {
        int n;
        int n2;
        Object object2 = (RangeToken)object;
        if (((RangeToken)object2).ranges == null) return;
        if (this.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.sortRanges();
        this.compactRanges();
        ((RangeToken)object2).sortRanges();
        ((RangeToken)object2).compactRanges();
        object = new int[this.ranges.length + ((RangeToken)object2).ranges.length];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            block13: {
                int n6;
                int n7;
                int n8;
                block10: {
                    int n9;
                    block14: {
                        block9: {
                            block12: {
                                block11: {
                                    int[] nArray = this.ranges;
                                    n2 = n3;
                                    n = n5;
                                    if (n3 >= nArray.length) break;
                                    int[] nArray2 = ((RangeToken)object2).ranges;
                                    if (n4 >= nArray2.length) {
                                        n2 = n3;
                                        n = n5;
                                        break;
                                    }
                                    n8 = nArray[n3];
                                    n7 = n3 + 1;
                                    n = nArray[n7];
                                    n9 = nArray2[n4];
                                    n6 = n4 + 1;
                                    n2 = nArray2[n6];
                                    if (n < n9) break block9;
                                    if (n < n9 || n8 > n2) break block10;
                                    if (n > n2) break block11;
                                    n2 = n5 + 1;
                                    object[n5] = n8;
                                    n5 = n2 + 1;
                                    object[n2] = n;
                                    break block9;
                                }
                                if (n9 > n8) break block12;
                                n = n5 + 1;
                                object[n5] = n8;
                                n5 = n + 1;
                                object[n] = n2;
                                nArray[n3] = n2 + 1;
                                break block13;
                            }
                            if (n > n2) break block14;
                            n2 = n5 + 1;
                            object[n5] = n9;
                            n5 = n2 + 1;
                            object[n2] = n;
                        }
                        n3 += 2;
                        continue;
                    }
                    n = n5 + 1;
                    object[n5] = n9;
                    n5 = n + 1;
                    object[n] = n2;
                    nArray[n3] = n2 + 1;
                    continue;
                }
                if (n2 >= n8) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("Token#intersectRanges(): Internal Error: [");
                    ((StringBuffer)object).append(this.ranges[n3]);
                    ((StringBuffer)object).append(",");
                    ((StringBuffer)object).append(this.ranges[n7]);
                    ((StringBuffer)object).append("] & [");
                    ((StringBuffer)object).append(((RangeToken)object2).ranges[n4]);
                    ((StringBuffer)object).append(",");
                    ((StringBuffer)object).append(((RangeToken)object2).ranges[n6]);
                    ((StringBuffer)object).append("]");
                    throw new RuntimeException(((StringBuffer)object).toString());
                }
            }
            n4 += 2;
        }
        while (true) {
            if (n2 >= ((Object)(object2 = (Object)this.ranges)).length) {
                object2 = new int[n];
                this.ranges = (int[])object2;
                System.arraycopy(object, 0, object2, 0, n);
                return;
            }
            n5 = n + 1;
            n3 = n2 + 1;
            object[n] = object2[n2];
            n = n5 + 1;
            n2 = n3 + 1;
            object[n5] = object2[n3];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean match(int n) {
        if (this.map == null) {
            this.createMap();
        }
        int n2 = this.type;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 == 4) {
            if (n < 256) {
                if ((1 << (n & 0x1F) & this.map[n / 32]) == 0) return bl3;
                return true;
            }
            n2 = this.nonMapIndex;
            while (true) {
                int[] nArray;
                if (n2 >= (nArray = this.ranges).length) {
                    return bl2;
                }
                if (nArray[n2] <= n && n <= nArray[n2 + 1]) {
                    return true;
                }
                n2 += 2;
            }
        }
        if (n < 256) {
            bl3 = bl;
            if ((1 << (n & 0x1F) & this.map[n / 32]) != 0) return bl3;
            return true;
        }
        n2 = this.nonMapIndex;
        int[] nArray;
        while (n2 < (nArray = this.ranges).length) {
            if (nArray[n2] <= n && n <= nArray[n2 + 1]) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    @Override
    protected void mergeRanges(Token object) {
        object = (RangeToken)object;
        this.sortRanges();
        ((RangeToken)object).sortRanges();
        if (((RangeToken)object).ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.setSorted(true);
        int[] nArray = this.ranges;
        int n = 0;
        if (nArray == null) {
            this.ranges = nArray = new int[((RangeToken)object).ranges.length];
            object = ((RangeToken)object).ranges;
            System.arraycopy(object, 0, nArray, 0, ((Object)object).length);
            return;
        }
        nArray = new int[nArray.length + ((RangeToken)object).ranges.length];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            int[] nArray2;
            int n5;
            int[] nArray3;
            if (n >= (nArray3 = this.ranges).length && n2 >= ((RangeToken)object).ranges.length) {
                this.ranges = nArray;
                return;
            }
            if (n >= nArray3.length) {
                n5 = n3 + 1;
                nArray2 = ((RangeToken)object).ranges;
                n4 = n2 + 1;
                nArray[n3] = nArray2[n2];
                n3 = n5 + 1;
                n2 = n4 + 1;
                nArray[n5] = nArray2[n4];
                continue;
            }
            nArray2 = ((RangeToken)object).ranges;
            if (n2 >= nArray2.length) {
                n5 = n3 + 1;
                n4 = n + 1;
                nArray[n3] = nArray3[n];
                n3 = n5 + 1;
                n = n4 + 1;
                nArray[n5] = nArray3[n4];
                continue;
            }
            if (nArray2[n2] >= nArray3[n] && (nArray2[n2] != nArray3[n] || nArray2[n2 + 1] >= nArray3[n + 1])) {
                n4 = n3 + 1;
                n5 = n + 1;
                nArray[n3] = nArray3[n];
                n3 = n4 + 1;
                n = n5 + 1;
                nArray[n4] = nArray3[n5];
                continue;
            }
            n5 = n3 + 1;
            n4 = n2 + 1;
            nArray[n3] = nArray2[n2];
            n3 = n5 + 1;
            n2 = n4 + 1;
            nArray[n5] = nArray2[n4];
        }
    }

    @Override
    protected void sortRanges() {
        if (this.isSorted()) {
            return;
        }
        int[] nArray = this.ranges;
        if (nArray == null) {
            return;
        }
        int n = nArray.length - 4;
        block0: while (true) {
            if (n < 0) {
                this.setSorted(true);
                return;
            }
            int n2 = 0;
            while (true) {
                if (n2 > n) {
                    n -= 2;
                    continue block0;
                }
                nArray = this.ranges;
                int n3 = nArray[n2];
                int n4 = n2 + 2;
                if (n3 > nArray[n4] || nArray[n2] == nArray[n4] && nArray[n2 + 1] > nArray[n2 + 3]) {
                    n3 = nArray[n4];
                    nArray[n4] = nArray[n2];
                    nArray[n2] = n3;
                    int n5 = n2 + 3;
                    n3 = nArray[n5];
                    nArray[n5] = nArray[++n2];
                    nArray[n2] = n3;
                }
                n2 = n4;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void subtractRanges(Token object) {
        int n;
        int n2;
        if (((Token)object).type == 5) {
            this.intersectRanges((Token)object);
            return;
        }
        Object object2 = (RangeToken)object;
        if (((RangeToken)object2).ranges == null) return;
        if (this.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.sortRanges();
        this.compactRanges();
        ((RangeToken)object2).sortRanges();
        ((RangeToken)object2).compactRanges();
        object = new int[this.ranges.length + ((RangeToken)object2).ranges.length];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            block14: {
                int n6;
                int n7;
                int n8;
                block11: {
                    block15: {
                        block12: {
                            int n9;
                            block13: {
                                int[] nArray = this.ranges;
                                n2 = n3;
                                n = n5;
                                if (n3 >= nArray.length) break;
                                int[] nArray2 = ((RangeToken)object2).ranges;
                                if (n4 >= nArray2.length) {
                                    n2 = n3;
                                    n = n5;
                                    break;
                                }
                                n8 = nArray[n3];
                                n = n3 + 1;
                                n9 = nArray[n];
                                n2 = nArray2[n4];
                                n7 = n4 + 1;
                                n6 = nArray2[n7];
                                if (n9 < n2) {
                                    n2 = n5 + 1;
                                    object[n5] = nArray[n3];
                                    n5 = n2 + 1;
                                    n3 = n + 1;
                                    object[n2] = nArray[n];
                                    continue;
                                }
                                if (n9 < n2 || n8 > n6) break block11;
                                if (n2 <= n8 && n9 <= n6) break block12;
                                if (n2 > n8) break block13;
                                nArray[n3] = n6 + 1;
                                break block14;
                            }
                            if (n9 > n6) break block15;
                            n = n5 + 1;
                            object[n5] = n8;
                            n5 = n + 1;
                            object[n] = n2 - 1;
                        }
                        n3 += 2;
                        continue;
                    }
                    n = n5 + 1;
                    object[n5] = n8;
                    n5 = n + 1;
                    object[n] = n2 - 1;
                    nArray[n3] = n6 + 1;
                    break block14;
                }
                if (n6 >= n8) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("Token#subtractRanges(): Internal Error: [");
                    ((StringBuffer)object).append(this.ranges[n3]);
                    ((StringBuffer)object).append(",");
                    ((StringBuffer)object).append(this.ranges[n]);
                    ((StringBuffer)object).append("] - [");
                    ((StringBuffer)object).append(((RangeToken)object2).ranges[n4]);
                    ((StringBuffer)object).append(",");
                    ((StringBuffer)object).append(((RangeToken)object2).ranges[n7]);
                    ((StringBuffer)object).append("]");
                    throw new RuntimeException(((StringBuffer)object).toString());
                }
            }
            n4 += 2;
        }
        while (true) {
            if (n2 >= ((Object)(object2 = (Object)this.ranges)).length) {
                object2 = new int[n];
                this.ranges = (int[])object2;
                System.arraycopy(object, 0, object2, 0, n);
                return;
            }
            n3 = n + 1;
            n5 = n2 + 1;
            object[n] = object2[n2];
            n = n3 + 1;
            n2 = n5 + 1;
            object[n3] = object2[n5];
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String toString(int n) {
        int n2;
        CharSequence charSequence;
        int n3 = this.type;
        int n4 = 0;
        if (n3 == 4) {
            if (this == Token.token_dot) {
                return ".";
            }
            if (this == Token.token_0to9) {
                return "\\d";
            }
            if (this == Token.token_wordchars) {
                return "\\w";
            }
            if (this == Token.token_spaces) {
                return "\\s";
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("[");
            for (n2 = 0; n2 < this.ranges.length; n2 += 2) {
                int[] nArray;
                if ((n & 0x400) != 0 && n2 > 0) {
                    ((StringBuffer)charSequence).append(",");
                }
                if ((n3 = (nArray = this.ranges)[n2]) == nArray[n4 = n2 + 1]) {
                    n4 = nArray[n2];
                } else {
                    ((StringBuffer)charSequence).append(RangeToken.escapeCharInCharClass(nArray[n2]));
                    ((StringBuffer)charSequence).append('-');
                    n4 = this.ranges[n4];
                }
                ((StringBuffer)charSequence).append(RangeToken.escapeCharInCharClass(n4));
            }
        } else {
            if (this == Token.token_not_0to9) {
                return "\\D";
            }
            if (this == Token.token_not_wordchars) {
                return "\\W";
            }
            if (this == Token.token_not_spaces) {
                return "\\S";
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("[^");
            for (n2 = n4; n2 < this.ranges.length; n2 += 2) {
                int[] nArray;
                if ((n & 0x400) != 0 && n2 > 0) {
                    ((StringBuffer)charSequence).append(",");
                }
                if ((n4 = (nArray = this.ranges)[n2]) == nArray[n3 = n2 + 1]) {
                    n4 = nArray[n2];
                } else {
                    ((StringBuffer)charSequence).append(RangeToken.escapeCharInCharClass(nArray[n2]));
                    ((StringBuffer)charSequence).append('-');
                    n4 = this.ranges[n3];
                }
                ((StringBuffer)charSequence).append(RangeToken.escapeCharInCharClass(n4));
            }
        }
        ((StringBuffer)charSequence).append("]");
        return ((StringBuffer)charSequence).toString();
    }
}

